/* @brief Round Robin scheduler for mbed
      
   @author John Bailey 
 
   @copyright Copyright 2017 John Bailey
 
   @section LICENSE

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

#if !defined ROUNDROBIN_HPP
#define      ROUNDROBIN_HPP

#include "rtos.h"
#include <map>

class RoundRobin
{
    protected:
        EventQueue eventQueue;
        Thread*    thread;
        Ticker     ticker;
        static     RoundRobin *p_instance;

        RoundRobin();
        static void EventTrigger( void );

        class TaskEntry
        {
            void     (*fn)( void );
            unsigned counter;

            public:
                TaskEntry( void (*p_fn)( void ) ) : fn(p_fn),counter(0) {}
                void tick( void ) { counter++; }
                void triggerIfNeeded( unsigned multiplier )
                {
                    if( multiplier == counter )
                    {
                        fn();
                        counter = 0;
                    }
                }
        };

        static std::multimap<unsigned,TaskEntry> p_taskList;

    public:
        virtual ~RoundRobin();

        static RoundRobin* instance( void );

        static bool addTask( unsigned p_multiplier, void (*p_fn)(void) );

        void SetBaseRate( const float p_rate );
};

#endif
