#include "mbed.h"
#include "CircularBuffer.h"
#include "TestSupportSimple.hpp" 
 
#define TEST_BUFFER_SIZE 16

CircularBuffer<TEST_BUFFER_SIZE> buffer;
uint8_t temp_buffer[ TEST_BUFFER_SIZE ];

void check_empty( void )
{
    /* A buffer which is empty should pass all of these tests */
    
    TST_EQ( buffer.getSize(), 0, "Empty buffer: getSize()" );
    TST_EQ( buffer.read( temp_buffer, TEST_BUFFER_SIZE ), 0, "Empty buffer: read()" );
    TST_EQ( buffer.peek( temp_buffer, TEST_BUFFER_SIZE ), 0, "Empty buffer: peek()" );
    TST_TRUE( buffer.isEmpty(), "Empty buffer: isEmpty()" );
    TST_FALSE( buffer.isFull(), "Empty buffer: isFull()" );
    TST_EQ( buffer.getCapacity(), TEST_BUFFER_SIZE, "Empty buffer: capacity()" );
}
 
#define FIRST_TEST_BYTE 0x55U
 
int main()
{
    check_empty();
    temp_buffer[ 0 ] = FIRST_TEST_BYTE;
    
    /* Write a single byte into the buffer then call various methods */
    TST_EQ( buffer.write( temp_buffer, 1 ), 1, "Empty buffer: write() single byte" );
    TST_EQ( buffer[0], FIRST_TEST_BYTE, "Single byte buffer: [] operator to read first byte" );
    TST_EQ( buffer.getSize(), 1, "Single-byte buffer: getSize()" );
    temp_buffer[0]++;
    TST_EQ( buffer.peek( temp_buffer, TEST_BUFFER_SIZE ), 1, "Single-byte buffer: peek()" );
    TST_EQ( temp_buffer[0], FIRST_TEST_BYTE, "Single-byte buffer: peek() yielded correct value" );
    TST_FALSE( buffer.isEmpty(), "Single-byte buffer: isEmpty()" );
    TST_FALSE( buffer.isFull(), "Single-byte buffer: isFull()" );
    TST_EQ( buffer.getCapacity(), TEST_BUFFER_SIZE, "Single-byte buffer: capacity()" );
    // This test is last as it will empty the buffer again
    TST_EQ( buffer.read( temp_buffer, TEST_BUFFER_SIZE ), 1, "Single-byte buffer: read()" );
    
    /* Now that the buffer is empty again, run the tests to make sure that method returns 
       are again consistent with this */
    check_empty();
    
    /* TODO: Finish off writing tests! */
    
    TST_DONE();
    return 0;
}
