#include "mbed.h"
#include "mbed_events.h"
#include "HEPTA_CDH.h"
#include "HEPTA_EPS.h"
#include "HEPTA_SENSOR.h"
#include "HEPTA_COM.h"
#include"Air_Quality.h"


HEPTA_CDH cdh(p5, p6, p7, p8, "sd");
HEPTA_EPS eps(p16,p26);
HEPTA_SENSOR sensor(p17,
                    p28,p27,0x19,0x69,0x13,
                    p13, p14,p25,p24);
HEPTA_COM com(p9,p10);
DigitalOut condition(LED1);
AirQuality airqualitysensor;
PinName analogPin = p19;
AnalogIn soil(p18);
int s = 0;
int sprinkler_switch = 0; //0 = OFF, 1 = ON
Timer sattime;
Timer buzzertime;
Ticker sound;

#define mC 261.626
#define mD 293.665
#define mE 329.628
#define mF 349.228
#define mG 391.995
#define mA 440.000
#define mB 493.883
float mm[]= {mC*4,mD*4,mE*4,mF*4,mG*4,mA*4,mB*4,mC*8};  //timbre
// Guess: Use p22 for buzzer. If not working, just change
DigitalOut sp1(p22);    //DigitalOut for buzzer
//Thread thread;

Serial sat(USBTX,USBRX,9600);
int rcmd = 0,cmdflag = 0; //command variable

void tick(void)
{
    sp1.write(s);
    s=!s;
}

// Interrupt Handler
void AirQualityInterrupt()
{
    AnalogIn sensor(analogPin);
    airqualitysensor.last_vol = airqualitysensor.first_vol;
    airqualitysensor.first_vol = sensor.read()*1000;
//    com.printf("%d\r\n",airqualitysensor.first_vol);
    airqualitysensor.timer_index = 1;
}

//Thread function responsible for turning on the buzzer
void buzzer_asnyc()
{
    Ticker sound;
    buzzertime.start();
    //sound on
    sprinkler_switch = 1;
    for(int i=0; i < sizeof(mm)/sizeof(mm[0]); i++) {
        sound.attach(&tick,1.0/mm[i]/2.0);
        wait(0.5f);
    }
    sound.detach();
    sprinkler_switch = 0;
}


int main()
{
    sat.printf("From Sat : Nominal Operation\r\n");
    com.printf("From Sat : Nominal Operation\r\n");
    com.baud(9600);
    int flag = 0; //condition flag
    float batvol, temp; //voltage, temperature
    float moisture = 0.0; //moisture
    long air_quality = -1; //air quality

    int rcmd=0,cmdflag=0;  //command variable
    sattime.start();
    eps.turn_on_regulator();//turn on 3.3V conveter

    char target_dir[] = "/sd/mydir";
    char basename[] = "sdtest.csv";
    char target_path[] ="/sd/mydir/sdtest.csv";

//    strcat(target_path,target_dir);
//    strcat(target_path,"/");
//    strcat(target_path,basename);
    // check saving to SD card
    mkdir(target_dir, 0777);
    //TODO: Overwrite basename if it exists.
    sat.printf("Full Path %s\r\n",target_path);
    // remove the original file
//    remove(target_path);
    FILE *fp = fopen(target_path, "w");
    if(fp == NULL) {
        error("Could not open file for write\r\n");
    }
    fclose(fp);

    //TODO: Fix the wait timer inside
    airqualitysensor.init(analogPin, AirQualityInterrupt); //Turn on Air Quality

    //Assume that the satellite is accessible.
    //TODO: Establish first that satellite is available.
    sat.printf("Sending Satellite Data...\r\n");

    int packet_num = 0;
    while(1) {
        com.xbee_receive(&rcmd,&cmdflag);//interupting by ground station command

        //satellite condition led
        condition = !condition;

        //senssing HK data(dummy data)
        eps.vol(&batvol);
        sensor.temp_sense(&temp);

        //Transmitting HK data to Ground Station(GS)
        com.printf("HEPTASAT::Condition = %d, Time = %f [s], batVol = %.2f [V],Temp = %.2f [C]\r\n",flag,sattime.read(),batvol,temp);
        wait_ms(1000);
        
        //Collect Data from GST Sensors
        moisture = soil.read() * 1000.0;
        air_quality=airqualitysensor.slope();
        sprinkler_switch = 0; //OFF
        FILE *fp = fopen(target_path, "a");
        sat.printf("Time = %.0f, Moisture = %0.4f,Air Quality = %0.2ld, Sprinkler = %d\r\n",sattime.read(),moisture,air_quality,sprinkler_switch);
        fprintf(fp,"Time = %.0f, Moisture = %0.4f,Air Quality = %0.2ld, Sprinkler = %d\r\n",sattime.read(),moisture,air_quality,sprinkler_switch);
        fclose(fp);
        packet_num++;
        //For every 10 packets, delete the file.
       // if (packet_num % 100 == 0) {
//            remove(target_path);
//        }
        //Contents of command
        if (cmdflag == 1) {
            if (rcmd == 'a') {
                //Download GST Farm Sensors data from SD Card
                sat.printf("rcmd=%c,cmdflag=%d\r\n",rcmd,cmdflag);
                com.printf("Hepta-Sat Uplink Ok\r\n");
                char buffer[2048];
                //Send all contents of SD Cards.
                //TODO: Make it buffered
                //TODO: Add temporary for safety
                fp = fopen(target_path,"r");
                while(fgets(buffer,2048,fp)) {
                    char send_GS[2048];
                    strcpy(send_GS, buffer);
                    com.printf(send_GS);
                }
                fclose(fp);
                // remove the original file
                remove(target_path);
            } else if (rcmd == 'b') {
                //Activate Buzzer
                sat.printf("rcmd=%c,cmdflag=%d\r\n",rcmd,cmdflag);
                com.printf("Hepta-Sat Uplink Ok\r\n");
                sat.printf("Current Sattime: %d\r\n",sattime.read());
                
                int time=2; //Duration of time
                
                for(int t=time;t>=0; t--) {
                    //sound on
                    for(int i=0; i < sizeof(mm)/sizeof(mm[0]); i++) {
                        sound.attach(&tick,1.0/mm[i]/2.0);
                        wait(0.5f);
                    }
                    sound.detach();
                    sat.printf("Current time: %d\r\n",t);
                }
                //
//                if(sattime.read() > 300) {
//                    //sound on
//                    for(int i=0; i < sizeof(mm)/sizeof(mm[0]); i++) {
//                        sound.attach(&tick,1.0/mm[i]/2.0);
//                        wait(0.5f);
//                    }
//                    sound.detach();
//                }
                //else {
//                    sat.printf("Catch Some error here.\r\n");
//                }
            } else if (rcmd == 'c') {
                //Please insert your answer

            } else if (rcmd == 'd') {
                //Please insert your answer

            } else if (rcmd == 'e') {
                //Please insert your answer

            }
            com.initialize();
        }
    }

    sattime.stop();
    sat.printf("From Sat : End of operation\r\n");
    com.printf("From Sat : End of operation\r\n");
}
