/*******************************************************************************
 * Copyright (C) 2017 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */
 

#include "mbed.h"
#include "max32630fthr.h"
#include "MAX113XX_Pixi.h"
#include "MAX11301Hex.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

int main()
{
    Serial pc(USBTX, USBRX);            // Use USB debug probe for serial link
    pc.baud(115200);                    // Baud rate = 115200
    
    I2C i2cBus(I2C1_SDA, I2C1_SCL);     // I2C bus, P3_4 = SDA, P3_5 = SCL

    MAX113XX_I2C pixi(i2cBus, MAX113XX_I2C::MAX11301, 0x38, P5_5);
        
    pixi.dacWrite(MAX113XX_Pixi::PORT0, 0x000);    // Pixi PORT0 is -5V
    pixi.dacWrite(MAX113XX_Pixi::PORT1, 0xFFF);    // Pixi PORT1 is +5V
    
    uint16_t adcData;
    float adcVoltage;
    while(1) {
        
        pixi.singleEndedADCRead(MAX113XX_Pixi::PORT9, adcData);    // Read value from PORT9
        adcVoltage = -5 + 2.442e-3  * adcData;                     // Convert ADC val. to a voltage
        pc.printf("ADC Read is : %i,\tVoltage is %1.3f V \r\n", adcData, adcVoltage);
        wait(0.05);
           
    }
}

