/*
 *  no_shield_single_polling.h
 *  This pogram is a simple sample program which demsonstrates the VL53L3 being used without 
 *  a nucleo sheild. The shutdown pins are directly connected to the MCU pins D9,D4 and D3
 *  as defined by this line:
 *    status = board->init_board(D9,D4,D3);
 *  the interrupt pins are defined in
 *     board = NoShield53L3::instance(dev_I2C, A2, D8, D2);
 *
 *  Measured ranges are ouput on the Serial Port, running at 115200 baud.
 *
 *  The Reset button can be used to restart the program.
 */
 
#include <stdio.h>
#include <time.h>

#include "mbed.h"
//#include "NoShield53L3.h"
#include "vl53l3_class.h"
#include "vl53L3_I2c.h"


// define i2c mcu pins
#define I2C_SDA   D14 
#define I2C_SCL   D15 

//static NoShield53L3 *board=NULL;
static VL53L3 *sensor = NULL;
#if (MBED_VERSION  > 60300)
    UnbufferedSerial  pc(USBTX, USBRX);
#else
    Serial pc(SERIAL_TX, SERIAL_RX);
#endif



VL53LX_Dev_t                   devCentre;
VL53LX_Dev_t                   devLeft;
VL53LX_Dev_t                   devRight;
VL53LX_DEV                     Dev = &devCentre;


 
/*=================================== Main ==================================
=============================================================================*/
int main()
{   
    int status;
    uint16_t wordData;
    
    DigitalOut xshutdown(D8);
    

    static VL53LX_MultiRangingData_t RangingData;


    pc.baud(115200);  // baud rate is important as printf statements take a lot of time
    printf("Hello world!\r\n");

    vl53L3_DevI2C *dev_I2C = new vl53L3_DevI2C(I2C_SDA, I2C_SCL);
    
    /* no expansion board so don't use stmpe1600 */
//    board = NoShield53L3::instance(dev_I2C, A2, D8, D2);
    sensor = new VL53L3(dev_I2C, &xshutdown, A2);
    
    printf("sensor created!\r\n");

    status = sensor->InitSensor(0x52);
    if (status) {
        printf("Failed to init sensor!\r\n");
        return 0;
    }   
    
    printf("sensor initialised! \n");
                                            
    uint8_t NewDataReady=0;     
    
    status = sensor->VL53LX_StartMeasurement();   
    printf("VL53LX_StartMeasurement %d \n",status);         
 
 // loop forever getting measurements       
    while(1) 
    {     
        status = sensor->VL53LX_WaitMeasurementDataReady();

        if(!status)
        {

            status = sensor->VL53LX_GetMultiRangingData(&RangingData);

            if (status == 0)
            {
                int no_of_object_found = RangingData.NumberOfObjectsFound;
                if ( no_of_object_found < 10 ) 
                {
                    for(int j=0;j<no_of_object_found;j++)
                    {
                        if ((RangingData.RangeData[j].RangeStatus == VL53LX_RANGESTATUS_RANGE_VALID) || 
                            (RangingData.RangeData[j].RangeStatus == VL53LX_RANGESTATUS_RANGE_VALID_NO_WRAP_CHECK_FAIL))
                        {   // print data
                            printf("centre \t object %d  \t status=%d, \t D=%5dmm, \t Signal=%2.2f Mcps, \t Ambient=%2.2f Mcps \n",
                                j,
                                RangingData.RangeData[j].RangeStatus,
                                RangingData.RangeData[j].RangeMilliMeter,
                                RangingData.RangeData[j].SignalRateRtnMegaCps/65536.0,
                                RangingData.RangeData[j].AmbientRateRtnMegaCps/65536.0);
                        } //if
                    } //for
                } // if  ( no_of_object_found < 10 ) 
            }   // if status VL53LX_GetMultiRangingData                                                                                                      
        } // if !status VL53LX_WaitMeasurementDataReady
        else
        {
            printf("VL53L1_WaitMeasurementDataReady failed %d \n",status);
        }

        status = sensor->VL53LX_ClearInterruptAndStartMeasurement();
        
    } // while(1)
    
}
