
#ifndef __VL53LX_DEF_H
#define __VL53LX_DEF_H

#include <stdint.h>
#include <stdint.h>
#include <stddef.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "vl53L3_I2c.h"

#ifdef __cplusplus
extern "C"
{
#endif

//define from vl53lx_register_map.h

#define VL53LX_SOFT_RESET 0x0000

#define VL53LX_I2C_SLAVE__DEVICE_ADDRESS 0x0001

#define VL53LX_ANA_CONFIG__VHV_REF_SEL_VDDPIX 0x0002

#define VL53LX_ANA_CONFIG__VHV_REF_SEL_VQUENCH 0x0003

#define VL53LX_ANA_CONFIG__REG_AVDD1V2_SEL 0x0004

#define VL53LX_ANA_CONFIG__FAST_OSC__TRIM 0x0005

#define VL53LX_OSC_MEASURED__FAST_OSC__FREQUENCY 0x0006

#define VL53LX_OSC_MEASURED__FAST_OSC__FREQUENCY_HI 0x0006

#define VL53LX_OSC_MEASURED__FAST_OSC__FREQUENCY_LO 0x0007

#define VL53LX_VHV_CONFIG__TIMEOUT_MACROP_LOOP_BOUND 0x0008

#define VL53LX_VHV_CONFIG__COUNT_THRESH 0x0009

#define VL53LX_VHV_CONFIG__OFFSET 0x000A

#define VL53LX_VHV_CONFIG__INIT 0x000B

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_REF_0 0x000D

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_REF_1 0x000E

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_REF_2 0x000F

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_REF_3 0x0010

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_REF_4 0x0011

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_REF_5 0x0012

#define VL53LX_GLOBAL_CONFIG__REF_EN_START_SELECT 0x0013

#define VL53LX_REF_SPAD_MAN__NUM_REQUESTED_REF_SPADS 0x0014

#define VL53LX_REF_SPAD_MAN__REF_LOCATION 0x0015

#define VL53LX_ALGO__CROSSTALK_COMPENSATION_PLANE_OFFSET_KCPS 0x0016

#define VL53LX_ALGO__CROSSTALK_COMPENSATION_PLANE_OFFSET_KCPS_HI 0x0016

#define VL53LX_ALGO__CROSSTALK_COMPENSATION_PLANE_OFFSET_KCPS_LO 0x0017

#define VL53LX_ALGO__CROSSTALK_COMPENSATION_X_PLANE_GRADIENT_KCPS 0x0018

#define VL53LX_ALGO__CROSSTALK_COMPENSATION_X_PLANE_GRADIENT_KCPS_HI 0x0018

#define VL53LX_ALGO__CROSSTALK_COMPENSATION_X_PLANE_GRADIENT_KCPS_LO 0x0019

#define VL53LX_ALGO__CROSSTALK_COMPENSATION_Y_PLANE_GRADIENT_KCPS 0x001A

#define VL53LX_ALGO__CROSSTALK_COMPENSATION_Y_PLANE_GRADIENT_KCPS_HI 0x001A

#define VL53LX_ALGO__CROSSTALK_COMPENSATION_Y_PLANE_GRADIENT_KCPS_LO 0x001B

#define VL53LX_REF_SPAD_CHAR__TOTAL_RATE_TARGET_MCPS 0x001C

#define VL53LX_REF_SPAD_CHAR__TOTAL_RATE_TARGET_MCPS_HI 0x001C

#define VL53LX_REF_SPAD_CHAR__TOTAL_RATE_TARGET_MCPS_LO 0x001D

#define VL53LX_ALGO__PART_TO_PART_RANGE_OFFSET_MM 0x001E

#define VL53LX_ALGO__PART_TO_PART_RANGE_OFFSET_MM_HI 0x001E

#define VL53LX_ALGO__PART_TO_PART_RANGE_OFFSET_MM_LO 0x001F

#define VL53LX_MM_CONFIG__INNER_OFFSET_MM 0x0020

#define VL53LX_MM_CONFIG__INNER_OFFSET_MM_HI 0x0020

#define VL53LX_MM_CONFIG__INNER_OFFSET_MM_LO 0x0021

#define VL53LX_MM_CONFIG__OUTER_OFFSET_MM 0x0022

#define VL53LX_MM_CONFIG__OUTER_OFFSET_MM_HI 0x0022

#define VL53LX_MM_CONFIG__OUTER_OFFSET_MM_LO 0x0023

#define VL53LX_DSS_CONFIG__TARGET_TOTAL_RATE_MCPS 0x0024

#define VL53LX_DSS_CONFIG__TARGET_TOTAL_RATE_MCPS_HI 0x0024

#define VL53LX_DSS_CONFIG__TARGET_TOTAL_RATE_MCPS_LO 0x0025

#define VL53LX_DEBUG__CTRL 0x0026

#define VL53LX_TEST_MODE__CTRL 0x0027

#define VL53LX_CLK_GATING__CTRL 0x0028

#define VL53LX_NVM_BIST__CTRL 0x0029

#define VL53LX_NVM_BIST__NUM_NVM_WORDS 0x002A

#define VL53LX_NVM_BIST__START_ADDRESS 0x002B

#define VL53LX_HOST_IF__STATUS 0x002C

#define VL53LX_PAD_I2C_HV__CONFIG 0x002D

#define VL53LX_PAD_I2C_HV__EXTSUP_CONFIG 0x002E

#define VL53LX_GPIO_HV_PAD__CTRL 0x002F

#define VL53LX_GPIO_HV_MUX__CTRL 0x0030

#define VL53LX_GPIO__TIO_HV_STATUS 0x0031

#define VL53LX_GPIO__FIO_HV_STATUS 0x0032

#define VL53LX_ANA_CONFIG__SPAD_SEL_PSWIDTH 0x0033

#define VL53LX_ANA_CONFIG__VCSEL_PULSE_WIDTH_OFFSET 0x0034

#define VL53LX_ANA_CONFIG__FAST_OSC__CONFIG_CTRL 0x0035

#define VL53LX_SIGMA_ESTIMATOR__EFFECTIVE_PULSE_WIDTH_NS 0x0036

#define VL53LX_SIGMA_ESTIMATOR__EFFECTIVE_AMBIENT_WIDTH_NS 0x0037

#define VL53LX_SIGMA_ESTIMATOR__SIGMA_REF_MM 0x0038

#define VL53LX_ALGO__CROSSTALK_COMPENSATION_VALID_HEIGHT_MM 0x0039

#define VL53LX_SPARE_HOST_CONFIG__STATIC_CONFIG_SPARE_0 0x003A

#define VL53LX_SPARE_HOST_CONFIG__STATIC_CONFIG_SPARE_1 0x003B

#define VL53LX_ALGO__RANGE_IGNORE_THRESHOLD_MCPS 0x003C

#define VL53LX_ALGO__RANGE_IGNORE_THRESHOLD_MCPS_HI 0x003C

#define VL53LX_ALGO__RANGE_IGNORE_THRESHOLD_MCPS_LO 0x003D

#define VL53LX_ALGO__RANGE_IGNORE_VALID_HEIGHT_MM 0x003E

#define VL53LX_ALGO__RANGE_MIN_CLIP 0x003F

#define VL53LX_ALGO__CONSISTENCY_CHECK__TOLERANCE 0x0040

#define VL53LX_SPARE_HOST_CONFIG__STATIC_CONFIG_SPARE_2 0x0041

#define VL53LX_SD_CONFIG__RESET_STAGES_MSB 0x0042

#define VL53LX_SD_CONFIG__RESET_STAGES_LSB 0x0043

#define VL53LX_GPH_CONFIG__STREAM_COUNT_UPDATE_VALUE 0x0044

#define VL53LX_GLOBAL_CONFIG__STREAM_DIVIDER 0x0045

#define VL53LX_SYSTEM__INTERRUPT_CONFIG_GPIO 0x0046

#define VL53LX_CAL_CONFIG__VCSEL_START 0x0047

#define VL53LX_CAL_CONFIG__REPEAT_RATE 0x0048

#define VL53LX_CAL_CONFIG__REPEAT_RATE_HI 0x0048

#define VL53LX_CAL_CONFIG__REPEAT_RATE_LO 0x0049

#define VL53LX_GLOBAL_CONFIG__VCSEL_WIDTH 0x004A

#define VL53LX_PHASECAL_CONFIG__TIMEOUT_MACROP 0x004B

#define VL53LX_PHASECAL_CONFIG__TARGET 0x004C

#define VL53LX_PHASECAL_CONFIG__OVERRIDE 0x004D

#define VL53LX_DSS_CONFIG__ROI_MODE_CONTROL 0x004F

#define VL53LX_SYSTEM__THRESH_RATE_HIGH 0x0050

#define VL53LX_SYSTEM__THRESH_RATE_HIGH_HI 0x0050

#define VL53LX_SYSTEM__THRESH_RATE_HIGH_LO 0x0051

#define VL53LX_SYSTEM__THRESH_RATE_LOW 0x0052

#define VL53LX_SYSTEM__THRESH_RATE_LOW_HI 0x0052

#define VL53LX_SYSTEM__THRESH_RATE_LOW_LO 0x0053

#define VL53LX_DSS_CONFIG__MANUAL_EFFECTIVE_SPADS_SELECT 0x0054

#define VL53LX_DSS_CONFIG__MANUAL_EFFECTIVE_SPADS_SELECT_HI 0x0054

#define VL53LX_DSS_CONFIG__MANUAL_EFFECTIVE_SPADS_SELECT_LO 0x0055

#define VL53LX_DSS_CONFIG__MANUAL_BLOCK_SELECT 0x0056

#define VL53LX_DSS_CONFIG__APERTURE_ATTENUATION 0x0057

#define VL53LX_DSS_CONFIG__MAX_SPADS_LIMIT 0x0058

#define VL53LX_DSS_CONFIG__MIN_SPADS_LIMIT 0x0059

#define VL53LX_MM_CONFIG__TIMEOUT_MACROP_A_HI 0x005A

#define VL53LX_MM_CONFIG__TIMEOUT_MACROP_A_LO 0x005B

#define VL53LX_MM_CONFIG__TIMEOUT_MACROP_B_HI 0x005C

#define VL53LX_MM_CONFIG__TIMEOUT_MACROP_B_LO 0x005D

#define VL53LX_RANGE_CONFIG__TIMEOUT_MACROP_A_HI 0x005E

#define VL53LX_RANGE_CONFIG__TIMEOUT_MACROP_A_LO 0x005F

#define VL53LX_RANGE_CONFIG__VCSEL_PERIOD_A 0x0060

#define VL53LX_RANGE_CONFIG__TIMEOUT_MACROP_B_HI 0x0061

#define VL53LX_RANGE_CONFIG__TIMEOUT_MACROP_B_LO 0x0062

#define VL53LX_RANGE_CONFIG__VCSEL_PERIOD_B 0x0063

#define VL53LX_RANGE_CONFIG__SIGMA_THRESH 0x0064

#define VL53LX_RANGE_CONFIG__SIGMA_THRESH_HI 0x0064

#define VL53LX_RANGE_CONFIG__SIGMA_THRESH_LO 0x0065

#define VL53LX_RANGE_CONFIG__MIN_COUNT_RATE_RTN_LIMIT_MCPS 0x0066

#define VL53LX_RANGE_CONFIG__MIN_COUNT_RATE_RTN_LIMIT_MCPS_HI 0x0066

#define VL53LX_RANGE_CONFIG__MIN_COUNT_RATE_RTN_LIMIT_MCPS_LO 0x0067

#define VL53LX_RANGE_CONFIG__VALID_PHASE_LOW 0x0068

#define VL53LX_RANGE_CONFIG__VALID_PHASE_HIGH 0x0069

#define VL53LX_SYSTEM__INTERMEASUREMENT_PERIOD 0x006C

#define VL53LX_SYSTEM__INTERMEASUREMENT_PERIOD_3 0x006C

#define VL53LX_SYSTEM__INTERMEASUREMENT_PERIOD_2 0x006D

#define VL53LX_SYSTEM__INTERMEASUREMENT_PERIOD_1 0x006E

#define VL53LX_SYSTEM__INTERMEASUREMENT_PERIOD_0 0x006F

#define VL53LX_SYSTEM__FRACTIONAL_ENABLE 0x0070

#define VL53LX_SYSTEM__GROUPED_PARAMETER_HOLD_0 0x0071

#define VL53LX_SYSTEM__THRESH_HIGH 0x0072

#define VL53LX_SYSTEM__THRESH_HIGH_HI 0x0072

#define VL53LX_SYSTEM__THRESH_HIGH_LO 0x0073

#define VL53LX_SYSTEM__THRESH_LOW 0x0074

#define VL53LX_SYSTEM__THRESH_LOW_HI 0x0074

#define VL53LX_SYSTEM__THRESH_LOW_LO 0x0075

#define VL53LX_SYSTEM__ENABLE_XTALK_PER_QUADRANT 0x0076

#define VL53LX_SYSTEM__SEED_CONFIG 0x0077

#define VL53LX_SD_CONFIG__WOI_SD0 0x0078

#define VL53LX_SD_CONFIG__WOI_SD1 0x0079

#define VL53LX_SD_CONFIG__INITIAL_PHASE_SD0 0x007A

#define VL53LX_SD_CONFIG__INITIAL_PHASE_SD1 0x007B

#define VL53LX_SYSTEM__GROUPED_PARAMETER_HOLD_1 0x007C

#define VL53LX_SD_CONFIG__FIRST_ORDER_SELECT 0x007D

#define VL53LX_SD_CONFIG__QUANTIFIER 0x007E

#define VL53LX_ROI_CONFIG__USER_ROI_CENTRE_SPAD 0x007F

#define VL53LX_ROI_CONFIG__USER_ROI_REQUESTED_GLOBAL_XY_SIZE 0x0080

#define VL53LX_SYSTEM__SEQUENCE_CONFIG 0x0081

#define VL53LX_SYSTEM__GROUPED_PARAMETER_HOLD 0x0082

#define VL53LX_POWER_MANAGEMENT__GO1_POWER_FORCE 0x0083

#define VL53LX_SYSTEM__STREAM_COUNT_CTRL 0x0084

#define VL53LX_FIRMWARE__ENABLE 0x0085

#define VL53LX_SYSTEM__INTERRUPT_CLEAR 0x0086

#define VL53LX_SYSTEM__MODE_START 0x0087

#define VL53LX_RESULT__INTERRUPT_STATUS 0x0088

#define VL53LX_RESULT__RANGE_STATUS 0x0089

#define VL53LX_RESULT__REPORT_STATUS 0x008A

#define VL53LX_RESULT__STREAM_COUNT 0x008B

#define VL53LX_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD0 0x008C

#define VL53LX_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD0_HI 0x008C

#define VL53LX_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD0_LO 0x008D

#define VL53LX_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD0 0x008E

#define VL53LX_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD0_HI 0x008E

#define VL53LX_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD0_LO 0x008F

#define VL53LX_RESULT__AMBIENT_COUNT_RATE_MCPS_SD0 0x0090

#define VL53LX_RESULT__AMBIENT_COUNT_RATE_MCPS_SD0_HI 0x0090

#define VL53LX_RESULT__AMBIENT_COUNT_RATE_MCPS_SD0_LO 0x0091

#define VL53LX_RESULT__SIGMA_SD0 0x0092

#define VL53LX_RESULT__SIGMA_SD0_HI 0x0092

#define VL53LX_RESULT__SIGMA_SD0_LO 0x0093

#define VL53LX_RESULT__PHASE_SD0 0x0094

#define VL53LX_RESULT__PHASE_SD0_HI 0x0094

#define VL53LX_RESULT__PHASE_SD0_LO 0x0095

#define VL53LX_RESULT__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD0 0x0096

#define VL53LX_RESULT__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD0_HI 0x0096

#define VL53LX_RESULT__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD0_LO 0x0097

#define VL53LX_PEAK_SIGNAL_COUNT_RATE_CROSSTALK_CORRECTED_MCPS_SD0 0x0098

#define VL53LX__PEAK_SIGNAL_COUNT_RATE_CROSSTALK_CORRECTED_MCPS_SD0_HI 0x0098

#define VL53LX___PEAK_SIGNAL_COUNT_RATE_CROSSTALK_CORRECTED_MCPS_SD0_LO 0x0099

#define VL53LX_RESULT__MM_INNER_ACTUAL_EFFECTIVE_SPADS_SD0 0x009A

#define VL53LX_RESULT__MM_INNER_ACTUAL_EFFECTIVE_SPADS_SD0_HI 0x009A

#define VL53LX_RESULT__MM_INNER_ACTUAL_EFFECTIVE_SPADS_SD0_LO 0x009B

#define VL53LX_RESULT__MM_OUTER_ACTUAL_EFFECTIVE_SPADS_SD0 0x009C

#define VL53LX_RESULT__MM_OUTER_ACTUAL_EFFECTIVE_SPADS_SD0_HI 0x009C

#define VL53LX_RESULT__MM_OUTER_ACTUAL_EFFECTIVE_SPADS_SD0_LO 0x009D

#define VL53LX_RESULT__AVG_SIGNAL_COUNT_RATE_MCPS_SD0 0x009E

#define VL53LX_RESULT__AVG_SIGNAL_COUNT_RATE_MCPS_SD0_HI 0x009E

#define VL53LX_RESULT__AVG_SIGNAL_COUNT_RATE_MCPS_SD0_LO 0x009F

#define VL53LX_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD1 0x00A0

#define VL53LX_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD1_HI 0x00A0

#define VL53LX_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD1_LO 0x00A1

#define VL53LX_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD1 0x00A2

#define VL53LX_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD1_HI 0x00A2

#define VL53LX_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD1_LO 0x00A3

#define VL53LX_RESULT__AMBIENT_COUNT_RATE_MCPS_SD1 0x00A4

#define VL53LX_RESULT__AMBIENT_COUNT_RATE_MCPS_SD1_HI 0x00A4

#define VL53LX_RESULT__AMBIENT_COUNT_RATE_MCPS_SD1_LO 0x00A5

#define VL53LX_RESULT__SIGMA_SD1 0x00A6

#define VL53LX_RESULT__SIGMA_SD1_HI 0x00A6

#define VL53LX_RESULT__SIGMA_SD1_LO 0x00A7

#define VL53LX_RESULT__PHASE_SD1 0x00A8

#define VL53LX_RESULT__PHASE_SD1_HI 0x00A8

#define VL53LX_RESULT__PHASE_SD1_LO 0x00A9

#define VL53LX_RESULT__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD1 0x00AA

#define VL53LX_RESULT__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD1_HI 0x00AA

#define VL53LX_RESULT__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD1_LO 0x00AB

#define VL53LX_RESULT__SPARE_0_SD1 0x00AC

#define VL53LX_RESULT__SPARE_0_SD1_HI 0x00AC

#define VL53LX_RESULT__SPARE_0_SD1_LO 0x00AD

#define VL53LX_RESULT__SPARE_1_SD1 0x00AE

#define VL53LX_RESULT__SPARE_1_SD1_HI 0x00AE

#define VL53LX_RESULT__SPARE_1_SD1_LO 0x00AF

#define VL53LX_RESULT__SPARE_2_SD1 0x00B0

#define VL53LX_RESULT__SPARE_2_SD1_HI 0x00B0

#define VL53LX_RESULT__SPARE_2_SD1_LO 0x00B1

#define VL53LX_RESULT__SPARE_3_SD1 0x00B2

#define VL53LX_RESULT__THRESH_INFO 0x00B3

#define VL53LX_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0 0x00B4

#define VL53LX_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0_3 0x00B4

#define VL53LX_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0_2 0x00B5

#define VL53LX_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0_1 0x00B6

#define VL53LX_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0_0 0x00B7

#define VL53LX_RESULT_CORE__RANGING_TOTAL_EVENTS_SD0 0x00B8

#define VL53LX_RESULT_CORE__RANGING_TOTAL_EVENTS_SD0_3 0x00B8

#define VL53LX_RESULT_CORE__RANGING_TOTAL_EVENTS_SD0_2 0x00B9

#define VL53LX_RESULT_CORE__RANGING_TOTAL_EVENTS_SD0_1 0x00BA

#define VL53LX_RESULT_CORE__RANGING_TOTAL_EVENTS_SD0_0 0x00BB

#define VL53LX_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD0 0x00BC

#define VL53LX_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD0_3 0x00BC

#define VL53LX_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD0_2 0x00BD

#define VL53LX_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD0_1 0x00BE

#define VL53LX_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD0_0 0x00BF

#define VL53LX_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD0 0x00C0

#define VL53LX_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD0_3 0x00C0

#define VL53LX_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD0_2 0x00C1

#define VL53LX_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD0_1 0x00C2

#define VL53LX_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD0_0 0x00C3

#define VL53LX_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD1 0x00C4

#define VL53LX_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD1_3 0x00C4

#define VL53LX_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD1_2 0x00C5

#define VL53LX_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD1_1 0x00C6

#define VL53LX_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD1_0 0x00C7

#define VL53LX_RESULT_CORE__RANGING_TOTAL_EVENTS_SD1 0x00C8

#define VL53LX_RESULT_CORE__RANGING_TOTAL_EVENTS_SD1_3 0x00C8

#define VL53LX_RESULT_CORE__RANGING_TOTAL_EVENTS_SD1_2 0x00C9

#define VL53LX_RESULT_CORE__RANGING_TOTAL_EVENTS_SD1_1 0x00CA

#define VL53LX_RESULT_CORE__RANGING_TOTAL_EVENTS_SD1_0 0x00CB

#define VL53LX_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD1 0x00CC

#define VL53LX_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD1_3 0x00CC

#define VL53LX_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD1_2 0x00CD

#define VL53LX_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD1_1 0x00CE

#define VL53LX_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD1_0 0x00CF

#define VL53LX_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD1 0x00D0

#define VL53LX_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD1_3 0x00D0

#define VL53LX_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD1_2 0x00D1

#define VL53LX_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD1_1 0x00D2

#define VL53LX_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD1_0 0x00D3

#define VL53LX_RESULT_CORE__SPARE_0 0x00D4

#define VL53LX_PHASECAL_RESULT__REFERENCE_PHASE 0x00D6

#define VL53LX_PHASECAL_RESULT__REFERENCE_PHASE_HI 0x00D6

#define VL53LX_PHASECAL_RESULT__REFERENCE_PHASE_LO 0x00D7

#define VL53LX_PHASECAL_RESULT__VCSEL_START 0x00D8

#define VL53LX_REF_SPAD_CHAR_RESULT__NUM_ACTUAL_REF_SPADS 0x00D9

#define VL53LX_REF_SPAD_CHAR_RESULT__REF_LOCATION 0x00DA

#define VL53LX_VHV_RESULT__COLDBOOT_STATUS 0x00DB

#define VL53LX_VHV_RESULT__SEARCH_RESULT 0x00DC

#define VL53LX_VHV_RESULT__LATEST_SETTING 0x00DD

#define VL53LX_RESULT__OSC_CALIBRATE_VAL 0x00DE

#define VL53LX_RESULT__OSC_CALIBRATE_VAL_HI 0x00DE

#define VL53LX_RESULT__OSC_CALIBRATE_VAL_LO 0x00DF

#define VL53LX_ANA_CONFIG__POWERDOWN_GO1 0x00E0

#define VL53LX_ANA_CONFIG__REF_BG_CTRL 0x00E1

#define VL53LX_ANA_CONFIG__REGDVDD1V2_CTRL 0x00E2

#define VL53LX_ANA_CONFIG__OSC_SLOW_CTRL 0x00E3

#define VL53LX_TEST_MODE__STATUS 0x00E4

#define VL53LX_FIRMWARE__SYSTEM_STATUS 0x00E5

#define VL53LX_FIRMWARE__MODE_STATUS 0x00E6

#define VL53LX_FIRMWARE__SECONDARY_MODE_STATUS 0x00E7

#define VL53LX_FIRMWARE__CAL_REPEAT_RATE_COUNTER 0x00E8

#define VL53LX_FIRMWARE__CAL_REPEAT_RATE_COUNTER_HI 0x00E8

#define VL53LX_FIRMWARE__CAL_REPEAT_RATE_COUNTER_LO 0x00E9

#define VL53LX_FIRMWARE__HISTOGRAM_BIN 0x00EA

#define VL53LX_GPH__SYSTEM__THRESH_HIGH 0x00EC

#define VL53LX_GPH__SYSTEM__THRESH_HIGH_HI 0x00EC

#define VL53LX_GPH__SYSTEM__THRESH_HIGH_LO 0x00ED

#define VL53LX_GPH__SYSTEM__THRESH_LOW 0x00EE

#define VL53LX_GPH__SYSTEM__THRESH_LOW_HI 0x00EE

#define VL53LX_GPH__SYSTEM__THRESH_LOW_LO 0x00EF

#define VL53LX_GPH__SYSTEM__ENABLE_XTALK_PER_QUADRANT 0x00F0

#define VL53LX_GPH__SPARE_0 0x00F1

#define VL53LX_GPH__SD_CONFIG__WOI_SD0 0x00F2

#define VL53LX_GPH__SD_CONFIG__WOI_SD1 0x00F3

#define VL53LX_GPH__SD_CONFIG__INITIAL_PHASE_SD0 0x00F4

#define VL53LX_GPH__SD_CONFIG__INITIAL_PHASE_SD1 0x00F5

#define VL53LX_GPH__SD_CONFIG__FIRST_ORDER_SELECT 0x00F6

#define VL53LX_GPH__SD_CONFIG__QUANTIFIER 0x00F7

#define VL53LX_GPH__ROI_CONFIG__USER_ROI_CENTRE_SPAD 0x00F8

#define VL53LX_GPH__ROI_CONFIG__USER_ROI_REQUESTED_GLOBAL_XY_SIZE 0x00F9

#define VL53LX_GPH__SYSTEM__SEQUENCE_CONFIG 0x00FA

#define VL53LX_GPH__GPH_ID 0x00FB

#define VL53LX_SYSTEM__INTERRUPT_SET 0x00FC

#define VL53LX_INTERRUPT_MANAGER__ENABLES 0x00FD

#define VL53LX_INTERRUPT_MANAGER__CLEAR 0x00FE

#define VL53LX_INTERRUPT_MANAGER__STATUS 0x00FF

#define VL53LX_MCU_TO_HOST_BANK__WR_ACCESS_EN 0x0100

#define VL53LX_POWER_MANAGEMENT__GO1_RESET_STATUS 0x0101

#define VL53LX_PAD_STARTUP_MODE__VALUE_RO 0x0102

#define VL53LX_PAD_STARTUP_MODE__VALUE_CTRL 0x0103

#define VL53LX_PLL_PERIOD_US 0x0104

#define VL53LX_PLL_PERIOD_US_3 0x0104

#define VL53LX_PLL_PERIOD_US_2 0x0105

#define VL53LX_PLL_PERIOD_US_1 0x0106

#define VL53LX_PLL_PERIOD_US_0 0x0107

#define VL53LX_INTERRUPT_SCHEDULER__DATA_OUT 0x0108

#define VL53LX_INTERRUPT_SCHEDULER__DATA_OUT_3 0x0108

#define VL53LX_INTERRUPT_SCHEDULER__DATA_OUT_2 0x0109

#define VL53LX_INTERRUPT_SCHEDULER__DATA_OUT_1 0x010A

#define VL53LX_INTERRUPT_SCHEDULER__DATA_OUT_0 0x010B

#define VL53LX_NVM_BIST__COMPLETE 0x010C

#define VL53LX_NVM_BIST__STATUS 0x010D

#define VL53LX_IDENTIFICATION__MODEL_ID 0x010F

#define VL53LX_IDENTIFICATION__MODULE_TYPE 0x0110

#define VL53LX_IDENTIFICATION__REVISION_ID 0x0111

#define VL53LX_IDENTIFICATION__MODULE_ID 0x0112

#define VL53LX_IDENTIFICATION__MODULE_ID_HI 0x0112

#define VL53LX_IDENTIFICATION__MODULE_ID_LO 0x0113

#define VL53LX_ANA_CONFIG__FAST_OSC__TRIM_MAX 0x0114

#define VL53LX_ANA_CONFIG__FAST_OSC__FREQ_SET 0x0115

#define VL53LX_ANA_CONFIG__VCSEL_TRIM 0x0116

#define VL53LX_ANA_CONFIG__VCSEL_SELION 0x0117

#define VL53LX_ANA_CONFIG__VCSEL_SELION_MAX 0x0118

#define VL53LX_PROTECTED_LASER_SAFETY__LOCK_BIT 0x0119

#define VL53LX_LASER_SAFETY__KEY 0x011A

#define VL53LX_LASER_SAFETY__KEY_RO 0x011B

#define VL53LX_LASER_SAFETY__CLIP 0x011C

#define VL53LX_LASER_SAFETY__MULT 0x011D

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_0 0x011E

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_1 0x011F

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_2 0x0120

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_3 0x0121

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_4 0x0122

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_5 0x0123

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_6 0x0124

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_7 0x0125

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_8 0x0126

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_9 0x0127

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_10 0x0128

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_11 0x0129

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_12 0x012A

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_13 0x012B

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_14 0x012C

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_15 0x012D

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_16 0x012E

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_17 0x012F

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_18 0x0130

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_19 0x0131

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_20 0x0132

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_21 0x0133

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_22 0x0134

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_23 0x0135

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_24 0x0136

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_25 0x0137

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_26 0x0138

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_27 0x0139

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_28 0x013A

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_29 0x013B

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_30 0x013C

#define VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_RTN_31 0x013D

#define VL53LX_ROI_CONFIG__MODE_ROI_CENTRE_SPAD 0x013E

#define VL53LX_ROI_CONFIG__MODE_ROI_XY_SIZE 0x013F

#define VL53LX_GO2_HOST_BANK_ACCESS__OVERRIDE 0x0300

#define VL53LX_MCU_UTIL_MULTIPLIER__MULTIPLICAND 0x0400

#define VL53LX_MCU_UTIL_MULTIPLIER__MULTIPLICAND_3 0x0400

#define VL53LX_MCU_UTIL_MULTIPLIER__MULTIPLICAND_2 0x0401

#define VL53LX_MCU_UTIL_MULTIPLIER__MULTIPLICAND_1 0x0402

#define VL53LX_MCU_UTIL_MULTIPLIER__MULTIPLICAND_0 0x0403

#define VL53LX_MCU_UTIL_MULTIPLIER__MULTIPLIER 0x0404

#define VL53LX_MCU_UTIL_MULTIPLIER__MULTIPLIER_3 0x0404

#define VL53LX_MCU_UTIL_MULTIPLIER__MULTIPLIER_2 0x0405

#define VL53LX_MCU_UTIL_MULTIPLIER__MULTIPLIER_1 0x0406

#define VL53LX_MCU_UTIL_MULTIPLIER__MULTIPLIER_0 0x0407

#define VL53LX_MCU_UTIL_MULTIPLIER__PRODUCT_HI 0x0408

#define VL53LX_MCU_UTIL_MULTIPLIER__PRODUCT_HI_3 0x0408

#define VL53LX_MCU_UTIL_MULTIPLIER__PRODUCT_HI_2 0x0409

#define VL53LX_MCU_UTIL_MULTIPLIER__PRODUCT_HI_1 0x040A

#define VL53LX_MCU_UTIL_MULTIPLIER__PRODUCT_HI_0 0x040B

#define VL53LX_MCU_UTIL_MULTIPLIER__PRODUCT_LO 0x040C

#define VL53LX_MCU_UTIL_MULTIPLIER__PRODUCT_LO_3 0x040C

#define VL53LX_MCU_UTIL_MULTIPLIER__PRODUCT_LO_2 0x040D

#define VL53LX_MCU_UTIL_MULTIPLIER__PRODUCT_LO_1 0x040E

#define VL53LX_MCU_UTIL_MULTIPLIER__PRODUCT_LO_0 0x040F

#define VL53LX_MCU_UTIL_MULTIPLIER__START 0x0410

#define VL53LX_MCU_UTIL_MULTIPLIER__STATUS 0x0411

#define VL53LX_MCU_UTIL_DIVIDER__START 0x0412

#define VL53LX_MCU_UTIL_DIVIDER__STATUS 0x0413

#define VL53LX_MCU_UTIL_DIVIDER__DIVIDEND 0x0414

#define VL53LX_MCU_UTIL_DIVIDER__DIVIDEND_3 0x0414

#define VL53LX_MCU_UTIL_DIVIDER__DIVIDEND_2 0x0415

#define VL53LX_MCU_UTIL_DIVIDER__DIVIDEND_1 0x0416

#define VL53LX_MCU_UTIL_DIVIDER__DIVIDEND_0 0x0417

#define VL53LX_MCU_UTIL_DIVIDER__DIVISOR 0x0418

#define VL53LX_MCU_UTIL_DIVIDER__DIVISOR_3 0x0418

#define VL53LX_MCU_UTIL_DIVIDER__DIVISOR_2 0x0419

#define VL53LX_MCU_UTIL_DIVIDER__DIVISOR_1 0x041A

#define VL53LX_MCU_UTIL_DIVIDER__DIVISOR_0 0x041B

#define VL53LX_MCU_UTIL_DIVIDER__QUOTIENT 0x041C

#define VL53LX_MCU_UTIL_DIVIDER__QUOTIENT_3 0x041C

#define VL53LX_MCU_UTIL_DIVIDER__QUOTIENT_2 0x041D

#define VL53LX_MCU_UTIL_DIVIDER__QUOTIENT_1 0x041E

#define VL53LX_MCU_UTIL_DIVIDER__QUOTIENT_0 0x041F

#define VL53LX_TIMER0__VALUE_IN 0x0420

#define VL53LX_TIMER0__VALUE_IN_3 0x0420

#define VL53LX_TIMER0__VALUE_IN_2 0x0421

#define VL53LX_TIMER0__VALUE_IN_1 0x0422

#define VL53LX_TIMER0__VALUE_IN_0 0x0423

#define VL53LX_TIMER1__VALUE_IN 0x0424

#define VL53LX_TIMER1__VALUE_IN_3 0x0424

#define VL53LX_TIMER1__VALUE_IN_2 0x0425

#define VL53LX_TIMER1__VALUE_IN_1 0x0426

#define VL53LX_TIMER1__VALUE_IN_0 0x0427

#define VL53LX_TIMER0__CTRL 0x0428

#define VL53LX_TIMER1__CTRL 0x0429

#define VL53LX_MCU_GENERAL_PURPOSE__GP_0 0x042C

#define VL53LX_MCU_GENERAL_PURPOSE__GP_1 0x042D

#define VL53LX_MCU_GENERAL_PURPOSE__GP_2 0x042E

#define VL53LX_MCU_GENERAL_PURPOSE__GP_3 0x042F

#define VL53LX_MCU_RANGE_CALC__CONFIG 0x0430

#define VL53LX_MCU_RANGE_CALC__OFFSET_CORRECTED_RANGE 0x0432

#define VL53LX_MCU_RANGE_CALC__OFFSET_CORRECTED_RANGE_HI 0x0432

#define VL53LX_MCU_RANGE_CALC__OFFSET_CORRECTED_RANGE_LO 0x0433

#define VL53LX_MCU_RANGE_CALC__SPARE_4 0x0434

#define VL53LX_MCU_RANGE_CALC__SPARE_4_3 0x0434

#define VL53LX_MCU_RANGE_CALC__SPARE_4_2 0x0435

#define VL53LX_MCU_RANGE_CALC__SPARE_4_1 0x0436

#define VL53LX_MCU_RANGE_CALC__SPARE_4_0 0x0437

#define VL53LX_MCU_RANGE_CALC__AMBIENT_DURATION_PRE_CALC 0x0438

#define VL53LX_MCU_RANGE_CALC__AMBIENT_DURATION_PRE_CALC_HI 0x0438

#define VL53LX_MCU_RANGE_CALC__AMBIENT_DURATION_PRE_CALC_LO 0x0439

#define VL53LX_MCU_RANGE_CALC__ALGO_VCSEL_PERIOD 0x043C

#define VL53LX_MCU_RANGE_CALC__SPARE_5 0x043D

#define VL53LX_MCU_RANGE_CALC__ALGO_TOTAL_PERIODS 0x043E

#define VL53LX_MCU_RANGE_CALC__ALGO_TOTAL_PERIODS_HI 0x043E

#define VL53LX_MCU_RANGE_CALC__ALGO_TOTAL_PERIODS_LO 0x043F

#define VL53LX_MCU_RANGE_CALC__ALGO_ACCUM_PHASE 0x0440

#define VL53LX_MCU_RANGE_CALC__ALGO_ACCUM_PHASE_3 0x0440

#define VL53LX_MCU_RANGE_CALC__ALGO_ACCUM_PHASE_2 0x0441

#define VL53LX_MCU_RANGE_CALC__ALGO_ACCUM_PHASE_1 0x0442

#define VL53LX_MCU_RANGE_CALC__ALGO_ACCUM_PHASE_0 0x0443

#define VL53LX_MCU_RANGE_CALC__ALGO_SIGNAL_EVENTS 0x0444

#define VL53LX_MCU_RANGE_CALC__ALGO_SIGNAL_EVENTS_3 0x0444

#define VL53LX_MCU_RANGE_CALC__ALGO_SIGNAL_EVENTS_2 0x0445

#define VL53LX_MCU_RANGE_CALC__ALGO_SIGNAL_EVENTS_1 0x0446

#define VL53LX_MCU_RANGE_CALC__ALGO_SIGNAL_EVENTS_0 0x0447

#define VL53LX_MCU_RANGE_CALC__ALGO_AMBIENT_EVENTS 0x0448

#define VL53LX_MCU_RANGE_CALC__ALGO_AMBIENT_EVENTS_3 0x0448

#define VL53LX_MCU_RANGE_CALC__ALGO_AMBIENT_EVENTS_2 0x0449

#define VL53LX_MCU_RANGE_CALC__ALGO_AMBIENT_EVENTS_1 0x044A

#define VL53LX_MCU_RANGE_CALC__ALGO_AMBIENT_EVENTS_0 0x044B

#define VL53LX_MCU_RANGE_CALC__SPARE_6 0x044C

#define VL53LX_MCU_RANGE_CALC__SPARE_6_HI 0x044C

#define VL53LX_MCU_RANGE_CALC__SPARE_6_LO 0x044D

#define VL53LX_MCU_RANGE_CALC__ALGO_ADJUST_VCSEL_PERIOD 0x044E

#define VL53LX_MCU_RANGE_CALC__ALGO_ADJUST_VCSEL_PERIOD_HI 0x044E

#define VL53LX_MCU_RANGE_CALC__ALGO_ADJUST_VCSEL_PERIOD_LO 0x044F

#define VL53LX_MCU_RANGE_CALC__NUM_SPADS 0x0450

#define VL53LX_MCU_RANGE_CALC__NUM_SPADS_HI 0x0450

#define VL53LX_MCU_RANGE_CALC__NUM_SPADS_LO 0x0451

#define VL53LX_MCU_RANGE_CALC__PHASE_OUTPUT 0x0452

#define VL53LX_MCU_RANGE_CALC__PHASE_OUTPUT_HI 0x0452

#define VL53LX_MCU_RANGE_CALC__PHASE_OUTPUT_LO 0x0453

#define VL53LX_MCU_RANGE_CALC__RATE_PER_SPAD_MCPS 0x0454

#define VL53LX_MCU_RANGE_CALC__RATE_PER_SPAD_MCPS_3 0x0454

#define VL53LX_MCU_RANGE_CALC__RATE_PER_SPAD_MCPS_2 0x0455

#define VL53LX_MCU_RANGE_CALC__RATE_PER_SPAD_MCPS_1 0x0456

#define VL53LX_MCU_RANGE_CALC__RATE_PER_SPAD_MCPS_0 0x0457

#define VL53LX_MCU_RANGE_CALC__SPARE_7 0x0458

#define VL53LX_MCU_RANGE_CALC__SPARE_8 0x0459

#define VL53LX_MCU_RANGE_CALC__PEAK_SIGNAL_RATE_MCPS 0x045A

#define VL53LX_MCU_RANGE_CALC__PEAK_SIGNAL_RATE_MCPS_HI 0x045A

#define VL53LX_MCU_RANGE_CALC__PEAK_SIGNAL_RATE_MCPS_LO 0x045B

#define VL53LX_MCU_RANGE_CALC__AVG_SIGNAL_RATE_MCPS 0x045C

#define VL53LX_MCU_RANGE_CALC__AVG_SIGNAL_RATE_MCPS_HI 0x045C

#define VL53LX_MCU_RANGE_CALC__AVG_SIGNAL_RATE_MCPS_LO 0x045D

#define VL53LX_MCU_RANGE_CALC__AMBIENT_RATE_MCPS 0x045E

#define VL53LX_MCU_RANGE_CALC__AMBIENT_RATE_MCPS_HI 0x045E

#define VL53LX_MCU_RANGE_CALC__AMBIENT_RATE_MCPS_LO 0x045F

#define VL53LX_MCU_RANGE_CALC__XTALK 0x0460

#define VL53LX_MCU_RANGE_CALC__XTALK_HI 0x0460

#define VL53LX_MCU_RANGE_CALC__XTALK_LO 0x0461

#define VL53LX_MCU_RANGE_CALC__CALC_STATUS 0x0462

#define VL53LX_MCU_RANGE_CALC__DEBUG 0x0463

#define VL53LX_MCU_RANGE_CALC__PEAK_SIGNAL_RATE_XTALK_CORR_MCPS 0x0464

#define VL53LX_MCU_RANGE_CALC__PEAK_SIGNAL_RATE_XTALK_CORR_MCPS_HI 0x0464

#define VL53LX_MCU_RANGE_CALC__PEAK_SIGNAL_RATE_XTALK_CORR_MCPS_LO 0x0465

#define VL53LX_MCU_RANGE_CALC__SPARE_0 0x0468

#define VL53LX_MCU_RANGE_CALC__SPARE_1 0x0469

#define VL53LX_MCU_RANGE_CALC__SPARE_2 0x046A

#define VL53LX_MCU_RANGE_CALC__SPARE_3 0x046B

#define VL53LX_PATCH__CTRL 0x0470

#define VL53LX_PATCH__JMP_ENABLES 0x0472

#define VL53LX_PATCH__JMP_ENABLES_HI 0x0472

#define VL53LX_PATCH__JMP_ENABLES_LO 0x0473

#define VL53LX_PATCH__DATA_ENABLES 0x0474

#define VL53LX_PATCH__DATA_ENABLES_HI 0x0474

#define VL53LX_PATCH__DATA_ENABLES_LO 0x0475

#define VL53LX_PATCH__OFFSET_0 0x0476

#define VL53LX_PATCH__OFFSET_0_HI 0x0476

#define VL53LX_PATCH__OFFSET_0_LO 0x0477

#define VL53LX_PATCH__OFFSET_1 0x0478

#define VL53LX_PATCH__OFFSET_1_HI 0x0478

#define VL53LX_PATCH__OFFSET_1_LO 0x0479

#define VL53LX_PATCH__OFFSET_2 0x047A

#define VL53LX_PATCH__OFFSET_2_HI 0x047A

#define VL53LX_PATCH__OFFSET_2_LO 0x047B

#define VL53LX_PATCH__OFFSET_3 0x047C

#define VL53LX_PATCH__OFFSET_3_HI 0x047C

#define VL53LX_PATCH__OFFSET_3_LO 0x047D

#define VL53LX_PATCH__OFFSET_4 0x047E

#define VL53LX_PATCH__OFFSET_4_HI 0x047E

#define VL53LX_PATCH__OFFSET_4_LO 0x047F

#define VL53LX_PATCH__OFFSET_5 0x0480

#define VL53LX_PATCH__OFFSET_5_HI 0x0480

#define VL53LX_PATCH__OFFSET_5_LO 0x0481

#define VL53LX_PATCH__OFFSET_6 0x0482

#define VL53LX_PATCH__OFFSET_6_HI 0x0482

#define VL53LX_PATCH__OFFSET_6_LO 0x0483

#define VL53LX_PATCH__OFFSET_7 0x0484

#define VL53LX_PATCH__OFFSET_7_HI 0x0484

#define VL53LX_PATCH__OFFSET_7_LO 0x0485

#define VL53LX_PATCH__OFFSET_8 0x0486

#define VL53LX_PATCH__OFFSET_8_HI 0x0486

#define VL53LX_PATCH__OFFSET_8_LO 0x0487

#define VL53LX_PATCH__OFFSET_9 0x0488

#define VL53LX_PATCH__OFFSET_9_HI 0x0488

#define VL53LX_PATCH__OFFSET_9_LO 0x0489

#define VL53LX_PATCH__OFFSET_10 0x048A

#define VL53LX_PATCH__OFFSET_10_HI 0x048A

#define VL53LX_PATCH__OFFSET_10_LO 0x048B

#define VL53LX_PATCH__OFFSET_11 0x048C

#define VL53LX_PATCH__OFFSET_11_HI 0x048C

#define VL53LX_PATCH__OFFSET_11_LO 0x048D

#define VL53LX_PATCH__OFFSET_12 0x048E

#define VL53LX_PATCH__OFFSET_12_HI 0x048E

#define VL53LX_PATCH__OFFSET_12_LO 0x048F

#define VL53LX_PATCH__OFFSET_13 0x0490

#define VL53LX_PATCH__OFFSET_13_HI 0x0490

#define VL53LX_PATCH__OFFSET_13_LO 0x0491

#define VL53LX_PATCH__OFFSET_14 0x0492

#define VL53LX_PATCH__OFFSET_14_HI 0x0492

#define VL53LX_PATCH__OFFSET_14_LO 0x0493

#define VL53LX_PATCH__OFFSET_15 0x0494

#define VL53LX_PATCH__OFFSET_15_HI 0x0494

#define VL53LX_PATCH__OFFSET_15_LO 0x0495

#define VL53LX_PATCH__ADDRESS_0 0x0496

#define VL53LX_PATCH__ADDRESS_0_HI 0x0496

#define VL53LX_PATCH__ADDRESS_0_LO 0x0497

#define VL53LX_PATCH__ADDRESS_1 0x0498

#define VL53LX_PATCH__ADDRESS_1_HI 0x0498

#define VL53LX_PATCH__ADDRESS_1_LO 0x0499

#define VL53LX_PATCH__ADDRESS_2 0x049A

#define VL53LX_PATCH__ADDRESS_2_HI 0x049A

#define VL53LX_PATCH__ADDRESS_2_LO 0x049B

#define VL53LX_PATCH__ADDRESS_3 0x049C

#define VL53LX_PATCH__ADDRESS_3_HI 0x049C

#define VL53LX_PATCH__ADDRESS_3_LO 0x049D

#define VL53LX_PATCH__ADDRESS_4 0x049E

#define VL53LX_PATCH__ADDRESS_4_HI 0x049E

#define VL53LX_PATCH__ADDRESS_4_LO 0x049F

#define VL53LX_PATCH__ADDRESS_5 0x04A0

#define VL53LX_PATCH__ADDRESS_5_HI 0x04A0

#define VL53LX_PATCH__ADDRESS_5_LO 0x04A1

#define VL53LX_PATCH__ADDRESS_6 0x04A2

#define VL53LX_PATCH__ADDRESS_6_HI 0x04A2

#define VL53LX_PATCH__ADDRESS_6_LO 0x04A3

#define VL53LX_PATCH__ADDRESS_7 0x04A4

#define VL53LX_PATCH__ADDRESS_7_HI 0x04A4

#define VL53LX_PATCH__ADDRESS_7_LO 0x04A5

#define VL53LX_PATCH__ADDRESS_8 0x04A6

#define VL53LX_PATCH__ADDRESS_8_HI 0x04A6

#define VL53LX_PATCH__ADDRESS_8_LO 0x04A7

#define VL53LX_PATCH__ADDRESS_9 0x04A8

#define VL53LX_PATCH__ADDRESS_9_HI 0x04A8

#define VL53LX_PATCH__ADDRESS_9_LO 0x04A9

#define VL53LX_PATCH__ADDRESS_10 0x04AA

#define VL53LX_PATCH__ADDRESS_10_HI 0x04AA

#define VL53LX_PATCH__ADDRESS_10_LO 0x04AB

#define VL53LX_PATCH__ADDRESS_11 0x04AC

#define VL53LX_PATCH__ADDRESS_11_HI 0x04AC

#define VL53LX_PATCH__ADDRESS_11_LO 0x04AD

#define VL53LX_PATCH__ADDRESS_12 0x04AE

#define VL53LX_PATCH__ADDRESS_12_HI 0x04AE

#define VL53LX_PATCH__ADDRESS_12_LO 0x04AF

#define VL53LX_PATCH__ADDRESS_13 0x04B0

#define VL53LX_PATCH__ADDRESS_13_HI 0x04B0

#define VL53LX_PATCH__ADDRESS_13_LO 0x04B1

#define VL53LX_PATCH__ADDRESS_14 0x04B2

#define VL53LX_PATCH__ADDRESS_14_HI 0x04B2

#define VL53LX_PATCH__ADDRESS_14_LO 0x04B3

#define VL53LX_PATCH__ADDRESS_15 0x04B4

#define VL53LX_PATCH__ADDRESS_15_HI 0x04B4

#define VL53LX_PATCH__ADDRESS_15_LO 0x04B5

#define VL53LX_SPI_ASYNC_MUX__CTRL 0x04C0

#define VL53LX_CLK__CONFIG 0x04C4

#define VL53LX_GPIO_LV_MUX__CTRL 0x04CC

#define VL53LX_GPIO_LV_PAD__CTRL 0x04CD

#define VL53LX_PAD_I2C_LV__CONFIG 0x04D0

#define VL53LX_PAD_STARTUP_MODE__VALUE_RO_GO1 0x04D4

#define VL53LX_HOST_IF__STATUS_GO1 0x04D5

#define VL53LX_MCU_CLK_GATING__CTRL 0x04D8

#define VL53LX_TEST__BIST_ROM_CTRL 0x04E0

#define VL53LX_TEST__BIST_ROM_RESULT 0x04E1

#define VL53LX_TEST__BIST_ROM_MCU_SIG 0x04E2

#define VL53LX_TEST__BIST_ROM_MCU_SIG_HI 0x04E2

#define VL53LX_TEST__BIST_ROM_MCU_SIG_LO 0x04E3

#define VL53LX_TEST__BIST_RAM_CTRL 0x04E4

#define VL53LX_TEST__BIST_RAM_RESULT 0x04E5

#define VL53LX_TEST__TMC 0x04E8

#define VL53LX_TEST__PLL_BIST_MIN_THRESHOLD 0x04F0

#define VL53LX_TEST__PLL_BIST_MIN_THRESHOLD_HI 0x04F0

#define VL53LX_TEST__PLL_BIST_MIN_THRESHOLD_LO 0x04F1

#define VL53LX_TEST__PLL_BIST_MAX_THRESHOLD 0x04F2

#define VL53LX_TEST__PLL_BIST_MAX_THRESHOLD_HI 0x04F2

#define VL53LX_TEST__PLL_BIST_MAX_THRESHOLD_LO 0x04F3

#define VL53LX_TEST__PLL_BIST_COUNT_OUT 0x04F4

#define VL53LX_TEST__PLL_BIST_COUNT_OUT_HI 0x04F4

#define VL53LX_TEST__PLL_BIST_COUNT_OUT_LO 0x04F5

#define VL53LX_TEST__PLL_BIST_GONOGO 0x04F6

#define VL53LX_TEST__PLL_BIST_CTRL 0x04F7

#define VL53LX_RANGING_CORE__DEVICE_ID 0x0680

#define VL53LX_RANGING_CORE__REVISION_ID 0x0681

#define VL53LX_RANGING_CORE__CLK_CTRL1 0x0683

#define VL53LX_RANGING_CORE__CLK_CTRL2 0x0684

#define VL53LX_RANGING_CORE__WOI_1 0x0685

#define VL53LX_RANGING_CORE__WOI_REF_1 0x0686

#define VL53LX_RANGING_CORE__START_RANGING 0x0687

#define VL53LX_RANGING_CORE__LOW_LIMIT_1 0x0690

#define VL53LX_RANGING_CORE__HIGH_LIMIT_1 0x0691

#define VL53LX_RANGING_CORE__LOW_LIMIT_REF_1 0x0692

#define VL53LX_RANGING_CORE__HIGH_LIMIT_REF_1 0x0693

#define VL53LX_RANGING_CORE__QUANTIFIER_1_MSB 0x0694

#define VL53LX_RANGING_CORE__QUANTIFIER_1_LSB 0x0695

#define VL53LX_RANGING_CORE__QUANTIFIER_REF_1_MSB 0x0696

#define VL53LX_RANGING_CORE__QUANTIFIER_REF_1_LSB 0x0697

#define VL53LX_RANGING_CORE__AMBIENT_OFFSET_1_MSB 0x0698

#define VL53LX_RANGING_CORE__AMBIENT_OFFSET_1_LSB 0x0699

#define VL53LX_RANGING_CORE__AMBIENT_OFFSET_REF_1_MSB 0x069A

#define VL53LX_RANGING_CORE__AMBIENT_OFFSET_REF_1_LSB 0x069B

#define VL53LX_RANGING_CORE__FILTER_STRENGTH_1 0x069C

#define VL53LX_RANGING_CORE__FILTER_STRENGTH_REF_1 0x069D

#define VL53LX_RANGING_CORE__SIGNAL_EVENT_LIMIT_1_MSB 0x069E

#define VL53LX_RANGING_CORE__SIGNAL_EVENT_LIMIT_1_LSB 0x069F

#define VL53LX_RANGING_CORE__SIGNAL_EVENT_LIMIT_REF_1_MSB 0x06A0

#define VL53LX_RANGING_CORE__SIGNAL_EVENT_LIMIT_REF_1_LSB 0x06A1

#define VL53LX_RANGING_CORE__TIMEOUT_OVERALL_PERIODS_MSB 0x06A4

#define VL53LX_RANGING_CORE__TIMEOUT_OVERALL_PERIODS_LSB 0x06A5

#define VL53LX_RANGING_CORE__INVERT_HW 0x06A6

#define VL53LX_RANGING_CORE__FORCE_HW 0x06A7

#define VL53LX_RANGING_CORE__STATIC_HW_VALUE 0x06A8

#define VL53LX_RANGING_CORE__FORCE_CONTINUOUS_AMBIENT 0x06A9

#define VL53LX_RANGING_CORE__TEST_PHASE_SELECT_TO_FILTER 0x06AA

#define VL53LX_RANGING_CORE__TEST_PHASE_SELECT_TO_TIMING_GEN 0x06AB

#define VL53LX_RANGING_CORE__INITIAL_PHASE_VALUE_1 0x06AC

#define VL53LX_RANGING_CORE__INITIAL_PHASE_VALUE_REF_1 0x06AD

#define VL53LX_RANGING_CORE__FORCE_UP_IN 0x06AE

#define VL53LX_RANGING_CORE__FORCE_DN_IN 0x06AF

#define VL53LX_RANGING_CORE__STATIC_UP_VALUE_1 0x06B0

#define VL53LX_RANGING_CORE__STATIC_UP_VALUE_REF_1 0x06B1

#define VL53LX_RANGING_CORE__STATIC_DN_VALUE_1 0x06B2

#define VL53LX_RANGING_CORE__STATIC_DN_VALUE_REF_1 0x06B3

#define VL53LX_RANGING_CORE__MONITOR_UP_DN 0x06B4

#define VL53LX_RANGING_CORE__INVERT_UP_DN 0x06B5

#define VL53LX_RANGING_CORE__CPUMP_1 0x06B6

#define VL53LX_RANGING_CORE__CPUMP_2 0x06B7

#define VL53LX_RANGING_CORE__CPUMP_3 0x06B8

#define VL53LX_RANGING_CORE__OSC_1 0x06B9

#define VL53LX_RANGING_CORE__PLL_1 0x06BB

#define VL53LX_RANGING_CORE__PLL_2 0x06BC

#define VL53LX_RANGING_CORE__REFERENCE_1 0x06BD

#define VL53LX_RANGING_CORE__REFERENCE_3 0x06BF

#define VL53LX_RANGING_CORE__REFERENCE_4 0x06C0

#define VL53LX_RANGING_CORE__REFERENCE_5 0x06C1

#define VL53LX_RANGING_CORE__REGAVDD1V2 0x06C3

#define VL53LX_RANGING_CORE__CALIB_1 0x06C4

#define VL53LX_RANGING_CORE__CALIB_2 0x06C5

#define VL53LX_RANGING_CORE__CALIB_3 0x06C6

#define VL53LX_RANGING_CORE__TST_MUX_SEL1 0x06C9

#define VL53LX_RANGING_CORE__TST_MUX_SEL2 0x06CA

#define VL53LX_RANGING_CORE__TST_MUX 0x06CB

#define VL53LX_RANGING_CORE__GPIO_OUT_TESTMUX 0x06CC

#define VL53LX_RANGING_CORE__CUSTOM_FE 0x06CD

#define VL53LX_RANGING_CORE__CUSTOM_FE_2 0x06CE

#define VL53LX_RANGING_CORE__SPAD_READOUT 0x06CF

#define VL53LX_RANGING_CORE__SPAD_READOUT_1 0x06D0

#define VL53LX_RANGING_CORE__SPAD_READOUT_2 0x06D1

#define VL53LX_RANGING_CORE__SPAD_PS 0x06D2

#define VL53LX_RANGING_CORE__LASER_SAFETY_2 0x06D4

#define VL53LX_RANGING_CORE__NVM_CTRL__MODE 0x0780

#define VL53LX_RANGING_CORE__NVM_CTRL__PDN 0x0781

#define VL53LX_RANGING_CORE__NVM_CTRL__PROGN 0x0782

#define VL53LX_RANGING_CORE__NVM_CTRL__READN 0x0783

#define VL53LX_RANGING_CORE__NVM_CTRL__PULSE_WIDTH_MSB 0x0784

#define VL53LX_RANGING_CORE__NVM_CTRL__PULSE_WIDTH_LSB 0x0785

#define VL53LX_RANGING_CORE__NVM_CTRL__HV_RISE_MSB 0x0786

#define VL53LX_RANGING_CORE__NVM_CTRL__HV_RISE_LSB 0x0787

#define VL53LX_RANGING_CORE__NVM_CTRL__HV_FALL_MSB 0x0788

#define VL53LX_RANGING_CORE__NVM_CTRL__HV_FALL_LSB 0x0789

#define VL53LX_RANGING_CORE__NVM_CTRL__TST 0x078A

#define VL53LX_RANGING_CORE__NVM_CTRL__TESTREAD 0x078B

#define VL53LX_RANGING_CORE__NVM_CTRL__DATAIN_MMM 0x078C

#define VL53LX_RANGING_CORE__NVM_CTRL__DATAIN_LMM 0x078D

#define VL53LX_RANGING_CORE__NVM_CTRL__DATAIN_LLM 0x078E

#define VL53LX_RANGING_CORE__NVM_CTRL__DATAIN_LLL 0x078F

#define VL53LX_RANGING_CORE__NVM_CTRL__DATAOUT_MMM 0x0790

#define VL53LX_RANGING_CORE__NVM_CTRL__DATAOUT_LMM 0x0791

#define VL53LX_RANGING_CORE__NVM_CTRL__DATAOUT_LLM 0x0792

#define VL53LX_RANGING_CORE__NVM_CTRL__DATAOUT_LLL 0x0793

#define VL53LX_RANGING_CORE__NVM_CTRL__ADDR 0x0794

#define VL53LX_RANGING_CORE__NVM_CTRL__DATAOUT_ECC 0x0795

#define VL53LX_RANGING_CORE__RET_SPAD_EN_0 0x0796

#define VL53LX_RANGING_CORE__RET_SPAD_EN_1 0x0797

#define VL53LX_RANGING_CORE__RET_SPAD_EN_2 0x0798

#define VL53LX_RANGING_CORE__RET_SPAD_EN_3 0x0799

#define VL53LX_RANGING_CORE__RET_SPAD_EN_4 0x079A

#define VL53LX_RANGING_CORE__RET_SPAD_EN_5 0x079B

#define VL53LX_RANGING_CORE__RET_SPAD_EN_6 0x079C

#define VL53LX_RANGING_CORE__RET_SPAD_EN_7 0x079D

#define VL53LX_RANGING_CORE__RET_SPAD_EN_8 0x079E

#define VL53LX_RANGING_CORE__RET_SPAD_EN_9 0x079F

#define VL53LX_RANGING_CORE__RET_SPAD_EN_10 0x07A0

#define VL53LX_RANGING_CORE__RET_SPAD_EN_11 0x07A1

#define VL53LX_RANGING_CORE__RET_SPAD_EN_12 0x07A2

#define VL53LX_RANGING_CORE__RET_SPAD_EN_13 0x07A3

#define VL53LX_RANGING_CORE__RET_SPAD_EN_14 0x07A4

#define VL53LX_RANGING_CORE__RET_SPAD_EN_15 0x07A5

#define VL53LX_RANGING_CORE__RET_SPAD_EN_16 0x07A6

#define VL53LX_RANGING_CORE__RET_SPAD_EN_17 0x07A7

#define VL53LX_RANGING_CORE__SPAD_SHIFT_EN 0x07BA

#define VL53LX_RANGING_CORE__SPAD_DISABLE_CTRL 0x07BB

#define VL53LX_RANGING_CORE__SPAD_EN_SHIFT_OUT_DEBUG 0x07BC

#define VL53LX_RANGING_CORE__SPI_MODE 0x07BD

#define VL53LX_RANGING_CORE__GPIO_DIR 0x07BE

#define VL53LX_RANGING_CORE__VCSEL_PERIOD 0x0880

#define VL53LX_RANGING_CORE__VCSEL_START 0x0881

#define VL53LX_RANGING_CORE__VCSEL_STOP 0x0882

#define VL53LX_RANGING_CORE__VCSEL_1 0x0885

#define VL53LX_RANGING_CORE__VCSEL_STATUS 0x088D

#define VL53LX_RANGING_CORE__STATUS 0x0980

#define VL53LX_RANGING_CORE__LASER_CONTINUITY_STATE 0x0981

#define VL53LX_RANGING_CORE__RANGE_1_MMM 0x0982

#define VL53LX_RANGING_CORE__RANGE_1_LMM 0x0983

#define VL53LX_RANGING_CORE__RANGE_1_LLM 0x0984

#define VL53LX_RANGING_CORE__RANGE_1_LLL 0x0985

#define VL53LX_RANGING_CORE__RANGE_REF_1_MMM 0x0986

#define VL53LX_RANGING_CORE__RANGE_REF_1_LMM 0x0987

#define VL53LX_RANGING_CORE__RANGE_REF_1_LLM 0x0988

#define VL53LX_RANGING_CORE__RANGE_REF_1_LLL 0x0989

#define VL53LX_RANGING_CORE__AMBIENT_WINDOW_EVENTS_1_MMM 0x098A

#define VL53LX_RANGING_CORE__AMBIENT_WINDOW_EVENTS_1_LMM 0x098B

#define VL53LX_RANGING_CORE__AMBIENT_WINDOW_EVENTS_1_LLM 0x098C

#define VL53LX_RANGING_CORE__AMBIENT_WINDOW_EVENTS_1_LLL 0x098D

#define VL53LX_RANGING_CORE__RANGING_TOTAL_EVENTS_1_MMM 0x098E

#define VL53LX_RANGING_CORE__RANGING_TOTAL_EVENTS_1_LMM 0x098F

#define VL53LX_RANGING_CORE__RANGING_TOTAL_EVENTS_1_LLM 0x0990

#define VL53LX_RANGING_CORE__RANGING_TOTAL_EVENTS_1_LLL 0x0991

#define VL53LX_RANGING_CORE__SIGNAL_TOTAL_EVENTS_1_MMM 0x0992

#define VL53LX_RANGING_CORE__SIGNAL_TOTAL_EVENTS_1_LMM 0x0993

#define VL53LX_RANGING_CORE__SIGNAL_TOTAL_EVENTS_1_LLM 0x0994

#define VL53LX_RANGING_CORE__SIGNAL_TOTAL_EVENTS_1_LLL 0x0995

#define VL53LX_RANGING_CORE__TOTAL_PERIODS_ELAPSED_1_MM 0x0996

#define VL53LX_RANGING_CORE__TOTAL_PERIODS_ELAPSED_1_LM 0x0997

#define VL53LX_RANGING_CORE__TOTAL_PERIODS_ELAPSED_1_LL 0x0998

#define VL53LX_RANGING_CORE__AMBIENT_MISMATCH_MM 0x0999

#define VL53LX_RANGING_CORE__AMBIENT_MISMATCH_LM 0x099A

#define VL53LX_RANGING_CORE__AMBIENT_MISMATCH_LL 0x099B

#define VL53LX_RANGING_CORE__AMBIENT_WINDOW_EVENTS_REF_1_MMM 0x099C

#define VL53LX_RANGING_CORE__AMBIENT_WINDOW_EVENTS_REF_1_LMM 0x099D

#define VL53LX_RANGING_CORE__AMBIENT_WINDOW_EVENTS_REF_1_LLM 0x099E

#define VL53LX_RANGING_CORE__AMBIENT_WINDOW_EVENTS_REF_1_LLL 0x099F

#define VL53LX_RANGING_CORE__RANGING_TOTAL_EVENTS_REF_1_MMM 0x09A0

#define VL53LX_RANGING_CORE__RANGING_TOTAL_EVENTS_REF_1_LMM 0x09A1

#define VL53LX_RANGING_CORE__RANGING_TOTAL_EVENTS_REF_1_LLM 0x09A2

#define VL53LX_RANGING_CORE__RANGING_TOTAL_EVENTS_REF_1_LLL 0x09A3

#define VL53LX_RANGING_CORE__SIGNAL_TOTAL_EVENTS_REF_1_MMM 0x09A4

#define VL53LX_RANGING_CORE__SIGNAL_TOTAL_EVENTS_REF_1_LMM 0x09A5

#define VL53LX_RANGING_CORE__SIGNAL_TOTAL_EVENTS_REF_1_LLM 0x09A6

#define VL53LX_RANGING_CORE__SIGNAL_TOTAL_EVENTS_REF_1_LLL 0x09A7

#define VL53LX_RANGING_CORE__TOTAL_PERIODS_ELAPSED_REF_1_MM 0x09A8

#define VL53LX_RANGING_CORE__TOTAL_PERIODS_ELAPSED_REF_1_LM 0x09A9

#define VL53LX_RANGING_CORE__TOTAL_PERIODS_ELAPSED_REF_1_LL 0x09AA

#define VL53LX_RANGING_CORE__AMBIENT_MISMATCH_REF_MM 0x09AB

#define VL53LX_RANGING_CORE__AMBIENT_MISMATCH_REF_LM 0x09AC

#define VL53LX_RANGING_CORE__AMBIENT_MISMATCH_REF_LL 0x09AD

#define VL53LX_RANGING_CORE__GPIO_CONFIG__A0 0x0A00

#define VL53LX_RANGING_CORE__RESET_CONTROL__A0 0x0A01

#define VL53LX_RANGING_CORE__INTR_MANAGER__A0 0x0A02

#define VL53LX_RANGING_CORE__POWER_FSM_TIME_OSC__A0 0x0A06

#define VL53LX_RANGING_CORE__VCSEL_ATEST__A0 0x0A07

#define VL53LX_RANGING_CORE__VCSEL_PERIOD_CLIPPED__A0 0x0A08

#define VL53LX_RANGING_CORE__VCSEL_STOP_CLIPPED__A0 0x0A09

#define VL53LX_RANGING_CORE__CALIB_2__A0 0x0A0A

#define VL53LX_RANGING_CORE__STOP_CONDITION__A0 0x0A0B

#define VL53LX_RANGING_CORE__STATUS_RESET__A0 0x0A0C

#define VL53LX_RANGING_CORE__READOUT_CFG__A0 0x0A0D

#define VL53LX_RANGING_CORE__WINDOW_SETTING__A0 0x0A0E

#define VL53LX_RANGING_CORE__VCSEL_DELAY__A0 0x0A1A

#define VL53LX_RANGING_CORE__REFERENCE_2__A0 0x0A1B

#define VL53LX_RANGING_CORE__REGAVDD1V2__A0 0x0A1D

#define VL53LX_RANGING_CORE__TST_MUX__A0 0x0A1F

#define VL53LX_RANGING_CORE__CUSTOM_FE_2__A0 0x0A20

#define VL53LX_RANGING_CORE__SPAD_READOUT__A0 0x0A21

#define VL53LX_RANGING_CORE__CPUMP_1__A0 0x0A22

#define VL53LX_RANGING_CORE__SPARE_REGISTER__A0 0x0A23

#define VL53LX_RANGING_CORE__VCSEL_CONT_STAGE5_BYPASS__A0 0x0A24

#define VL53LX_RANGING_CORE__RET_SPAD_EN_18 0x0A25

#define VL53LX_RANGING_CORE__RET_SPAD_EN_19 0x0A26

#define VL53LX_RANGING_CORE__RET_SPAD_EN_20 0x0A27

#define VL53LX_RANGING_CORE__RET_SPAD_EN_21 0x0A28

#define VL53LX_RANGING_CORE__RET_SPAD_EN_22 0x0A29

#define VL53LX_RANGING_CORE__RET_SPAD_EN_23 0x0A2A

#define VL53LX_RANGING_CORE__RET_SPAD_EN_24 0x0A2B

#define VL53LX_RANGING_CORE__RET_SPAD_EN_25 0x0A2C

#define VL53LX_RANGING_CORE__RET_SPAD_EN_26 0x0A2D

#define VL53LX_RANGING_CORE__RET_SPAD_EN_27 0x0A2E

#define VL53LX_RANGING_CORE__RET_SPAD_EN_28 0x0A2F

#define VL53LX_RANGING_CORE__RET_SPAD_EN_29 0x0A30

#define VL53LX_RANGING_CORE__RET_SPAD_EN_30 0x0A31

#define VL53LX_RANGING_CORE__RET_SPAD_EN_31 0x0A32

#define VL53LX_RANGING_CORE__REF_SPAD_EN_0__EWOK 0x0A33

#define VL53LX_RANGING_CORE__REF_SPAD_EN_1__EWOK 0x0A34

#define VL53LX_RANGING_CORE__REF_SPAD_EN_2__EWOK 0x0A35

#define VL53LX_RANGING_CORE__REF_SPAD_EN_3__EWOK 0x0A36

#define VL53LX_RANGING_CORE__REF_SPAD_EN_4__EWOK 0x0A37

#define VL53LX_RANGING_CORE__REF_SPAD_EN_5__EWOK 0x0A38

#define VL53LX_RANGING_CORE__REF_EN_START_SELECT 0x0A39

#define VL53LX_RANGING_CORE__REGDVDD1V2_ATEST__EWOK 0x0A41

#define VL53LX_SOFT_RESET_GO1 0x0B00

#define VL53LX_PRIVATE__PATCH_BASE_ADDR_RSLV 0x0E00

#define VL53LX_PREV_SHADOW_RESULT__INTERRUPT_STATUS 0x0ED0

#define VL53LX_PREV_SHADOW_RESULT__RANGE_STATUS 0x0ED1

#define VL53LX_PREV_SHADOW_RESULT__REPORT_STATUS 0x0ED2

#define VL53LX_PREV_SHADOW_RESULT__STREAM_COUNT 0x0ED3

#define VL53LX_PREV_SHADOW_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD0 0x0ED4

#define VL53LX_PREV_SHADOW_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD0_HI 0x0ED4

#define VL53LX_PREV_SHADOW_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD0_LO 0x0ED5

#define VL53LX_PREV_SHADOW_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD0 0x0ED6

#define VL53LX_PREV_SHADOW_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD0_HI 0x0ED6

#define VL53LX_PREV_SHADOW_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD0_LO 0x0ED7

#define VL53LX_PREV_SHADOW_RESULT__AMBIENT_COUNT_RATE_MCPS_SD0 0x0ED8

#define VL53LX_PREV_SHADOW_RESULT__AMBIENT_COUNT_RATE_MCPS_SD0_HI 0x0ED8

#define VL53LX_PREV_SHADOW_RESULT__AMBIENT_COUNT_RATE_MCPS_SD0_LO 0x0ED9

#define VL53LX_PREV_SHADOW_RESULT__SIGMA_SD0 0x0EDA

#define VL53LX_PREV_SHADOW_RESULT__SIGMA_SD0_HI 0x0EDA

#define VL53LX_PREV_SHADOW_RESULT__SIGMA_SD0_LO 0x0EDB

#define VL53LX_PREV_SHADOW_RESULT__PHASE_SD0 0x0EDC

#define VL53LX_PREV_SHADOW_RESULT__PHASE_SD0_HI 0x0EDC

#define VL53LX_PREV_SHADOW_RESULT__PHASE_SD0_LO 0x0EDD

#define VL53LX_PREV_SHADOW_RESULT__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD0 0x0EDE

#define VL53LX_PREV__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD0_HI 0x0EDE

#define VL53LX_PREV__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD0_LO 0x0EDF

#define VL53LX_PREV__PEAK_SIGNAL_COUNT_RATE_CROSSTALK_CORRECTED_MCPS_SD0 0x0EE0

#define VL53LX_PPEAK_SIGNAL_COUNT_RATE_CROSSTALK_CORRECTED_MCPS_SD0_HI 0x0EE0

#define VL53LX_PPEAK_SIGNAL_COUNT_RATE_CROSSTALK_CORRECTED_MCPS_SD0_LO 0x0EE1

#define VL53LX_PREV_SHADOW_RESULT__MM_INNER_ACTUAL_EFFECTIVE_SPADS_SD0 0x0EE2

#define VL53LX_PREV_SHADOW_RESULT__MM_INNER_ACTUAL_EFFECTIVE_SPADS_SD0_HI 0x0EE2

#define VL53LX_PREV_SHADOW_RESULT__MM_INNER_ACTUAL_EFFECTIVE_SPADS_SD0_LO 0x0EE3

#define VL53LX_PREV_SHADOW_RESULT__MM_OUTER_ACTUAL_EFFECTIVE_SPADS_SD0 0x0EE4

#define VL53LX_PREV_SHADOW_RESULT__MM_OUTER_ACTUAL_EFFECTIVE_SPADS_SD0_HI 0x0EE4

#define VL53LX_PREV_SHADOW_RESULT__MM_OUTER_ACTUAL_EFFECTIVE_SPADS_SD0_LO 0x0EE5

#define VL53LX_PREV_SHADOW_RESULT__AVG_SIGNAL_COUNT_RATE_MCPS_SD0 0x0EE6

#define VL53LX_PREV_SHADOW_RESULT__AVG_SIGNAL_COUNT_RATE_MCPS_SD0_HI 0x0EE6

#define VL53LX_PREV_SHADOW_RESULT__AVG_SIGNAL_COUNT_RATE_MCPS_SD0_LO 0x0EE7

#define VL53LX_PREV_SHADOW_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD1 0x0EE8

#define VL53LX_PREV_SHADOW_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD1_HI 0x0EE8

#define VL53LX_PREV_SHADOW_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD1_LO 0x0EE9

#define VL53LX_PREV_SHADOW_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD1 0x0EEA

#define VL53LX_PREV_SHADOW_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD1_HI 0x0EEA

#define VL53LX_PREV_SHADOW_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD1_LO 0x0EEB

#define VL53LX_PREV_SHADOW_RESULT__AMBIENT_COUNT_RATE_MCPS_SD1 0x0EEC

#define VL53LX_PREV_SHADOW_RESULT__AMBIENT_COUNT_RATE_MCPS_SD1_HI 0x0EEC

#define VL53LX_PREV_SHADOW_RESULT__AMBIENT_COUNT_RATE_MCPS_SD1_LO 0x0EED

#define VL53LX_PREV_SHADOW_RESULT__SIGMA_SD1 0x0EEE

#define VL53LX_PREV_SHADOW_RESULT__SIGMA_SD1_HI 0x0EEE

#define VL53LX_PREV_SHADOW_RESULT__SIGMA_SD1_LO 0x0EEF

#define VL53LX_PREV_SHADOW_RESULT__PHASE_SD1 0x0EF0

#define VL53LX_PREV_SHADOW_RESULT__PHASE_SD1_HI 0x0EF0

#define VL53LX_PREV_SHADOW_RESULT__PHASE_SD1_LO 0x0EF1

#define VL53LX_PREV_SHADOW_RESULT__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD1 0x0EF2

#define VL53LX_PFINAL_CROSSTALK_CORRECTED_RANGE_MM_SD1_HI 0x0EF2

#define VL53LX_PFINAL_CROSSTALK_CORRECTED_RANGE_MM_SD1_LO 0x0EF3

#define VL53LX_PREV_SHADOW_RESULT__SPARE_0_SD1 0x0EF4

#define VL53LX_PREV_SHADOW_RESULT__SPARE_0_SD1_HI 0x0EF4

#define VL53LX_PREV_SHADOW_RESULT__SPARE_0_SD1_LO 0x0EF5

#define VL53LX_PREV_SHADOW_RESULT__SPARE_1_SD1 0x0EF6

#define VL53LX_PREV_SHADOW_RESULT__SPARE_1_SD1_HI 0x0EF6

#define VL53LX_PREV_SHADOW_RESULT__SPARE_1_SD1_LO 0x0EF7

#define VL53LX_PREV_SHADOW_RESULT__SPARE_2_SD1 0x0EF8

#define VL53LX_PREV_SHADOW_RESULT__SPARE_2_SD1_HI 0x0EF8

#define VL53LX_PREV_SHADOW_RESULT__SPARE_2_SD1_LO 0x0EF9

#define VL53LX_PREV_SHADOW_RESULT__SPARE_3_SD1 0x0EFA

#define VL53LX_PREV_SHADOW_RESULT__SPARE_3_SD1_HI 0x0EFA

#define VL53LX_PREV_SHADOW_RESULT__SPARE_3_SD1_LO 0x0EFB

#define VL53LX_PREV_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0 0x0EFC

#define VL53LX_PREV_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0_3 0x0EFC

#define VL53LX_PREV_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0_2 0x0EFD

#define VL53LX_PREV_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0_1 0x0EFE

#define VL53LX_PREV_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0_0 0x0EFF

#define VL53LX_PREV_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD0 0x0F00

#define VL53LX_PREV_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD0_3 0x0F00

#define VL53LX_PREV_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD0_2 0x0F01

#define VL53LX_PREV_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD0_1 0x0F02

#define VL53LX_PREV_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD0_0 0x0F03

#define VL53LX_PREV_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD0 0x0F04

#define VL53LX_PREV_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD0_3 0x0F04

#define VL53LX_PREV_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD0_2 0x0F05

#define VL53LX_PREV_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD0_1 0x0F06

#define VL53LX_PREV_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD0_0 0x0F07

#define VL53LX_PREV_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD0 0x0F08

#define VL53LX_PREV_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD0_3 0x0F08

#define VL53LX_PREV_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD0_2 0x0F09

#define VL53LX_PREV_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD0_1 0x0F0A

#define VL53LX_PREV_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD0_0 0x0F0B

#define VL53LX_PREV_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD1 0x0F0C

#define VL53LX_PREV_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD1_3 0x0F0C

#define VL53LX_PREV_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD1_2 0x0F0D

#define VL53LX_PREV_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD1_1 0x0F0E

#define VL53LX_PREV_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD1_0 0x0F0F

#define VL53LX_PREV_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD1 0x0F10

#define VL53LX_PREV_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD1_3 0x0F10

#define VL53LX_PREV_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD1_2 0x0F11

#define VL53LX_PREV_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD1_1 0x0F12

#define VL53LX_PREV_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD1_0 0x0F13

#define VL53LX_PREV_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD1 0x0F14

#define VL53LX_PREV_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD1_3 0x0F14

#define VL53LX_PREV_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD1_2 0x0F15

#define VL53LX_PREV_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD1_1 0x0F16

#define VL53LX_PREV_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD1_0 0x0F17

#define VL53LX_PREV_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD1 0x0F18

#define VL53LX_PREV_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD1_3 0x0F18

#define VL53LX_PREV_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD1_2 0x0F19

#define VL53LX_PREV_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD1_1 0x0F1A

#define VL53LX_PREV_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD1_0 0x0F1B

#define VL53LX_PREV_SHADOW_RESULT_CORE__SPARE_0 0x0F1C

#define VL53LX_RESULT__DEBUG_STATUS 0x0F20

#define VL53LX_RESULT__DEBUG_STAGE 0x0F21

#define VL53LX_GPH__SYSTEM__THRESH_RATE_HIGH 0x0F24

#define VL53LX_GPH__SYSTEM__THRESH_RATE_HIGH_HI 0x0F24

#define VL53LX_GPH__SYSTEM__THRESH_RATE_HIGH_LO 0x0F25

#define VL53LX_GPH__SYSTEM__THRESH_RATE_LOW 0x0F26

#define VL53LX_GPH__SYSTEM__THRESH_RATE_LOW_HI 0x0F26

#define VL53LX_GPH__SYSTEM__THRESH_RATE_LOW_LO 0x0F27

#define VL53LX_GPH__SYSTEM__INTERRUPT_CONFIG_GPIO 0x0F28

#define VL53LX_GPH__DSS_CONFIG__ROI_MODE_CONTROL 0x0F2F

#define VL53LX_GPH__DSS_CONFIG__MANUAL_EFFECTIVE_SPADS_SELECT 0x0F30

#define VL53LX_GPH__DSS_CONFIG__MANUAL_EFFECTIVE_SPADS_SELECT_HI 0x0F30

#define VL53LX_GPH__DSS_CONFIG__MANUAL_EFFECTIVE_SPADS_SELECT_LO 0x0F31

#define VL53LX_GPH__DSS_CONFIG__MANUAL_BLOCK_SELECT 0x0F32

#define VL53LX_GPH__DSS_CONFIG__MAX_SPADS_LIMIT 0x0F33

#define VL53LX_GPH__DSS_CONFIG__MIN_SPADS_LIMIT 0x0F34

#define VL53LX_GPH__MM_CONFIG__TIMEOUT_MACROP_A_HI 0x0F36

#define VL53LX_GPH__MM_CONFIG__TIMEOUT_MACROP_A_LO 0x0F37

#define VL53LX_GPH__MM_CONFIG__TIMEOUT_MACROP_B_HI 0x0F38

#define VL53LX_GPH__MM_CONFIG__TIMEOUT_MACROP_B_LO 0x0F39

#define VL53LX_GPH__RANGE_CONFIG__TIMEOUT_MACROP_A_HI 0x0F3A

#define VL53LX_GPH__RANGE_CONFIG__TIMEOUT_MACROP_A_LO 0x0F3B

#define VL53LX_GPH__RANGE_CONFIG__VCSEL_PERIOD_A 0x0F3C

#define VL53LX_GPH__RANGE_CONFIG__VCSEL_PERIOD_B 0x0F3D

#define VL53LX_GPH__RANGE_CONFIG__TIMEOUT_MACROP_B_HI 0x0F3E

#define VL53LX_GPH__RANGE_CONFIG__TIMEOUT_MACROP_B_LO 0x0F3F

#define VL53LX_GPH__RANGE_CONFIG__SIGMA_THRESH 0x0F40

#define VL53LX_GPH__RANGE_CONFIG__SIGMA_THRESH_HI 0x0F40

#define VL53LX_GPH__RANGE_CONFIG__SIGMA_THRESH_LO 0x0F41

#define VL53LX_GPH__RANGE_CONFIG__MIN_COUNT_RATE_RTN_LIMIT_MCPS 0x0F42

#define VL53LX_GPH__RANGE_CONFIG__MIN_COUNT_RATE_RTN_LIMIT_MCPS_HI 0x0F42

#define VL53LX_GPH__RANGE_CONFIG__MIN_COUNT_RATE_RTN_LIMIT_MCPS_LO 0x0F43

#define VL53LX_GPH__RANGE_CONFIG__VALID_PHASE_LOW 0x0F44

#define VL53LX_GPH__RANGE_CONFIG__VALID_PHASE_HIGH 0x0F45

#define VL53LX_FIRMWARE__INTERNAL_STREAM_COUNT_DIV 0x0F46

#define VL53LX_FIRMWARE__INTERNAL_STREAM_COUNTER_VAL 0x0F47

#define VL53LX_DSS_CALC__ROI_CTRL 0x0F54

#define VL53LX_DSS_CALC__SPARE_1 0x0F55

#define VL53LX_DSS_CALC__SPARE_2 0x0F56

#define VL53LX_DSS_CALC__SPARE_3 0x0F57

#define VL53LX_DSS_CALC__SPARE_4 0x0F58

#define VL53LX_DSS_CALC__SPARE_5 0x0F59

#define VL53LX_DSS_CALC__SPARE_6 0x0F5A

#define VL53LX_DSS_CALC__SPARE_7 0x0F5B

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_0 0x0F5C

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_1 0x0F5D

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_2 0x0F5E

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_3 0x0F5F

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_4 0x0F60

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_5 0x0F61

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_6 0x0F62

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_7 0x0F63

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_8 0x0F64

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_9 0x0F65

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_10 0x0F66

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_11 0x0F67

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_12 0x0F68

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_13 0x0F69

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_14 0x0F6A

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_15 0x0F6B

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_16 0x0F6C

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_17 0x0F6D

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_18 0x0F6E

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_19 0x0F6F

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_20 0x0F70

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_21 0x0F71

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_22 0x0F72

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_23 0x0F73

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_24 0x0F74

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_25 0x0F75

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_26 0x0F76

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_27 0x0F77

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_28 0x0F78

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_29 0x0F79

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_30 0x0F7A

#define VL53LX_DSS_CALC__USER_ROI_SPAD_EN_31 0x0F7B

#define VL53LX_DSS_CALC__USER_ROI_0 0x0F7C

#define VL53LX_DSS_CALC__USER_ROI_1 0x0F7D

#define VL53LX_DSS_CALC__MODE_ROI_0 0x0F7E

#define VL53LX_DSS_CALC__MODE_ROI_1 0x0F7F

#define VL53LX_SIGMA_ESTIMATOR_CALC__SPARE_0 0x0F80

#define VL53LX_VHV_RESULT__PEAK_SIGNAL_RATE_MCPS 0x0F82

#define VL53LX_VHV_RESULT__PEAK_SIGNAL_RATE_MCPS_HI 0x0F82

#define VL53LX_VHV_RESULT__PEAK_SIGNAL_RATE_MCPS_LO 0x0F83

#define VL53LX_VHV_RESULT__SIGNAL_TOTAL_EVENTS_REF 0x0F84

#define VL53LX_VHV_RESULT__SIGNAL_TOTAL_EVENTS_REF_3 0x0F84

#define VL53LX_VHV_RESULT__SIGNAL_TOTAL_EVENTS_REF_2 0x0F85

#define VL53LX_VHV_RESULT__SIGNAL_TOTAL_EVENTS_REF_1 0x0F86

#define VL53LX_VHV_RESULT__SIGNAL_TOTAL_EVENTS_REF_0 0x0F87

#define VL53LX_PHASECAL_RESULT__PHASE_OUTPUT_REF 0x0F88

#define VL53LX_PHASECAL_RESULT__PHASE_OUTPUT_REF_HI 0x0F88

#define VL53LX_PHASECAL_RESULT__PHASE_OUTPUT_REF_LO 0x0F89

#define VL53LX_DSS_RESULT__TOTAL_RATE_PER_SPAD 0x0F8A

#define VL53LX_DSS_RESULT__TOTAL_RATE_PER_SPAD_HI 0x0F8A

#define VL53LX_DSS_RESULT__TOTAL_RATE_PER_SPAD_LO 0x0F8B

#define VL53LX_DSS_RESULT__ENABLED_BLOCKS 0x0F8C

#define VL53LX_DSS_RESULT__NUM_REQUESTED_SPADS 0x0F8E

#define VL53LX_DSS_RESULT__NUM_REQUESTED_SPADS_HI 0x0F8E

#define VL53LX_DSS_RESULT__NUM_REQUESTED_SPADS_LO 0x0F8F

#define VL53LX_MM_RESULT__INNER_INTERSECTION_RATE 0x0F92

#define VL53LX_MM_RESULT__INNER_INTERSECTION_RATE_HI 0x0F92

#define VL53LX_MM_RESULT__INNER_INTERSECTION_RATE_LO 0x0F93

#define VL53LX_MM_RESULT__OUTER_COMPLEMENT_RATE 0x0F94

#define VL53LX_MM_RESULT__OUTER_COMPLEMENT_RATE_HI 0x0F94

#define VL53LX_MM_RESULT__OUTER_COMPLEMENT_RATE_LO 0x0F95

#define VL53LX_MM_RESULT__TOTAL_OFFSET 0x0F96

#define VL53LX_MM_RESULT__TOTAL_OFFSET_HI 0x0F96

#define VL53LX_MM_RESULT__TOTAL_OFFSET_LO 0x0F97

#define VL53LX_XTALK_CALC__XTALK_FOR_ENABLED_SPADS 0x0F98

#define VL53LX_XTALK_CALC__XTALK_FOR_ENABLED_SPADS_3 0x0F98

#define VL53LX_XTALK_CALC__XTALK_FOR_ENABLED_SPADS_2 0x0F99

#define VL53LX_XTALK_CALC__XTALK_FOR_ENABLED_SPADS_1 0x0F9A

#define VL53LX_XTALK_CALC__XTALK_FOR_ENABLED_SPADS_0 0x0F9B

#define VL53LX_XTALK_RESULT__AVG_XTALK_USER_ROI_KCPS 0x0F9C

#define VL53LX_XTALK_RESULT__AVG_XTALK_USER_ROI_KCPS_3 0x0F9C

#define VL53LX_XTALK_RESULT__AVG_XTALK_USER_ROI_KCPS_2 0x0F9D

#define VL53LX_XTALK_RESULT__AVG_XTALK_USER_ROI_KCPS_1 0x0F9E

#define VL53LX_XTALK_RESULT__AVG_XTALK_USER_ROI_KCPS_0 0x0F9F

#define VL53LX_XTALK_RESULT__AVG_XTALK_MM_INNER_ROI_KCPS 0x0FA0

#define VL53LX_XTALK_RESULT__AVG_XTALK_MM_INNER_ROI_KCPS_3 0x0FA0

#define VL53LX_XTALK_RESULT__AVG_XTALK_MM_INNER_ROI_KCPS_2 0x0FA1

#define VL53LX_XTALK_RESULT__AVG_XTALK_MM_INNER_ROI_KCPS_1 0x0FA2

#define VL53LX_XTALK_RESULT__AVG_XTALK_MM_INNER_ROI_KCPS_0 0x0FA3

#define VL53LX_XTALK_RESULT__AVG_XTALK_MM_OUTER_ROI_KCPS 0x0FA4

#define VL53LX_XTALK_RESULT__AVG_XTALK_MM_OUTER_ROI_KCPS_3 0x0FA4

#define VL53LX_XTALK_RESULT__AVG_XTALK_MM_OUTER_ROI_KCPS_2 0x0FA5

#define VL53LX_XTALK_RESULT__AVG_XTALK_MM_OUTER_ROI_KCPS_1 0x0FA6

#define VL53LX_XTALK_RESULT__AVG_XTALK_MM_OUTER_ROI_KCPS_0 0x0FA7

#define VL53LX_RANGE_RESULT__ACCUM_PHASE 0x0FA8

#define VL53LX_RANGE_RESULT__ACCUM_PHASE_3 0x0FA8

#define VL53LX_RANGE_RESULT__ACCUM_PHASE_2 0x0FA9

#define VL53LX_RANGE_RESULT__ACCUM_PHASE_1 0x0FAA

#define VL53LX_RANGE_RESULT__ACCUM_PHASE_0 0x0FAB

#define VL53LX_RANGE_RESULT__OFFSET_CORRECTED_RANGE 0x0FAC

#define VL53LX_RANGE_RESULT__OFFSET_CORRECTED_RANGE_HI 0x0FAC

#define VL53LX_RANGE_RESULT__OFFSET_CORRECTED_RANGE_LO 0x0FAD

#define VL53LX_SHADOW_PHASECAL_RESULT__VCSEL_START 0x0FAE

#define VL53LX_SHADOW_RESULT__INTERRUPT_STATUS 0x0FB0

#define VL53LX_SHADOW_RESULT__RANGE_STATUS 0x0FB1

#define VL53LX_SHADOW_RESULT__REPORT_STATUS 0x0FB2

#define VL53LX_SHADOW_RESULT__STREAM_COUNT 0x0FB3

#define VL53LX_SHADOW_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD0 0x0FB4

#define VL53LX_SHADOW_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD0_HI 0x0FB4

#define VL53LX_SHADOW_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD0_LO 0x0FB5

#define VL53LX_SHADOW_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD0 0x0FB6

#define VL53LX_SHADOW_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD0_HI 0x0FB6

#define VL53LX_SHADOW_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD0_LO 0x0FB7

#define VL53LX_SHADOW_RESULT__AMBIENT_COUNT_RATE_MCPS_SD0 0x0FB8

#define VL53LX_SHADOW_RESULT__AMBIENT_COUNT_RATE_MCPS_SD0_HI 0x0FB8

#define VL53LX_SHADOW_RESULT__AMBIENT_COUNT_RATE_MCPS_SD0_LO 0x0FB9

#define VL53LX_SHADOW_RESULT__SIGMA_SD0 0x0FBA

#define VL53LX_SHADOW_RESULT__SIGMA_SD0_HI 0x0FBA

#define VL53LX_SHADOW_RESULT__SIGMA_SD0_LO 0x0FBB

#define VL53LX_SHADOW_RESULT__PHASE_SD0 0x0FBC

#define VL53LX_SHADOW_RESULT__PHASE_SD0_HI 0x0FBC

#define VL53LX_SHADOW_RESULT__PHASE_SD0_LO 0x0FBD

#define VL53LX_SHADOW_RESULT__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD0 0x0FBE

#define VL53LX_SHADOW_RESULT__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD0_HI 0x0FBE

#define VL53LX_SHADOW_RESULT__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD0_LO 0x0FBF

#define VL53LX_SHPEAK_SIGNAL_COUNT_RATE_CROSSTALK_CORRECTED_MCPS_SD0 0x0FC0

#define VL53LX_SHPEAK_SIGNAL_COUNT_RATE_CROSSTALK_CORRECTED_MCPS_SD0_HI 0x0FC0

#define VL53LX_SHPEAK_SIGNAL_COUNT_RATE_CROSSTALK_CORRECTED_MCPS_SD0_LO 0x0FC1

#define VL53LX_SHADOW_RESULT__MM_INNER_ACTUAL_EFFECTIVE_SPADS_SD0 0x0FC2

#define VL53LX_SHADOW_RESULT__MM_INNER_ACTUAL_EFFECTIVE_SPADS_SD0_HI 0x0FC2

#define VL53LX_SHADOW_RESULT__MM_INNER_ACTUAL_EFFECTIVE_SPADS_SD0_LO 0x0FC3

#define VL53LX_SHADOW_RESULT__MM_OUTER_ACTUAL_EFFECTIVE_SPADS_SD0 0x0FC4

#define VL53LX_SHADOW_RESULT__MM_OUTER_ACTUAL_EFFECTIVE_SPADS_SD0_HI 0x0FC4

#define VL53LX_SHADOW_RESULT__MM_OUTER_ACTUAL_EFFECTIVE_SPADS_SD0_LO 0x0FC5

#define VL53LX_SHADOW_RESULT__AVG_SIGNAL_COUNT_RATE_MCPS_SD0 0x0FC6

#define VL53LX_SHADOW_RESULT__AVG_SIGNAL_COUNT_RATE_MCPS_SD0_HI 0x0FC6

#define VL53LX_SHADOW_RESULT__AVG_SIGNAL_COUNT_RATE_MCPS_SD0_LO 0x0FC7

#define VL53LX_SHADOW_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD1 0x0FC8

#define VL53LX_SHADOW_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD1_HI 0x0FC8

#define VL53LX_SHADOW_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD1_LO 0x0FC9

#define VL53LX_SHADOW_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD1 0x0FCA

#define VL53LX_SHADOW_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD1_HI 0x0FCA

#define VL53LX_SHADOW_RESULT__PEAK_SIGNAL_COUNT_RATE_MCPS_SD1_LO 0x0FCB

#define VL53LX_SHADOW_RESULT__AMBIENT_COUNT_RATE_MCPS_SD1 0x0FCC

#define VL53LX_SHADOW_RESULT__AMBIENT_COUNT_RATE_MCPS_SD1_HI 0x0FCC

#define VL53LX_SHADOW_RESULT__AMBIENT_COUNT_RATE_MCPS_SD1_LO 0x0FCD

#define VL53LX_SHADOW_RESULT__SIGMA_SD1 0x0FCE

#define VL53LX_SHADOW_RESULT__SIGMA_SD1_HI 0x0FCE

#define VL53LX_SHADOW_RESULT__SIGMA_SD1_LO 0x0FCF

#define VL53LX_SHADOW_RESULT__PHASE_SD1 0x0FD0

#define VL53LX_SHADOW_RESULT__PHASE_SD1_HI 0x0FD0

#define VL53LX_SHADOW_RESULT__PHASE_SD1_LO 0x0FD1

#define VL53LX_SHADOW_RESULT__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD1 0x0FD2

#define VL53LX_SHADOW_RESULT__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD1_HI 0x0FD2

#define VL53LX_SHADOW_RESULT__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD1_LO 0x0FD3

#define VL53LX_SHADOW_RESULT__SPARE_0_SD1 0x0FD4

#define VL53LX_SHADOW_RESULT__SPARE_0_SD1_HI 0x0FD4

#define VL53LX_SHADOW_RESULT__SPARE_0_SD1_LO 0x0FD5

#define VL53LX_SHADOW_RESULT__SPARE_1_SD1 0x0FD6

#define VL53LX_SHADOW_RESULT__SPARE_1_SD1_HI 0x0FD6

#define VL53LX_SHADOW_RESULT__SPARE_1_SD1_LO 0x0FD7

#define VL53LX_SHADOW_RESULT__SPARE_2_SD1 0x0FD8

#define VL53LX_SHADOW_RESULT__SPARE_2_SD1_HI 0x0FD8

#define VL53LX_SHADOW_RESULT__SPARE_2_SD1_LO 0x0FD9

#define VL53LX_SHADOW_RESULT__SPARE_3_SD1 0x0FDA

#define VL53LX_SHADOW_RESULT__THRESH_INFO 0x0FDB

#define VL53LX_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0 0x0FDC

#define VL53LX_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0_3 0x0FDC

#define VL53LX_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0_2 0x0FDD

#define VL53LX_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0_1 0x0FDE

#define VL53LX_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0_0 0x0FDF

#define VL53LX_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD0 0x0FE0

#define VL53LX_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD0_3 0x0FE0

#define VL53LX_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD0_2 0x0FE1

#define VL53LX_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD0_1 0x0FE2

#define VL53LX_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD0_0 0x0FE3

#define VL53LX_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD0 0x0FE4

#define VL53LX_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD0_3 0x0FE4

#define VL53LX_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD0_2 0x0FE5

#define VL53LX_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD0_1 0x0FE6

#define VL53LX_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD0_0 0x0FE7

#define VL53LX_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD0 0x0FE8

#define VL53LX_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD0_3 0x0FE8

#define VL53LX_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD0_2 0x0FE9

#define VL53LX_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD0_1 0x0FEA

#define VL53LX_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD0_0 0x0FEB

#define VL53LX_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD1 0x0FEC

#define VL53LX_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD1_3 0x0FEC

#define VL53LX_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD1_2 0x0FED

#define VL53LX_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD1_1 0x0FEE

#define VL53LX_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD1_0 0x0FEF

#define VL53LX_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD1 0x0FF0

#define VL53LX_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD1_3 0x0FF0

#define VL53LX_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD1_2 0x0FF1

#define VL53LX_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD1_1 0x0FF2

#define VL53LX_SHADOW_RESULT_CORE__RANGING_TOTAL_EVENTS_SD1_0 0x0FF3

#define VL53LX_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD1 0x0FF4

#define VL53LX_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD1_3 0x0FF4

#define VL53LX_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD1_2 0x0FF5

#define VL53LX_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD1_1 0x0FF6

#define VL53LX_SHADOW_RESULT_CORE__SIGNAL_TOTAL_EVENTS_SD1_0 0x0FF7

#define VL53LX_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD1 0x0FF8

#define VL53LX_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD1_3 0x0FF8

#define VL53LX_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD1_2 0x0FF9

#define VL53LX_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD1_1 0x0FFA

#define VL53LX_SHADOW_RESULT_CORE__TOTAL_PERIODS_ELAPSED_SD1_0 0x0FFB

#define VL53LX_SHADOW_RESULT_CORE__SPARE_0 0x0FFC

#define VL53LX_SHADOW_PHASECAL_RESULT__REFERENCE_PHASE_HI 0x0FFE

#define VL53LX_SHADOW_PHASECAL_RESULT__REFERENCE_PHASE_LO 0x0FFF





// define from vl53lx_error_exceptions.h

#ifndef _VL53LX_ERROR_EXCEPTIONS_H_
#define _VL53LX_ERROR_EXCEPTIONS_H_

#define IGNORE_DIVISION_BY_ZERO                                0

#define IGNORE_XTALK_EXTRACTION_NO_SAMPLE_FAIL                 0
#define IGNORE_XTALK_EXTRACTION_SIGMA_LIMIT_FAIL               0
#define IGNORE_XTALK_EXTRACTION_NO_SAMPLE_FOR_GRADIENT_WARN    0
#define IGNORE_XTALK_EXTRACTION_SIGMA_LIMIT_FOR_GRADIENT_WARN  0
#define IGNORE_XTALK_EXTRACTION_MISSING_SAMPLES_WARN           0

#define IGNORE_REF_SPAD_CHAR_NOT_ENOUGH_SPADS                  0
#define IGNORE_REF_SPAD_CHAR_RATE_TOO_HIGH                     0
#define IGNORE_REF_SPAD_CHAR_RATE_TOO_LOW                      0

#define IGNORE_OFFSET_CAL_MISSING_SAMPLES                      0
#define IGNORE_OFFSET_CAL_SIGMA_TOO_HIGH                       0
#define IGNORE_OFFSET_CAL_RATE_TOO_HIGH                        0
#define IGNORE_OFFSET_CAL_SPAD_COUNT_TOO_LOW           0

#define IGNORE_ZONE_CAL_MISSING_SAMPLES                        0
#define IGNORE_ZONE_CAL_SIGMA_TOO_HIGH                         0
#define IGNORE_ZONE_CAL_RATE_TOO_HIGH                          0

#endif

// define from vl53lx_platform_user_defines.h

#define do_division_u(dividend, divisor) (dividend / divisor)

#define do_division_s(dividend, divisor) (dividend / divisor)



#ifdef _MSC_VER
#define DISABLE_WARNINGS() { \
        __pragma(warning(push)); \
        __pragma(warning(disable:4127)); \
        }
#define ENABLE_WARNINGS() { \
        __pragma(warning( pop )); \
        }
#else


#define DISABLE_WARNINGS()
#define ENABLE_WARNINGS()
#endif




/*vl53lx_register_settings.h*/


#define VL53LX_DEVICESCHEDULERMODE_PSEUDO_SOLO  0x00
#define VL53LX_DEVICESCHEDULERMODE_STREAMING    0x01
#define VL53LX_DEVICESCHEDULERMODE_HISTOGRAM    0x02





#define VL53LX_DEVICEREADOUTMODE_SINGLE_SD        (0x00 << 2)
#define VL53LX_DEVICEREADOUTMODE_DUAL_SD          (0x01 << 2)
#define VL53LX_DEVICEREADOUTMODE_SPLIT_READOUT    (0x02 << 2)
#define VL53LX_DEVICEREADOUTMODE_SPLIT_MANUAL     (0x03 << 2)






#define VL53LX_DEVICEMEASUREMENTMODE_MODE_MASK          0xF0
#define VL53LX_DEVICEMEASUREMENTMODE_STOP_MASK          0x0F

#define VL53LX_GROUPEDPARAMETERHOLD_ID_MASK             0x02



#define VL53LX_EWOK_I2C_DEV_ADDR_DEFAULT                0x29

#define VL53LX_OSC_FREQUENCY                            0x00
#define VL53LX_OSC_TRIM_DEFAULT                         0x00
#define VL53LX_OSC_FREQ_SET_DEFAULT                     0x00

#define VL53LX_RANGE_HISTOGRAM_REF                      0x08
#define VL53LX_RANGE_HISTOGRAM_RET                      0x10
#define VL53LX_RANGE_HISTOGRAM_BOTH                     0x18
#define VL53LX_RANGE_HISTOGRAM_INIT                     0x20
#define VL53LX_RANGE_VHV_INIT                           0x40


#define VL53LX_RESULT_RANGE_STATUS                      0x1F


#define VL53LX_SYSTEM__SEED_CONFIG__MANUAL              0x00
#define VL53LX_SYSTEM__SEED_CONFIG__STANDARD            0x01
#define VL53LX_SYSTEM__SEED_CONFIG__EVEN_UPDATE_ONLY    0x02


#define VL53LX_INTERRUPT_CONFIG_LEVEL_LOW               0x00
#define VL53LX_INTERRUPT_CONFIG_LEVEL_HIGH              0x01
#define VL53LX_INTERRUPT_CONFIG_OUT_OF_WINDOW           0x02
#define VL53LX_INTERRUPT_CONFIG_IN_WINDOW               0x03
#define VL53LX_INTERRUPT_CONFIG_NEW_SAMPLE_READY        0x20


#define VL53LX_CLEAR_RANGE_INT                          0x01
#define VL53LX_CLEAR_ERROR_INT                          0x02


#define VL53LX_SEQUENCE_VHV_EN                0x01
#define VL53LX_SEQUENCE_PHASECAL_EN                     0x02
#define VL53LX_SEQUENCE_REFERENCE_PHASE_EN              0x04
#define VL53LX_SEQUENCE_DSS1_EN                         0x08
#define VL53LX_SEQUENCE_DSS2_EN                         0x10
#define VL53LX_SEQUENCE_MM1_EN                          0x20
#define VL53LX_SEQUENCE_MM2_EN                          0x40
#define VL53LX_SEQUENCE_RANGE_EN                        0x80


#define VL53LX_DSS_CONTROL__ROI_SUBTRACT                0x20
#define VL53LX_DSS_CONTROL__ROI_INTERSECT               0x10

#define VL53LX_DSS_CONTROL__MODE_DISABLED               0x00
#define VL53LX_DSS_CONTROL__MODE_TARGET_RATE            0x01
#define VL53LX_DSS_CONTROL__MODE_EFFSPADS               0x02
#define VL53LX_DSS_CONTROL__MODE_BLOCKSELECT            0x03



#define VL53LX_RANGING_CORE__SPAD_READOUT__STANDARD              0x45
#define VL53LX_RANGING_CORE__SPAD_READOUT__RETURN_ARRAY_ONLY     0x05
#define VL53LX_RANGING_CORE__SPAD_READOUT__REFERENCE_ARRAY_ONLY  0x55
#define VL53LX_RANGING_CORE__SPAD_READOUT__RETURN_SPLIT_ARRAY    0x25
#define VL53LX_RANGING_CORE__SPAD_READOUT__CALIB_PULSES          0xF5


#define VL53LX_LASER_SAFETY__KEY_VALUE                  0x6C



#define VL53LX_RANGE_STATUS__RANGE_STATUS_MASK          0x1F
#define VL53LX_RANGE_STATUS__MAX_THRESHOLD_HIT_MASK     0x20
#define VL53LX_RANGE_STATUS__MIN_THRESHOLD_HIT_MASK     0x40
#define VL53LX_RANGE_STATUS__GPH_ID_RANGE_STATUS_MASK   0x80



#define VL53LX_INTERRUPT_STATUS__INT_STATUS_MASK            0x07
#define VL53LX_INTERRUPT_STATUS__INT_ERROR_STATUS_MASK      0x18
#define VL53LX_INTERRUPT_STATUS__GPH_ID_INT_STATUS_MASK     0x20


/* vl53lx_nvm_map.h */




#define VL53LX_NVM__IDENTIFICATION__MODEL_ID 0x0008

#define VL53LX_NVM__IDENTIFICATION__MODULE_TYPE 0x000C

#define VL53LX_NVM__IDENTIFICATION__REVISION_ID 0x000D

#define VL53LX_NVM__IDENTIFICATION__MODULE_ID 0x000E

#define VL53LX_NVM__I2C_VALID 0x0010

#define VL53LX_NVM__I2C_SLAVE__DEVICE_ADDRESS 0x0011

#define VL53LX_NVM__EWS__OSC_MEASURED__FAST_OSC_FREQUENCY 0x0014

#define VL53LX_NVM__EWS__FAST_OSC_TRIM_MAX 0x0016

#define VL53LX_NVM__EWS__FAST_OSC_FREQ_SET 0x0017

#define VL53LX_NVM__EWS__SLOW_OSC_CALIBRATION 0x0018

#define VL53LX_NVM__FMT__OSC_MEASURED__FAST_OSC_FREQUENCY 0x001C

#define VL53LX_NVM__FMT__FAST_OSC_TRIM_MAX 0x001E

#define VL53LX_NVM__FMT__FAST_OSC_FREQ_SET 0x001F

#define VL53LX_NVM__FMT__SLOW_OSC_CALIBRATION 0x0020

#define VL53LX_NVM__VHV_CONFIG_UNLOCK 0x0028

#define VL53LX_NVM__REF_SELVDDPIX 0x0029

#define VL53LX_NVM__REF_SELVQUENCH 0x002A

#define VL53LX_NVM__REGAVDD1V2_SEL_REGDVDD1V2_SEL 0x002B

#define VL53LX_NVM__VHV_CONFIG__TIMEOUT_MACROP_LOOP_BOUND 0x002C

#define VL53LX_NVM__VHV_CONFIG__COUNT_THRESH 0x002D

#define VL53LX_NVM__VHV_CONFIG__OFFSET 0x002E

#define VL53LX_NVM__VHV_CONFIG__INIT 0x002F

#define VL53LX_NVM__LASER_SAFETY__VCSEL_TRIM_LL 0x0030

#define VL53LX_NVM__LASER_SAFETY__VCSEL_SELION_LL 0x0031

#define VL53LX_NVM__LASER_SAFETY__VCSEL_SELION_MAX_LL 0x0032

#define VL53LX_NVM__LASER_SAFETY__MULT_LL 0x0034

#define VL53LX_NVM__LASER_SAFETY__CLIP_LL 0x0035

#define VL53LX_NVM__LASER_SAFETY__VCSEL_TRIM_LD 0x0038

#define VL53LX_NVM__LASER_SAFETY__VCSEL_SELION_LD 0x0039

#define VL53LX_NVM__LASER_SAFETY__VCSEL_SELION_MAX_LD 0x003A

#define VL53LX_NVM__LASER_SAFETY__MULT_LD 0x003C

#define VL53LX_NVM__LASER_SAFETY__CLIP_LD 0x003D

#define VL53LX_NVM__LASER_SAFETY_LOCK_BYTE 0x0040

#define VL53LX_NVM__LASER_SAFETY_UNLOCK_BYTE 0x0044

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_0_ 0x0048

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_1_ 0x0049

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_2_ 0x004A

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_3_ 0x004B

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_4_ 0x004C

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_5_ 0x004D

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_6_ 0x004E

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_7_ 0x004F

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_8_ 0x0050

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_9_ 0x0051

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_10_ 0x0052

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_11_ 0x0053

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_12_ 0x0054

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_13_ 0x0055

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_14_ 0x0056

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_15_ 0x0057

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_16_ 0x0058

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_17_ 0x0059

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_18_ 0x005A

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_19_ 0x005B

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_20_ 0x005C

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_21_ 0x005D

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_22_ 0x005E

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_23_ 0x005F

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_24_ 0x0060

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_25_ 0x0061

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_26_ 0x0062

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_27_ 0x0063

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_28_ 0x0064

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_29_ 0x0065

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_30_ 0x0066

#define VL53LX_NVM__EWS__SPAD_ENABLES_RTN_31_ 0x0067

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC1_0_ 0x0068

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC1_1_ 0x0069

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC1_2_ 0x006A

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC1_3_ 0x006B

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC1_4_ 0x006C

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC1_5_ 0x006D

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC2_0_ 0x0070

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC2_1_ 0x0071

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC2_2_ 0x0072

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC2_3_ 0x0073

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC2_4_ 0x0074

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC2_5_ 0x0075

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC3_0_ 0x0078

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC3_1_ 0x0079

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC3_2_ 0x007A

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC3_3_ 0x007B

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC3_4_ 0x007C

#define VL53LX_NVM__EWS__SPAD_ENABLES_REF__LOC3_5_ 0x007D

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_0_ 0x0080

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_1_ 0x0081

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_2_ 0x0082

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_3_ 0x0083

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_4_ 0x0084

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_5_ 0x0085

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_6_ 0x0086

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_7_ 0x0087

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_8_ 0x0088

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_9_ 0x0089

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_10_ 0x008A

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_11_ 0x008B

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_12_ 0x008C

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_13_ 0x008D

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_14_ 0x008E

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_15_ 0x008F

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_16_ 0x0090

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_17_ 0x0091

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_18_ 0x0092

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_19_ 0x0093

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_20_ 0x0094

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_21_ 0x0095

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_22_ 0x0096

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_23_ 0x0097

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_24_ 0x0098

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_25_ 0x0099

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_26_ 0x009A

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_27_ 0x009B

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_28_ 0x009C

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_29_ 0x009D

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_30_ 0x009E

#define VL53LX_NVM__FMT__SPAD_ENABLES_RTN_31_ 0x009F

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC1_0_ 0x00A0

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC1_1_ 0x00A1

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC1_2_ 0x00A2

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC1_3_ 0x00A3

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC1_4_ 0x00A4

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC1_5_ 0x00A5

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC2_0_ 0x00A8

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC2_1_ 0x00A9

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC2_2_ 0x00AA

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC2_3_ 0x00AB

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC2_4_ 0x00AC

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC2_5_ 0x00AD

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC3_0_ 0x00B0

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC3_1_ 0x00B1

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC3_2_ 0x00B2

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC3_3_ 0x00B3

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC3_4_ 0x00B4

#define VL53LX_NVM__FMT__SPAD_ENABLES_REF__LOC3_5_ 0x00B5

#define VL53LX_NVM__FMT__ROI_CONFIG__MODE_ROI_CENTRE_SPAD 0x00B8

#define VL53LX_NVM__FMT__ROI_CONFIG__MODE_ROI_XY_SIZE 0x00B9

#define VL53LX_NVM__FMT__REF_SPAD_APPLY__NUM_REQUESTED_REF_SPAD 0x00BC

#define VL53LX_NVM__FMT__REF_SPAD_MAN__REF_LOCATION 0x00BD

#define VL53LX_NVM__FMT__MM_CONFIG__INNER_OFFSET_MM 0x00C0

#define VL53LX_NVM__FMT__MM_CONFIG__OUTER_OFFSET_MM 0x00C2

#define VL53LX_NVM__FMT__ALGO__PART_TO_PART_RANGE_OFFSET_MM 0x00C4

#define VL53LX_NVM__FMT__ALGO__CROSSTALK_COMPENSATION_PLANE_OFFSET_KCPS 0x00C8

#define VL53LX_NVM__FMT__ALGO__CROSSTALK_COMPENSATION_X_PLANE_GRADIENT_KCPS \
  0x00CA

#define VL53LX_NVM__FMT__ALGO__CROSSTALK_COMPENSATION_Y_PLANE_GRADIENT_KCPS \
  0x00CC

#define VL53LX_NVM__FMT__SPARE_HOST_CONFIG__NVM_CONFIG_SPARE_0 0x00CE

#define VL53LX_NVM__FMT__SPARE_HOST_CONFIG__NVM_CONFIG_SPARE_1 0x00CF

#define VL53LX_NVM__CUSTOMER_NVM_SPACE_PROGRAMMED 0x00E0

#define VL53LX_NVM__CUST__I2C_SLAVE__DEVICE_ADDRESS 0x00E4

#define VL53LX_NVM__CUST__REF_SPAD_APPLY__NUM_REQUESTED_REF_SPAD 0x00E8

#define VL53LX_NVM__CUST__REF_SPAD_MAN__REF_LOCATION 0x00E9

#define VL53LX_NVM__CUST__MM_CONFIG__INNER_OFFSET_MM 0x00EC

#define VL53LX_NVM__CUST__MM_CONFIG__OUTER_OFFSET_MM 0x00EE

#define VL53LX_NVM__CUST__ALGO__PART_TO_PART_RANGE_OFFSET_MM 0x00F0

#define VL53LX_NVM__CUST__ALGO__CROSSTALK_COMPENSATION_PLANE_OFFSET_KCPS 0x00F4

#define VL53LX_NVM__CUST__ALGO__CROSSTALK_COMPENSATION_X_PLANE_GRADIENT_KCPS \
  0x00F6

#define VL53LX_NVM__CUST__ALGO__CROSSTALK_COMPENSATION_Y_PLANE_GRADIENT_KCPS \
  0x00F8

#define VL53LX_NVM__CUST__SPARE_HOST_CONFIG__NVM_CONFIG_SPARE_0 0x00FA

#define VL53LX_NVM__CUST__SPARE_HOST_CONFIG__NVM_CONFIG_SPARE_1 0x00FB

#define VL53LX_NVM__FMT__FGC__BYTE_0 0x01DC

#define VL53LX_NVM__FMT__FGC__BYTE_1 0x01DD

#define VL53LX_NVM__FMT__FGC__BYTE_2 0x01DE

#define VL53LX_NVM__FMT__FGC__BYTE_3 0x01DF

#define VL53LX_NVM__FMT__FGC__BYTE_4 0x01E0

#define VL53LX_NVM__FMT__FGC__BYTE_5 0x01E1

#define VL53LX_NVM__FMT__FGC__BYTE_6 0x01E2

#define VL53LX_NVM__FMT__FGC__BYTE_7 0x01E3

#define VL53LX_NVM__FMT__FGC__BYTE_8 0x01E4

#define VL53LX_NVM__FMT__FGC__BYTE_9 0x01E5

#define VL53LX_NVM__FMT__FGC__BYTE_10 0x01E6

#define VL53LX_NVM__FMT__FGC__BYTE_11 0x01E7

#define VL53LX_NVM__FMT__FGC__BYTE_12 0x01E8

#define VL53LX_NVM__FMT__FGC__BYTE_13 0x01E9

#define VL53LX_NVM__FMT__FGC__BYTE_14 0x01EA

#define VL53LX_NVM__FMT__FGC__BYTE_15 0x01EB

#define VL53LX_NVM__FMT__TEST_PROGRAM_MAJOR_MINOR 0x01EC

#define VL53LX_NVM__FMT__MAP_MAJOR_MINOR 0x01ED

#define VL53LX_NVM__FMT__YEAR_MONTH 0x01EE

#define VL53LX_NVM__FMT__DAY_MODULE_DATE_PHASE 0x01EF

#define VL53LX_NVM__FMT__TIME 0x01F0

#define VL53LX_NVM__FMT__TESTER_ID 0x01F2

#define VL53LX_NVM__FMT__SITE_ID 0x01F3

#define VL53LX_NVM__EWS__TEST_PROGRAM_MAJOR_MINOR 0x01F4

#define VL53LX_NVM__EWS__PROBE_CARD_MAJOR_MINOR 0x01F5

#define VL53LX_NVM__EWS__TESTER_ID 0x01F6

#define VL53LX_NVM__EWS__LOT__BYTE_0 0x01F8

#define VL53LX_NVM__EWS__LOT__BYTE_1 0x01F9

#define VL53LX_NVM__EWS__LOT__BYTE_2 0x01FA

#define VL53LX_NVM__EWS__LOT__BYTE_3 0x01FB

#define VL53LX_NVM__EWS__LOT__BYTE_4 0x01FC

#define VL53LX_NVM__EWS__LOT__BYTE_5 0x01FD

#define VL53LX_NVM__EWS__WAFER 0x01FD

#define VL53LX_NVM__EWS__XCOORD 0x01FE

#define VL53LX_NVM__EWS__YCOORD 0x01FF


#define VL53LX_NVM__FMT__OPTICAL_CENTRE_DATA_INDEX 0x00B8
#define VL53LX_NVM__FMT__OPTICAL_CENTRE_DATA_SIZE      4

#define VL53LX_NVM__FMT__CAL_PEAK_RATE_MAP_DATA_INDEX 0x015C
#define VL53LX_NVM__FMT__CAL_PEAK_RATE_MAP_DATA_SIZE   56

#define VL53LX_NVM__FMT__ADDITIONAL_OFFSET_CAL_DATA_INDEX 0x0194
#define VL53LX_NVM__FMT__ADDITIONAL_OFFSET_CAL_DATA_SIZE   8

#define VL53LX_NVM__FMT__RANGE_RESULTS__140MM_MM_PRE_RANGE 0x019C
#define VL53LX_NVM__FMT__RANGE_RESULTS__140MM_DARK 0x01AC
#define VL53LX_NVM__FMT__RANGE_RESULTS__400MM_DARK 0x01BC
#define VL53LX_NVM__FMT__RANGE_RESULTS__400MM_AMBIENT 0x01CC
#define VL53LX_NVM__FMT__RANGE_RESULTS__SIZE_BYTES         16






/* vl53lx_tuning_parm_defaults.h */



#define VL53LX_TUNINGPARM_VERSION_DEFAULT \
((uint16_t) 29)
#define VL53LX_TUNINGPARM_KEY_TABLE_VERSION_DEFAULT \
((uint16_t) 14)
#define VL53LX_TUNINGPARM_LLD_VERSION_DEFAULT \
((uint16_t) 12180)
#define VL53LX_TUNINGPARM_HIST_ALGO_SELECT_DEFAULT \
((uint8_t) 4)
#define VL53LX_TUNINGPARM_HIST_TARGET_ORDER_DEFAULT \
((uint8_t) 1)
#define VL53LX_TUNINGPARM_HIST_FILTER_WOI_0_DEFAULT \
((uint8_t) 1)
#define VL53LX_TUNINGPARM_HIST_FILTER_WOI_1_DEFAULT \
((uint8_t) 2)
#define VL53LX_TUNINGPARM_HIST_AMB_EST_METHOD_DEFAULT \
((uint8_t) 1)
#define VL53LX_TUNINGPARM_HIST_AMB_THRESH_SIGMA_0_DEFAULT \
((uint8_t) 80)
#define VL53LX_TUNINGPARM_HIST_AMB_THRESH_SIGMA_1_DEFAULT \
((uint8_t) 100)
#define VL53LX_TUNINGPARM_HIST_MIN_AMB_THRESH_EVENTS_DEFAULT \
((int32_t) 16)
#define VL53LX_TUNINGPARM_HIST_AMB_EVENTS_SCALER_DEFAULT \
((uint16_t) 4157)
#define VL53LX_TUNINGPARM_HIST_NOISE_THRESHOLD_DEFAULT \
((uint16_t) 50)
#define VL53LX_TUNINGPARM_HIST_SIGNAL_TOTAL_EVENTS_LIMIT_DEFAULT \
((int32_t) 100)
#define VL53LX_TUNINGPARM_HIST_SIGMA_EST_REF_MM_DEFAULT \
((uint8_t) 1)
#define VL53LX_TUNINGPARM_HIST_SIGMA_THRESH_MM_DEFAULT \
((uint16_t) 180)
#define VL53LX_TUNINGPARM_HIST_GAIN_FACTOR_DEFAULT \
((uint16_t) 1987)
#define VL53LX_TUNINGPARM_CONSISTENCY_HIST_PHASE_TOLERANCE_DEFAULT \
((uint8_t) 8)
#define VL53LX_TUNINGPARM_CONSISTENCY_HIST_MIN_MAX_TOLERANCE_MM_DEFAULT \
((uint16_t) 0)
#define VL53LX_TUNINGPARM_CONSISTENCY_HIST_EVENT_SIGMA_DEFAULT \
((uint8_t) 0)
#define VL53LX_TUNINGPARM_CONSISTENCY_HIST_EVENT_SIGMA_MIN_SPAD_LIMIT_DEFAULT \
((uint16_t) 2048)
#define VL53LX_TUNINGPARM_INITIAL_PHASE_RTN_HISTO_LONG_RANGE_DEFAULT \
((uint8_t) 9)
#define VL53LX_TUNINGPARM_INITIAL_PHASE_RTN_HISTO_MED_RANGE_DEFAULT \
((uint8_t) 5)
#define VL53LX_TUNINGPARM_INITIAL_PHASE_RTN_HISTO_SHORT_RANGE_DEFAULT \
((uint8_t) 3)
#define VL53LX_TUNINGPARM_INITIAL_PHASE_REF_HISTO_LONG_RANGE_DEFAULT \
((uint8_t) 6)
#define VL53LX_TUNINGPARM_INITIAL_PHASE_REF_HISTO_MED_RANGE_DEFAULT \
((uint8_t) 6)
#define VL53LX_TUNINGPARM_INITIAL_PHASE_REF_HISTO_SHORT_RANGE_DEFAULT \
((uint8_t) 6)
#define VL53LX_TUNINGPARM_XTALK_DETECT_MIN_VALID_RANGE_MM_DEFAULT \
((int16_t) -50)
#define VL53LX_TUNINGPARM_XTALK_DETECT_MAX_VALID_RANGE_MM_DEFAULT \
((int16_t) 50)
#define VL53LX_TUNINGPARM_XTALK_DETECT_MAX_SIGMA_MM_DEFAULT \
((uint16_t) 140)
#define VL53LX_TUNINGPARM_XTALK_DETECT_MIN_MAX_TOLERANCE_DEFAULT \
((uint16_t) 50)
#define VL53LX_TUNINGPARM_XTALK_DETECT_MAX_VALID_RATE_KCPS_DEFAULT \
((uint16_t) 400)
#define VL53LX_TUNINGPARM_XTALK_DETECT_EVENT_SIGMA_DEFAULT \
((uint8_t) 80)
#define VL53LX_TUNINGPARM_HIST_XTALK_MARGIN_KCPS_DEFAULT \
((int16_t) 0)
#define VL53LX_TUNINGPARM_CONSISTENCY_LITE_PHASE_TOLERANCE_DEFAULT \
((uint8_t) 2)
#define VL53LX_TUNINGPARM_PHASECAL_TARGET_DEFAULT \
((uint8_t) 33)
#define VL53LX_TUNINGPARM_LITE_CAL_REPEAT_RATE_DEFAULT \
((uint16_t) 0)
#define VL53LX_TUNINGPARM_LITE_RANGING_GAIN_FACTOR_DEFAULT \
((uint16_t) 2011)
#define VL53LX_TUNINGPARM_LITE_MIN_CLIP_MM_DEFAULT \
((uint8_t) 0)
#define VL53LX_TUNINGPARM_LITE_LONG_SIGMA_THRESH_MM_DEFAULT \
((uint16_t) 60)
#define VL53LX_TUNINGPARM_LITE_MED_SIGMA_THRESH_MM_DEFAULT \
((uint16_t) 60)
#define VL53LX_TUNINGPARM_LITE_SHORT_SIGMA_THRESH_MM_DEFAULT \
((uint16_t) 60)
#define VL53LX_TUNINGPARM_LITE_LONG_MIN_COUNT_RATE_RTN_MCPS_DEFAULT \
((uint16_t) 128)
#define VL53LX_TUNINGPARM_LITE_MED_MIN_COUNT_RATE_RTN_MCPS_DEFAULT \
((uint16_t) 128)
#define VL53LX_TUNINGPARM_LITE_SHORT_MIN_COUNT_RATE_RTN_MCPS_DEFAULT \
((uint16_t) 128)
#define VL53LX_TUNINGPARM_LITE_SIGMA_EST_PULSE_WIDTH_DEFAULT \
((uint8_t) 8)
#define VL53LX_TUNINGPARM_LITE_SIGMA_EST_AMB_WIDTH_NS_DEFAULT \
((uint8_t) 16)
#define VL53LX_TUNINGPARM_LITE_SIGMA_REF_MM_DEFAULT \
((uint8_t) 1)
#define VL53LX_TUNINGPARM_LITE_RIT_MULT_DEFAULT \
((uint8_t) 64)
#define VL53LX_TUNINGPARM_LITE_SEED_CONFIG_DEFAULT \
((uint8_t) 2)
#define VL53LX_TUNINGPARM_LITE_QUANTIFIER_DEFAULT \
((uint8_t) 2)
#define VL53LX_TUNINGPARM_LITE_FIRST_ORDER_SELECT_DEFAULT \
((uint8_t) 0)
#define VL53LX_TUNINGPARM_LITE_XTALK_MARGIN_KCPS_DEFAULT \
((int16_t) 0)
#define VL53LX_TUNINGPARM_INITIAL_PHASE_RTN_LITE_LONG_RANGE_DEFAULT \
((uint8_t) 14)
#define VL53LX_TUNINGPARM_INITIAL_PHASE_RTN_LITE_MED_RANGE_DEFAULT \
((uint8_t) 10)
#define VL53LX_TUNINGPARM_INITIAL_PHASE_RTN_LITE_SHORT_RANGE_DEFAULT \
((uint8_t) 6)
#define VL53LX_TUNINGPARM_INITIAL_PHASE_REF_LITE_LONG_RANGE_DEFAULT \
((uint8_t) 14)
#define VL53LX_TUNINGPARM_INITIAL_PHASE_REF_LITE_MED_RANGE_DEFAULT \
((uint8_t) 10)
#define VL53LX_TUNINGPARM_INITIAL_PHASE_REF_LITE_SHORT_RANGE_DEFAULT \
((uint8_t) 6)
#define VL53LX_TUNINGPARM_TIMED_SEED_CONFIG_DEFAULT \
((uint8_t) 1)
#define VL53LX_TUNINGPARM_DMAX_CFG_SIGNAL_THRESH_SIGMA_DEFAULT \
((uint8_t) 32)
#define VL53LX_TUNINGPARM_DMAX_CFG_REFLECTANCE_ARRAY_0_DEFAULT \
((uint16_t) 15)
#define VL53LX_TUNINGPARM_DMAX_CFG_REFLECTANCE_ARRAY_1_DEFAULT \
((uint16_t) 52)
#define VL53LX_TUNINGPARM_DMAX_CFG_REFLECTANCE_ARRAY_2_DEFAULT \
((uint16_t) 200)
#define VL53LX_TUNINGPARM_DMAX_CFG_REFLECTANCE_ARRAY_3_DEFAULT \
((uint16_t) 364)
#define VL53LX_TUNINGPARM_DMAX_CFG_REFLECTANCE_ARRAY_4_DEFAULT \
((uint16_t) 400)
#define VL53LX_TUNINGPARM_VHV_LOOPBOUND_DEFAULT \
((uint8_t) 129)
#define VL53LX_TUNINGPARM_REFSPADCHAR_DEVICE_TEST_MODE_DEFAULT \
((uint8_t) 8)
#define VL53LX_TUNINGPARM_REFSPADCHAR_VCSEL_PERIOD_DEFAULT \
((uint8_t) 11)
#define VL53LX_TUNINGPARM_REFSPADCHAR_PHASECAL_TIMEOUT_US_DEFAULT \
((uint32_t) 1000)
#define VL53LX_TUNINGPARM_REFSPADCHAR_TARGET_COUNT_RATE_MCPS_DEFAULT \
((uint16_t) 2560)
#define VL53LX_TUNINGPARM_REFSPADCHAR_MIN_COUNTRATE_LIMIT_MCPS_DEFAULT \
((uint16_t) 1280)
#define VL53LX_TUNINGPARM_REFSPADCHAR_MAX_COUNTRATE_LIMIT_MCPS_DEFAULT \
((uint16_t) 5120)
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_NUM_OF_SAMPLES_DEFAULT \
((uint8_t) 7)
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_MIN_FILTER_THRESH_MM_DEFAULT \
((int16_t) -70)
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_MAX_FILTER_THRESH_MM_DEFAULT \
((int16_t) 70)
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_DSS_RATE_MCPS_DEFAULT \
((uint16_t) 5120)
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_PHASECAL_TIMEOUT_US_DEFAULT \
((uint32_t) 15000)
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_MAX_VALID_RATE_KCPS_DEFAULT \
((uint16_t) 640)
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_SIGMA_THRESHOLD_MM_DEFAULT \
((uint16_t) 140)
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_DSS_TIMEOUT_US_DEFAULT \
((uint32_t) 2000)
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_BIN_TIMEOUT_US_DEFAULT \
((uint32_t) 10000)
#define VL53LX_TUNINGPARM_OFFSET_CAL_DSS_RATE_MCPS_DEFAULT \
((uint16_t) 2560)
#define VL53LX_TUNINGPARM_OFFSET_CAL_PHASECAL_TIMEOUT_US_DEFAULT \
((uint32_t) 15000)
#define VL53LX_TUNINGPARM_OFFSET_CAL_MM_TIMEOUT_US_DEFAULT \
((uint32_t) 13000)
#define VL53LX_TUNINGPARM_OFFSET_CAL_RANGE_TIMEOUT_US_DEFAULT \
((uint32_t) 13000)
#define VL53LX_TUNINGPARM_OFFSET_CAL_PRE_SAMPLES_DEFAULT \
((uint8_t) 8)
#define VL53LX_TUNINGPARM_OFFSET_CAL_MM1_SAMPLES_DEFAULT \
((uint8_t) 40)
#define VL53LX_TUNINGPARM_OFFSET_CAL_MM2_SAMPLES_DEFAULT \
((uint8_t) 9)
#define VL53LX_TUNINGPARM_ZONE_CAL_DSS_RATE_MCPS_DEFAULT \
((uint16_t) 5120)
#define VL53LX_TUNINGPARM_ZONE_CAL_PHASECAL_TIMEOUT_US_DEFAULT \
((uint32_t) 15000)
#define VL53LX_TUNINGPARM_ZONE_CAL_DSS_TIMEOUT_US_DEFAULT \
((uint32_t) 2000)
#define VL53LX_TUNINGPARM_ZONE_CAL_PHASECAL_NUM_SAMPLES_DEFAULT \
((uint16_t) 16)
#define VL53LX_TUNINGPARM_ZONE_CAL_RANGE_TIMEOUT_US_DEFAULT \
((uint32_t) 1000)
#define VL53LX_TUNINGPARM_ZONE_CAL_ZONE_NUM_SAMPLES_DEFAULT \
((uint16_t) 8)
#define VL53LX_TUNINGPARM_SPADMAP_VCSEL_PERIOD_DEFAULT \
((uint8_t) 18)
#define VL53LX_TUNINGPARM_SPADMAP_VCSEL_START_DEFAULT \
((uint8_t) 15)
#define VL53LX_TUNINGPARM_SPADMAP_RATE_LIMIT_MCPS_DEFAULT \
((uint16_t) 12)
#define VL53LX_TUNINGPARM_LITE_DSS_CONFIG_TARGET_TOTAL_RATE_MCPS_DEFAULT \
((uint16_t) 2560)
#define VL53LX_TUNINGPARM_RANGING_DSS_CONFIG_TARGET_TOTAL_RATE_MCPS_DEFAULT \
((uint16_t) 5120)
#define VL53LX_TUNINGPARM_MZ_DSS_CONFIG_TARGET_TOTAL_RATE_MCPS_DEFAULT \
((uint16_t) 5120)
#define VL53LX_TUNINGPARM_TIMED_DSS_CONFIG_TARGET_TOTAL_RATE_MCPS_DEFAULT \
((uint16_t) 2560)
#define VL53LX_TUNINGPARM_LITE_PHASECAL_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 1000)
#define VL53LX_TUNINGPARM_RANGING_LONG_PHASECAL_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 15000)
#define VL53LX_TUNINGPARM_RANGING_MED_PHASECAL_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 9000)
#define VL53LX_TUNINGPARM_RANGING_SHORT_PHASECAL_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 6000)
#define VL53LX_TUNINGPARM_MZ_LONG_PHASECAL_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 15000)
#define VL53LX_TUNINGPARM_MZ_MED_PHASECAL_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 9000)
#define VL53LX_TUNINGPARM_MZ_SHORT_PHASECAL_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 6000)
#define VL53LX_TUNINGPARM_TIMED_PHASECAL_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 1000)
#define VL53LX_TUNINGPARM_LITE_MM_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 2000)
#define VL53LX_TUNINGPARM_RANGING_MM_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 2000)
#define VL53LX_TUNINGPARM_MZ_MM_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 2000)
#define VL53LX_TUNINGPARM_TIMED_MM_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 2000)
#define VL53LX_TUNINGPARM_LITE_RANGE_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 63000)
#define VL53LX_TUNINGPARM_RANGING_RANGE_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 2500)
#define VL53LX_TUNINGPARM_MZ_RANGE_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 2500)
#define VL53LX_TUNINGPARM_TIMED_RANGE_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 13000)
#define VL53LX_TUNINGPARM_DYNXTALK_SMUDGE_MARGIN_DEFAULT \
((uint16_t) 0)
#define VL53LX_TUNINGPARM_DYNXTALK_NOISE_MARGIN_DEFAULT \
((uint32_t) 100)
#define VL53LX_TUNINGPARM_DYNXTALK_XTALK_OFFSET_LIMIT_DEFAULT \
((uint32_t) 0)
#define VL53LX_TUNINGPARM_DYNXTALK_XTALK_OFFSET_LIMIT_HI_DEFAULT \
((uint8_t) 0)
#define VL53LX_TUNINGPARM_DYNXTALK_SAMPLE_LIMIT_DEFAULT \
((uint32_t) 200)
#define VL53LX_TUNINGPARM_DYNXTALK_SINGLE_XTALK_DELTA_DEFAULT \
((uint32_t) 2048)
#define VL53LX_TUNINGPARM_DYNXTALK_AVERAGED_XTALK_DELTA_DEFAULT \
((uint32_t) 308)
#define VL53LX_TUNINGPARM_DYNXTALK_CLIP_LIMIT_DEFAULT \
((uint32_t) 10240)
#define VL53LX_TUNINGPARM_DYNXTALK_SCALER_CALC_METHOD_DEFAULT \
((uint8_t) 0)
#define VL53LX_TUNINGPARM_DYNXTALK_XGRADIENT_SCALER_DEFAULT \
((int16_t) 256)
#define VL53LX_TUNINGPARM_DYNXTALK_YGRADIENT_SCALER_DEFAULT \
((int16_t) 256)
#define VL53LX_TUNINGPARM_DYNXTALK_USER_SCALER_SET_DEFAULT \
((uint8_t) 0)
#define VL53LX_TUNINGPARM_DYNXTALK_SMUDGE_COR_SINGLE_APPLY_DEFAULT \
((uint8_t) 0)
#define VL53LX_TUNINGPARM_DYNXTALK_XTALK_AMB_THRESHOLD_DEFAULT \
((uint32_t) 128)
#define VL53LX_TUNINGPARM_DYNXTALK_NODETECT_AMB_THRESHOLD_KCPS_DEFAULT \
((uint32_t) 57671680)
#define VL53LX_TUNINGPARM_DYNXTALK_NODETECT_SAMPLE_LIMIT_DEFAULT \
((uint32_t) 40)
#define VL53LX_TUNINGPARM_DYNXTALK_NODETECT_XTALK_OFFSET_KCPS_DEFAULT \
((uint32_t) 410)
#define VL53LX_TUNINGPARM_DYNXTALK_NODETECT_MIN_RANGE_MM_DEFAULT \
((uint16_t) 900)
#define VL53LX_TUNINGPARM_LOWPOWERAUTO_VHV_LOOP_BOUND_DEFAULT \
((uint8_t) 3)
#define VL53LX_TUNINGPARM_LOWPOWERAUTO_MM_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 1)
#define VL53LX_TUNINGPARM_LOWPOWERAUTO_RANGE_CONFIG_TIMEOUT_US_DEFAULT \
((uint32_t) 8000)
#define VL53LX_TUNINGPARM_VERY_SHORT_DSS_RATE_MCPS_DEFAULT \
((uint16_t) 10240)
#define VL53LX_TUNINGPARM_PHASECAL_PATCH_POWER_DEFAULT \
((uint32_t) 0)
#define VL53LX_TUNINGPARM_HIST_MERGE_DEFAULT \
((uint32_t) 1)
#define VL53LX_TUNINGPARM_RESET_MERGE_THRESHOLD_DEFAULT \
((uint32_t) 15000)
#define VL53LX_TUNINGPARM_HIST_MERGE_MAX_SIZE_DEFAULT \
((uint32_t) 6)
#define VL53LX_TUNINGPARM_DYNXTALK_MAX_SMUDGE_FACTOR_DEFAULT \
((uint32_t) 2000)



/* vl53lx_preset_setup.h */


/* indexes for the bare driver tuning setting API function */

enum VL53LX_Tuning_t {
  VL53LX_TUNING_VERSION = 0,
  VL53LX_TUNING_PROXY_MIN,
  VL53LX_TUNING_SINGLE_TARGET_XTALK_TARGET_DISTANCE_MM,
  VL53LX_TUNING_SINGLE_TARGET_XTALK_SAMPLE_NUMBER,
  VL53LX_TUNING_MIN_AMBIENT_DMAX_VALID,
  VL53LX_TUNING_MAX_SIMPLE_OFFSET_CALIBRATION_SAMPLE_NUMBER,
  VL53LX_TUNING_XTALK_FULL_ROI_TARGET_DISTANCE_MM,
  VL53LX_TUNING_SIMPLE_OFFSET_CALIBRATION_REPEAT,
  VL53LX_TUNING_XTALK_FULL_ROI_BIN_SUM_MARGIN,
  VL53LX_TUNING_XTALK_FULL_ROI_DEFAULT_OFFSET,
  VL53LX_TUNING_ZERO_DISTANCE_OFFSET_NON_LINEAR_FACTOR,
  VL53LX_TUNING_MAX_TUNABLE_KEY
};


/* default values for the tuning settings parameters */
#define TUNING_VERSION  0x0007

#define TUNING_PROXY_MIN -30 /* min distance in mm */
#define TUNING_SINGLE_TARGET_XTALK_TARGET_DISTANCE_MM 600
/* Target distance in mm for single target Xtalk */
#define TUNING_SINGLE_TARGET_XTALK_SAMPLE_NUMBER 50
/* Number of sample used for single target Xtalk */
#define TUNING_MIN_AMBIENT_DMAX_VALID 8
/* Minimum ambient level to state the Dmax returned by the device is valid */
#ifdef SMALL_FOOTPRINT
#define TUNING_MAX_SIMPLE_OFFSET_CALIBRATION_SAMPLE_NUMBER 50
#else
#define TUNING_MAX_SIMPLE_OFFSET_CALIBRATION_SAMPLE_NUMBER 10
#endif
/* Maximum loops to perform simple offset calibration */
#define TUNING_XTALK_FULL_ROI_TARGET_DISTANCE_MM 600
/* Target distance in mm for target Xtalk from Bins method*/
#ifdef SMALL_FOOTPRINT
#define TUNING_SIMPLE_OFFSET_CALIBRATION_REPEAT 1
#else
#define TUNING_SIMPLE_OFFSET_CALIBRATION_REPEAT 3
#endif
/* Number of loops done during the simple offset calibration*/
#define TUNING_ZERO_DISTANCE_OFFSET_NON_LINEAR_FACTOR_DEFAULT 9
/* zero distance offset calibration non linear compensation default value */

/* The following settings are related to the fix for ticket EwokP #558410 */
#define TUNING_XTALK_FULL_ROI_BIN_SUM_MARGIN 24
/* Acceptance margin for the xtalk_shape bin_data sum computation */
#define TUNING_XTALK_FULL_ROI_DEFAULT_OFFSET 50
/* Recovery value for Xtalk compensation plane offset in kcps */
/* 50 stands for ~0.10 kcps cover glass in 7.9 format */
/* End of settings related to the fix for ticket EwokP #558410 */




// define from vl53lx_platform_user_config

#define    VL53LX_BYTES_PER_WORD              2
#define    VL53LX_BYTES_PER_DWORD             4

/* Define polling delays */
#define VL53LX_BOOT_COMPLETION_POLLING_TIMEOUT_MS     500
#define VL53LX_RANGE_COMPLETION_POLLING_TIMEOUT_MS   2000
#define VL53LX_TEST_COMPLETION_POLLING_TIMEOUT_MS   10000

#define VL53LX_POLLING_DELAY_MS                         1

/* Define LLD TuningParms Page Base Address
* - Part of Patch_AddedTuningParms_11761
*/
#define VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS  0x8000
#define VL53LX_TUNINGPARM_PRIVATE_PAGE_BASE_ADDRESS 0xC000

#define VL53LX_OFFSET_CAL_MIN_MM1_EFFECTIVE_SPADS  0x0500
/*!< Lower Limit for the  MM1 effective SPAD count during offset
    calibration Format 8.8 0x0500 -> 5.0 effective SPADs */

#define VL53LX_GAIN_FACTOR__STANDARD_DEFAULT       0x0800
/*!<  Default standard ranging gain correction factor
    1.11 format. 1.0 = 0x0800, 0.980 = 0x07D7 */
#define VL53LX_GAIN_FACTOR__HISTOGRAM_DEFAULT      0x0800
/*!<  Default histogram ranging gain correction factor
    1.11 format. 1.0 = 0x0800, 0.975 = 0x07CC */


#define VL53LX_OFFSET_CAL_MIN_EFFECTIVE_SPADS  0x0500
/*!< Lower Limit for the  MM1 effective SPAD count during offset
    calibration Format 8.8 0x0500 -> 5.0 effective SPADs */

#define VL53LX_OFFSET_CAL_MAX_PRE_PEAK_RATE_MCPS   0x1900
/*!< Max Limit for the pre range preak rate during offset
    calibration Format 9.7 0x1900 -> 50.0 Mcps.
    If larger then in pile up */

#define VL53LX_OFFSET_CAL_MAX_SIGMA_MM             0x0040
/*!< Max sigma estimate limit during offset calibration
    Check applies to pre-range, mm1 and mm2 ranges
    Format 14.2 0x0040 -> 16.0mm. */

#define VL53LX_ZONE_CAL_MAX_PRE_PEAK_RATE_MCPS     0x1900
/*!< Max Peak Rate Limit for the during zone calibration
    Format 9.7 0x1900 -> 50.0 Mcps.
    If larger then in pile up */

#define VL53LX_ZONE_CAL_MAX_SIGMA_MM               0x0040
/*!< Max sigma estimate limit during zone calibration
    Format 14.2 0x0040 -> 16.0mm. */


#define VL53LX_XTALK_EXTRACT_MAX_SIGMA_MM          0x008C
/*!< Max Sigma value allowed for a successful xtalk extraction
    Format 14.2 0x008C -> 35.0 mm.*/

#ifndef VL53LX_MAX_USER_ZONES
#define VL53LX_MAX_USER_ZONES                16
/*!< Max number of user Zones - maximal limitation from
    FW stream divide - value of 254 */
#endif

#define VL53LX_MAX_RANGE_RESULTS              4
#define VL53LX_BUFFER_SIZE              5

/*!< Sets the maximum number of targets distances the histogram
    post processing can generate */

#define VL53LX_MAX_STRING_LENGTH 512
/*!< Sets the maximum string length */


// typedef from vl53lx_types.h


#ifndef NULL
#error "Error NULL definition should be done. Please add required include "
#endif


#if !defined(STDINT_H) && !defined(_STDINT_H) && !defined(_GCC_STDINT_H) && !defined(__STDINT_DECLS) && !defined(_GCC_WRAP_STDINT_H)  && !defined(_STDINT)

#pragma message("Please review  type definition of STDINT define for your platform and add to list above ")

typedef unsigned long long uint64_t;
typedef unsigned int uint32_t;
typedef int int32_t;
typedef unsigned short uint16_t;
typedef short int16_t;
typedef unsigned char uint8_t;
typedef signed char int8_t;

#endif

typedef uint32_t FixPoint1616_t;



// define from vl53lx_error_codes.h



/*
****************************************
* PRIVATE define do not edit
***************************************
*/

/*
* @defgroup VL53LX_define_Error_group Error and Warning code returned by API
*  The following DEFINE are used to identify the PAL ERROR
*  @{
*/

typedef int8_t VL53LX_Error;

#define VL53LX_ERROR_NONE                              ((VL53LX_Error)  0)
#define VL53LX_ERROR_CALIBRATION_WARNING               ((VL53LX_Error) - 1)
/*!< Warning invalid calibration data may be in used
* \a  VL53LX_InitData()
* \a VL53LX_GetOffsetCalibrationData
* \a VL53LX_SetOffsetCalibrationData
*/
#define VL53LX_ERROR_MIN_CLIPPED                       ((VL53LX_Error) - 2)
/*!< Warning parameter passed was clipped to min before to be applied */

#define VL53LX_ERROR_UNDEFINED                         ((VL53LX_Error) - 3)
/*!< Unqualified error */
#define VL53LX_ERROR_INVALID_PARAMS                    ((VL53LX_Error) - 4)
/*!< Parameter passed is invalid or out of range */
#define VL53LX_ERROR_NOT_SUPPORTED                     ((VL53LX_Error) - 5)
/*!< Function is not supported in current mode or configuration */
#define VL53LX_ERROR_RANGE_ERROR                       ((VL53LX_Error) - 6)
/*!< Device report a ranging error interrupt status */
#define VL53LX_ERROR_TIME_OUT                          ((VL53LX_Error) - 7)
/*!< Aborted due to time out */
#define VL53LX_ERROR_MODE_NOT_SUPPORTED                ((VL53LX_Error) - 8)
/*!< Asked mode is not supported by the device */
#define VL53LX_ERROR_BUFFER_TOO_SMALL                  ((VL53LX_Error) - 9)
/*!< ... */
#define VL53LX_ERROR_COMMS_BUFFER_TOO_SMALL            ((VL53LX_Error) - 10)
/*!< Supplied buffer is larger than I2C supports */
#define VL53LX_ERROR_GPIO_NOT_EXISTING                 ((VL53LX_Error) - 11)
/*!< User tried to setup a non-existing GPIO pin */
#define VL53LX_ERROR_GPIO_FUNCTIONALITY_NOT_SUPPORTED  ((VL53LX_Error) - 12)
/*!< unsupported GPIO functionality */
#define VL53LX_ERROR_CONTROL_INTERFACE                 ((VL53LX_Error) - 13)
/*!< error reported from IO functions */
#define VL53LX_ERROR_INVALID_COMMAND                   ((VL53LX_Error) - 14)
/*!< The command is not allowed in the current device state
*  (power down)
*/
#define VL53LX_ERROR_DIVISION_BY_ZERO                  ((VL53LX_Error) - 15)
/*!< In the function a division by zero occurs */
#define VL53LX_ERROR_REF_SPAD_INIT                     ((VL53LX_Error) - 16)
/*!< Error during reference SPAD initialization */
#define VL53LX_ERROR_GPH_SYNC_CHECK_FAIL               ((VL53LX_Error) - 17)
/*!<  GPH sync interrupt check fail - API out of sync with device*/
#define VL53LX_ERROR_STREAM_COUNT_CHECK_FAIL           ((VL53LX_Error) - 18)
/*!<  Stream count check fail - API out of sync with device */
#define VL53LX_ERROR_GPH_ID_CHECK_FAIL                 ((VL53LX_Error) - 19)
/*!<  GPH ID check fail - API out of sync with device */
#define VL53LX_ERROR_ZONE_STREAM_COUNT_CHECK_FAIL      ((VL53LX_Error) - 20)
/*!<  Zone dynamic config stream count check failed - API out of sync */
#define VL53LX_ERROR_ZONE_GPH_ID_CHECK_FAIL            ((VL53LX_Error) - 21)
/*!<  Zone dynamic config GPH ID check failed - API out of sync */

#define VL53LX_ERROR_XTALK_EXTRACTION_NO_SAMPLE_FAIL   ((VL53LX_Error) - 22)
/*!<  Thrown when run_xtalk_extraction fn has 0 successful samples
* when using the full array to sample the xtalk. In this case there is
* not enough information to generate new Xtalk parm info. The function
* will exit and leave the current xtalk parameters unaltered
*/
#define VL53LX_ERROR_XTALK_EXTRACTION_SIGMA_LIMIT_FAIL ((VL53LX_Error) - 23)
/*!<  Thrown when run_xtalk_extraction fn has found that the
* avg sigma estimate of the full array xtalk sample is > than the
* maximal limit allowed. In this case the xtalk sample is too noisy for
* measurement. The function will exit and leave the current xtalk
* parameters unaltered.
*/


#define VL53LX_ERROR_OFFSET_CAL_NO_SAMPLE_FAIL           ((VL53LX_Error) - 24)
/*!<  Thrown if there one of stages has no valid offset calibration
*    samples. A fatal error calibration not valid
*/
#define VL53LX_ERROR_OFFSET_CAL_NO_SPADS_ENABLED_FAIL    ((VL53LX_Error) - 25)
/*!<  Thrown if there one of stages has zero effective SPADS
*    Traps the case when MM1 SPADs is zero.
*    A fatal error calibration not valid
*/
#define VL53LX_ERROR_ZONE_CAL_NO_SAMPLE_FAIL             ((VL53LX_Error) - 26)
/*!<  Thrown if then some of the zones have no valid samples
*    A fatal error calibration not valid
*/

#define VL53LX_ERROR_TUNING_PARM_KEY_MISMATCH             ((VL53LX_Error) - 27)
/*!<  Thrown if the tuning file key table version does not match with
* expected value. The driver expects the key table version to match
* the compiled default version number in the define
* #VL53LX_TUNINGPARM_KEY_TABLE_VERSION_DEFAULT
*/

#define VL53LX_WARNING_REF_SPAD_CHAR_NOT_ENOUGH_SPADS   ((VL53LX_Error) - 28)
/*!<  Thrown if there are less than 5 good SPADs are available. */
#define VL53LX_WARNING_REF_SPAD_CHAR_RATE_TOO_HIGH      ((VL53LX_Error) - 29)
/*!<  Thrown if the final reference rate is greater than
* the upper reference rate limit - default is 40 Mcps.
* Implies a minimum Q3 (x10) SPAD (5) selected
*/
#define VL53LX_WARNING_REF_SPAD_CHAR_RATE_TOO_LOW       ((VL53LX_Error) - 30)
/*!<  Thrown if the final reference rate is less than
* the lower reference rate limit - default is 10 Mcps.
* Implies maximum Q1 (x1) SPADs selected
*/


#define VL53LX_WARNING_OFFSET_CAL_MISSING_SAMPLES       ((VL53LX_Error) - 31)
/*!<  Thrown if there is less than the requested number of
*    valid samples.
*/
#define VL53LX_WARNING_OFFSET_CAL_SIGMA_TOO_HIGH        ((VL53LX_Error) - 32)
/*!<  Thrown if the offset calibration range sigma estimate is greater
*    than 8.0 mm. This is the recommended min value to yield a stable
*    offset measurement
*/
#define VL53LX_WARNING_OFFSET_CAL_RATE_TOO_HIGH         ((VL53LX_Error) - 33)
/*!< Thrown when VL53LX_run_offset_calibration()  peak rate is greater
* than that 50.0Mcps. This is the recommended  max rate to avoid
* pile-up influencing the offset measurement
*/
#define VL53LX_WARNING_OFFSET_CAL_SPAD_COUNT_TOO_LOW    ((VL53LX_Error) - 34)
/*!< Thrown when VL53LX_run_offset_calibration() when one of stages
* range has less that 5.0 effective SPADS. This is the recommended
* min value to yield a stable offset
*/


#define VL53LX_WARNING_ZONE_CAL_MISSING_SAMPLES       ((VL53LX_Error) - 35)
/*!<  Thrown if one of more of the zones have less than
* the requested number of valid samples
*/
#define VL53LX_WARNING_ZONE_CAL_SIGMA_TOO_HIGH        ((VL53LX_Error) - 36)
/*!<  Thrown if one or more zones have sigma estimate value greater
*    than 8.0 mm. This is the recommended min value to yield a stable
*    offset measurement
*/
#define VL53LX_WARNING_ZONE_CAL_RATE_TOO_HIGH         ((VL53LX_Error) - 37)
/*!< Thrown if one of more zones have  peak rate higher than
* that 50.0Mcps. This is the recommended  max rate to avoid
* pile-up influencing the offset measurement
*/


#define VL53LX_WARNING_XTALK_MISSING_SAMPLES             ((VL53LX_Error) - 38)
/*!< Thrown to notify that some of the xtalk samples did not yield
* valid ranging pulse data while attempting to measure
* the xtalk signal in vl53lx_run_xtalk_extract(). This can signify any
* of the zones are missing samples, for further debug information the
* xtalk_results struct should be referred to. This warning is for
* notification only, xtalk pulse and shape have still been generated
*/
#define VL53LX_WARNING_XTALK_NO_SAMPLES_FOR_GRADIENT     ((VL53LX_Error) - 39)
/*!< Thrown to notify that some of the xtalk samples used for gradient
* generation did not yield valid ranging pulse data while attempting to
* measure the xtalk signal in vl53lx_run_xtalk_extract(). This can
* signify that any one of the zones 0-3 yielded no successful samples.
* xtalk_results struct should be referred to for further debug info.
* This warning is for notification only, the xtalk pulse and shape
* have still been generated.
*/
#define VL53LX_WARNING_XTALK_SIGMA_LIMIT_FOR_GRADIENT    ((VL53LX_Error) - 40)
/*!< Thrown to notify that some of the xtalk samples used for gradient
* generation did not pass the sigma limit check  while attempting to
* measure the xtalk signal in vl53lx_run_xtalk_extract(). This can
* signify that any one of the zones 0-3 yielded an avg sigma_mm
* value > the limit. The xtalk_results struct should be referred to for
* further debug info.
* This warning is for notification only, the xtalk pulse and shape
* have still been generated.
*/

#define VL53LX_ERROR_NOT_IMPLEMENTED                   ((VL53LX_Error) - 41)
/*!< Tells requested functionality has not been implemented yet or
* not compatible with the device
*/
#define VL53LX_ERROR_PLATFORM_SPECIFIC_START           ((VL53LX_Error) - 60)
/*!< Tells the starting code for platform */
/** @} VL53LX_define_Error_group */



/* vl53lx_dmax_private_structs.h */








typedef struct {

  uint32_t  VL53LX_p_037;



  uint8_t   VL53LX_p_063;


  uint8_t   VL53LX_p_064;



  uint16_t   VL53LX_p_065;


  uint16_t   VL53LX_p_066;


  uint16_t   VL53LX_p_067;


  uint16_t   VL53LX_p_038;



  uint32_t   VL53LX_p_009;


  uint32_t   VL53LX_p_033;



  uint16_t   VL53LX_p_034;



  uint16_t   VL53LX_p_004;



  uint32_t   VL53LX_p_028;


  uint32_t   VL53LX_p_035;



  int16_t    VL53LX_p_036;


  int16_t    VL53LX_p_022;



} VL53LX_hist_gen3_dmax_private_data_t;




// def & typedef from vl53lx_ll_device.h


#define   VL53LX_I2C                      0x01
#define   VL53LX_SPI                      0x00





typedef uint8_t VL53LX_WaitMethod;

#define VL53LX_WAIT_METHOD_BLOCKING               ((VL53LX_WaitMethod)  0)
#define VL53LX_WAIT_METHOD_NON_BLOCKING           ((VL53LX_WaitMethod)  1)




typedef uint8_t VL53LX_DeviceState;

#define VL53LX_DEVICESTATE_POWERDOWN              ((VL53LX_DeviceState)  0)
#define VL53LX_DEVICESTATE_HW_STANDBY             ((VL53LX_DeviceState)  1)
#define VL53LX_DEVICESTATE_FW_COLDBOOT            ((VL53LX_DeviceState)  2)
#define VL53LX_DEVICESTATE_SW_STANDBY             ((VL53LX_DeviceState)  3)
#define VL53LX_DEVICESTATE_RANGING_DSS_AUTO       ((VL53LX_DeviceState)  4)
#define VL53LX_DEVICESTATE_RANGING_DSS_MANUAL     ((VL53LX_DeviceState)  5)
#define VL53LX_DEVICESTATE_RANGING_WAIT_GPH_SYNC  ((VL53LX_DeviceState)  6)
#define VL53LX_DEVICESTATE_RANGING_GATHER_DATA    ((VL53LX_DeviceState)  7)
#define VL53LX_DEVICESTATE_RANGING_OUTPUT_DATA    ((VL53LX_DeviceState)  8)

#define VL53LX_DEVICESTATE_UNKNOWN               ((VL53LX_DeviceState) 98)
#define VL53LX_DEVICESTATE_ERROR                 ((VL53LX_DeviceState) 99)





typedef uint8_t VL53LX_DeviceZonePreset;

#define VL53LX_DEVICEZONEPRESET_NONE            \
        ((VL53LX_DeviceZonePreset)   0)

#define VL53LX_DEVICEZONEPRESET_XTALK_PLANAR     \
        ((VL53LX_DeviceZonePreset)   1)
#define VL53LX_DEVICEZONEPRESET_1X1_SIZE_16X16    \
        ((VL53LX_DeviceZonePreset)   2)
#define VL53LX_DEVICEZONEPRESET_1X2_SIZE_16X8      \
        ((VL53LX_DeviceZonePreset)   3)
#define VL53LX_DEVICEZONEPRESET_2X1_SIZE_8X16     \
        ((VL53LX_DeviceZonePreset)   4)
#define VL53LX_DEVICEZONEPRESET_2X2_SIZE_8X8      \
        ((VL53LX_DeviceZonePreset)   5)
#define VL53LX_DEVICEZONEPRESET_3X3_SIZE_5X5      \
        ((VL53LX_DeviceZonePreset)   6)
#define VL53LX_DEVICEZONEPRESET_4X4_SIZE_4X4       \
        ((VL53LX_DeviceZonePreset)   7)
#define VL53LX_DEVICEZONEPRESET_5X5_SIZE_4X4       \
        ((VL53LX_DeviceZonePreset)   8)
#define VL53LX_DEVICEZONEPRESET_11X11_SIZE_5X5     \
        ((VL53LX_DeviceZonePreset)   9)
#define VL53LX_DEVICEZONEPRESET_13X13_SIZE_4X4     \
        ((VL53LX_DeviceZonePreset)  10)

#define VL53LX_DEVICEZONEPRESET_1X1_SIZE_4X4_POS_8X8 \
        ((VL53LX_DeviceZonePreset)  11)

#define VL53LX_DEVICEZONEPRESET_CUSTOM             \
        ((VL53LX_DeviceZonePreset) 255)





typedef uint8_t VL53LX_DevicePresetModes;

#define VL53LX_DEVICEPRESETMODE_NONE                            \
        ((VL53LX_DevicePresetModes)  0)
#define VL53LX_DEVICEPRESETMODE_STANDARD_RANGING                \
        ((VL53LX_DevicePresetModes)  1)
#define VL53LX_DEVICEPRESETMODE_STANDARD_RANGING_SHORT_RANGE    \
        ((VL53LX_DevicePresetModes)  2)
#define VL53LX_DEVICEPRESETMODE_STANDARD_RANGING_LONG_RANGE     \
        ((VL53LX_DevicePresetModes)  3)
#define VL53LX_DEVICEPRESETMODE_STANDARD_RANGING_MM1_CAL        \
        ((VL53LX_DevicePresetModes)  4)
#define VL53LX_DEVICEPRESETMODE_STANDARD_RANGING_MM2_CAL        \
        ((VL53LX_DevicePresetModes)  5)
#define VL53LX_DEVICEPRESETMODE_TIMED_RANGING                   \
        ((VL53LX_DevicePresetModes)  6)
#define VL53LX_DEVICEPRESETMODE_TIMED_RANGING_SHORT_RANGE       \
        ((VL53LX_DevicePresetModes)  7)
#define VL53LX_DEVICEPRESETMODE_TIMED_RANGING_LONG_RANGE        \
        ((VL53LX_DevicePresetModes)  8)
#define VL53LX_DEVICEPRESETMODE_NEAR_FARRANGING                 \
        ((VL53LX_DevicePresetModes)  9)
#define VL53LX_DEVICEPRESETMODE_QUADRANT_RANGING                \
        ((VL53LX_DevicePresetModes) 10)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_RANGING               \
        ((VL53LX_DevicePresetModes) 11)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_RANGING_SHORT_TIMING  \
        ((VL53LX_DevicePresetModes) 12)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_CHARACTERISATION      \
        ((VL53LX_DevicePresetModes) 13)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_XTALK_PLANAR          \
        ((VL53LX_DevicePresetModes) 14)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_XTALK_MM1             \
        ((VL53LX_DevicePresetModes) 15)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_XTALK_MM2             \
        ((VL53LX_DevicePresetModes) 16)
#define VL53LX_DEVICEPRESETMODE_OLT                             \
        ((VL53LX_DevicePresetModes) 17)
#define VL53LX_DEVICEPRESETMODE_SINGLESHOT_RANGING              \
        ((VL53LX_DevicePresetModes) 18)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_REF_ARRAY             \
        ((VL53LX_DevicePresetModes) 19)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_RANGING_WITH_MM1      \
        ((VL53LX_DevicePresetModes) 20)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_RANGING_WITH_MM2      \
        ((VL53LX_DevicePresetModes) 21)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_RANGING_MM1_CAL       \
        ((VL53LX_DevicePresetModes) 22)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_RANGING_MM2_CAL       \
        ((VL53LX_DevicePresetModes) 23)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_MULTIZONE             \
        ((VL53LX_DevicePresetModes) 24)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_MULTIZONE_SHORT_RANGE \
        ((VL53LX_DevicePresetModes) 25)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_MULTIZONE_LONG_RANGE  \
        ((VL53LX_DevicePresetModes) 26)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_LONG_RANGE            \
        ((VL53LX_DevicePresetModes) 27)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_LONG_RANGE_MM1        \
        ((VL53LX_DevicePresetModes) 28)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_LONG_RANGE_MM2        \
        ((VL53LX_DevicePresetModes) 29)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_MEDIUM_RANGE          \
        ((VL53LX_DevicePresetModes) 30)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_MEDIUM_RANGE_MM1      \
        ((VL53LX_DevicePresetModes) 31)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_MEDIUM_RANGE_MM2      \
        ((VL53LX_DevicePresetModes) 32)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_SHORT_RANGE           \
        ((VL53LX_DevicePresetModes) 33)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_SHORT_RANGE_MM1       \
        ((VL53LX_DevicePresetModes) 34)
#define VL53LX_DEVICEPRESETMODE_HISTOGRAM_SHORT_RANGE_MM2       \
        ((VL53LX_DevicePresetModes) 35)
#define VL53LX_DEVICEPRESETMODE_LOWPOWERAUTO_SHORT_RANGE  \
        ((VL53LX_DevicePresetModes) 36)
#define VL53LX_DEVICEPRESETMODE_LOWPOWERAUTO_MEDIUM_RANGE \
        ((VL53LX_DevicePresetModes) 37)
#define VL53LX_DEVICEPRESETMODE_LOWPOWERAUTO_LONG_RANGE   \
        ((VL53LX_DevicePresetModes) 38)
#define VL53LX_DEVICEPRESETMODE_SPECIAL_HISTOGRAM_SHORT_RANGE \
        ((VL53LX_DevicePresetModes) 39)





typedef uint8_t VL53LX_DeviceMeasurementModes;

#define VL53LX_DEVICEMEASUREMENTMODE_STOP          \
        ((VL53LX_DeviceMeasurementModes)  0x00)
#define VL53LX_DEVICEMEASUREMENTMODE_SINGLESHOT     \
        ((VL53LX_DeviceMeasurementModes)  0x10)
#define VL53LX_DEVICEMEASUREMENTMODE_BACKTOBACK      \
        ((VL53LX_DeviceMeasurementModes)  0x20)
#define VL53LX_DEVICEMEASUREMENTMODE_TIMED          \
        ((VL53LX_DeviceMeasurementModes)  0x40)
#define VL53LX_DEVICEMEASUREMENTMODE_ABORT          \
        ((VL53LX_DeviceMeasurementModes)  0x80)





typedef uint8_t VL53LX_OffsetCalibrationMode;

#define VL53LX_OFFSETCALIBRATIONMODE__NONE                \
        ((VL53LX_OffsetCalibrationMode)  0)
#define VL53LX_OFFSETCALIBRATIONMODE__MM1_MM2__STANDARD    \
        ((VL53LX_OffsetCalibrationMode)  1)
#define VL53LX_OFFSETCALIBRATIONMODE__MM1_MM2__HISTOGRAM    \
        ((VL53LX_OffsetCalibrationMode)  2)
#define VL53LX_OFFSETCALIBRATIONMODE__MM1_MM2__STANDARD_PRE_RANGE_ONLY \
        ((VL53LX_OffsetCalibrationMode)  3)
#define VL53LX_OFFSETCALIBRATIONMODE__MM1_MM2__HISTOGRAM_PRE_RANGE_ONLY \
        ((VL53LX_OffsetCalibrationMode)  4)





typedef uint8_t VL53LX_OffsetCorrectionMode;

#define VL53LX_OFFSETCORRECTIONMODE__NONE             \
        ((VL53LX_OffsetCorrectionMode)  0)
#define VL53LX_OFFSETCORRECTIONMODE__MM1_MM2_OFFSETS  \
        ((VL53LX_OffsetCorrectionMode)  1)
#define VL53LX_OFFSETCORRECTIONMODE__PER_VCSEL_OFFSETS  \
        ((VL53LX_OffsetCorrectionMode)  3)





typedef uint8_t VL53LX_DeviceDmaxMode;

#define VL53LX_DEVICEDMAXMODE__NONE                 \
        ((VL53LX_DeviceDmaxMode)  0)
#define VL53LX_DEVICEDMAXMODE__FMT_CAL_DATA          \
        ((VL53LX_DeviceDmaxMode)  1)
#define VL53LX_DEVICEDMAXMODE__CUST_CAL_DATA         \
        ((VL53LX_DeviceDmaxMode)  2)





typedef uint8_t VL53LX_DeviceSequenceConfig;

#define VL53LX_DEVICESEQUENCECONFIG_VHV   \
        ((VL53LX_DeviceSequenceConfig) 0)
#define VL53LX_DEVICESEQUENCECONFIG_PHASECAL     \
        ((VL53LX_DeviceSequenceConfig) 1)
#define VL53LX_DEVICESEQUENCECONFIG_REFERENCE_PHASE \
        ((VL53LX_DeviceSequenceConfig) 2)
#define VL53LX_DEVICESEQUENCECONFIG_DSS1           \
        ((VL53LX_DeviceSequenceConfig) 3)
#define VL53LX_DEVICESEQUENCECONFIG_DSS2           \
        ((VL53LX_DeviceSequenceConfig) 4)
#define VL53LX_DEVICESEQUENCECONFIG_MM1            \
        ((VL53LX_DeviceSequenceConfig) 5)
#define VL53LX_DEVICESEQUENCECONFIG_MM2            \
        ((VL53LX_DeviceSequenceConfig) 6)
#define VL53LX_DEVICESEQUENCECONFIG_RANGE          \
        ((VL53LX_DeviceSequenceConfig) 7)





typedef uint8_t VL53LX_DeviceInterruptPolarity;

#define VL53LX_DEVICEINTERRUPTPOLARITY_ACTIVE_HIGH        \
        ((VL53LX_DeviceInterruptPolarity)  0x00)
#define VL53LX_DEVICEINTERRUPTPOLARITY_ACTIVE_LOW         \
        ((VL53LX_DeviceInterruptPolarity)  0x10)
#define VL53LX_DEVICEINTERRUPTPOLARITY_BIT_MASK           \
        ((VL53LX_DeviceInterruptPolarity)  0x10)
#define VL53LX_DEVICEINTERRUPTPOLARITY_CLEAR_MASK          \
        ((VL53LX_DeviceInterruptPolarity)  0xEF)





typedef uint8_t VL53LX_DeviceGpioMode;

#define VL53LX_DEVICEGPIOMODE_OUTPUT_CONSTANT_ZERO                \
        ((VL53LX_DeviceGpioMode)  0x00)
#define VL53LX_DEVICEGPIOMODE_OUTPUT_RANGE_AND_ERROR_INTERRUPTS    \
        ((VL53LX_DeviceGpioMode)  0x01)
#define VL53LX_DEVICEGPIOMODE_OUTPUT_TIMIER_INTERRUPTS             \
        ((VL53LX_DeviceGpioMode)  0x02)
#define VL53LX_DEVICEGPIOMODE_OUTPUT_RANGE_MODE_INTERRUPT_STATUS  \
        ((VL53LX_DeviceGpioMode)  0x03)
#define VL53LX_DEVICEGPIOMODE_OUTPUT_SLOW_OSCILLATOR_CLOCK        \
        ((VL53LX_DeviceGpioMode)  0x04)
#define VL53LX_DEVICEGPIOMODE_BIT_MASK                           \
        ((VL53LX_DeviceGpioMode)  0x0F)
#define VL53LX_DEVICEGPIOMODE_CLEAR_MASK                        \
        ((VL53LX_DeviceGpioMode)  0xF0)





typedef uint8_t VL53LX_DeviceError;

#define VL53LX_DEVICEERROR_NOUPDATE                   \
        ((VL53LX_DeviceError) 0)

#define VL53LX_DEVICEERROR_VCSELCONTINUITYTESTFAILURE \
        ((VL53LX_DeviceError) 1)
#define VL53LX_DEVICEERROR_VCSELWATCHDOGTESTFAILURE   \
        ((VL53LX_DeviceError) 2)
#define VL53LX_DEVICEERROR_NOVHVVALUEFOUND            \
        ((VL53LX_DeviceError) 3)
#define VL53LX_DEVICEERROR_MSRCNOTARGET               \
        ((VL53LX_DeviceError) 4)
#define VL53LX_DEVICEERROR_RANGEPHASECHECK            \
        ((VL53LX_DeviceError) 5)
#define VL53LX_DEVICEERROR_SIGMATHRESHOLDCHECK        \
        ((VL53LX_DeviceError) 6)
#define VL53LX_DEVICEERROR_PHASECONSISTENCY           \
        ((VL53LX_DeviceError) 7)
#define VL53LX_DEVICEERROR_MINCLIP                    \
        ((VL53LX_DeviceError) 8)
#define VL53LX_DEVICEERROR_RANGECOMPLETE               \
        ((VL53LX_DeviceError) 9)
#define VL53LX_DEVICEERROR_ALGOUNDERFLOW               \
        ((VL53LX_DeviceError) 10)
#define VL53LX_DEVICEERROR_ALGOOVERFLOW                \
        ((VL53LX_DeviceError) 11)
#define VL53LX_DEVICEERROR_RANGEIGNORETHRESHOLD       \
        ((VL53LX_DeviceError) 12)
#define VL53LX_DEVICEERROR_USERROICLIP                \
        ((VL53LX_DeviceError) 13)
#define VL53LX_DEVICEERROR_REFSPADCHARNOTENOUGHDPADS   \
        ((VL53LX_DeviceError) 14)
#define VL53LX_DEVICEERROR_REFSPADCHARMORETHANTARGET  \
        ((VL53LX_DeviceError) 15)
#define VL53LX_DEVICEERROR_REFSPADCHARLESSTHANTARGET  \
        ((VL53LX_DeviceError) 16)
#define VL53LX_DEVICEERROR_MULTCLIPFAIL                \
        ((VL53LX_DeviceError) 17)
#define VL53LX_DEVICEERROR_GPHSTREAMCOUNT0READY        \
        ((VL53LX_DeviceError) 18)
#define VL53LX_DEVICEERROR_RANGECOMPLETE_NO_WRAP_CHECK \
        ((VL53LX_DeviceError) 19)
#define VL53LX_DEVICEERROR_EVENTCONSISTENCY           \
        ((VL53LX_DeviceError) 20)
#define VL53LX_DEVICEERROR_MINSIGNALEVENTCHECK        \
        ((VL53LX_DeviceError) 21)
#define VL53LX_DEVICEERROR_RANGECOMPLETE_MERGED_PULSE \
        ((VL53LX_DeviceError) 22)


#define VL53LX_DEVICEERROR_PREV_RANGE_NO_TARGETS      \
        ((VL53LX_DeviceError) 23)





typedef uint8_t VL53LX_DeviceReportStatus;

#define VL53LX_DEVICEREPORTSTATUS_NOUPDATE                 \
        ((VL53LX_DeviceReportStatus) 0)

#define VL53LX_DEVICEREPORTSTATUS_ROI_SETUP               \
        ((VL53LX_DeviceReportStatus)  1)
#define VL53LX_DEVICEREPORTSTATUS_VHV                     \
        ((VL53LX_DeviceReportStatus)  2)
#define VL53LX_DEVICEREPORTSTATUS_PHASECAL                \
        ((VL53LX_DeviceReportStatus)  3)
#define VL53LX_DEVICEREPORTSTATUS_REFERENCE_PHASE         \
        ((VL53LX_DeviceReportStatus)  4)
#define VL53LX_DEVICEREPORTSTATUS_DSS1                    \
        ((VL53LX_DeviceReportStatus)  5)
#define VL53LX_DEVICEREPORTSTATUS_DSS2                    \
        ((VL53LX_DeviceReportStatus)  6)
#define VL53LX_DEVICEREPORTSTATUS_MM1                     \
        ((VL53LX_DeviceReportStatus)  7)
#define VL53LX_DEVICEREPORTSTATUS_MM2                     \
        ((VL53LX_DeviceReportStatus)  8)
#define VL53LX_DEVICEREPORTSTATUS_RANGE                   \
        ((VL53LX_DeviceReportStatus)  9)
#define VL53LX_DEVICEREPORTSTATUS_HISTOGRAM               \
        ((VL53LX_DeviceReportStatus) 10)





typedef uint8_t VL53LX_DeviceDssMode;

#define VL53LX_DEVICEDSSMODE__DISABLED \
        ((VL53LX_DeviceDssMode) 0)
#define VL53LX_DEVICEDSSMODE__TARGET_RATE \
        ((VL53LX_DeviceDssMode) 1)
#define VL53LX_DEVICEDSSMODE__REQUESTED_EFFFECTIVE_SPADS \
        ((VL53LX_DeviceDssMode) 2)
#define VL53LX_DEVICEDSSMODE__BLOCK_SELECT \
        ((VL53LX_DeviceDssMode) 3)






typedef uint8_t VL53LX_HistAlgoSelect;

#define VL53LX_HIST_ALGO_SELECT__PW_HIST_GEN1 \
        ((VL53LX_HistAlgoSelect) 1)
#define VL53LX_HIST_ALGO_SELECT__PW_HIST_GEN2 \
        ((VL53LX_HistAlgoSelect) 2)
#define VL53LX_HIST_ALGO_SELECT__PW_HIST_GEN3 \
        ((VL53LX_HistAlgoSelect) 3)
#define VL53LX_HIST_ALGO_SELECT__PW_HIST_GEN4 \
        ((VL53LX_HistAlgoSelect) 4)






typedef uint8_t VL53LX_HistTargetOrder;

#define VL53LX_HIST_TARGET_ORDER__INCREASING_DISTANCE \
        ((VL53LX_HistTargetOrder) 1)
#define VL53LX_HIST_TARGET_ORDER__STRONGEST_FIRST \
        ((VL53LX_HistTargetOrder) 2)






typedef uint8_t VL53LX_HistAmbEstMethod;

#define VL53LX_HIST_AMB_EST_METHOD__AMBIENT_BINS \
        ((VL53LX_HistAmbEstMethod) 1)
#define VL53LX_HIST_AMB_EST_METHOD__THRESHOLDED_BINS  \
        ((VL53LX_HistAmbEstMethod) 2)






typedef uint8_t VL53LX_HistXtalkCompEnable;

#define VL53LX_HIST_XTALK_COMP__DIS \
        ((VL53LX_HistXtalkCompEnable) 0)
#define VL53LX_HIST_XTALK_COMP__EN \
        ((VL53LX_HistXtalkCompEnable) 1)




typedef uint8_t VL53LX_DeviceConfigLevel;

#define VL53LX_DEVICECONFIGLEVEL_SYSTEM_CONTROL  \
        ((VL53LX_DeviceConfigLevel)  0)

#define VL53LX_DEVICECONFIGLEVEL_DYNAMIC_ONWARDS \
        ((VL53LX_DeviceConfigLevel)  1)

#define VL53LX_DEVICECONFIGLEVEL_TIMING_ONWARDS \
        ((VL53LX_DeviceConfigLevel)  2)

#define VL53LX_DEVICECONFIGLEVEL_GENERAL_ONWARDS \
        ((VL53LX_DeviceConfigLevel)  3)

#define VL53LX_DEVICECONFIGLEVEL_STATIC_ONWARDS  \
        ((VL53LX_DeviceConfigLevel)  4)

#define VL53LX_DEVICECONFIGLEVEL_CUSTOMER_ONWARDS  \
        ((VL53LX_DeviceConfigLevel)  5)

#define VL53LX_DEVICECONFIGLEVEL_FULL  \
        ((VL53LX_DeviceConfigLevel)  6)






typedef uint8_t VL53LX_DeviceResultsLevel;

#define VL53LX_DEVICERESULTSLEVEL_SYSTEM_RESULTS  \
        ((VL53LX_DeviceResultsLevel)  0)

#define VL53LX_DEVICERESULTSLEVEL_UPTO_CORE  \
        ((VL53LX_DeviceResultsLevel)  1)

#define VL53LX_DEVICERESULTSLEVEL_FULL  \
        ((VL53LX_DeviceResultsLevel)  2)







typedef uint8_t VL53LX_DeviceTestMode;

#define VL53LX_DEVICETESTMODE_NONE \
        ((VL53LX_DeviceTestMode) 0x00)

#define VL53LX_DEVICETESTMODE_NVM_ZERO \
        ((VL53LX_DeviceTestMode) 0x01)

#define VL53LX_DEVICETESTMODE_NVM_COPY \
        ((VL53LX_DeviceTestMode) 0x02)

#define VL53LX_DEVICETESTMODE_PATCH \
        ((VL53LX_DeviceTestMode) 0x03)

#define VL53LX_DEVICETESTMODE_DCR \
        ((VL53LX_DeviceTestMode) 0x04)

#define VL53LX_DEVICETESTMODE_LCR_VCSEL_OFF \
        ((VL53LX_DeviceTestMode) 0x05)

#define VL53LX_DEVICETESTMODE_LCR_VCSEL_ON \
        ((VL53LX_DeviceTestMode) 0x06)

#define VL53LX_DEVICETESTMODE_SPOT_CENTRE_LOCATE \
        ((VL53LX_DeviceTestMode) 0x07)

#define VL53LX_DEVICETESTMODE_REF_SPAD_CHAR_WITH_PRE_VHV \
        ((VL53LX_DeviceTestMode) 0x08)

#define VL53LX_DEVICETESTMODE_REF_SPAD_CHAR_ONLY \
        ((VL53LX_DeviceTestMode) 0x09)







typedef uint8_t VL53LX_DeviceSscArray;

#define VL53LX_DEVICESSCARRAY_RTN ((VL53LX_DeviceSscArray) 0x00)

#define VL53LX_DEVICETESTMODE_REF ((VL53LX_DeviceSscArray) 0x01)







#define VL53LX_RETURN_ARRAY_ONLY                   0x01

#define VL53LX_REFERENCE_ARRAY_ONLY                0x10

#define VL53LX_BOTH_RETURN_AND_REFERENCE_ARRAYS    0x11

#define VL53LX_NEITHER_RETURN_AND_REFERENCE_ARRAYS 0x00






#define VL53LX_DEVICEINTERRUPTLEVEL_ACTIVE_HIGH               0x00

#define VL53LX_DEVICEINTERRUPTLEVEL_ACTIVE_LOW                0x10

#define VL53LX_DEVICEINTERRUPTLEVEL_ACTIVE_MASK               0x10






#define VL53LX_POLLING_DELAY_US                     1000

#define VL53LX_SOFTWARE_RESET_DURATION_US            100

#define VL53LX_FIRMWARE_BOOT_TIME_US                1200

#define VL53LX_ENABLE_POWERFORCE_SETTLING_TIME_US    250

#define VL53LX_SPAD_ARRAY_WIDTH                       16

#define VL53LX_SPAD_ARRAY_HEIGHT                      16

#define VL53LX_NVM_SIZE_IN_BYTES                     512

#define VL53LX_NO_OF_SPAD_ENABLES                    256

#define VL53LX_RTN_SPAD_BUFFER_SIZE                   32

#define VL53LX_REF_SPAD_BUFFER_SIZE                    6

#define VL53LX_AMBIENT_WINDOW_VCSEL_PERIODS          256

#define VL53LX_RANGING_WINDOW_VCSEL_PERIODS         2048

#define VL53LX_MACRO_PERIOD_VCSEL_PERIODS \
        (VL53LX_AMBIENT_WINDOW_VCSEL_PERIODS + \
            VL53LX_RANGING_WINDOW_VCSEL_PERIODS)

#define VL53LX_MAX_ALLOWED_PHASE                    0xFFFF


#define VL53LX_RTN_SPAD_UNITY_TRANSMISSION      0x0100

#define VL53LX_RTN_SPAD_APERTURE_TRANSMISSION   0x0038


#define VL53LX_SPAD_TOTAL_COUNT_MAX                 ((0x01 << 29) - 1)

#define VL53LX_SPAD_TOTAL_COUNT_RES_THRES            (0x01 << 24)

#define VL53LX_COUNT_RATE_INTERNAL_MAX              ((0x01 << 24) - 1)

#define VL53LX_SPEED_OF_LIGHT_IN_AIR                299704

#define VL53LX_SPEED_OF_LIGHT_IN_AIR_DIV_8          (299704 >> 3)








typedef uint8_t VL53LX_ZoneConfig_BinConfig_select;

#define VL53LX_ZONECONFIG_BINCONFIG__LOWAMB \
        ((VL53LX_ZoneConfig_BinConfig_select) 1)
#define VL53LX_ZONECONFIG_BINCONFIG__MIDAMB \
        ((VL53LX_ZoneConfig_BinConfig_select) 2)
#define VL53LX_ZONECONFIG_BINCONFIG__HIGHAMB \
        ((VL53LX_ZoneConfig_BinConfig_select) 3)





typedef uint8_t VL53LX_GPIO_Interrupt_Mode;

#define VL53LX_GPIOINTMODE_LEVEL_LOW \
        ((VL53LX_GPIO_Interrupt_Mode) 0)

#define VL53LX_GPIOINTMODE_LEVEL_HIGH \
        ((VL53LX_GPIO_Interrupt_Mode) 1)

#define VL53LX_GPIOINTMODE_OUT_OF_WINDOW \
        ((VL53LX_GPIO_Interrupt_Mode) 2)

#define VL53LX_GPIOINTMODE_IN_WINDOW \
        ((VL53LX_GPIO_Interrupt_Mode) 3)






typedef uint16_t VL53LX_TuningParms;

#define VL53LX_TUNINGPARMS_LLD_PUBLIC_MIN_ADDRESS \
        ((VL53LX_TuningParms) VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS)
#define VL53LX_TUNINGPARMS_LLD_PUBLIC_MAX_ADDRESS \
        ((VL53LX_TuningParms) VL53LX_TUNINGPARM_DYNXTALK_MAX_SMUDGE_FACTOR)

#define VL53LX_TUNINGPARMS_LLD_PRIVATE_MIN_ADDRESS \
        ((VL53LX_TuningParms) VL53LX_TUNINGPARM_PRIVATE_PAGE_BASE_ADDRESS)
#define VL53LX_TUNINGPARMS_LLD_PRIVATE_MAX_ADDRESS \
        ((VL53LX_TuningParms) VL53LX_TUNINGPARMS_LLD_PRIVATE_MIN_ADDRESS)

#define VL53LX_TUNINGPARM_VERSION \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 0))
#define VL53LX_TUNINGPARM_KEY_TABLE_VERSION \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 1))
#define VL53LX_TUNINGPARM_LLD_VERSION \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 2))
#define VL53LX_TUNINGPARM_HIST_ALGO_SELECT \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 3))
#define VL53LX_TUNINGPARM_HIST_TARGET_ORDER \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 4))
#define VL53LX_TUNINGPARM_HIST_FILTER_WOI_0 \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 5))
#define VL53LX_TUNINGPARM_HIST_FILTER_WOI_1 \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 6))
#define VL53LX_TUNINGPARM_HIST_AMB_EST_METHOD \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 7))
#define VL53LX_TUNINGPARM_HIST_AMB_THRESH_SIGMA_0 \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 8))
#define VL53LX_TUNINGPARM_HIST_AMB_THRESH_SIGMA_1 \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 9))
#define VL53LX_TUNINGPARM_HIST_MIN_AMB_THRESH_EVENTS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 10))
#define VL53LX_TUNINGPARM_HIST_AMB_EVENTS_SCALER \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 11))
#define VL53LX_TUNINGPARM_HIST_NOISE_THRESHOLD \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 12))
#define VL53LX_TUNINGPARM_HIST_SIGNAL_TOTAL_EVENTS_LIMIT \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 13))
#define VL53LX_TUNINGPARM_HIST_SIGMA_EST_REF_MM \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 14))
#define VL53LX_TUNINGPARM_HIST_SIGMA_THRESH_MM \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 15))
#define VL53LX_TUNINGPARM_HIST_GAIN_FACTOR \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 16))
#define VL53LX_TUNINGPARM_CONSISTENCY_HIST_PHASE_TOLERANCE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 17))
#define VL53LX_TUNINGPARM_CONSISTENCY_HIST_MIN_MAX_TOLERANCE_MM \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 18))
#define VL53LX_TUNINGPARM_CONSISTENCY_HIST_EVENT_SIGMA \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 19))
#define VL53LX_TUNINGPARM_CONSISTENCY_HIST_EVENT_SIGMA_MIN_SPAD_LIMIT \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 20))
#define VL53LX_TUNINGPARM_INITIAL_PHASE_RTN_HISTO_LONG_RANGE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 21))
#define VL53LX_TUNINGPARM_INITIAL_PHASE_RTN_HISTO_MED_RANGE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 22))
#define VL53LX_TUNINGPARM_INITIAL_PHASE_RTN_HISTO_SHORT_RANGE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 23))
#define VL53LX_TUNINGPARM_INITIAL_PHASE_REF_HISTO_LONG_RANGE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 24))
#define VL53LX_TUNINGPARM_INITIAL_PHASE_REF_HISTO_MED_RANGE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 25))
#define VL53LX_TUNINGPARM_INITIAL_PHASE_REF_HISTO_SHORT_RANGE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 26))
#define VL53LX_TUNINGPARM_XTALK_DETECT_MIN_VALID_RANGE_MM \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 27))
#define VL53LX_TUNINGPARM_XTALK_DETECT_MAX_VALID_RANGE_MM \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 28))
#define VL53LX_TUNINGPARM_XTALK_DETECT_MAX_SIGMA_MM \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 29))
#define VL53LX_TUNINGPARM_XTALK_DETECT_MIN_MAX_TOLERANCE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 30))
#define VL53LX_TUNINGPARM_XTALK_DETECT_MAX_VALID_RATE_KCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 31))
#define VL53LX_TUNINGPARM_XTALK_DETECT_EVENT_SIGMA \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 32))
#define VL53LX_TUNINGPARM_HIST_XTALK_MARGIN_KCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 33))
#define VL53LX_TUNINGPARM_CONSISTENCY_LITE_PHASE_TOLERANCE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 34))
#define VL53LX_TUNINGPARM_PHASECAL_TARGET \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 35))
#define VL53LX_TUNINGPARM_LITE_CAL_REPEAT_RATE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 36))
#define VL53LX_TUNINGPARM_LITE_RANGING_GAIN_FACTOR \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 37))
#define VL53LX_TUNINGPARM_LITE_MIN_CLIP_MM \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 38))
#define VL53LX_TUNINGPARM_LITE_LONG_SIGMA_THRESH_MM \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 39))
#define VL53LX_TUNINGPARM_LITE_MED_SIGMA_THRESH_MM \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 40))
#define VL53LX_TUNINGPARM_LITE_SHORT_SIGMA_THRESH_MM \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 41))
#define VL53LX_TUNINGPARM_LITE_LONG_MIN_COUNT_RATE_RTN_MCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 42))
#define VL53LX_TUNINGPARM_LITE_MED_MIN_COUNT_RATE_RTN_MCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 43))
#define VL53LX_TUNINGPARM_LITE_SHORT_MIN_COUNT_RATE_RTN_MCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 44))
#define VL53LX_TUNINGPARM_LITE_SIGMA_EST_PULSE_WIDTH \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 45))
#define VL53LX_TUNINGPARM_LITE_SIGMA_EST_AMB_WIDTH_NS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 46))
#define VL53LX_TUNINGPARM_LITE_SIGMA_REF_MM \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 47))
#define VL53LX_TUNINGPARM_LITE_RIT_MULT \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 48))
#define VL53LX_TUNINGPARM_LITE_SEED_CONFIG \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 49))
#define VL53LX_TUNINGPARM_LITE_QUANTIFIER \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 50))
#define VL53LX_TUNINGPARM_LITE_FIRST_ORDER_SELECT \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 51))
#define VL53LX_TUNINGPARM_LITE_XTALK_MARGIN_KCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 52))
#define VL53LX_TUNINGPARM_INITIAL_PHASE_RTN_LITE_LONG_RANGE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 53))
#define VL53LX_TUNINGPARM_INITIAL_PHASE_RTN_LITE_MED_RANGE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 54))
#define VL53LX_TUNINGPARM_INITIAL_PHASE_RTN_LITE_SHORT_RANGE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 55))
#define VL53LX_TUNINGPARM_INITIAL_PHASE_REF_LITE_LONG_RANGE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 56))
#define VL53LX_TUNINGPARM_INITIAL_PHASE_REF_LITE_MED_RANGE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 57))
#define VL53LX_TUNINGPARM_INITIAL_PHASE_REF_LITE_SHORT_RANGE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 58))
#define VL53LX_TUNINGPARM_TIMED_SEED_CONFIG \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 59))
#define VL53LX_TUNINGPARM_DMAX_CFG_SIGNAL_THRESH_SIGMA \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 60))
#define VL53LX_TUNINGPARM_DMAX_CFG_REFLECTANCE_ARRAY_0 \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 61))
#define VL53LX_TUNINGPARM_DMAX_CFG_REFLECTANCE_ARRAY_1 \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 62))
#define VL53LX_TUNINGPARM_DMAX_CFG_REFLECTANCE_ARRAY_2 \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 63))
#define VL53LX_TUNINGPARM_DMAX_CFG_REFLECTANCE_ARRAY_3 \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 64))
#define VL53LX_TUNINGPARM_DMAX_CFG_REFLECTANCE_ARRAY_4 \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 65))
#define VL53LX_TUNINGPARM_VHV_LOOPBOUND \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 66))
#define VL53LX_TUNINGPARM_REFSPADCHAR_DEVICE_TEST_MODE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 67))
#define VL53LX_TUNINGPARM_REFSPADCHAR_VCSEL_PERIOD \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 68))
#define VL53LX_TUNINGPARM_REFSPADCHAR_PHASECAL_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 69))
#define VL53LX_TUNINGPARM_REFSPADCHAR_TARGET_COUNT_RATE_MCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 70))
#define VL53LX_TUNINGPARM_REFSPADCHAR_MIN_COUNTRATE_LIMIT_MCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 71))
#define VL53LX_TUNINGPARM_REFSPADCHAR_MAX_COUNTRATE_LIMIT_MCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 72))
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_NUM_OF_SAMPLES \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 73))
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_MIN_FILTER_THRESH_MM \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 74))
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_MAX_FILTER_THRESH_MM \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 75))
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_DSS_RATE_MCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 76))
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_PHASECAL_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 77))
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_MAX_VALID_RATE_KCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 78))
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_SIGMA_THRESHOLD_MM \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 79))
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_DSS_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 80))
#define VL53LX_TUNINGPARM_XTALK_EXTRACT_BIN_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 81))
#define VL53LX_TUNINGPARM_OFFSET_CAL_DSS_RATE_MCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 82))
#define VL53LX_TUNINGPARM_OFFSET_CAL_PHASECAL_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 83))
#define VL53LX_TUNINGPARM_OFFSET_CAL_MM_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 84))
#define VL53LX_TUNINGPARM_OFFSET_CAL_RANGE_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 85))
#define VL53LX_TUNINGPARM_OFFSET_CAL_PRE_SAMPLES \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 86))
#define VL53LX_TUNINGPARM_OFFSET_CAL_MM1_SAMPLES \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 87))
#define VL53LX_TUNINGPARM_OFFSET_CAL_MM2_SAMPLES \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 88))
#define VL53LX_TUNINGPARM_ZONE_CAL_DSS_RATE_MCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 89))
#define VL53LX_TUNINGPARM_ZONE_CAL_PHASECAL_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 90))
#define VL53LX_TUNINGPARM_ZONE_CAL_DSS_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 91))
#define VL53LX_TUNINGPARM_ZONE_CAL_PHASECAL_NUM_SAMPLES \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 92))
#define VL53LX_TUNINGPARM_ZONE_CAL_RANGE_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 93))
#define VL53LX_TUNINGPARM_ZONE_CAL_ZONE_NUM_SAMPLES \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 94))
#define VL53LX_TUNINGPARM_SPADMAP_VCSEL_PERIOD \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 95))
#define VL53LX_TUNINGPARM_SPADMAP_VCSEL_START \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 96))
#define VL53LX_TUNINGPARM_SPADMAP_RATE_LIMIT_MCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 97))
#define VL53LX_TUNINGPARM_LITE_DSS_CONFIG_TARGET_TOTAL_RATE_MCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 98))
#define VL53LX_TUNINGPARM_RANGING_DSS_CONFIG_TARGET_TOTAL_RATE_MCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 99))
#define VL53LX_TUNINGPARM_MZ_DSS_CONFIG_TARGET_TOTAL_RATE_MCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 100))
#define VL53LX_TUNINGPARM_TIMED_DSS_CONFIG_TARGET_TOTAL_RATE_MCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 101))
#define VL53LX_TUNINGPARM_LITE_PHASECAL_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 102))
#define VL53LX_TUNINGPARM_RANGING_LONG_PHASECAL_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 103))
#define VL53LX_TUNINGPARM_RANGING_MED_PHASECAL_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 104))
#define VL53LX_TUNINGPARM_RANGING_SHORT_PHASECAL_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 105))
#define VL53LX_TUNINGPARM_MZ_LONG_PHASECAL_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 106))
#define VL53LX_TUNINGPARM_MZ_MED_PHASECAL_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 107))
#define VL53LX_TUNINGPARM_MZ_SHORT_PHASECAL_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 108))
#define VL53LX_TUNINGPARM_TIMED_PHASECAL_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 109))
#define VL53LX_TUNINGPARM_LITE_MM_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 110))
#define VL53LX_TUNINGPARM_RANGING_MM_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 111))
#define VL53LX_TUNINGPARM_MZ_MM_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 112))
#define VL53LX_TUNINGPARM_TIMED_MM_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 113))
#define VL53LX_TUNINGPARM_LITE_RANGE_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 114))
#define VL53LX_TUNINGPARM_RANGING_RANGE_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 115))
#define VL53LX_TUNINGPARM_MZ_RANGE_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 116))
#define VL53LX_TUNINGPARM_TIMED_RANGE_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 117))
#define VL53LX_TUNINGPARM_DYNXTALK_SMUDGE_MARGIN \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 118))
#define VL53LX_TUNINGPARM_DYNXTALK_NOISE_MARGIN \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 119))
#define VL53LX_TUNINGPARM_DYNXTALK_XTALK_OFFSET_LIMIT \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 120))
#define VL53LX_TUNINGPARM_DYNXTALK_XTALK_OFFSET_LIMIT_HI \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 121))
#define VL53LX_TUNINGPARM_DYNXTALK_SAMPLE_LIMIT \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 122))
#define VL53LX_TUNINGPARM_DYNXTALK_SINGLE_XTALK_DELTA \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 123))
#define VL53LX_TUNINGPARM_DYNXTALK_AVERAGED_XTALK_DELTA \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 124))
#define VL53LX_TUNINGPARM_DYNXTALK_CLIP_LIMIT \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 125))
#define VL53LX_TUNINGPARM_DYNXTALK_SCALER_CALC_METHOD \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 126))
#define VL53LX_TUNINGPARM_DYNXTALK_XGRADIENT_SCALER \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 127))
#define VL53LX_TUNINGPARM_DYNXTALK_YGRADIENT_SCALER \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 128))
#define VL53LX_TUNINGPARM_DYNXTALK_USER_SCALER_SET \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 129))
#define VL53LX_TUNINGPARM_DYNXTALK_SMUDGE_COR_SINGLE_APPLY \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 130))
#define VL53LX_TUNINGPARM_DYNXTALK_XTALK_AMB_THRESHOLD \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 131))
#define VL53LX_TUNINGPARM_DYNXTALK_NODETECT_AMB_THRESHOLD_KCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 132))
#define VL53LX_TUNINGPARM_DYNXTALK_NODETECT_SAMPLE_LIMIT \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 133))
#define VL53LX_TUNINGPARM_DYNXTALK_NODETECT_XTALK_OFFSET_KCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 134))
#define VL53LX_TUNINGPARM_DYNXTALK_NODETECT_MIN_RANGE_MM \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 135))
#define VL53LX_TUNINGPARM_LOWPOWERAUTO_VHV_LOOP_BOUND \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 136))
#define VL53LX_TUNINGPARM_LOWPOWERAUTO_MM_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 137))
#define VL53LX_TUNINGPARM_LOWPOWERAUTO_RANGE_CONFIG_TIMEOUT_US \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 138))
#define VL53LX_TUNINGPARM_VERY_SHORT_DSS_RATE_MCPS \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 139))
#define VL53LX_TUNINGPARM_PHASECAL_PATCH_POWER \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 140))
#define VL53LX_TUNINGPARM_HIST_MERGE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 141))
#define VL53LX_TUNINGPARM_RESET_MERGE_THRESHOLD \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 142))
#define VL53LX_TUNINGPARM_HIST_MERGE_MAX_SIZE \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 143))
#define VL53LX_TUNINGPARM_DYNXTALK_MAX_SMUDGE_FACTOR \
    ((VL53LX_TuningParms) (VL53LX_TUNINGPARM_PUBLIC_PAGE_BASE_ADDRESS + 144))

// define from vl53lx_platform_log.h

#define   VL53LX_TRACE_LEVEL_NONE     0x00000000
#define   VL53LX_TRACE_LEVEL_ERRORS   0x00000001
#define   VL53LX_TRACE_LEVEL_WARNING    0x00000002
#define   VL53LX_TRACE_LEVEL_INFO     0x00000004
#define   VL53LX_TRACE_LEVEL_DEBUG    0x00000008
#define   VL53LX_TRACE_LEVEL_ALL      0x00000010
#define   VL53LX_TRACE_LEVEL_IGNORE   0x00000020

#define   VL53LX_TRACE_FUNCTION_NONE    0x00000000
#define   VL53LX_TRACE_FUNCTION_I2C   0x00000001
#define   VL53LX_TRACE_FUNCTION_ALL   0x7fffffff

#define   VL53LX_TRACE_MODULE_NONE    0x00000000
#define   VL53LX_TRACE_MODULE_API     0x00000001
#define   VL53LX_TRACE_MODULE_CORE    0x00000002
#define   VL53LX_TRACE_MODULE_PROTECTED   0x00000004
#define   VL53LX_TRACE_MODULE_HISTOGRAM   0x00000008
#define   VL53LX_TRACE_MODULE_REGISTERS   0x00000010
#define   VL53LX_TRACE_MODULE_PLATFORM    0x00000020
#define   VL53LX_TRACE_MODULE_NVM     0x00000040
#define   VL53LX_TRACE_MODULE_CALIBRATION_DATA  0x00000080
#define   VL53LX_TRACE_MODULE_NVM_DATA    0x00000100
#define   VL53LX_TRACE_MODULE_HISTOGRAM_DATA  0x00000200
#define   VL53LX_TRACE_MODULE_RANGE_RESULTS_DATA  0x00000400
#define   VL53LX_TRACE_MODULE_XTALK_DATA    0x00000800
#define   VL53LX_TRACE_MODULE_OFFSET_DATA   0x00001000
#define   VL53LX_TRACE_MODULE_DATA_INIT   0x00002000
#define   VL53LX_TRACE_MODULE_REF_SPAD_CHAR 0x00004000
#define   VL53LX_TRACE_MODULE_SPAD_RATE_MAP 0x00008000



// define & typedef from vl53lx_register_structs.h


#define VL53LX_STATIC_NVM_MANAGED_I2C_INDEX             \
        VL53LX_I2C_SLAVE__DEVICE_ADDRESS
#define VL53LX_CUSTOMER_NVM_MANAGED_I2C_INDEX           \
        VL53LX_GLOBAL_CONFIG__SPAD_ENABLES_REF_0
#define VL53LX_STATIC_CONFIG_I2C_INDEX                  \
        VL53LX_DSS_CONFIG__TARGET_TOTAL_RATE_MCPS
#define VL53LX_GENERAL_CONFIG_I2C_INDEX                  \
        VL53LX_GPH_CONFIG__STREAM_COUNT_UPDATE_VALUE
#define VL53LX_TIMING_CONFIG_I2C_INDEX                  \
        VL53LX_MM_CONFIG__TIMEOUT_MACROP_A_HI
#define VL53LX_DYNAMIC_CONFIG_I2C_INDEX                 \
        VL53LX_SYSTEM__GROUPED_PARAMETER_HOLD_0
#define VL53LX_SYSTEM_CONTROL_I2C_INDEX                 \
        VL53LX_POWER_MANAGEMENT__GO1_POWER_FORCE
#define VL53LX_SYSTEM_RESULTS_I2C_INDEX                 \
        VL53LX_RESULT__INTERRUPT_STATUS
#define VL53LX_CORE_RESULTS_I2C_INDEX                   \
        VL53LX_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0
#define VL53LX_DEBUG_RESULTS_I2C_INDEX                  \
        VL53LX_PHASECAL_RESULT__REFERENCE_PHASE
#define VL53LX_NVM_COPY_DATA_I2C_INDEX                 \
        VL53LX_IDENTIFICATION__MODEL_ID
#define VL53LX_PREV_SHADOW_SYSTEM_RESULTS_I2C_INDEX    \
        VL53LX_PREV_SHADOW_RESULT__INTERRUPT_STATUS
#define VL53LX_PREV_SHADOW_CORE_RESULTS_I2C_INDEX      \
        VL53LX_PREV_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0
#define VL53LX_PATCH_DEBUG_I2C_INDEX                   \
        VL53LX_RESULT__DEBUG_STATUS
#define VL53LX_GPH_GENERAL_CONFIG_I2C_INDEX            \
        VL53LX_GPH__SYSTEM__THRESH_RATE_HIGH
#define VL53LX_GPH_STATIC_CONFIG_I2C_INDEX             \
        VL53LX_GPH__DSS_CONFIG__ROI_MODE_CONTROL
#define VL53LX_GPH_TIMING_CONFIG_I2C_INDEX             \
        VL53LX_GPH__MM_CONFIG__TIMEOUT_MACROP_A_HI
#define VL53LX_FW_INTERNAL_I2C_INDEX                   \
        VL53LX_FIRMWARE__INTERNAL_STREAM_COUNT_DIV
#define VL53LX_PATCH_RESULTS_I2C_INDEX                 \
        VL53LX_DSS_CALC__ROI_CTRL
#define VL53LX_SHADOW_SYSTEM_RESULTS_I2C_INDEX         \
        VL53LX_SHADOW_PHASECAL_RESULT__VCSEL_START
#define VL53LX_SHADOW_CORE_RESULTS_I2C_INDEX           \
        VL53LX_SHADOW_RESULT_CORE__AMBIENT_WINDOW_EVENTS_SD0

#define VL53LX_STATIC_NVM_MANAGED_I2C_SIZE_BYTES           11
#define VL53LX_CUSTOMER_NVM_MANAGED_I2C_SIZE_BYTES         23
#define VL53LX_STATIC_CONFIG_I2C_SIZE_BYTES                32
#define VL53LX_GENERAL_CONFIG_I2C_SIZE_BYTES               22
#define VL53LX_TIMING_CONFIG_I2C_SIZE_BYTES                23
#define VL53LX_DYNAMIC_CONFIG_I2C_SIZE_BYTES               18
#define VL53LX_SYSTEM_CONTROL_I2C_SIZE_BYTES                5
#define VL53LX_SYSTEM_RESULTS_I2C_SIZE_BYTES               44
#define VL53LX_CORE_RESULTS_I2C_SIZE_BYTES                 33
#define VL53LX_DEBUG_RESULTS_I2C_SIZE_BYTES                56
#define VL53LX_NVM_COPY_DATA_I2C_SIZE_BYTES                49
#define VL53LX_PREV_SHADOW_SYSTEM_RESULTS_I2C_SIZE_BYTES   44
#define VL53LX_PREV_SHADOW_CORE_RESULTS_I2C_SIZE_BYTES     33
#define VL53LX_PATCH_DEBUG_I2C_SIZE_BYTES                   2
#define VL53LX_GPH_GENERAL_CONFIG_I2C_SIZE_BYTES            5
#define VL53LX_GPH_STATIC_CONFIG_I2C_SIZE_BYTES             6
#define VL53LX_GPH_TIMING_CONFIG_I2C_SIZE_BYTES            16
#define VL53LX_FW_INTERNAL_I2C_SIZE_BYTES                   2
#define VL53LX_PATCH_RESULTS_I2C_SIZE_BYTES                90
#define VL53LX_SHADOW_SYSTEM_RESULTS_I2C_SIZE_BYTES        82
#define VL53LX_SHADOW_CORE_RESULTS_I2C_SIZE_BYTES          33




typedef struct {
  uint8_t   i2c_slave__device_address;

  uint8_t   ana_config__vhv_ref_sel_vddpix;

  uint8_t   ana_config__vhv_ref_sel_vquench;

  uint8_t   ana_config__reg_avdd1v2_sel;

  uint8_t   ana_config__fast_osc__trim;

  uint16_t  osc_measured__fast_osc__frequency;

  uint8_t   vhv_config__timeout_macrop_loop_bound;

  uint8_t   vhv_config__count_thresh;

  uint8_t   vhv_config__offset;

  uint8_t   vhv_config__init;

} VL53LX_static_nvm_managed_t;




typedef struct {
  uint8_t   global_config__spad_enables_ref_0;

  uint8_t   global_config__spad_enables_ref_1;

  uint8_t   global_config__spad_enables_ref_2;

  uint8_t   global_config__spad_enables_ref_3;

  uint8_t   global_config__spad_enables_ref_4;

  uint8_t   global_config__spad_enables_ref_5;

  uint8_t   global_config__ref_en_start_select;

  uint8_t   ref_spad_man__num_requested_ref_spads;

  uint8_t   ref_spad_man__ref_location;

  uint16_t  algo__crosstalk_compensation_plane_offset_kcps;

  int16_t   algo__crosstalk_compensation_x_plane_gradient_kcps;

  int16_t   algo__crosstalk_compensation_y_plane_gradient_kcps;

  uint16_t  ref_spad_char__total_rate_target_mcps;

  int16_t   algo__part_to_part_range_offset_mm;

  int16_t   mm_config__inner_offset_mm;

  int16_t   mm_config__outer_offset_mm;

} VL53LX_customer_nvm_managed_t;




typedef struct {
  uint16_t  dss_config__target_total_rate_mcps;

  uint8_t   debug__ctrl;

  uint8_t   test_mode__ctrl;

  uint8_t   clk_gating__ctrl;

  uint8_t   nvm_bist__ctrl;

  uint8_t   nvm_bist__num_nvm_words;

  uint8_t   nvm_bist__start_address;

  uint8_t   host_if__status;

  uint8_t   pad_i2c_hv__config;

  uint8_t   pad_i2c_hv__extsup_config;

  uint8_t   gpio_hv_pad__ctrl;

  uint8_t   gpio_hv_mux__ctrl;

  uint8_t   gpio__tio_hv_status;

  uint8_t   gpio__fio_hv_status;

  uint8_t   ana_config__spad_sel_pswidth;

  uint8_t   ana_config__vcsel_pulse_width_offset;

  uint8_t   ana_config__fast_osc__config_ctrl;

  uint8_t   sigma_estimator__effective_pulse_width_ns;

  uint8_t   sigma_estimator__effective_ambient_width_ns;

  uint8_t   sigma_estimator__sigma_ref_mm;

  uint8_t   algo__crosstalk_compensation_valid_height_mm;

  uint8_t   spare_host_config__static_config_spare_0;

  uint8_t   spare_host_config__static_config_spare_1;

  uint16_t  algo__range_ignore_threshold_mcps;

  uint8_t   algo__range_ignore_valid_height_mm;

  uint8_t   algo__range_min_clip;

  uint8_t   algo__consistency_check__tolerance;

  uint8_t   spare_host_config__static_config_spare_2;

  uint8_t   sd_config__reset_stages_msb;

  uint8_t   sd_config__reset_stages_lsb;

} VL53LX_static_config_t;




typedef struct {
  uint8_t   gph_config__stream_count_update_value;

  uint8_t   global_config__stream_divider;

  uint8_t   system__interrupt_config_gpio;

  uint8_t   cal_config__vcsel_start;

  uint16_t  cal_config__repeat_rate;

  uint8_t   global_config__vcsel_width;

  uint8_t   phasecal_config__timeout_macrop;

  uint8_t   phasecal_config__target;

  uint8_t   phasecal_config__override;

  uint8_t   dss_config__roi_mode_control;

  uint16_t  system__thresh_rate_high;

  uint16_t  system__thresh_rate_low;

  uint16_t  dss_config__manual_effective_spads_select;

  uint8_t   dss_config__manual_block_select;

  uint8_t   dss_config__aperture_attenuation;

  uint8_t   dss_config__max_spads_limit;

  uint8_t   dss_config__min_spads_limit;

} VL53LX_general_config_t;




typedef struct {
  uint8_t   mm_config__timeout_macrop_a_hi;

  uint8_t   mm_config__timeout_macrop_a_lo;

  uint8_t   mm_config__timeout_macrop_b_hi;

  uint8_t   mm_config__timeout_macrop_b_lo;

  uint8_t   range_config__timeout_macrop_a_hi;

  uint8_t   range_config__timeout_macrop_a_lo;

  uint8_t   range_config__vcsel_period_a;

  uint8_t   range_config__timeout_macrop_b_hi;

  uint8_t   range_config__timeout_macrop_b_lo;

  uint8_t   range_config__vcsel_period_b;

  uint16_t  range_config__sigma_thresh;

  uint16_t  range_config__min_count_rate_rtn_limit_mcps;

  uint8_t   range_config__valid_phase_low;

  uint8_t   range_config__valid_phase_high;

  uint32_t  system__intermeasurement_period;

  uint8_t   system__fractional_enable;

} VL53LX_timing_config_t;




typedef struct {
  uint8_t   system__grouped_parameter_hold_0;

  uint16_t  system__thresh_high;

  uint16_t  system__thresh_low;

  uint8_t   system__enable_xtalk_per_quadrant;

  uint8_t   system__seed_config;

  uint8_t   sd_config__woi_sd0;

  uint8_t   sd_config__woi_sd1;

  uint8_t   sd_config__initial_phase_sd0;

  uint8_t   sd_config__initial_phase_sd1;

  uint8_t   system__grouped_parameter_hold_1;

  uint8_t   sd_config__first_order_select;

  uint8_t   sd_config__quantifier;

  uint8_t   roi_config__user_roi_centre_spad;

  uint8_t   roi_config__user_roi_requested_global_xy_size;

  uint8_t   system__sequence_config;

  uint8_t   system__grouped_parameter_hold;

} VL53LX_dynamic_config_t;




typedef struct {
  uint8_t   power_management__go1_power_force;

  uint8_t   system__stream_count_ctrl;

  uint8_t   firmware__enable;

  uint8_t   system__interrupt_clear;

  uint8_t   system__mode_start;

} VL53LX_system_control_t;




typedef struct {
  uint8_t   result__interrupt_status;

  uint8_t   result__range_status;

  uint8_t   result__report_status;

  uint8_t   result__stream_count;

  uint16_t  result__dss_actual_effective_spads_sd0;

  uint16_t  result__peak_signal_count_rate_mcps_sd0;

  uint16_t  result__ambient_count_rate_mcps_sd0;

  uint16_t  result__sigma_sd0;

  uint16_t  result__phase_sd0;

  uint16_t  result__final_crosstalk_corrected_range_mm_sd0;

  uint16_t  result__peak_signal_count_rate_crosstalk_corrected_mcps_sd0;

  uint16_t  result__mm_inner_actual_effective_spads_sd0;

  uint16_t  result__mm_outer_actual_effective_spads_sd0;

  uint16_t  result__avg_signal_count_rate_mcps_sd0;

  uint16_t  result__dss_actual_effective_spads_sd1;

  uint16_t  result__peak_signal_count_rate_mcps_sd1;

  uint16_t  result__ambient_count_rate_mcps_sd1;

  uint16_t  result__sigma_sd1;

  uint16_t  result__phase_sd1;

  uint16_t  result__final_crosstalk_corrected_range_mm_sd1;

  uint16_t  result__spare_0_sd1;

  uint16_t  result__spare_1_sd1;

  uint16_t  result__spare_2_sd1;

  uint8_t   result__spare_3_sd1;

  uint8_t   result__thresh_info;

} VL53LX_system_results_t;




typedef struct {
  uint32_t  result_core__ambient_window_events_sd0;

  uint32_t  result_core__ranging_total_events_sd0;

  int32_t   result_core__signal_total_events_sd0;

  uint32_t  result_core__total_periods_elapsed_sd0;

  uint32_t  result_core__ambient_window_events_sd1;

  uint32_t  result_core__ranging_total_events_sd1;

  int32_t   result_core__signal_total_events_sd1;

  uint32_t  result_core__total_periods_elapsed_sd1;

  uint8_t   result_core__spare_0;

} VL53LX_core_results_t;




typedef struct {
  uint16_t  phasecal_result__reference_phase;

  uint8_t   phasecal_result__vcsel_start;

  uint8_t   ref_spad_char_result__num_actual_ref_spads;

  uint8_t   ref_spad_char_result__ref_location;

  uint8_t   vhv_result__coldboot_status;

  uint8_t   vhv_result__search_result;

  uint8_t   vhv_result__latest_setting;

  uint16_t  result__osc_calibrate_val;

  uint8_t   ana_config__powerdown_go1;

  uint8_t   ana_config__ref_bg_ctrl;

  uint8_t   ana_config__regdvdd1v2_ctrl;

  uint8_t   ana_config__osc_slow_ctrl;

  uint8_t   test_mode__status;

  uint8_t   firmware__system_status;

  uint8_t   firmware__mode_status;

  uint8_t   firmware__secondary_mode_status;

  uint16_t  firmware__cal_repeat_rate_counter;

  uint16_t  gph__system__thresh_high;

  uint16_t  gph__system__thresh_low;

  uint8_t   gph__system__enable_xtalk_per_quadrant;

  uint8_t   gph__spare_0;

  uint8_t   gph__sd_config__woi_sd0;

  uint8_t   gph__sd_config__woi_sd1;

  uint8_t   gph__sd_config__initial_phase_sd0;

  uint8_t   gph__sd_config__initial_phase_sd1;

  uint8_t   gph__sd_config__first_order_select;

  uint8_t   gph__sd_config__quantifier;

  uint8_t   gph__roi_config__user_roi_centre_spad;

  uint8_t   gph__roi_config__user_roi_requested_global_xy_size;

  uint8_t   gph__system__sequence_config;

  uint8_t   gph__gph_id;

  uint8_t   system__interrupt_set;

  uint8_t   interrupt_manager__enables;

  uint8_t   interrupt_manager__clear;

  uint8_t   interrupt_manager__status;

  uint8_t   mcu_to_host_bank__wr_access_en;

  uint8_t   power_management__go1_reset_status;

  uint8_t   pad_startup_mode__value_ro;

  uint8_t   pad_startup_mode__value_ctrl;

  uint32_t  pll_period_us;

  uint32_t  interrupt_scheduler__data_out;

  uint8_t   nvm_bist__complete;

  uint8_t   nvm_bist__status;

} VL53LX_debug_results_t;




typedef struct {
  uint8_t   identification__model_id;

  uint8_t   identification__module_type;

  uint8_t   identification__revision_id;

  uint16_t  identification__module_id;

  uint8_t   ana_config__fast_osc__trim_max;

  uint8_t   ana_config__fast_osc__freq_set;

  uint8_t   ana_config__vcsel_trim;

  uint8_t   ana_config__vcsel_selion;

  uint8_t   ana_config__vcsel_selion_max;

  uint8_t   protected_laser_safety__lock_bit;

  uint8_t   laser_safety__key;

  uint8_t   laser_safety__key_ro;

  uint8_t   laser_safety__clip;

  uint8_t   laser_safety__mult;

  uint8_t   global_config__spad_enables_rtn_0;

  uint8_t   global_config__spad_enables_rtn_1;

  uint8_t   global_config__spad_enables_rtn_2;

  uint8_t   global_config__spad_enables_rtn_3;

  uint8_t   global_config__spad_enables_rtn_4;

  uint8_t   global_config__spad_enables_rtn_5;

  uint8_t   global_config__spad_enables_rtn_6;

  uint8_t   global_config__spad_enables_rtn_7;

  uint8_t   global_config__spad_enables_rtn_8;

  uint8_t   global_config__spad_enables_rtn_9;

  uint8_t   global_config__spad_enables_rtn_10;

  uint8_t   global_config__spad_enables_rtn_11;

  uint8_t   global_config__spad_enables_rtn_12;

  uint8_t   global_config__spad_enables_rtn_13;

  uint8_t   global_config__spad_enables_rtn_14;

  uint8_t   global_config__spad_enables_rtn_15;

  uint8_t   global_config__spad_enables_rtn_16;

  uint8_t   global_config__spad_enables_rtn_17;

  uint8_t   global_config__spad_enables_rtn_18;

  uint8_t   global_config__spad_enables_rtn_19;

  uint8_t   global_config__spad_enables_rtn_20;

  uint8_t   global_config__spad_enables_rtn_21;

  uint8_t   global_config__spad_enables_rtn_22;

  uint8_t   global_config__spad_enables_rtn_23;

  uint8_t   global_config__spad_enables_rtn_24;

  uint8_t   global_config__spad_enables_rtn_25;

  uint8_t   global_config__spad_enables_rtn_26;

  uint8_t   global_config__spad_enables_rtn_27;

  uint8_t   global_config__spad_enables_rtn_28;

  uint8_t   global_config__spad_enables_rtn_29;

  uint8_t   global_config__spad_enables_rtn_30;

  uint8_t   global_config__spad_enables_rtn_31;

  uint8_t   roi_config__mode_roi_centre_spad;

  uint8_t   roi_config__mode_roi_xy_size;

} VL53LX_nvm_copy_data_t;




typedef struct {
  uint8_t   prev_shadow_result__interrupt_status;

  uint8_t   prev_shadow_result__range_status;

  uint8_t   prev_shadow_result__report_status;

  uint8_t   prev_shadow_result__stream_count;

  uint16_t  prev_shadow_result__dss_actual_effective_spads_sd0;

  uint16_t  prev_shadow_result__peak_signal_count_rate_mcps_sd0;

  uint16_t  prev_shadow_result__ambient_count_rate_mcps_sd0;

  uint16_t  prev_shadow_result__sigma_sd0;

  uint16_t  prev_shadow_result__phase_sd0;

  uint16_t  prev_shadow_result__final_crosstalk_corrected_range_mm_sd0;

  uint16_t
  psr__peak_signal_count_rate_crosstalk_corrected_mcps_sd0;

  uint16_t  prev_shadow_result__mm_inner_actual_effective_spads_sd0;

  uint16_t  prev_shadow_result__mm_outer_actual_effective_spads_sd0;

  uint16_t  prev_shadow_result__avg_signal_count_rate_mcps_sd0;

  uint16_t  prev_shadow_result__dss_actual_effective_spads_sd1;

  uint16_t  prev_shadow_result__peak_signal_count_rate_mcps_sd1;

  uint16_t  prev_shadow_result__ambient_count_rate_mcps_sd1;

  uint16_t  prev_shadow_result__sigma_sd1;

  uint16_t  prev_shadow_result__phase_sd1;

  uint16_t  prev_shadow_result__final_crosstalk_corrected_range_mm_sd1;

  uint16_t  prev_shadow_result__spare_0_sd1;

  uint16_t  prev_shadow_result__spare_1_sd1;

  uint16_t  prev_shadow_result__spare_2_sd1;

  uint16_t  prev_shadow_result__spare_3_sd1;

} VL53LX_prev_shadow_system_results_t;




typedef struct {
  uint32_t  prev_shadow_result_core__ambient_window_events_sd0;

  uint32_t  prev_shadow_result_core__ranging_total_events_sd0;

  int32_t   prev_shadow_result_core__signal_total_events_sd0;

  uint32_t  prev_shadow_result_core__total_periods_elapsed_sd0;

  uint32_t  prev_shadow_result_core__ambient_window_events_sd1;

  uint32_t  prev_shadow_result_core__ranging_total_events_sd1;

  int32_t   prev_shadow_result_core__signal_total_events_sd1;

  uint32_t  prev_shadow_result_core__total_periods_elapsed_sd1;

  uint8_t   prev_shadow_result_core__spare_0;

} VL53LX_prev_shadow_core_results_t;




typedef struct {
  uint8_t   result__debug_status;

  uint8_t   result__debug_stage;

} VL53LX_patch_debug_t;




typedef struct {
  uint16_t  gph__system__thresh_rate_high;

  uint16_t  gph__system__thresh_rate_low;

  uint8_t   gph__system__interrupt_config_gpio;

} VL53LX_gph_general_config_t;




typedef struct {
  uint8_t   gph__dss_config__roi_mode_control;

  uint16_t  gph__dss_config__manual_effective_spads_select;

  uint8_t   gph__dss_config__manual_block_select;

  uint8_t   gph__dss_config__max_spads_limit;

  uint8_t   gph__dss_config__min_spads_limit;

} VL53LX_gph_static_config_t;




typedef struct {
  uint8_t   gph__mm_config__timeout_macrop_a_hi;

  uint8_t   gph__mm_config__timeout_macrop_a_lo;

  uint8_t   gph__mm_config__timeout_macrop_b_hi;

  uint8_t   gph__mm_config__timeout_macrop_b_lo;

  uint8_t   gph__range_config__timeout_macrop_a_hi;

  uint8_t   gph__range_config__timeout_macrop_a_lo;

  uint8_t   gph__range_config__vcsel_period_a;

  uint8_t   gph__range_config__vcsel_period_b;

  uint8_t   gph__range_config__timeout_macrop_b_hi;

  uint8_t   gph__range_config__timeout_macrop_b_lo;

  uint16_t  gph__range_config__sigma_thresh;

  uint16_t  gph__range_config__min_count_rate_rtn_limit_mcps;

  uint8_t   gph__range_config__valid_phase_low;

  uint8_t   gph__range_config__valid_phase_high;

} VL53LX_gph_timing_config_t;




typedef struct {
  uint8_t   firmware__internal_stream_count_div;

  uint8_t   firmware__internal_stream_counter_val;

} VL53LX_fw_internal_t;




typedef struct {
  uint8_t   dss_calc__roi_ctrl;

  uint8_t   dss_calc__spare_1;

  uint8_t   dss_calc__spare_2;

  uint8_t   dss_calc__spare_3;

  uint8_t   dss_calc__spare_4;

  uint8_t   dss_calc__spare_5;

  uint8_t   dss_calc__spare_6;

  uint8_t   dss_calc__spare_7;

  uint8_t   dss_calc__user_roi_spad_en_0;

  uint8_t   dss_calc__user_roi_spad_en_1;

  uint8_t   dss_calc__user_roi_spad_en_2;

  uint8_t   dss_calc__user_roi_spad_en_3;

  uint8_t   dss_calc__user_roi_spad_en_4;

  uint8_t   dss_calc__user_roi_spad_en_5;

  uint8_t   dss_calc__user_roi_spad_en_6;

  uint8_t   dss_calc__user_roi_spad_en_7;

  uint8_t   dss_calc__user_roi_spad_en_8;

  uint8_t   dss_calc__user_roi_spad_en_9;

  uint8_t   dss_calc__user_roi_spad_en_10;

  uint8_t   dss_calc__user_roi_spad_en_11;

  uint8_t   dss_calc__user_roi_spad_en_12;

  uint8_t   dss_calc__user_roi_spad_en_13;

  uint8_t   dss_calc__user_roi_spad_en_14;

  uint8_t   dss_calc__user_roi_spad_en_15;

  uint8_t   dss_calc__user_roi_spad_en_16;

  uint8_t   dss_calc__user_roi_spad_en_17;

  uint8_t   dss_calc__user_roi_spad_en_18;

  uint8_t   dss_calc__user_roi_spad_en_19;

  uint8_t   dss_calc__user_roi_spad_en_20;

  uint8_t   dss_calc__user_roi_spad_en_21;

  uint8_t   dss_calc__user_roi_spad_en_22;

  uint8_t   dss_calc__user_roi_spad_en_23;

  uint8_t   dss_calc__user_roi_spad_en_24;

  uint8_t   dss_calc__user_roi_spad_en_25;

  uint8_t   dss_calc__user_roi_spad_en_26;

  uint8_t   dss_calc__user_roi_spad_en_27;

  uint8_t   dss_calc__user_roi_spad_en_28;

  uint8_t   dss_calc__user_roi_spad_en_29;

  uint8_t   dss_calc__user_roi_spad_en_30;

  uint8_t   dss_calc__user_roi_spad_en_31;

  uint8_t   dss_calc__user_roi_0;

  uint8_t   dss_calc__user_roi_1;

  uint8_t   dss_calc__mode_roi_0;

  uint8_t   dss_calc__mode_roi_1;

  uint8_t   sigma_estimator_calc__spare_0;

  uint16_t  vhv_result__peak_signal_rate_mcps;

  uint32_t  vhv_result__signal_total_events_ref;

  uint16_t  phasecal_result__phase_output_ref;

  uint16_t  dss_result__total_rate_per_spad;

  uint8_t   dss_result__enabled_blocks;

  uint16_t  dss_result__num_requested_spads;

  uint16_t  mm_result__inner_intersection_rate;

  uint16_t  mm_result__outer_complement_rate;

  uint16_t  mm_result__total_offset;

  uint32_t  xtalk_calc__xtalk_for_enabled_spads;

  uint32_t  xtalk_result__avg_xtalk_user_roi_kcps;

  uint32_t  xtalk_result__avg_xtalk_mm_inner_roi_kcps;

  uint32_t  xtalk_result__avg_xtalk_mm_outer_roi_kcps;

  uint32_t  range_result__accum_phase;

  uint16_t  range_result__offset_corrected_range;

} VL53LX_patch_results_t;




typedef struct {
  uint8_t   shadow_phasecal_result__vcsel_start;

  uint8_t   shadow_result__interrupt_status;

  uint8_t   shadow_result__range_status;

  uint8_t   shadow_result__report_status;

  uint8_t   shadow_result__stream_count;

  uint16_t  shadow_result__dss_actual_effective_spads_sd0;

  uint16_t  shadow_result__peak_signal_count_rate_mcps_sd0;

  uint16_t  shadow_result__ambient_count_rate_mcps_sd0;

  uint16_t  shadow_result__sigma_sd0;

  uint16_t  shadow_result__phase_sd0;

  uint16_t  shadow_result__final_crosstalk_corrected_range_mm_sd0;

  uint16_t
  shr__peak_signal_count_rate_crosstalk_corrected_mcps_sd0;

  uint16_t  shadow_result__mm_inner_actual_effective_spads_sd0;

  uint16_t  shadow_result__mm_outer_actual_effective_spads_sd0;

  uint16_t  shadow_result__avg_signal_count_rate_mcps_sd0;

  uint16_t  shadow_result__dss_actual_effective_spads_sd1;

  uint16_t  shadow_result__peak_signal_count_rate_mcps_sd1;

  uint16_t  shadow_result__ambient_count_rate_mcps_sd1;

  uint16_t  shadow_result__sigma_sd1;

  uint16_t  shadow_result__phase_sd1;

  uint16_t  shadow_result__final_crosstalk_corrected_range_mm_sd1;

  uint16_t  shadow_result__spare_0_sd1;

  uint16_t  shadow_result__spare_1_sd1;

  uint16_t  shadow_result__spare_2_sd1;

  uint8_t   shadow_result__spare_3_sd1;

  uint8_t   shadow_result__thresh_info;

  uint8_t   shadow_phasecal_result__reference_phase_hi;

  uint8_t   shadow_phasecal_result__reference_phase_lo;

} VL53LX_shadow_system_results_t;




typedef struct {
  uint32_t  shadow_result_core__ambient_window_events_sd0;

  uint32_t  shadow_result_core__ranging_total_events_sd0;

  int32_t   shadow_result_core__signal_total_events_sd0;

  uint32_t  shadow_result_core__total_periods_elapsed_sd0;

  uint32_t  shadow_result_core__ambient_window_events_sd1;

  uint32_t  shadow_result_core__ranging_total_events_sd1;

  int32_t   shadow_result_core__signal_total_events_sd1;

  uint32_t  shadow_result_core__total_periods_elapsed_sd1;

  uint8_t   shadow_result_core__spare_0;

} VL53LX_shadow_core_results_t;


// typedef from vl53lx_dmax_structs.h

#define VL53LX_MAX_AMBIENT_DMAX_VALUES        5

typedef struct {
  uint16_t  ref__actual_effective_spads;
  uint16_t  ref__peak_signal_count_rate_mcps;
  uint16_t  ref__distance_mm;
  uint16_t   ref_reflectance_pc;
  uint16_t   coverglass_transmission;

} VL53LX_dmax_calibration_data_t;




typedef struct {
  uint8_t   signal_thresh_sigma;
  uint8_t   ambient_thresh_sigma;
  int32_t   min_ambient_thresh_events;
  int32_t   signal_total_events_limit;
  uint16_t  target_reflectance_for_dmax_calc[VL53LX_MAX_AMBIENT_DMAX_VALUES];
  uint16_t  max_effective_spads;
  uint16_t  dss_config__target_total_rate_mcps;
  uint8_t   dss_config__aperture_attenuation;
} VL53LX_hist_gen3_dmax_config_t;



// define & typedef from vl53lx_hist_structs.h

#define  VL53LX_MAX_BIN_SEQUENCE_LENGTH  6
#define  VL53LX_MAX_BIN_SEQUENCE_CODE   15
#define  VL53LX_HISTOGRAM_BUFFER_SIZE   24
#define  VL53LX_XTALK_HISTO_BINS        12



typedef struct {

  uint8_t                          histogram_config__spad_array_selection;

  uint8_t                          histogram_config__low_amb_even_bin_0_1;
  uint8_t                          histogram_config__low_amb_even_bin_2_3;
  uint8_t                          histogram_config__low_amb_even_bin_4_5;

  uint8_t                          histogram_config__low_amb_odd_bin_0_1;
  uint8_t                          histogram_config__low_amb_odd_bin_2_3;
  uint8_t                          histogram_config__low_amb_odd_bin_4_5;

  uint8_t                          histogram_config__mid_amb_even_bin_0_1;
  uint8_t                          histogram_config__mid_amb_even_bin_2_3;
  uint8_t                          histogram_config__mid_amb_even_bin_4_5;

  uint8_t                          histogram_config__mid_amb_odd_bin_0_1;
  uint8_t                          histogram_config__mid_amb_odd_bin_2;
  uint8_t                          histogram_config__mid_amb_odd_bin_3_4;
  uint8_t                          histogram_config__mid_amb_odd_bin_5;

  uint8_t                          histogram_config__user_bin_offset;

  uint8_t                     histogram_config__high_amb_even_bin_0_1;
  uint8_t                     histogram_config__high_amb_even_bin_2_3;
  uint8_t                     histogram_config__high_amb_even_bin_4_5;

  uint8_t                  histogram_config__high_amb_odd_bin_0_1;
  uint8_t                  histogram_config__high_amb_odd_bin_2_3;
  uint8_t                  histogram_config__high_amb_odd_bin_4_5;

  uint16_t                         histogram_config__amb_thresh_low;

  uint16_t                         histogram_config__amb_thresh_high;


} VL53LX_histogram_config_t;




typedef struct {

  VL53LX_HistAlgoSelect  hist_algo_select;


  VL53LX_HistTargetOrder hist_target_order;


  uint8_t   filter_woi0;

  uint8_t   filter_woi1;


  VL53LX_HistAmbEstMethod hist_amb_est_method;

  uint8_t   ambient_thresh_sigma0;

  uint8_t   ambient_thresh_sigma1;



  uint16_t  ambient_thresh_events_scaler;



  int32_t   min_ambient_thresh_events;

  uint16_t  noise_threshold;


  int32_t   signal_total_events_limit;

  uint8_t   sigma_estimator__sigma_ref_mm;

  uint16_t  sigma_thresh;

  int16_t   range_offset_mm;

  uint16_t  gain_factor;


  uint8_t   valid_phase_low;

  uint8_t   valid_phase_high;

  uint8_t   algo__consistency_check__phase_tolerance;

  uint8_t   algo__consistency_check__event_sigma;



  uint16_t  algo__consistency_check__event_min_spad_count;



  uint16_t  algo__consistency_check__min_max_tolerance;


  uint8_t   algo__crosstalk_compensation_enable;

  uint32_t  algo__crosstalk_compensation_plane_offset_kcps;

  int16_t   algo__crosstalk_compensation_x_plane_gradient_kcps;

  int16_t   algo__crosstalk_compensation_y_plane_gradient_kcps;


  int16_t   algo__crosstalk_detect_min_valid_range_mm;

  int16_t   algo__crosstalk_detect_max_valid_range_mm;

  uint16_t  algo__crosstalk_detect_max_valid_rate_kcps;

  uint16_t  algo__crosstalk_detect_max_sigma_mm;



  uint8_t   algo__crosstalk_detect_event_sigma;



  uint16_t  algo__crosstalk_detect_min_max_tolerance;


} VL53LX_hist_post_process_config_t;



typedef struct {


  VL53LX_DeviceState     cfg_device_state;

  VL53LX_DeviceState     rd_device_state;


  uint8_t  zone_id;

  uint32_t time_stamp;


  uint8_t  VL53LX_p_019;

  uint8_t  VL53LX_p_020;

  uint8_t  VL53LX_p_021;

  uint8_t  number_of_ambient_bins;

  uint8_t  bin_seq[VL53LX_MAX_BIN_SEQUENCE_LENGTH];

  uint8_t  bin_rep[VL53LX_MAX_BIN_SEQUENCE_LENGTH];

  int32_t  bin_data[VL53LX_HISTOGRAM_BUFFER_SIZE];


  uint8_t  result__interrupt_status;

  uint8_t  result__range_status;

  uint8_t  result__report_status;

  uint8_t  result__stream_count;

  uint16_t result__dss_actual_effective_spads;


  uint16_t phasecal_result__reference_phase;

  uint8_t  phasecal_result__vcsel_start;

  uint8_t  cal_config__vcsel_start;

  uint16_t vcsel_width;

  uint8_t  VL53LX_p_005;

  uint16_t VL53LX_p_015;

  uint32_t  total_periods_elapsed;


  uint32_t peak_duration_us;

  uint32_t woi_duration_us;


  int32_t  min_bin_value;

  int32_t  max_bin_value;


  uint16_t zero_distance_phase;

  uint8_t  number_of_ambient_samples;

  int32_t  ambient_events_sum;

  int32_t  VL53LX_p_028;


  uint8_t  roi_config__user_roi_centre_spad;

  uint8_t  roi_config__user_roi_requested_global_xy_size;


} VL53LX_histogram_bin_data_t;




typedef struct {


  uint8_t  zone_id;

  uint32_t time_stamp;


  uint8_t  VL53LX_p_019;

  uint8_t  VL53LX_p_020;

  uint8_t  VL53LX_p_021;

  uint32_t bin_data[VL53LX_XTALK_HISTO_BINS];



  uint16_t phasecal_result__reference_phase;

  uint8_t  phasecal_result__vcsel_start;

  uint8_t  cal_config__vcsel_start;

  uint16_t vcsel_width;

  uint16_t VL53LX_p_015;

  uint16_t zero_distance_phase;


} VL53LX_xtalk_histogram_shape_t;




typedef struct {


  VL53LX_xtalk_histogram_shape_t  xtalk_shape;

  VL53LX_histogram_bin_data_t     xtalk_hist_removed;

} VL53LX_xtalk_histogram_data_t;


/* vl53lx_hist_private_structs.h */

#define VL53LX_D_001         8





typedef struct {

  uint8_t  VL53LX_p_019;


  uint8_t  VL53LX_p_020;


  uint8_t  VL53LX_p_021;


  uint8_t  VL53LX_p_029;


  int32_t  VL53LX_p_016;



  int32_t   VL53LX_p_043[VL53LX_HISTOGRAM_BUFFER_SIZE];

  int32_t   VL53LX_p_068[VL53LX_HISTOGRAM_BUFFER_SIZE];


  uint8_t   VL53LX_p_040[VL53LX_HISTOGRAM_BUFFER_SIZE];


  int32_t   VL53LX_p_018[VL53LX_HISTOGRAM_BUFFER_SIZE];

  uint16_t  VL53LX_p_014[VL53LX_HISTOGRAM_BUFFER_SIZE];

  uint16_t  VL53LX_p_008[VL53LX_HISTOGRAM_BUFFER_SIZE];


} VL53LX_hist_gen1_algo_private_data_t;










typedef struct {

  uint8_t  VL53LX_p_019;


  uint8_t  VL53LX_p_020;


  uint8_t  VL53LX_p_021;


  uint16_t VL53LX_p_015;


  uint8_t  VL53LX_p_005;


  uint8_t  VL53LX_p_029;


  int32_t  VL53LX_p_028;


  int32_t  VL53LX_p_016;



  int32_t   VL53LX_p_007[VL53LX_HISTOGRAM_BUFFER_SIZE];


  int32_t   VL53LX_p_032[VL53LX_HISTOGRAM_BUFFER_SIZE];


  int32_t   VL53LX_p_001[VL53LX_HISTOGRAM_BUFFER_SIZE];



  int32_t   VL53LX_p_018[VL53LX_HISTOGRAM_BUFFER_SIZE];


  int32_t   VL53LX_p_055[VL53LX_HISTOGRAM_BUFFER_SIZE];


  int32_t   VL53LX_p_053[VL53LX_HISTOGRAM_BUFFER_SIZE];


  int32_t   VL53LX_p_054[VL53LX_HISTOGRAM_BUFFER_SIZE];



} VL53LX_hist_gen2_algo_filtered_data_t;










typedef struct {

  uint8_t  VL53LX_p_019;


  uint8_t  VL53LX_p_020;


  uint8_t  VL53LX_p_021;


  int32_t  VL53LX_p_031;



  uint8_t   VL53LX_p_069[VL53LX_HISTOGRAM_BUFFER_SIZE];


  uint8_t   VL53LX_p_070[VL53LX_HISTOGRAM_BUFFER_SIZE];



  uint32_t  VL53LX_p_014[VL53LX_HISTOGRAM_BUFFER_SIZE];


  uint16_t  VL53LX_p_008[VL53LX_HISTOGRAM_BUFFER_SIZE];



  uint8_t   VL53LX_p_040[VL53LX_HISTOGRAM_BUFFER_SIZE];



} VL53LX_hist_gen2_algo_detection_data_t;










typedef struct {

  uint8_t  VL53LX_p_012;


  uint8_t  VL53LX_p_019;


  uint8_t  VL53LX_p_023;


  uint8_t  VL53LX_p_024;


  uint8_t  VL53LX_p_013;



  uint8_t  VL53LX_p_025;


  uint8_t  VL53LX_p_051;



  int32_t  VL53LX_p_016;


  int32_t  VL53LX_p_017;


  int32_t  VL53LX_p_010;



  uint32_t VL53LX_p_026;


  uint32_t VL53LX_p_011;


  uint32_t VL53LX_p_027;



  uint16_t VL53LX_p_002;



} VL53LX_hist_pulse_data_t;










typedef struct {

  uint8_t  VL53LX_p_019;


  uint8_t  VL53LX_p_020;


  uint8_t  VL53LX_p_021;


  uint8_t  VL53LX_p_030;


  uint8_t  VL53LX_p_039;


  int32_t  VL53LX_p_028;


  int32_t  VL53LX_p_031;



  uint8_t  VL53LX_p_040[VL53LX_HISTOGRAM_BUFFER_SIZE];


  uint8_t  VL53LX_p_041[VL53LX_HISTOGRAM_BUFFER_SIZE];


  uint8_t  VL53LX_p_042[VL53LX_HISTOGRAM_BUFFER_SIZE];



  int32_t  VL53LX_p_052[VL53LX_HISTOGRAM_BUFFER_SIZE];


  int32_t  VL53LX_p_043[VL53LX_HISTOGRAM_BUFFER_SIZE];


  int32_t  VL53LX_p_018[VL53LX_HISTOGRAM_BUFFER_SIZE];



  uint8_t  VL53LX_p_044;


  uint8_t  VL53LX_p_045;


  uint8_t  VL53LX_p_046;



  VL53LX_hist_pulse_data_t  VL53LX_p_003[VL53LX_D_001];






  VL53LX_histogram_bin_data_t   VL53LX_p_006;


  VL53LX_histogram_bin_data_t   VL53LX_p_047;


  VL53LX_histogram_bin_data_t   VL53LX_p_048;


  VL53LX_histogram_bin_data_t   VL53LX_p_049;


  VL53LX_histogram_bin_data_t   VL53LX_p_050;






} VL53LX_hist_gen3_algo_private_data_t;










typedef struct {

  uint8_t  VL53LX_p_019;


  uint8_t  VL53LX_p_020;


  uint8_t  VL53LX_p_021;



  int32_t   VL53LX_p_007[VL53LX_HISTOGRAM_BUFFER_SIZE];


  int32_t   VL53LX_p_032[VL53LX_HISTOGRAM_BUFFER_SIZE];


  int32_t   VL53LX_p_001[VL53LX_HISTOGRAM_BUFFER_SIZE];



  int32_t   VL53LX_p_053[VL53LX_HISTOGRAM_BUFFER_SIZE];


  int32_t   VL53LX_p_054[VL53LX_HISTOGRAM_BUFFER_SIZE];



  uint8_t  VL53LX_p_040[VL53LX_HISTOGRAM_BUFFER_SIZE];



} VL53LX_hist_gen4_algo_filtered_data_t;



// define & typedef from VL53Lx_ll_def.h




#define VL53LX_LL_API_IMPLEMENTATION_VER_MAJOR       1

#define VL53LX_LL_API_IMPLEMENTATION_VER_MINOR       1

#define VL53LX_LL_API_IMPLEMENTATION_VER_SUB         1

#define VL53LX_LL_API_IMPLEMENTATION_VER_REVISION   0

#define VL53LX_LL_API_IMPLEMENTATION_VER_STRING "1.1.1"


#define VL53LX_FIRMWARE_VER_MINIMUM         398
#define VL53LX_FIRMWARE_VER_MAXIMUM         400




#define VL53LX_LL_CALIBRATION_DATA_STRUCT_VERSION       0xECAB0102




#define VL53LX_LL_ZONE_CALIBRATION_DATA_STRUCT_VERSION  0xECAE0101





#define VL53LX_BIN_REC_SIZE 6

#define VL53LX_TIMING_CONF_A_B_SIZE 2

#define VL53LX_FRAME_WAIT_EVENT 6




#define VL53LX_MAX_XTALK_RANGE_RESULTS        5


#define VL53LX_MAX_OFFSET_RANGE_RESULTS       3


#define VL53LX_NVM_MAX_FMT_RANGE_DATA         4


#define VL53LX_NVM_PEAK_RATE_MAP_SAMPLES  25

#define VL53LX_NVM_PEAK_RATE_MAP_WIDTH     5

#define VL53LX_NVM_PEAK_RATE_MAP_HEIGHT     5




#define VL53LX_ERROR_DEVICE_FIRMWARE_TOO_OLD           ((VL53LX_Error) - 80)

#define VL53LX_ERROR_DEVICE_FIRMWARE_TOO_NEW           ((VL53LX_Error) - 85)

#define VL53LX_ERROR_UNIT_TEST_FAIL                    ((VL53LX_Error) - 90)

#define VL53LX_ERROR_FILE_READ_FAIL                    ((VL53LX_Error) - 95)

#define VL53LX_ERROR_FILE_WRITE_FAIL                   ((VL53LX_Error) - 96)






typedef struct {
  uint32_t     ll_revision;
  uint8_t      ll_major;
  uint8_t      ll_minor;
  uint8_t      ll_build;
} VL53LX_ll_version_t;




typedef struct {

  uint8_t    device_test_mode;
  uint8_t    VL53LX_p_005;
  uint32_t   timeout_us;
  uint16_t   target_count_rate_mcps;

  uint16_t   min_count_rate_limit_mcps;

  uint16_t   max_count_rate_limit_mcps;


} VL53LX_refspadchar_config_t;




typedef struct {

  uint16_t  dss_config__target_total_rate_mcps;

  uint32_t  phasecal_config_timeout_us;

  uint32_t  mm_config_timeout_us;

  uint32_t  range_config_timeout_us;

  uint8_t   num_of_samples;

  int16_t   algo__crosstalk_extract_min_valid_range_mm;

  int16_t   algo__crosstalk_extract_max_valid_range_mm;

  uint16_t  algo__crosstalk_extract_max_valid_rate_kcps;

  uint16_t  algo__crosstalk_extract_max_sigma_mm;


} VL53LX_xtalkextract_config_t;




typedef struct {

  uint16_t  dss_config__target_total_rate_mcps;

  uint32_t  phasecal_config_timeout_us;

  uint32_t  range_config_timeout_us;

  uint32_t  mm_config_timeout_us;

  uint8_t   pre_num_of_samples;

  uint8_t   mm1_num_of_samples;

  uint8_t   mm2_num_of_samples;


} VL53LX_offsetcal_config_t;




typedef struct {

  uint16_t   dss_config__target_total_rate_mcps;

  uint32_t   phasecal_config_timeout_us;

  uint32_t   mm_config_timeout_us;

  uint32_t   range_config_timeout_us;

  uint16_t   phasecal_num_of_samples;

  uint16_t   zone_num_of_samples;


} VL53LX_zonecal_config_t;





typedef struct {

  VL53LX_DeviceSscArray  array_select;

  uint8_t    VL53LX_p_005;

  uint8_t    vcsel_start;

  uint8_t    vcsel_width;

  uint32_t   timeout_us;

  uint16_t   rate_limit_mcps;


} VL53LX_ssc_config_t;




typedef struct {


  uint32_t  algo__crosstalk_compensation_plane_offset_kcps;

  int16_t   algo__crosstalk_compensation_x_plane_gradient_kcps;

  int16_t   algo__crosstalk_compensation_y_plane_gradient_kcps;

  uint32_t  nvm_default__crosstalk_compensation_plane_offset_kcps;

  int16_t   nvm_default__crosstalk_compensation_x_plane_gradient_kcps;

  int16_t   nvm_default__crosstalk_compensation_y_plane_gradient_kcps;

  uint8_t   global_crosstalk_compensation_enable;

  int16_t   histogram_mode_crosstalk_margin_kcps;

  int16_t   lite_mode_crosstalk_margin_kcps;

  uint8_t   crosstalk_range_ignore_threshold_mult;

  uint16_t  crosstalk_range_ignore_threshold_rate_mcps;

  int16_t   algo__crosstalk_detect_min_valid_range_mm;

  int16_t   algo__crosstalk_detect_max_valid_range_mm;

  uint16_t  algo__crosstalk_detect_max_valid_rate_kcps;

  uint16_t  algo__crosstalk_detect_max_sigma_mm;



} VL53LX_xtalk_config_t;




typedef struct {


  uint16_t  tp_tuning_parm_version;

  uint16_t  tp_tuning_parm_key_table_version;

  uint16_t  tp_tuning_parm_lld_version;

  uint8_t   tp_init_phase_rtn_lite_long;

  uint8_t   tp_init_phase_rtn_lite_med;

  uint8_t   tp_init_phase_rtn_lite_short;

  uint8_t   tp_init_phase_ref_lite_long;

  uint8_t   tp_init_phase_ref_lite_med;

  uint8_t   tp_init_phase_ref_lite_short;


  uint8_t   tp_init_phase_rtn_hist_long;

  uint8_t   tp_init_phase_rtn_hist_med;

  uint8_t   tp_init_phase_rtn_hist_short;

  uint8_t   tp_init_phase_ref_hist_long;

  uint8_t   tp_init_phase_ref_hist_med;

  uint8_t   tp_init_phase_ref_hist_short;


  uint8_t   tp_consistency_lite_phase_tolerance;

  uint8_t   tp_phasecal_target;

  uint16_t  tp_cal_repeat_rate;

  uint8_t   tp_lite_min_clip;


  uint16_t  tp_lite_long_sigma_thresh_mm;

  uint16_t  tp_lite_med_sigma_thresh_mm;

  uint16_t  tp_lite_short_sigma_thresh_mm;


  uint16_t  tp_lite_long_min_count_rate_rtn_mcps;

  uint16_t  tp_lite_med_min_count_rate_rtn_mcps;

  uint16_t  tp_lite_short_min_count_rate_rtn_mcps;


  uint8_t   tp_lite_sigma_est_pulse_width_ns;

  uint8_t   tp_lite_sigma_est_amb_width_ns;

  uint8_t   tp_lite_sigma_ref_mm;

  uint8_t   tp_lite_seed_cfg;

  uint8_t   tp_timed_seed_cfg;


  uint8_t   tp_lite_quantifier;

  uint8_t   tp_lite_first_order_select;


  uint16_t  tp_dss_target_lite_mcps;

  uint16_t  tp_dss_target_histo_mcps;

  uint16_t  tp_dss_target_histo_mz_mcps;

  uint16_t  tp_dss_target_timed_mcps;

  uint16_t  tp_dss_target_very_short_mcps;


  uint32_t  tp_phasecal_timeout_lite_us;

  uint32_t  tp_phasecal_timeout_hist_long_us;

  uint32_t  tp_phasecal_timeout_hist_med_us;

  uint32_t  tp_phasecal_timeout_hist_short_us;


  uint32_t  tp_phasecal_timeout_mz_long_us;

  uint32_t  tp_phasecal_timeout_mz_med_us;

  uint32_t  tp_phasecal_timeout_mz_short_us;

  uint32_t  tp_phasecal_timeout_timed_us;


  uint32_t  tp_mm_timeout_lite_us;

  uint32_t  tp_mm_timeout_histo_us;

  uint32_t  tp_mm_timeout_mz_us;

  uint32_t  tp_mm_timeout_timed_us;

  uint32_t  tp_mm_timeout_lpa_us;


  uint32_t  tp_range_timeout_lite_us;

  uint32_t  tp_range_timeout_histo_us;

  uint32_t  tp_range_timeout_mz_us;

  uint32_t  tp_range_timeout_timed_us;

  uint32_t  tp_range_timeout_lpa_us;

  uint32_t tp_phasecal_patch_power;

  uint32_t tp_hist_merge;

  uint32_t tp_reset_merge_threshold;

  uint32_t tp_hist_merge_max_size;


} VL53LX_tuning_parm_storage_t;





typedef struct {

  uint8_t   x_centre;
  uint8_t   y_centre;

} VL53LX_optical_centre_t;




typedef struct {

  uint8_t   x_centre;
  uint8_t   y_centre;
  uint8_t   width;
  uint8_t   height;

} VL53LX_user_zone_t;




typedef struct {

  uint8_t             max_zones;
  uint8_t             active_zones;



  VL53LX_histogram_config_t multizone_hist_cfg;

  VL53LX_user_zone_t user_zones[VL53LX_MAX_USER_ZONES];


  uint8_t bin_config[VL53LX_MAX_USER_ZONES];


} VL53LX_zone_config_t;



typedef struct {


  VL53LX_GPIO_Interrupt_Mode  intr_mode_distance;


  VL53LX_GPIO_Interrupt_Mode  intr_mode_rate;


  uint8_t       intr_new_measure_ready;


  uint8_t       intr_no_target;


  uint8_t       intr_combined_mode;





  uint16_t      threshold_distance_high;


  uint16_t      threshold_distance_low;


  uint16_t      threshold_rate_high;


  uint16_t      threshold_rate_low;

} VL53LX_GPIO_interrupt_config_t;




typedef struct {


  uint8_t   vhv_loop_bound;


  uint8_t   is_low_power_auto_mode;


  uint8_t   low_power_auto_range_count;


  uint8_t   saved_interrupt_config;


  uint8_t   saved_vhv_init;


  uint8_t   saved_vhv_timeout;


  uint8_t   first_run_phasecal_result;


  uint32_t  dss__total_rate_per_spad_mcps;


  uint16_t  dss__required_spads;

} VL53LX_low_power_auto_data_t;







typedef struct {


  uint8_t smudge_corr_enabled;


  uint8_t smudge_corr_apply_enabled;


  uint8_t smudge_corr_single_apply;




  uint16_t  smudge_margin;


  uint32_t  noise_margin;


  uint32_t  user_xtalk_offset_limit;


  uint8_t user_xtalk_offset_limit_hi;


  uint32_t  sample_limit;


  uint32_t  single_xtalk_delta;


  uint32_t  averaged_xtalk_delta;


  uint32_t  smudge_corr_clip_limit;


  uint32_t  smudge_corr_ambient_threshold;


  uint8_t scaler_calc_method;


  int16_t x_gradient_scaler;


  int16_t y_gradient_scaler;


  uint8_t user_scaler_set;


  uint32_t nodetect_ambient_threshold;


  uint32_t nodetect_sample_limit;


  uint32_t nodetect_xtalk_offset;


  uint16_t nodetect_min_range_mm;


  uint32_t max_smudge_factor;

} VL53LX_smudge_corrector_config_t;



typedef struct {


  uint32_t  current_samples;


  uint32_t  required_samples;


  uint64_t  accumulator;


  uint32_t  nodetect_counter;

} VL53LX_smudge_corrector_internals_t;



typedef struct {


  uint8_t smudge_corr_valid;


  uint8_t smudge_corr_clipped;


  uint8_t single_xtalk_delta_flag;


  uint8_t averaged_xtalk_delta_flag;


  uint8_t sample_limit_exceeded_flag;


  uint8_t gradient_zero_flag;


  uint8_t new_xtalk_applied_flag;


  uint32_t  algo__crosstalk_compensation_plane_offset_kcps;


  int16_t   algo__crosstalk_compensation_x_plane_gradient_kcps;


  int16_t   algo__crosstalk_compensation_y_plane_gradient_kcps;


} VL53LX_smudge_corrector_data_t;





typedef struct {



  uint8_t  range_id;

  uint32_t time_stamp;

  uint8_t  VL53LX_p_012;

  uint8_t  VL53LX_p_019;

  uint8_t  VL53LX_p_023;

  uint8_t  VL53LX_p_024;

  uint8_t  VL53LX_p_013;

  uint8_t  VL53LX_p_025;


  uint16_t   width;

  uint8_t    VL53LX_p_029;


  uint16_t   fast_osc_frequency;

  uint16_t   zero_distance_phase;

  uint16_t   VL53LX_p_004;


  uint32_t   total_periods_elapsed;


  uint32_t   peak_duration_us;


  uint32_t   woi_duration_us;





  uint32_t   VL53LX_p_016;

  uint32_t   VL53LX_p_017;

  int32_t    VL53LX_p_010;




  uint16_t    peak_signal_count_rate_mcps;

  uint16_t    avg_signal_count_rate_mcps;

  uint16_t    ambient_count_rate_mcps;

  uint16_t    total_rate_per_spad_mcps;

  uint32_t    VL53LX_p_009;




  uint16_t   VL53LX_p_002;




  uint16_t   VL53LX_p_026;

  uint16_t   VL53LX_p_011;

  uint16_t   VL53LX_p_027;




  int16_t    min_range_mm;

  int16_t    median_range_mm;

  int16_t    max_range_mm;




  uint8_t    range_status;

} VL53LX_range_data_t;




typedef struct {

  VL53LX_DeviceState     cfg_device_state;

  VL53LX_DeviceState     rd_device_state;

  uint8_t                zone_id;

  uint8_t                stream_count;


  int16_t                VL53LX_p_022[VL53LX_MAX_AMBIENT_DMAX_VALUES];

  int16_t                wrap_dmax_mm;


  uint8_t                device_status;


  uint8_t                max_results;

  uint8_t                active_results;

  VL53LX_range_data_t    VL53LX_p_003[VL53LX_MAX_RANGE_RESULTS];

  VL53LX_range_data_t    xmonitor;

  VL53LX_smudge_corrector_data_t smudge_corrector_data;



} VL53LX_range_results_t;




typedef struct {

  uint8_t    no_of_samples;

  uint32_t   rate_per_spad_kcps_sum;

  uint32_t   rate_per_spad_kcps_avg;

  int32_t    signal_total_events_sum;

  int32_t    signal_total_events_avg;

  uint32_t   sigma_mm_sum;

  uint32_t   sigma_mm_avg;

  uint32_t   median_phase_sum;

  uint32_t   median_phase_avg;


} VL53LX_xtalk_range_data_t;




typedef struct {

  VL53LX_Error                cal_status;

  uint8_t                     num_of_samples_status;

  uint8_t                     zero_samples_status;

  uint8_t                     max_sigma_status;

  uint8_t                     max_results;

  uint8_t                     active_results;


  VL53LX_xtalk_range_data_t
  VL53LX_p_003[VL53LX_MAX_XTALK_RANGE_RESULTS];

  VL53LX_histogram_bin_data_t central_histogram_sum;

  VL53LX_histogram_bin_data_t central_histogram_avg;

  uint8_t central_histogram__window_start;

  uint8_t central_histogram__window_end;

  VL53LX_histogram_bin_data_t
  histogram_avg_1[VL53LX_MAX_XTALK_RANGE_RESULTS];

  VL53LX_histogram_bin_data_t
  histogram_avg_2[VL53LX_MAX_XTALK_RANGE_RESULTS];

  VL53LX_histogram_bin_data_t
  xtalk_avg[VL53LX_MAX_XTALK_RANGE_RESULTS];


} VL53LX_xtalk_range_results_t;




typedef struct {

  uint8_t    preset_mode;

  uint8_t    dss_config__roi_mode_control;

  uint16_t   dss_config__manual_effective_spads_select;

  uint8_t    no_of_samples;

  uint32_t   effective_spads;

  uint32_t   peak_rate_mcps;

  uint32_t   VL53LX_p_002;

  int32_t    median_range_mm;

  int32_t    range_mm_offset;


} VL53LX_offset_range_data_t;




typedef struct {

  int16_t      cal_distance_mm;

  uint16_t     cal_reflectance_pc;

  VL53LX_Error cal_status;

  uint8_t      cal_report;

  uint8_t      max_results;

  uint8_t      active_results;

  VL53LX_offset_range_data_t
  VL53LX_p_003[VL53LX_MAX_OFFSET_RANGE_RESULTS];


} VL53LX_offset_range_results_t;




typedef struct {

  uint16_t  result__mm_inner_actual_effective_spads;

  uint16_t  result__mm_outer_actual_effective_spads;

  uint16_t  result__mm_inner_peak_signal_count_rtn_mcps;

  uint16_t  result__mm_outer_peak_signal_count_rtn_mcps;


} VL53LX_additional_offset_cal_data_t;



typedef struct {
  int16_t   short_a_offset_mm;
  int16_t   short_b_offset_mm;
  int16_t   medium_a_offset_mm;
  int16_t   medium_b_offset_mm;
  int16_t   long_a_offset_mm;
  int16_t   long_b_offset_mm;
} VL53LX_per_vcsel_period_offset_cal_data_t;





typedef struct {

  uint32_t   VL53LX_p_016;

  uint32_t   VL53LX_p_017;

  uint16_t   VL53LX_p_011;

  uint8_t    range_status;


} VL53LX_object_data_t;




typedef struct {

  VL53LX_DeviceState     cfg_device_state;

  VL53LX_DeviceState     rd_device_state;

  uint8_t                zone_id;

  uint8_t                stream_count;

  uint8_t                max_objects;

  uint8_t                active_objects;

  VL53LX_object_data_t   VL53LX_p_003[VL53LX_MAX_RANGE_RESULTS];


  VL53LX_object_data_t   xmonitor;


} VL53LX_zone_objects_t;






typedef struct {

  uint8_t                max_zones;

  uint8_t                active_zones;

  VL53LX_zone_objects_t VL53LX_p_003[VL53LX_MAX_USER_ZONES];


} VL53LX_zone_results_t;




typedef struct {

  VL53LX_DeviceState     rd_device_state;


  uint8_t  number_of_ambient_bins;


  uint16_t result__dss_actual_effective_spads;

  uint8_t  VL53LX_p_005;

  uint32_t total_periods_elapsed;


  int32_t  ambient_events_sum;


} VL53LX_zone_hist_info_t;




typedef struct {

  uint8_t                     max_zones;

  uint8_t                     active_zones;

  VL53LX_zone_hist_info_t     VL53LX_p_003[VL53LX_MAX_USER_ZONES];


} VL53LX_zone_histograms_t;




typedef struct {

  uint32_t   no_of_samples;

  uint32_t   effective_spads;

  uint32_t   peak_rate_mcps;

  uint32_t   VL53LX_p_011;

  uint32_t   VL53LX_p_002;

  int32_t    median_range_mm;

  int32_t    range_mm_offset;


} VL53LX_zone_calibration_data_t;






typedef struct {

  uint32_t                         struct_version;

  VL53LX_DevicePresetModes         preset_mode;

  VL53LX_DeviceZonePreset          zone_preset;

  int16_t                          cal_distance_mm;

  uint16_t                         cal_reflectance_pc;

  uint16_t                         phasecal_result__reference_phase;

  uint16_t                         zero_distance_phase;

  VL53LX_Error                     cal_status;

  uint8_t                          max_zones;

  uint8_t                          active_zones;

  VL53LX_zone_calibration_data_t   VL53LX_p_003[VL53LX_MAX_USER_ZONES];


} VL53LX_zone_calibration_results_t;





typedef struct {

  int16_t     cal_distance_mm;

  uint16_t    cal_reflectance_pc;

  uint16_t    max_samples;

  uint16_t    width;

  uint16_t    height;

  uint16_t    peak_rate_mcps[VL53LX_NVM_PEAK_RATE_MAP_SAMPLES];


} VL53LX_cal_peak_rate_map_t;




typedef struct {

  uint8_t      expected_stream_count;

  uint8_t      expected_gph_id;

  uint8_t      dss_mode;

  uint16_t     dss_requested_effective_spad_count;

  uint8_t      seed_cfg;

  uint8_t      initial_phase_seed;


  uint8_t  roi_config__user_roi_centre_spad;

  uint8_t  roi_config__user_roi_requested_global_xy_size;


} VL53LX_zone_private_dyn_cfg_t;




typedef struct {

  uint8_t                     max_zones;

  uint8_t                     active_zones;

  VL53LX_zone_private_dyn_cfg_t VL53LX_p_003[VL53LX_MAX_USER_ZONES];


} VL53LX_zone_private_dyn_cfgs_t;



typedef struct {

  uint32_t  algo__crosstalk_compensation_plane_offset_kcps;

  int16_t   algo__crosstalk_compensation_x_plane_gradient_kcps;

  int16_t   algo__crosstalk_compensation_y_plane_gradient_kcps;

  uint32_t  algo__xtalk_cpo_HistoMerge_kcps[VL53LX_BIN_REC_SIZE];


} VL53LX_xtalk_calibration_results_t;




typedef struct {


  uint32_t   sample_count;


  uint32_t   pll_period_mm;


  uint32_t   peak_duration_us_sum;


  uint32_t   effective_spad_count_sum;


  uint32_t   zero_distance_phase_sum;


  uint32_t   zero_distance_phase_avg;


  int32_t    event_scaler_sum;


  int32_t    event_scaler_avg;


  int32_t   signal_events_sum;


  uint32_t  xtalk_rate_kcps_per_spad;


  int32_t   xtalk_start_phase;


  int32_t   xtalk_end_phase;


  int32_t   xtalk_width_phase;


  int32_t   target_start_phase;


  int32_t   target_end_phase;


  int32_t   target_width_phase;


  int32_t   effective_width;


  int32_t   event_scaler;


  uint8_t   VL53LX_p_012;


  uint8_t   VL53LX_p_013;


  uint8_t   target_start;


  int32_t   max_shape_value;


  int32_t   bin_data_sums[VL53LX_XTALK_HISTO_BINS];

} VL53LX_hist_xtalk_extract_data_t;




typedef struct {

  uint16_t   standard_ranging_gain_factor;

  uint16_t   histogram_ranging_gain_factor;


} VL53LX_gain_calibration_data_t;




typedef struct {

  VL53LX_DeviceState   cfg_device_state;

  uint8_t   cfg_stream_count;

  uint8_t   cfg_internal_stream_count;

  uint8_t   cfg_internal_stream_count_val;

  uint8_t   cfg_gph_id;

  uint8_t   cfg_timing_status;

  uint8_t   cfg_zone_id;


  VL53LX_DeviceState   rd_device_state;

  uint8_t   rd_stream_count;

  uint8_t   rd_internal_stream_count;

  uint8_t   rd_internal_stream_count_val;

  uint8_t   rd_gph_id;

  uint8_t   rd_timing_status;

  uint8_t   rd_zone_id;


} VL53LX_ll_driver_state_t;




typedef struct {

  uint8_t   wait_method;

  VL53LX_DevicePresetModes        preset_mode;

  VL53LX_DeviceZonePreset         zone_preset;

  VL53LX_DeviceMeasurementModes   measurement_mode;

  VL53LX_OffsetCalibrationMode    offset_calibration_mode;

  VL53LX_OffsetCorrectionMode     offset_correction_mode;

  VL53LX_DeviceDmaxMode           dmax_mode;

  uint32_t  phasecal_config_timeout_us;

  uint32_t  mm_config_timeout_us;

  uint32_t  range_config_timeout_us;

  uint32_t  inter_measurement_period_ms;

  uint16_t  dss_config__target_total_rate_mcps;

  uint32_t  fw_ready_poll_duration_ms;

  uint8_t   fw_ready;

  uint8_t   debug_mode;



  VL53LX_ll_version_t                 version;


  VL53LX_ll_driver_state_t            ll_state;


  VL53LX_GPIO_interrupt_config_t      gpio_interrupt_config;


  VL53LX_customer_nvm_managed_t       customer;
  VL53LX_cal_peak_rate_map_t          cal_peak_rate_map;
  VL53LX_additional_offset_cal_data_t add_off_cal_data;
  VL53LX_dmax_calibration_data_t      fmt_dmax_cal;
  VL53LX_dmax_calibration_data_t      cust_dmax_cal;
  VL53LX_gain_calibration_data_t      gain_cal;
  VL53LX_user_zone_t                  mm_roi;
  VL53LX_optical_centre_t             optical_centre;
  VL53LX_zone_config_t                zone_cfg;


  VL53LX_tuning_parm_storage_t        tuning_parms;


  uint8_t rtn_good_spads[VL53LX_RTN_SPAD_BUFFER_SIZE];


  VL53LX_refspadchar_config_t         refspadchar;
  VL53LX_ssc_config_t                 ssc_cfg;
  VL53LX_hist_post_process_config_t   histpostprocess;
  VL53LX_hist_gen3_dmax_config_t      dmax_cfg;
  VL53LX_xtalkextract_config_t        xtalk_extract_cfg;
  VL53LX_xtalk_config_t               xtalk_cfg;
  VL53LX_offsetcal_config_t           offsetcal_cfg;
  VL53LX_zonecal_config_t             zonecal_cfg;


  VL53LX_static_nvm_managed_t         stat_nvm;
  VL53LX_histogram_config_t           hist_cfg;
  VL53LX_static_config_t              stat_cfg;
  VL53LX_general_config_t             gen_cfg;
  VL53LX_timing_config_t              tim_cfg;
  VL53LX_dynamic_config_t             dyn_cfg;
  VL53LX_system_control_t             sys_ctrl;
  VL53LX_system_results_t             sys_results;
  VL53LX_nvm_copy_data_t              nvm_copy_data;


  VL53LX_histogram_bin_data_t         hist_data;
  VL53LX_histogram_bin_data_t         hist_xtalk;


  VL53LX_xtalk_histogram_data_t       xtalk_shapes;
  VL53LX_xtalk_range_results_t        xtalk_results;
  VL53LX_xtalk_calibration_results_t  xtalk_cal;
  VL53LX_hist_xtalk_extract_data_t    xtalk_extract;


  VL53LX_offset_range_results_t       offset_results;


  VL53LX_core_results_t               core_results;
  VL53LX_debug_results_t              dbg_results;

  VL53LX_smudge_corrector_config_t  smudge_correct_config;

  VL53LX_smudge_corrector_internals_t smudge_corrector_internals;




  VL53LX_low_power_auto_data_t    low_power_auto_data;

  uint8_t  wArea1[1536];
  uint8_t  wArea2[512];
  VL53LX_per_vcsel_period_offset_cal_data_t per_vcsel_cal_data;

  uint8_t bin_rec_pos;

  uint8_t pos_before_next_recom;

  int32_t  multi_bins_rec[VL53LX_BIN_REC_SIZE]
  [VL53LX_TIMING_CONF_A_B_SIZE][VL53LX_HISTOGRAM_BUFFER_SIZE];

} VL53LX_LLDriverData_t;




typedef struct {


  VL53LX_range_results_t             range_results;


  VL53LX_zone_private_dyn_cfgs_t     zone_dyn_cfgs;


  VL53LX_zone_results_t              zone_results;
  VL53LX_zone_histograms_t           zone_hists;
  VL53LX_zone_calibration_results_t  zone_cal;

} VL53LX_LLDriverResults_t;




typedef struct {

  uint32_t                             struct_version;
  VL53LX_customer_nvm_managed_t        customer;
  VL53LX_dmax_calibration_data_t       fmt_dmax_cal;
  VL53LX_dmax_calibration_data_t       cust_dmax_cal;
  VL53LX_additional_offset_cal_data_t  add_off_cal_data;
  VL53LX_optical_centre_t              optical_centre;
  VL53LX_xtalk_histogram_data_t        xtalkhisto;
  VL53LX_gain_calibration_data_t       gain_cal;
  VL53LX_cal_peak_rate_map_t           cal_peak_rate_map;
  VL53LX_per_vcsel_period_offset_cal_data_t per_vcsel_cal_data;

} VL53LX_calibration_data_t;




typedef struct {

  VL53LX_customer_nvm_managed_t        customer;
  VL53LX_xtalkextract_config_t         xtalk_extract_cfg;
  VL53LX_xtalk_config_t                xtalk_cfg;
  VL53LX_histogram_bin_data_t          hist_data;
  VL53LX_xtalk_histogram_data_t        xtalk_shapes;
  VL53LX_xtalk_range_results_t         xtalk_results;

} VL53LX_xtalk_debug_data_t;




typedef struct {

  VL53LX_customer_nvm_managed_t        customer;
  VL53LX_dmax_calibration_data_t       fmt_dmax_cal;
  VL53LX_dmax_calibration_data_t       cust_dmax_cal;
  VL53LX_additional_offset_cal_data_t  add_off_cal_data;
  VL53LX_offset_range_results_t        offset_results;

} VL53LX_offset_debug_data_t;




typedef struct {
  uint16_t        vl53lx_tuningparm_version;
  uint16_t        vl53lx_tuningparm_key_table_version;
  uint16_t        vl53lx_tuningparm_lld_version;
  uint8_t        vl53lx_tuningparm_hist_algo_select;
  uint8_t        vl53lx_tuningparm_hist_target_order;
  uint8_t        vl53lx_tuningparm_hist_filter_woi_0;
  uint8_t        vl53lx_tuningparm_hist_filter_woi_1;
  uint8_t        vl53lx_tuningparm_hist_amb_est_method;
  uint8_t        vl53lx_tuningparm_hist_amb_thresh_sigma_0;
  uint8_t        vl53lx_tuningparm_hist_amb_thresh_sigma_1;
  int32_t        vl53lx_tuningparm_hist_min_amb_thresh_events;
  uint16_t        vl53lx_tuningparm_hist_amb_events_scaler;
  uint16_t        vl53lx_tuningparm_hist_noise_threshold;
  int32_t        vl53lx_tuningparm_hist_signal_total_events_limit;
  uint8_t        vl53lx_tuningparm_hist_sigma_est_ref_mm;
  uint16_t        vl53lx_tuningparm_hist_sigma_thresh_mm;
  uint16_t        vl53lx_tuningparm_hist_gain_factor;
  uint8_t        vl53lx_tuningparm_consistency_hist_phase_tolerance;
  uint16_t  vl53lx_tuningparm_consistency_hist_min_max_tolerance_mm;
  uint8_t        vl53lx_tuningparm_consistency_hist_event_sigma;
  uint16_t  vl53lx_tuningparm_consistency_hist_event_sigma_min_spad_limit;
  uint8_t        vl53lx_tuningparm_initial_phase_rtn_histo_long_range;
  uint8_t        vl53lx_tuningparm_initial_phase_rtn_histo_med_range;
  uint8_t        vl53lx_tuningparm_initial_phase_rtn_histo_short_range;
  uint8_t        vl53lx_tuningparm_initial_phase_ref_histo_long_range;
  uint8_t        vl53lx_tuningparm_initial_phase_ref_histo_med_range;
  uint8_t        vl53lx_tuningparm_initial_phase_ref_histo_short_range;
  int16_t        vl53lx_tuningparm_xtalk_detect_min_valid_range_mm;
  int16_t        vl53lx_tuningparm_xtalk_detect_max_valid_range_mm;
  uint16_t        vl53lx_tuningparm_xtalk_detect_max_sigma_mm;
  uint16_t        vl53lx_tuningparm_xtalk_detect_min_max_tolerance;
  uint16_t        vl53lx_tuningparm_xtalk_detect_max_valid_rate_kcps;
  uint8_t        vl53lx_tuningparm_xtalk_detect_event_sigma;
  int16_t        vl53lx_tuningparm_hist_xtalk_margin_kcps;
  uint8_t        vl53lx_tuningparm_consistency_lite_phase_tolerance;
  uint8_t        vl53lx_tuningparm_phasecal_target;
  uint16_t        vl53lx_tuningparm_lite_cal_repeat_rate;
  uint16_t        vl53lx_tuningparm_lite_ranging_gain_factor;
  uint8_t        vl53lx_tuningparm_lite_min_clip_mm;
  uint16_t        vl53lx_tuningparm_lite_long_sigma_thresh_mm;
  uint16_t        vl53lx_tuningparm_lite_med_sigma_thresh_mm;
  uint16_t        vl53lx_tuningparm_lite_short_sigma_thresh_mm;
  uint16_t        vl53lx_tuningparm_lite_long_min_count_rate_rtn_mcps;
  uint16_t        vl53lx_tuningparm_lite_med_min_count_rate_rtn_mcps;
  uint16_t        vl53lx_tuningparm_lite_short_min_count_rate_rtn_mcps;
  uint8_t        vl53lx_tuningparm_lite_sigma_est_pulse_width;
  uint8_t        vl53lx_tuningparm_lite_sigma_est_amb_width_ns;
  uint8_t        vl53lx_tuningparm_lite_sigma_ref_mm;
  uint8_t        vl53lx_tuningparm_lite_rit_mult;
  uint8_t        vl53lx_tuningparm_lite_seed_config;
  uint8_t        vl53lx_tuningparm_lite_quantifier;
  uint8_t        vl53lx_tuningparm_lite_first_order_select;
  int16_t        vl53lx_tuningparm_lite_xtalk_margin_kcps;
  uint8_t        vl53lx_tuningparm_initial_phase_rtn_lite_long_range;
  uint8_t        vl53lx_tuningparm_initial_phase_rtn_lite_med_range;
  uint8_t        vl53lx_tuningparm_initial_phase_rtn_lite_short_range;
  uint8_t        vl53lx_tuningparm_initial_phase_ref_lite_long_range;
  uint8_t        vl53lx_tuningparm_initial_phase_ref_lite_med_range;
  uint8_t        vl53lx_tuningparm_initial_phase_ref_lite_short_range;
  uint8_t        vl53lx_tuningparm_timed_seed_config;
  uint8_t        vl53lx_tuningparm_dmax_cfg_signal_thresh_sigma;
  uint16_t        vl53lx_tuningparm_dmax_cfg_reflectance_array_0;
  uint16_t        vl53lx_tuningparm_dmax_cfg_reflectance_array_1;
  uint16_t        vl53lx_tuningparm_dmax_cfg_reflectance_array_2;
  uint16_t        vl53lx_tuningparm_dmax_cfg_reflectance_array_3;
  uint16_t        vl53lx_tuningparm_dmax_cfg_reflectance_array_4;
  uint8_t        vl53lx_tuningparm_vhv_loopbound;
  uint8_t        vl53lx_tuningparm_refspadchar_device_test_mode;
  uint8_t        vl53lx_tuningparm_refspadchar_vcsel_period;
  uint32_t        vl53lx_tuningparm_refspadchar_phasecal_timeout_us;
  uint16_t        vl53lx_tuningparm_refspadchar_target_count_rate_mcps;
  uint16_t        vl53lx_tuningparm_refspadchar_min_countrate_limit_mcps;
  uint16_t        vl53lx_tuningparm_refspadchar_max_countrate_limit_mcps;
  uint8_t        vl53lx_tuningparm_xtalk_extract_num_of_samples;
  int16_t        vl53lx_tuningparm_xtalk_extract_min_filter_thresh_mm;
  int16_t        vl53lx_tuningparm_xtalk_extract_max_filter_thresh_mm;
  uint16_t        vl53lx_tuningparm_xtalk_extract_dss_rate_mcps;
  uint32_t        vl53lx_tuningparm_xtalk_extract_phasecal_timeout_us;
  uint16_t        vl53lx_tuningparm_xtalk_extract_max_valid_rate_kcps;
  uint16_t        vl53lx_tuningparm_xtalk_extract_sigma_threshold_mm;
  uint32_t        vl53lx_tuningparm_xtalk_extract_dss_timeout_us;
  uint32_t        vl53lx_tuningparm_xtalk_extract_bin_timeout_us;
  uint16_t        vl53lx_tuningparm_offset_cal_dss_rate_mcps;
  uint32_t        vl53lx_tuningparm_offset_cal_phasecal_timeout_us;
  uint32_t        vl53lx_tuningparm_offset_cal_mm_timeout_us;
  uint32_t        vl53lx_tuningparm_offset_cal_range_timeout_us;
  uint8_t        vl53lx_tuningparm_offset_cal_pre_samples;
  uint8_t        vl53lx_tuningparm_offset_cal_mm1_samples;
  uint8_t        vl53lx_tuningparm_offset_cal_mm2_samples;
  uint16_t        vl53lx_tuningparm_zone_cal_dss_rate_mcps;
  uint32_t        vl53lx_tuningparm_zone_cal_phasecal_timeout_us;
  uint32_t        vl53lx_tuningparm_zone_cal_dss_timeout_us;
  uint16_t        vl53lx_tuningparm_zone_cal_phasecal_num_samples;
  uint32_t        vl53lx_tuningparm_zone_cal_range_timeout_us;
  uint16_t        vl53lx_tuningparm_zone_cal_zone_num_samples;
  uint8_t        vl53lx_tuningparm_spadmap_vcsel_period;
  uint8_t        vl53lx_tuningparm_spadmap_vcsel_start;
  uint16_t        vl53lx_tuningparm_spadmap_rate_limit_mcps;
  uint16_t  vl53lx_tuningparm_lite_dss_config_target_total_rate_mcps;
  uint16_t   vl53lx_tuningparm_ranging_dss_config_target_total_rate_mcps;
  uint16_t        vl53lx_tuningparm_mz_dss_config_target_total_rate_mcps;
  uint16_t     vl53lx_tuningparm_timed_dss_config_target_total_rate_mcps;
  uint32_t        vl53lx_tuningparm_lite_phasecal_config_timeout_us;
  uint32_t     vl53lx_tuningparm_ranging_long_phasecal_config_timeout_us;
  uint32_t      vl53lx_tuningparm_ranging_med_phasecal_config_timeout_us;
  uint32_t    vl53lx_tuningparm_ranging_short_phasecal_config_timeout_us;
  uint32_t        vl53lx_tuningparm_mz_long_phasecal_config_timeout_us;
  uint32_t        vl53lx_tuningparm_mz_med_phasecal_config_timeout_us;
  uint32_t        vl53lx_tuningparm_mz_short_phasecal_config_timeout_us;
  uint32_t        vl53lx_tuningparm_timed_phasecal_config_timeout_us;
  uint32_t        vl53lx_tuningparm_lite_mm_config_timeout_us;
  uint32_t        vl53lx_tuningparm_ranging_mm_config_timeout_us;
  uint32_t        vl53lx_tuningparm_mz_mm_config_timeout_us;
  uint32_t        vl53lx_tuningparm_timed_mm_config_timeout_us;
  uint32_t        vl53lx_tuningparm_lite_range_config_timeout_us;
  uint32_t        vl53lx_tuningparm_ranging_range_config_timeout_us;
  uint32_t        vl53lx_tuningparm_mz_range_config_timeout_us;
  uint32_t        vl53lx_tuningparm_timed_range_config_timeout_us;
  uint16_t        vl53lx_tuningparm_dynxtalk_smudge_margin;
  uint32_t        vl53lx_tuningparm_dynxtalk_noise_margin;
  uint32_t        vl53lx_tuningparm_dynxtalk_xtalk_offset_limit;
  uint8_t        vl53lx_tuningparm_dynxtalk_xtalk_offset_limit_hi;
  uint32_t        vl53lx_tuningparm_dynxtalk_sample_limit;
  uint32_t        vl53lx_tuningparm_dynxtalk_single_xtalk_delta;
  uint32_t        vl53lx_tuningparm_dynxtalk_averaged_xtalk_delta;
  uint32_t        vl53lx_tuningparm_dynxtalk_clip_limit;
  uint8_t        vl53lx_tuningparm_dynxtalk_scaler_calc_method;
  int16_t        vl53lx_tuningparm_dynxtalk_xgradient_scaler;
  int16_t        vl53lx_tuningparm_dynxtalk_ygradient_scaler;
  uint8_t        vl53lx_tuningparm_dynxtalk_user_scaler_set;
  uint8_t        vl53lx_tuningparm_dynxtalk_smudge_cor_single_apply;
  uint32_t        vl53lx_tuningparm_dynxtalk_xtalk_amb_threshold;
  uint32_t        vl53lx_tuningparm_dynxtalk_nodetect_amb_threshold_kcps;
  uint32_t        vl53lx_tuningparm_dynxtalk_nodetect_sample_limit;
  uint32_t        vl53lx_tuningparm_dynxtalk_nodetect_xtalk_offset_kcps;
  uint16_t        vl53lx_tuningparm_dynxtalk_nodetect_min_range_mm;
  uint8_t        vl53lx_tuningparm_lowpowerauto_vhv_loop_bound;
  uint32_t        vl53lx_tuningparm_lowpowerauto_mm_config_timeout_us;
  uint32_t        vl53lx_tuningparm_lowpowerauto_range_config_timeout_us;
  uint16_t        vl53lx_tuningparm_very_short_dss_rate_mcps;
  uint32_t        vl53lx_tuningparm_phasecal_patch_power;
} VL53LX_tuning_parameters_t;





typedef struct {

  uint16_t  target_reflectance_for_dmax[VL53LX_MAX_AMBIENT_DMAX_VALUES];

} VL53LX_dmax_reflectance_array_t;




typedef struct {

  uint8_t    spad_type;

  uint16_t   VL53LX_p_020;

  uint16_t   rate_data[VL53LX_NO_OF_SPAD_ENABLES];

  uint16_t    no_of_values;

  uint8_t    fractional_bits;

  uint8_t    error_status;


} VL53LX_spad_rate_data_t;






typedef struct {

  VL53LX_DevicePresetModes        preset_mode;

  VL53LX_DeviceZonePreset         zone_preset;

  VL53LX_DeviceMeasurementModes   measurement_mode;

  VL53LX_OffsetCalibrationMode    offset_calibration_mode;

  VL53LX_OffsetCorrectionMode     offset_correction_mode;

  VL53LX_DeviceDmaxMode           dmax_mode;


  uint32_t  phasecal_config_timeout_us;

  uint32_t  mm_config_timeout_us;

  uint32_t  range_config_timeout_us;

  uint32_t  inter_measurement_period_ms;

  uint16_t  dss_config__target_total_rate_mcps;


  VL53LX_histogram_bin_data_t    VL53LX_p_006;


} VL53LX_additional_data_t;



/* vl53lx_def.h */


/** @defgroup VL53LX_globaldefine_group VL53LX Defines
 *  @brief    VL53LX Defines
 *  @{
 */


/** VL53LX IMPLEMENTATION major version */
#define VL53LX_IMPLEMENTATION_VER_MAJOR       1
/** VL53LX IMPLEMENTATION minor version */
#define VL53LX_IMPLEMENTATION_VER_MINOR       1
/** VL53LX IMPLEMENTATION sub version */
#define VL53LX_IMPLEMENTATION_VER_SUB         4
/** VL53LX IMPLEMENTATION sub version */
#define VL53LX_IMPLEMENTATION_VER_REVISION  2352

/****************************************
 * PRIVATE define do not edit
 ****************************************/

/** @brief Defines the parameters of the Get Version Functions
 */
typedef struct {
  uint32_t     revision; /*!< revision number */
  uint8_t      major;    /*!< major number */
  uint8_t      minor;    /*!< minor number */
  uint8_t      build;    /*!< build number */
} VL53LX_Version_t;


/** @brief Defines the parameters of the Get Device Info Functions
 */
typedef struct {
  uint8_t ProductType;
  /*!< Product Type, VL53LX = 0xAA
   * Stands as module_type in the datasheet
   */
  uint8_t ProductRevisionMajor;
  /*!< Product revision major */
  uint8_t ProductRevisionMinor;
  /*!< Product revision minor */
} VL53LX_DeviceInfo_t;

/** @defgroup VL53LX_define_DistanceModes_group Defines Distance modes
 *  Defines all possible Distance modes for the device
 *  @{
 */
typedef uint8_t VL53LX_DistanceModes;

#define VL53LX_DISTANCEMODE_SHORT             ((VL53LX_DistanceModes)  1)
#define VL53LX_DISTANCEMODE_MEDIUM            ((VL53LX_DistanceModes)  2)
#define VL53LX_DISTANCEMODE_LONG              ((VL53LX_DistanceModes)  3)
/** @} VL53LX_define_DistanceModes_group */

/** @defgroup VL53LX_define_OffsetCorrectionModes_group Defines Offset Correction modes
 *  Device Offset Correction Mode
 *
 *  @brief Defines all possible offset correction modes for the device
 *  @{
 */
typedef uint8_t VL53LX_OffsetCorrectionModes;

#define VL53LX_OFFSETCORRECTIONMODE_STANDARD ((VL53LX_OffsetCorrectionModes)  1)
#define VL53LX_OFFSETCORRECTIONMODE_PERVCSEL ((VL53LX_OffsetCorrectionModes)  3)

/** @} VL53LX_define_OffsetCorrectionModes_group */

/** @brief Defines all parameters for the device
 */
typedef struct {
  VL53LX_DistanceModes DistanceMode;
  /*!< Defines the operating mode to be used for the next measure */
  uint32_t MeasurementTimingBudgetMicroSeconds;
  /*!< Defines the allowed total time for a single measurement */
} VL53LX_DeviceParameters_t;


/** @defgroup VL53LX_define_Smudge_Mode_group Defines smudge correction modes
 *  Defines the smudge correction modes
 *  @{
 */

typedef uint8_t VL53LX_SmudgeCorrectionModes;

#define VL53LX_SMUDGE_CORRECTION_NONE       ((VL53LX_SmudgeCorrectionModes)  0)
/*!< Smudge correction is applied continuously across the rangings */
#define VL53LX_SMUDGE_CORRECTION_CONTINUOUS ((VL53LX_SmudgeCorrectionModes)  1)
/*!< Smudge correction is applied continuously across the rangings */
#define VL53LX_SMUDGE_CORRECTION_SINGLE     ((VL53LX_SmudgeCorrectionModes)  2)
/*!< Smudge correction is applied only once across the rangings */
#define VL53LX_SMUDGE_CORRECTION_DEBUG      ((VL53LX_SmudgeCorrectionModes)  3)
/*!< Smudge detection is applied continuously but Xtalk values are not
 * updated automatically within the driver
 */

/** @} VL53LX_define_Smudge_Correction_Mode_group */

/**
 * @struct VL53LX_TargetRangeData_t
 * @brief One Range measurement data for each target.
 */
typedef struct {
  int16_t RangeMaxMilliMeter;
  /*!< Tells what is the maximum detection distance of the object
   * in current setup and environment conditions (Filled when
   *  applicable)
   */

  int16_t RangeMinMilliMeter;
  /*!< Tells what is the minimum detection distance of the object
   * in current setup and environment conditions (Filled when
   *  applicable)
   */

  FixPoint1616_t SignalRateRtnMegaCps;
  /*!< Return signal rate (MCPS)\n these is a 16.16 fix point
   *  value, which is effectively a measure of target
   *   reflectance.
   */

  FixPoint1616_t AmbientRateRtnMegaCps;
  /*!< Return ambient rate (MCPS)\n these is a 16.16 fix point
   *  value, which is effectively a measure of the ambien
   *  t light.
   */

  FixPoint1616_t SigmaMilliMeter;
  /*!< Return the Sigma value in millimeter */

  int16_t RangeMilliMeter;
  /*!< range distance in millimeter. This should be between
   *  RangeMinMilliMeter and RangeMaxMilliMeter
   */

  uint8_t RangeStatus;
  /*!< Range Status for the current measurement. This is device
   *  dependent. Value = 0 means value is valid.
   */
} VL53LX_TargetRangeData_t;
/**
 * @struct  VL53LX_MultiRangingData_t
 * @brief   Structure for storing the set of range results
 *
 */
typedef struct {
  uint32_t TimeStamp;
  /*!< 32-bit time stamp.
   * @warning Not yet implemented
   */

  uint8_t StreamCount;
  /*!< 8-bit Stream Count. */

  uint8_t NumberOfObjectsFound;
  /*!< Indicate the number of objects found.
   * This is used to know how many ranging data should be get.
   * NumberOfObjectsFound is in the range 0 to
   * VL53LX_MAX_RANGE_RESULTS.
   */
  VL53LX_TargetRangeData_t RangeData[VL53LX_MAX_RANGE_RESULTS];
  /*!< Range data each target distance */
  uint8_t HasXtalkValueChanged;
  /*!< set to 1 if a new Xtalk value has been computed whilst
   * smudge correction mode enable by with
   * VL53LX_SmudgeCorrectionEnable() function is either
   * VL53LX_SMUDGE_CORRECTION_CONTINUOUS or
   * VL53LX_SMUDGE_CORRECTION_SINGLE.
   */
  uint16_t EffectiveSpadRtnCount;
  /*!< Return the effective SPAD count for the return signal.
   *  To obtain Real value it should be divided by 256
   */
} VL53LX_MultiRangingData_t;



/**
 * @struct VL53LX_CustomerNvmManaged_t
 *
 */

typedef struct {
  uint8_t   global_config__spad_enables_ref_0;
  uint8_t   global_config__spad_enables_ref_1;
  uint8_t   global_config__spad_enables_ref_2;
  uint8_t   global_config__spad_enables_ref_3;
  uint8_t   global_config__spad_enables_ref_4;
  uint8_t   global_config__spad_enables_ref_5;
  uint8_t   global_config__ref_en_start_select;
  uint8_t   ref_spad_man__num_requested_ref_spads;
  uint8_t   ref_spad_man__ref_location;
  uint32_t  algo__crosstalk_compensation_plane_offset_kcps;
  int16_t   algo__crosstalk_compensation_x_plane_gradient_kcps;
  int16_t   algo__crosstalk_compensation_y_plane_gradient_kcps;
  uint16_t  ref_spad_char__total_rate_target_mcps;
  int16_t   algo__part_to_part_range_offset_mm;
  int16_t   mm_config__inner_offset_mm;
  int16_t   mm_config__outer_offset_mm;
} VL53LX_CustomerNvmManaged_t;

/**
 * @struct  VL53LX_CalibrationData_t
 * @brief   Structure for storing the Calibration Data
 *
 */

typedef struct {

  uint32_t                             struct_version;
  VL53LX_CustomerNvmManaged_t          customer;
  VL53LX_additional_offset_cal_data_t  add_off_cal_data;
  VL53LX_optical_centre_t              optical_centre;
  VL53LX_xtalk_histogram_data_t        xtalkhisto;
  VL53LX_gain_calibration_data_t       gain_cal;
  VL53LX_cal_peak_rate_map_t           cal_peak_rate_map;
  VL53LX_per_vcsel_period_offset_cal_data_t per_vcsel_cal_data;
  uint32_t  algo__xtalk_cpo_HistoMerge_kcps[VL53LX_BIN_REC_SIZE];
} VL53LX_CalibrationData_t;

#define VL53LX_ADDITIONAL_CALIBRATION_DATA_STRUCT_VERSION  0x20
/** VL53LX additional Calibration Data struct version final struct version
 * is given by adding it to  VL53LX_LL_CALIBRATION_DATA_STRUCT_VERSION
 */

#define VL53LX_CALIBRATION_DATA_STRUCT_VERSION \
    (VL53LX_LL_CALIBRATION_DATA_STRUCT_VERSION + \
    VL53LX_ADDITIONAL_CALIBRATION_DATA_STRUCT_VERSION)
/* VL53LX Calibration Data struct version */

/**
 * @struct  VL53LX_AdditionalData_t
 * @brief   Structure for storing the Additional Data
 *
 */
typedef VL53LX_additional_data_t VL53LX_AdditionalData_t;


/** @defgroup VL53LX_define_RangeStatus_group Defines the Range Status
 *  @{
 */
#define  VL53LX_RANGESTATUS_RANGE_VALID       0
/*!<The Range is valid. */
#define  VL53LX_RANGESTATUS_SIGMA_FAIL        1
/*!<Sigma Fail. */
#define  VL53LX_RANGESTATUS_SIGNAL_FAIL       2
/*!<Signal fail. */
#define  VL53LX_RANGESTATUS_RANGE_VALID_MIN_RANGE_CLIPPED 3
/*!<Target is below minimum detection threshold. */
#define  VL53LX_RANGESTATUS_OUTOFBOUNDS_FAIL      4
/*!<Phase out of valid limits -  different to a wrap exit. */
#define  VL53LX_RANGESTATUS_HARDWARE_FAIL     5
/*!<Hardware fail. */
#define  VL53LX_RANGESTATUS_RANGE_VALID_NO_WRAP_CHECK_FAIL  6
/*!<The Range is valid but the wraparound check has not been done. */
#define VL53LX_RANGESTATUS_WRAP_TARGET_FAIL     7
/*!<Wrapped target - no matching phase in other VCSEL period timing. */
#define VL53LX_RANGESTATUS_PROCESSING_FAIL      8
/*!<Internal algo underflow or overflow in lite ranging. */
#define VL53LX_RANGESTATUS_XTALK_SIGNAL_FAIL      9
/*!<Specific to lite ranging. */
#define VL53LX_RANGESTATUS_SYNCRONISATION_INT     10
/*!<1st interrupt when starting ranging in back to back mode. Ignore data. */
#define VL53LX_RANGESTATUS_RANGE_VALID_MERGED_PULSE   11
/*!<All Range ok but object is result of multiple pulses merging together.
 * Used by RQL for merged pulse detection
 */
#define VL53LX_RANGESTATUS_TARGET_PRESENT_LACK_OF_SIGNAL  12
/*!<Used  by RQL  as different to phase fail. */
#define VL53LX_RANGESTATUS_MIN_RANGE_FAIL     13
/*!<Unexpected error in SPAD Array.*/
#define VL53LX_RANGESTATUS_RANGE_INVALID      14
/*!<lld returned valid range but negative value ! */
#define  VL53LX_RANGESTATUS_NONE        255
/*!<No Update. */

/** @} VL53LX_define_RangeStatus_group */


/** @brief  Contains the Internal data of the Bare Driver
 */

typedef struct {
  VL53LX_LLDriverData_t   LLData;
  /*!< Low Level Driver data structure */

  VL53LX_LLDriverResults_t llresults;
  /*!< Low Level Driver data structure */

  VL53LX_DeviceParameters_t CurrentParameters;
  /*!< Current Device Parameter */

} VL53LX_DevData_t;


/* MACRO Definitions */
/** @defgroup VL53LX_define_GeneralMacro_group General Macro Defines
 *  General Macro Defines
 *  @{
 */

/* Defines */
#define VL53LX_SETPARAMETERFIELD(Dev, field, value) \
  (VL53LXDevDataSet(Dev, CurrentParameters.field, value))

#define VL53LX_GETPARAMETERFIELD(Dev, field, variable) \
  (variable = VL53LXDevDataGet(Dev, CurrentParameters).field)

#define VL53LX_SETARRAYPARAMETERFIELD(Dev, field, index, value) \
  (VL53LXDevDataSet(Dev, CurrentParameters.field[index], value))

#define VL53LX_GETARRAYPARAMETERFIELD(Dev, field, index, variable) \
  (variable = VL53LXDevDataGet(Dev, CurrentParameters).field[index])

#define VL53LX_SETDEVICESPECIFICPARAMETER(Dev, field, value) \
  (VL53LXDevDataSet(Dev, DeviceSpecificParameters.field, value))

#define VL53LX_GETDEVICESPECIFICPARAMETER(Dev, field) \
  (VL53LXDevDataGet(Dev, DeviceSpecificParameters).field)


#define VL53LX_FIXPOINT1616TOFIXPOINT44(Value) \
  (uint16_t)((Value>>12)&0xFFFF)
#define VL53LX_FIXPOINT44TOFIXPOINT1616(Value) \
  (FixPoint1616_t)((uint32_t)Value<<12)

#define VL53LX_FIXPOINT1616TOFIXPOINT72(Value) \
  (uint16_t)((Value>>14)&0xFFFF)
#define VL53LX_FIXPOINT72TOFIXPOINT1616(Value) \
  (FixPoint1616_t)((uint32_t)Value<<14)

#define VL53LX_FIXPOINT1616TOFIXPOINT97(Value) \
  (uint16_t)((Value>>9)&0xFFFF)
#define VL53LX_FIXPOINT97TOFIXPOINT1616(Value) \
  (FixPoint1616_t)((uint32_t)Value<<9)

#define VL53LX_FIXPOINT1616TOFIXPOINT88(Value) \
  (uint16_t)((Value>>8)&0xFFFF)
#define VL53LX_FIXPOINT88TOFIXPOINT1616(Value) \
  (FixPoint1616_t)((uint32_t)Value<<8)

#define VL53LX_FIXPOINT1616TOFIXPOINT412(Value) \
  (uint16_t)((Value>>4)&0xFFFF)
#define VL53LX_FIXPOINT412TOFIXPOINT1616(Value) \
  (FixPoint1616_t)((uint32_t)Value<<4)

#define VL53LX_FIXPOINT1616TOFIXPOINT313(Value) \
  (uint16_t)((Value>>3)&0xFFFF)
#define VL53LX_FIXPOINT313TOFIXPOINT1616(Value) \
  (FixPoint1616_t)((uint32_t)Value<<3)

#define VL53LX_FIXPOINT1616TOFIXPOINT08(Value) \
  (uint8_t)((Value>>8)&0x00FF)
#define VL53LX_FIXPOINT08TOFIXPOINT1616(Value) \
  (FixPoint1616_t)((uint32_t)Value<<8)

#define VL53LX_FIXPOINT1616TOFIXPOINT53(Value) \
  (uint8_t)((Value>>13)&0x00FF)
#define VL53LX_FIXPOINT53TOFIXPOINT1616(Value) \
  (FixPoint1616_t)((uint32_t)Value<<13)

#define VL53LX_FIXPOINT1616TOFIXPOINT102(Value) \
  (uint16_t)((Value>>14)&0x0FFF)
#define VL53LX_FIXPOINT102TOFIXPOINT1616(Value) \
  (FixPoint1616_t)((uint32_t)Value<<14)

#define VL53LX_FIXPOINT1616TOFIXPOINT142(Value) \
  (uint16_t)((Value>>14)&0xFFFF)
#define VL53LX_FIXPOINT142TOFIXPOINT1616(Value) \
  (FixPoint1616_t)((uint32_t)Value<<14)

#define VL53LX_FIXPOINT1616TOFIXPOINT160(Value) \
  (uint16_t)((Value>>16)&0xFFFF)
#define VL53LX_FIXPOINT160TOFIXPOINT1616(Value) \
  (FixPoint1616_t)((uint32_t)Value<<16)

#define VL53LX_MAKEUINT16(lsb, msb) (uint16_t)((((uint16_t)msb)<<8) + \
    (uint16_t)lsb)

#ifndef SUPPRESS_UNUSED_WARNING
#define SUPPRESS_UNUSED_WARNING(x) ((void) (x))
#endif

/** @} VL53LX_define_GeneralMacro_group */

/** @} VL53LX_globaldefine_group */




/* vl53lx_xtalk_private_structs.h */


#define VL53LX_D_012  4









typedef struct {





  uint32_t VL53LX_p_061[VL53LX_D_012];



  int16_t  VL53LX_p_059;


  int16_t  VL53LX_p_060;



  VL53LX_histogram_bin_data_t VL53LX_p_056;


  VL53LX_histogram_bin_data_t VL53LX_p_057;




  uint32_t VL53LX_p_058;



  uint32_t VL53LX_p_062[VL53LX_XTALK_HISTO_BINS];



} VL53LX_xtalk_algo_data_t;


/*vl53lx_platform_user_data*/

#include <stdlib.h>
//#include "Wire.h"
/*

typedef struct {
  VL53LX_DevData_t   Data;
  //!< Low Level Driver data structure 
  uint8_t   i2c_slave_address;
  uint8_t   comms_type;
  uint16_t  comms_speed_khz;
  vl53L1X_DevI2C *I2cHandle;
  uint8_t   I2cDevAddr;
  int     Present;
  int   Enabled;
  int LoopState;
  int FirstStreamCountZero;
  int   Idle;
  int   Ready;
  uint8_t RangeStatus;
  FixPoint1616_t SignalRateRtnMegaCps;
  VL53LX_DeviceState   device_state;  //!< Device State 
} VL53LX_Dev_t;

typedef VL53LX_Dev_t *VL53LX_DEV;
*/
/**
 * @def VL53LXDevDataGet
 * @brief Get ST private structure @a VL53LX_DevData_t data access
 *
 * @param Dev       Device Handle
 * @param field     ST structure field name
 * It maybe used and as real data "ref" not just as "get" for sub-structure item
 * like VL53L1DevDataGet(FilterData.field)[i] or
 * VL53L1DevDataGet(FilterData.MeasurementIndex)++
 */
#define VL53LXDevDataGet(Dev, field) (Dev->Data.field)

/**
 * @def VL53LXDevDataSet(Dev, field, data)
 * @brief  Set ST private structure @a VL53LX_DevData_t data field
 * @param Dev       Device Handle
 * @param field     ST structure field name
 * @param data      Data to be set
 */
#define VL53LXDevDataSet(Dev, field, data) ((Dev->Data.field) = (data))

#define PALDevDataGet(Dev, field) (Dev->Data.field)

#define PALDevDataSet(Dev, field, VL53LX_PRM_00005) (Dev->Data.field)=(VL53LX_PRM_00005)

#define VL53LXDevStructGetLLDriverHandle(Dev) (&Dev -> Data.LLData)

#define VL53LXDevStructGetLLResultsHandle(Dev) (&Dev -> Data.llresults)


/* vl53lx_hist_map.h */


#define VL53LX_HISTOGRAM_CONFIG__OPCODE_SEQUENCE_0 \
      VL53LX_SIGMA_ESTIMATOR__EFFECTIVE_PULSE_WIDTH_NS

#define VL53LX_HISTOGRAM_CONFIG__OPCODE_SEQUENCE_1 \
        VL53LX_SIGMA_ESTIMATOR__EFFECTIVE_AMBIENT_WIDTH_NS

#define VL53LX_HISTOGRAM_CONFIG__OPCODE_SEQUENCE_2 \
        VL53LX_SIGMA_ESTIMATOR__SIGMA_REF_MM

#define VL53LX_HISTOGRAM_CONFIG__AMB_THRESH_HIGH \
        VL53LX_ALGO__RANGE_IGNORE_THRESHOLD_MCPS




#define VL53LX_RESULT__HISTOGRAM_BIN_0_2                               0x008E
#define VL53LX_RESULT__HISTOGRAM_BIN_0_1                               0x008F
#define VL53LX_RESULT__HISTOGRAM_BIN_0_0                               0x0090

#define VL53LX_RESULT__HISTOGRAM_BIN_23_2                              0x00D3
#define VL53LX_RESULT__HISTOGRAM_BIN_23_1                              0x00D4
#define VL53LX_RESULT__HISTOGRAM_BIN_23_0                              0x00D5

#define VL53LX_RESULT__HISTOGRAM_BIN_23_0_MSB                          0x00D9
#define VL53LX_RESULT__HISTOGRAM_BIN_23_0_LSB                          0x00DA



#define VL53LX_HISTOGRAM_BIN_DATA_I2C_INDEX       \
  VL53LX_RESULT__INTERRUPT_STATUS
#define VL53LX_HISTOGRAM_BIN_DATA_I2C_SIZE_BYTES  \
  (VL53LX_RESULT__HISTOGRAM_BIN_23_0_LSB - \
    VL53LX_RESULT__INTERRUPT_STATUS + 1)


/* vl53lx_nvm_structs.h */

typedef struct {

  uint16_t  result__actual_effective_rtn_spads;
  uint8_t   ref_spad_array__num_requested_ref_spads;
  uint8_t   ref_spad_array__ref_location;
  uint16_t  result__peak_signal_count_rate_rtn_mcps;
  uint16_t  result__ambient_count_rate_rtn_mcps;
  uint16_t  result__peak_signal_count_rate_ref_mcps;
  uint16_t  result__ambient_count_rate_ref_mcps;
  uint16_t  measured_distance_mm;
  uint16_t  measured_distance_stdev_mm;
} VL53LX_decoded_nvm_fmt_range_data_t;


typedef struct {

  char      nvm__fmt__fgc[19];
  uint8_t   nvm__fmt__test_program_major;
  uint8_t   nvm__fmt__test_program_minor;
  uint8_t   nvm__fmt__map_major;
  uint8_t   nvm__fmt__map_minor;
  uint8_t   nvm__fmt__year;
  uint8_t   nvm__fmt__month;
  uint8_t   nvm__fmt__day;
  uint8_t   nvm__fmt__module_date_phase;
  uint16_t  nvm__fmt__time;
  uint8_t   nvm__fmt__tester_id;
  uint8_t   nvm__fmt__site_id;
  uint8_t   nvm__ews__test_program_major;
  uint8_t   nvm__ews__test_program_minor;
  uint8_t   nvm__ews__probe_card_major;
  uint8_t   nvm__ews__probe_card_minor;
  uint8_t   nvm__ews__tester_id;
  char      nvm__ews__lot[8];
  uint8_t   nvm__ews__wafer;
  uint8_t   nvm__ews__xcoord;
  uint8_t   nvm__ews__ycoord;
} VL53LX_decoded_nvm_fmt_info_t;


typedef struct {

  uint8_t   nvm__ews__test_program_major;
  uint8_t   nvm__ews__test_program_minor;
  uint8_t   nvm__ews__probe_card_major;
  uint8_t   nvm__ews__probe_card_minor;
  uint8_t   nvm__ews__tester_id;
  char      nvm__ews__lot[8];
  uint8_t   nvm__ews__wafer;
  uint8_t   nvm__ews__xcoord;
  uint8_t   nvm__ews__ycoord;
} VL53LX_decoded_nvm_ews_info_t;


typedef struct {
  uint8_t   nvm__identification_model_id;
  uint8_t   nvm__identification_module_type;
  uint8_t   nvm__identification_revision_id;
  uint16_t  nvm__identification_module_id;
  uint8_t   nvm__i2c_valid;
  uint8_t   nvm__i2c_device_address_ews;
  uint16_t  nvm__ews__fast_osc_frequency;
  uint8_t   nvm__ews__fast_osc_trim_max;
  uint8_t   nvm__ews__fast_osc_freq_set;
  uint16_t  nvm__ews__slow_osc_calibration;
  uint16_t  nvm__fmt__fast_osc_frequency;
  uint8_t   nvm__fmt__fast_osc_trim_max;
  uint8_t   nvm__fmt__fast_osc_freq_set;
  uint16_t  nvm__fmt__slow_osc_calibration;
  uint8_t   nvm__vhv_config_unlock;
  uint8_t   nvm__ref_selvddpix;
  uint8_t   nvm__ref_selvquench;
  uint8_t   nvm__regavdd1v2_sel;
  uint8_t   nvm__regdvdd1v2_sel;
  uint8_t   nvm__vhv_timeout__macrop;
  uint8_t   nvm__vhv_loop_bound;
  uint8_t   nvm__vhv_count_threshold;
  uint8_t   nvm__vhv_offset;
  uint8_t   nvm__vhv_init_enable;
  uint8_t   nvm__vhv_init_value;
  uint8_t   nvm__laser_safety_vcsel_trim_ll;
  uint8_t   nvm__laser_safety_vcsel_selion_ll;
  uint8_t   nvm__laser_safety_vcsel_selion_max_ll;
  uint8_t   nvm__laser_safety_mult_ll;
  uint8_t   nvm__laser_safety_clip_ll;
  uint8_t   nvm__laser_safety_vcsel_trim_ld;
  uint8_t   nvm__laser_safety_vcsel_selion_ld;
  uint8_t   nvm__laser_safety_vcsel_selion_max_ld;
  uint8_t   nvm__laser_safety_mult_ld;
  uint8_t   nvm__laser_safety_clip_ld;
  uint8_t   nvm__laser_safety_lock_byte;
  uint8_t   nvm__laser_safety_unlock_byte;
  uint8_t   nvm__ews__spad_enables_rtn[VL53LX_RTN_SPAD_BUFFER_SIZE];
  uint8_t   nvm__ews__spad_enables_ref__loc1[VL53LX_REF_SPAD_BUFFER_SIZE];
  uint8_t   nvm__ews__spad_enables_ref__loc2[VL53LX_REF_SPAD_BUFFER_SIZE];
  uint8_t   nvm__ews__spad_enables_ref__loc3[VL53LX_REF_SPAD_BUFFER_SIZE];
  uint8_t   nvm__fmt__spad_enables_rtn[VL53LX_RTN_SPAD_BUFFER_SIZE];
  uint8_t   nvm__fmt__spad_enables_ref__loc1[VL53LX_REF_SPAD_BUFFER_SIZE];
  uint8_t   nvm__fmt__spad_enables_ref__loc2[VL53LX_REF_SPAD_BUFFER_SIZE];
  uint8_t   nvm__fmt__spad_enables_ref__loc3[VL53LX_REF_SPAD_BUFFER_SIZE];
  uint8_t   nvm__fmt__roi_config__mode_roi_centre_spad;
  uint8_t   nvm__fmt__roi_config__mode_roi_x_size;
  uint8_t   nvm__fmt__roi_config__mode_roi_y_size;
  uint8_t   nvm__fmt__ref_spad_apply__num_requested_ref_spad;
  uint8_t   nvm__fmt__ref_spad_man__ref_location;
  uint16_t  nvm__fmt__mm_config__inner_offset_mm;
  uint16_t  nvm__fmt__mm_config__outer_offset_mm;
  uint16_t  nvm__fmt__algo_part_to_part_range_offset_mm;
  uint16_t  nvm__fmt__algo__crosstalk_compensation_plane_offset_kcps;
  uint16_t  nvm__fmt__algo__crosstalk_compensation_x_plane_gradient_kcps;
  uint16_t  nvm__fmt__algo__crosstalk_compensation_y_plane_gradient_kcps;
  uint8_t   nvm__fmt__spare__host_config__nvm_config_spare_0;
  uint8_t   nvm__fmt__spare__host_config__nvm_config_spare_1;
  uint8_t   nvm__customer_space_programmed;
  uint8_t   nvm__cust__i2c_device_address;
  uint8_t   nvm__cust__ref_spad_apply__num_requested_ref_spad;
  uint8_t   nvm__cust__ref_spad_man__ref_location;
  uint16_t  nvm__cust__mm_config__inner_offset_mm;
  uint16_t  nvm__cust__mm_config__outer_offset_mm;
  uint16_t  nvm__cust__algo_part_to_part_range_offset_mm;
  uint16_t  nvm__cust__algo__crosstalk_compensation_plane_offset_kcps;
  uint16_t  nvm__cust__algo__crosstalk_compensation_x_plane_gradient_kcps;
  uint16_t  nvm__cust__algo__crosstalk_compensation_y_plane_gradient_kcps;
  uint8_t   nvm__cust__spare__host_config__nvm_config_spare_0;
  uint8_t   nvm__cust__spare__host_config__nvm_config_spare_1;
  VL53LX_optical_centre_t              fmt_optical_centre;
  VL53LX_cal_peak_rate_map_t           fmt_peak_rate_map;
  VL53LX_additional_offset_cal_data_t  fmt_add_offset_data;

  VL53LX_decoded_nvm_fmt_range_data_t
  fmt_range_data[VL53LX_NVM_MAX_FMT_RANGE_DATA];

  VL53LX_decoded_nvm_fmt_info_t        fmt_info;
  VL53LX_decoded_nvm_ews_info_t        ews_info;

} VL53LX_decoded_nvm_data_t;



#ifdef __cplusplus
}
#endif

#endif /* _VL53LX_DEF_H_ */