#include "mbed.h"
#include "EthernetInterface.h"
#include "Servo.h"

//internal led
DigitalOut rled(LED1,1);
DigitalOut gled(LED2,1);
DigitalOut bled(LED3,1);

//gpio
DigitalOut wealed(D2);
DigitalOut busled_00(D15);
DigitalOut busled_01(D14);
DigitalOut busled_02(D13);
DigitalOut busled_03(D12);
DigitalOut busled_10(D11);
DigitalOut busled_11(D10);
DigitalOut busled_12(D9);
DigitalOut busled_13(D8);
DigitalOut busled_20(D7);
DigitalOut busled_21(D6);
DigitalOut busled_22(D5);
DigitalOut busled_23(D4);

int main()
{
    int phy_link;
    printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x09}; 
    
    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP
    
    eth.connect();
    
    //phy link
     do{
        phy_link = eth.ethernet_link();
        printf("...");
        wait(2);
     }while(!phy_link);
     printf("PHY_LINK_OK\n");
     printf("IP Address is %s\r\n", eth.getIPAddress());
     
    //get info
    char buffer_wea[1000];
    char buffer_0[1000];
    char buffer_1[1000];
    char buffer_2[1000];
    int ret_wea;
    int ret_0;
    int ret_1;
    int ret_2;
    
    //weather
    char http_cmd_wea[] = "GET /data/2.5/weather?q=Seongnam,kr HTTP/1.0\n\n";
    

    //BUS
    //char http_cmd[] = "GET /ws/rest/busarrivalservice/station?serviceKey=test&stationId=206000606 \n\n";
    char http_cmd_0[] = "GET /ws/rest/busarrivalservice?serviceKey=test&routeId=204000039&stationId=206000606 \n\n"; //330
    char http_cmd_1[] = "GET /ws/rest/busarrivalservice?serviceKey=test&routeId=204000044&stationId=206000606 \n\n"; //350
    char http_cmd_2[] = "GET /ws/rest/busarrivalservice?serviceKey=test&routeId=204000079&stationId=206000606 \n\n"; //380
    

    while(1)
    {
    //TCP socket[weather] connect
    TCPSocketConnection sock_wea;
    sock_wea.connect("api.openweathermap.org", 80);
    printf("Socket[weather] connected\n");

    sock_wea.send_all(http_cmd_wea, sizeof(http_cmd_wea)-1);

    while (true)
    {
        ret_wea = sock_wea.receive(buffer_wea, sizeof(buffer_wea)-1);
        if (ret_wea <= 0)
            printf("fail\n");
            break;

        buffer_wea[ret_wea] = '\0';
    }        
        
    //TCP socket0 connect 
    TCPSocketConnection sock_0;
    sock_0.connect("openapi.gbis.go.kr", 80);
    printf("Socket0 connected\n");
    
    sock_0.send_all(http_cmd_0, sizeof(http_cmd_0)-1);
    
    while (true)
    {
        ret_0 = sock_0.receive(buffer_0, sizeof(buffer_0)-1);
        if (ret_0 <= 0)
        printf("fail\n");
        break;
        
        buffer_0[ret_0] = '\0';
    }

    
    //TCP socket1 connect
    TCPSocketConnection sock_1;
    sock_1.connect("openapi.gbis.go.kr", 80);
    printf("Socket1 connected\n");
    
    sock_1.send_all(http_cmd_1, sizeof(http_cmd_1)-1);
    while (true)
    {
        ret_1 = sock_1.receive(buffer_1, sizeof(buffer_1)-1);
        if (ret_1 <= 0)
        printf("fail\n");
        break;
        
        buffer_1[ret_1] = '\0';
    }

    
    //TCP socket2 connect 
    TCPSocketConnection sock_2;
    sock_2.connect("openapi.gbis.go.kr", 80);
    printf("Socket2 connected\n");
    
    sock_2.send_all(http_cmd_2, sizeof(http_cmd_2)-1);
    
    while (true)
    {
        ret_2 = sock_2.receive(buffer_2, sizeof(buffer_2)-1);
        if (ret_2 <= 0)
        printf("fail\n");
        break;
        
        buffer_2[ret_0] = '\0';
    }

    
    //print
    //printf("\nWeather\n\n Received %d chars from server=> \n%s\n\n", ret_wea, buffer_wea);
    //wait(2);
    //printf("\n330\n\n Received %d chars from server=> \n%s\n\n", ret_0, buffer_0);
    //wait(2);
    //printf("\n350\n\n Received %d chars from server=> \n%s\n\n", ret_1, buffer_1);
    //wait(2);
    //printf("\n380\n\n Received %d chars from server=> \n%s\n\n", ret_2, buffer_2);
    //wait(2);


    //get weather, city, tempurature
    char *weather;
    char *city;
    char *tempure;

    char weather_stu[3];
    char tempure_data[6];

    int weather_id;
    int weather_id_[3];

    int tempure_d;
    int tempure_[3];

    weather = strstr(buffer_wea, "id");
    printf("\nWeather ID=> %.3s\n", weather+4);
    for(int i=0; i<3; i++)
    {
        weather_stu[i] = (weather[i+4]);
        weather_id_[i] = weather_stu[i]-'0';
        //printf("%c", weather_stu[i]);
    }
    weather_id = weather_id_[0]*100+weather_id_[1]*10*weather_id_[2];
    //printf("%d\n", weather_id);

    city = strstr(buffer_wea, "name");
    printf("City Name=> %.8s\n", city + 7);

    tempure = strstr(buffer_wea, "temp");
    printf("Tempurature=> %.3sK\n", tempure + 6);
    for(int i=0; i<3; i++)
    {
        tempure_data[i] = (tempure[i+6]);
        tempure_[i] = tempure_data[i]-'0';
        //printf("%c", tempure_data[i]);
    }
    tempure_d = tempure_[0]*100+tempure_[1]*10+tempure_[2];

    printf("Tempurature=> %dC\n\n", (tempure_d - 273));


    //weather display
    if((weather_id>=200)&&(weather_id<300))
    {
        printf("<<< Thunderstom >>>\n");
        printf("<<< You need an umbrella >>>\n");
        //rled = 1;gled = 0;bled = 0;
        wealed = 1;
    }
    else if((weather_id>=300)&&(weather_id<400))
    {
        printf("<<< Drizzle >>>\n");
        printf("<<< You need an umbrella >>>\n");
        //rled = 1;gled = 0;bled = 0;
        wealed = 1;
    }
    else if((weather_id>=500)&&(weather_id<600))
    {
        printf("<<< Rain >>>\n");
        printf("<<< You need an umbrella >>>\n");
        //rled = 1;gled = 0;bled = 0;
        wealed = 1;
    }
    else if((weather_id>=600)&&(weather_id<700))
    {
         printf("<<< Snow >>>\n");
         printf("<<< You need an umbrella >>>\n");
         //rled = 1;gled = 0;bled = 0;
         wealed = 1;
    }
    else
    {
         printf("<<< You don't need an umbrella >>>\n");
         //rled = 0;gled = 1;bled = 0;
         wealed = 0;
    }
 
 
    //get location
    char *location_0;
    char *location_1;
    char *location_2;
    
    char loca_0[2];
    char loca_1[2];
    char loca_2[2];
    
    int INT_location_0[2];
    int INT_location_1[2];
    int INT_location_2[2];
    
    int S_location_0;
    int S_location_1;
    int S_location_2;
    
    printf("\n<<< locationNo1 >>>\n");
    
    location_0 = strstr(buffer_0, "<locationNo1>");
    printf("330 => %.2s\n", location_0+13);
    
    location_1 = strstr(buffer_1, "<locationNo1>");
    printf("350 => %.2s\n", location_1+13);
    
    location_2 = strstr(buffer_2, "<locationNo1>");
    printf("380 => %.2s\n", location_1+13);


    //330 display  
    for(int i=0; i<2; i++)
    {
        loca_0[i] = (location_0[i+13]);
        INT_location_0[i] = loca_0[i]-'0';
    }
    
    printf("\n<<< Remaining station >>>\n");
    
    if(INT_location_0[1]==12)
    {
    printf("330 => %d\n",INT_location_0[0]);
    S_location_0 = INT_location_0[0];
    }
    else
    {
    printf("330 => %d\n",INT_location_0[0]*10+INT_location_0[1]);
    S_location_0 = INT_location_0[0]*10+INT_location_0[1];
    }
    
    //330 position sign
    //if(S_location_0>=5)
    //{
    //    rled=0;bled=1;gled=1;
    //}
    //else if (S_location_0==4)
    //{
    //    rled=1;bled=0;gled=0;
    //}
    //else if (S_location_0==3)
    if (S_location_0>=4)
    {
        //rled=1;bled=1;gled=0;
        busled_00=0;busled_01=0;busled_02=0;busled_03=1;
    }
    else if (S_location_0==3)
    {
        //rled=1;bled=0;gled=1;
        busled_00=0;busled_01=0;busled_02=1;busled_03=0;
    }
    else if (S_location_0==2)
    {
        //rled=0;bled=0;gled=0;
        busled_00=0;busled_01=1;busled_02=0;busled_03=0;
    }
    else if (S_location_0==1)
    {
        //rled=1;bled=1;gled=1;
        busled_00=1;busled_01=0;busled_02=0;busled_03=0;
    }
    else
    {
        busled_00=0;busled_01=0;busled_02=0;busled_03=0;
    }
    

    //350 display  
    for(int i=0; i<2; i++)
    {
        loca_1[i] = (location_1[i+13]);
        INT_location_1[i] = loca_1[i]-'0';
    }
    
    if(INT_location_1[1]==12)
    {
    printf("350 => %d\n",INT_location_1[0]);
    S_location_1 = INT_location_1[0];
    }
    else
    {
    printf("350 => %d\n",INT_location_1[0]*10+INT_location_1[1]);
    S_location_1 = INT_location_1[0]*10+INT_location_1[1];
    }
    
    //350 position sign
    if (S_location_1>=4)
    {
        //rled=1;bled=1;gled=0;
        busled_10=0;busled_11=0;busled_12=0;busled_13=1;
    }
    else if (S_location_1==3)
    {
        //rled=1;bled=0;gled=1;
        busled_10=0;busled_11=0;busled_12=1;busled_13=0;
    }
    else if (S_location_1==2)
    {
        //rled=0;bled=0;gled=0;
        busled_10=0;busled_11=1;busled_12=0;busled_13=0;
    }
    else if (S_location_1==1)
    {
        //rled=1;bled=1;gled=1;
        busled_10=1;busled_11=0;busled_12=0;busled_13=0;
    }
    else
    {
        busled_10=0;busled_11=0;busled_12=0;busled_13=0;
    }
    
    
    //380 display  
    for(int i=0; i<2; i++)
    {
        loca_2[i] = (location_2[i+13]);
        INT_location_2[i] = loca_2[i]-'0';
    }
    
    if(INT_location_2[1]==12)
    {
    printf("380 => %d\n",INT_location_2[0]);
    S_location_2 = INT_location_2[0];
    }
    else
    {
    printf("380 => %d\n",INT_location_2[0]*10+INT_location_2[1]);
    S_location_2 = INT_location_2[0]*10+INT_location_2[1];
    }
    
    //380 position sign
    if (S_location_2>=4)
    {
        //rled=1;bled=1;gled=0;
        busled_20=0;busled_21=0;busled_22=0;busled_23=1;
    }
    else if (S_location_2==3)
    {
        //rled=1;bled=0;gled=1;
        busled_20=0;busled_21=0;busled_22=1;busled_23=0;
    }
    else if (S_location_2==2)
    {
        //rled=0;bled=0;gled=0;
        busled_20=0;busled_21=1;busled_22=0;busled_23=0;
    }
    else if (S_location_2==1)
    {
        //rled=1;bled=1;gled=1;
        busled_20=1;busled_21=0;busled_22=0;busled_23=0;
    }
    else
    {
        busled_20=0;busled_21=0;busled_22=0;busled_23=0;
    }
    

    sock_wea.close();
    sock_0.close();
    sock_1.close();
    sock_2.close();

    eth.disconnect();
    printf("\nSocket disconnected\n\n");
    
    wait(12);
   };

}