#include "mbed.h"
#include "EthernetInterface.h"
#include "Servo.h"

DigitalOut bled(D6);
DigitalOut gled(D5);
DigitalOut rled(D4);

Servo myservo(D15);

int main() {
   
    int phy_link;
    printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02}; 
    
    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP
    
    while(1){
    
    eth.connect();
    
    /* phy link */
     do{
        phy_link = eth.ethernet_link();
        printf("...");
        wait(2);
     }while(!phy_link);
     printf("\r\n");
     
    printf("IP Address is %s\r\n", eth.getIPAddress());
    
    /* TCP socket connect */
    TCPSocketConnection sock;
    sock.connect("api.openweathermap.org", 80);
    
    /* weather */
    char http_cmd[] = "GET /data/2.5/weather?q=Seoul,kr HTTP/1.0\n\n";
    //char http_cmd[] = "GET /data/2.5/weather?q=London,uk HTTP/1.0\n\n";
    //char http_cmd[] = "GET /data/2.5/weather?q=Berlin,de HTTP/1.0\n\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
    /* get info */
    char buffer[420];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        printf("Received %d chars from server: %s\n", ret, buffer);     
    }

    /* get weather, city, tempurature */
    char *weather;
    char *city;
    char *tempure;
    
    char weather_stu[3];
    char city_name[6];
    char tempure_data[6];
    
   weather = strstr(buffer, "main");
        printf("%.4s\n", weather + 7);
        for(int i=0; i<3;i++){
            weather_stu[i] = weather[i+7];
            printf("%c",weather_stu[i]);
       }
   
   city = strstr(buffer, "name");
        printf("%.6s\n", city + 7);
        for(int k=0; k<6;k++){
            city_name[k] = city[k+7];
            printf("%c",city_name[k]);
        }
 
   tempure = strstr(buffer, "temp");
        printf("%.3s\n", tempure + 6);
        for(int j=0; j<6;j++){
            tempure_data[j] = tempure[j+6];
            printf("%c",tempure_data[j]);
        }
        
        /*tempurature display */ 
        float data[2]={0};
        data[0] = tempure_data[1]-'7';
        data[1] = tempure_data[2]-'3';
        
        myservo = (data[0]*10+data[1])/40;

        printf("%f",(data[0]*10+data[1])/40);
   
   /* weather display */
   if(strcmp(weather_stu,"Clo")==0) {
        rled = 1; 
        gled = 1; 
        bled = 1;
    }else if(strcmp(weather_stu,"Rai")==0) {
        rled = 0; 
        gled = 0;
        bled = 1; 
    }else if(strcmp(weather_stu,"Cle")==0){
        rled = 1; 
        gled = 1;
        bled = 0; 
    }else if(strcmp(weather_stu,"Mis")==0){
        rled = 1;
        gled = 0;
        bled = 1;
    }else if(strcmp(weather_stu,"Haz")==0) {
        rled = 1; 
        gled = 1; 
        bled = 1;
    }else if(strcmp(weather_stu,"Fog")==0){
        rled = 1;
        gled = 0;
        bled = 1;
    }else {
        rled = 0;
        gled = 0;
        bled = 0;
    }

    sock.close();
    
    eth.disconnect();
    
    wait(60.0);
   };

}