#include "mbed.h"
#include "HIDScope.h"

//Define objects
AnalogIn    EMGData_1( A0 );
AnalogIn    emg1( A1 );

Ticker      sample_timer;
HIDScope    scope( 2 );
DigitalOut  led(LED1);

volatile float EMGData_1_HiFil=0;   //EMG Hi Filtered
volatile float EMGData_1_HiFilAbs=0;    //EMG Hi Filtered abs
volatile float EMGData_1_HiLoFil=0;   //EMG HiLo Filtered

double f_v1_EMG_1_Hi=0, f_v2_EMG_1_Hi=0; // set Hi filter variables EMG 1
const double M1_F_A1_EMG_Hi=-1.561018075800718, M1_F_A2_EMG_Hi=0.641351538057563, M1_F_B0_EMG_Hi=0.800592403464570, 
M1_F_B1_EMG_Hi=-1.601184806929141, M1_F_B2_EMG_Hi=0.800592403464570;// set EMG filter coefficients 

double f_v1_EMG_1_Lo=0, f_v2_EMG_1_Lo=0; // set Lo filter variables EMG 1
const double M1_F_A1_EMG_Lo=-1.561018075800718, M1_F_A2_EMG_Lo=0.641351538057563, M1_F_B0_EMG_Lo=0.800592403464570, 
M1_F_B1_EMG_Lo=-1.601184806929141, M1_F_B2_EMG_Lo=0.800592403464570;    // set EMG filter coefficients 

/** Sample function
 * this function samples the emg and sends it to HIDScope
 **/
 
//IIRFilter
double IIRFilter(double u, double &v1, double &v2, const double a1, 
const double a2, const double b0, const double b1, const double b2){
    double v = u-a1*v1-a2*v2;
    double y = b0*v + b1*v1 + b2*v2;
    v2=v1; v1=v;
    return y;
}


void sample()
{
    EMGData_1_HiFil = IIRFilter(EMGData_1, f_v1_EMG_1_Hi, f_v2_EMG_1_Hi, M1_F_A1_EMG_Hi, M1_F_A2_EMG_Hi, M1_F_B0_EMG_Hi, M1_F_B1_EMG_Hi, M1_F_B2_EMG_Hi);
    EMGData_1_HiFilAbs = abs(EMGData_1_HiFil);
    EMGData_1_HiLoFil = IIRFilter(EMGData_1_HiFilAbs, f_v1_EMG_1_Lo, f_v2_EMG_1_Lo, M1_F_A1_EMG_Lo, M1_F_A2_EMG_Lo, M1_F_B0_EMG_Lo, M1_F_B1_EMG_Lo, M1_F_B2_EMG_Lo);
    /* Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope' */
    scope.set(0, EMGData_1);                            // set scope channel 0 EMG
    scope.set(1, EMGData_1_HiLoFil);                           // set scope channel 1 EMG filtered
    /* Repeat the step above if required for more channels of required (channel 0 up to 5 = 6 channels) 
    *  Ensure that enough channels are available (HIDScope scope( 2 ))
    *  Finally, send all channels to the PC at once */
    scope.send();
    /* To indicate that the function is working, the LED is toggled */
    led = !led;
}

int main()
{   
    /**Attach the 'sample' function to the timer 'sample_timer'.
    * this ensures that 'sample' is executed every... 0.002 seconds = 500 Hz
    */
    sample_timer.attach(&sample, 0.005);

    /*empty loop, sample() is executed periodically*/
    while(1) {}
}