#include "mbed.h"

static const float PI = 3.141592653589793238;

class IgnMod
{
private:
    Timeout ignition_timer;
    Timer t;

    DigitalOut _pin;

    int ignition_length;
    int round_time;
    int ignition_delay;

    float offset;
    float def_ignition;

    void on() {
        _pin.write(1);
        ignition_timer.attach_us(this,&IgnMod::off,ignition_length);
    }
    void off() {
        _pin.write(0);
    }

    int get_delay(int round_time) {
        int delay=0;
        int rpm=60e6/round_time;
        
        if (rpm>7000) delay=-4;
        else if (rpm>6000) delay=-4;
        else if (rpm>5000) delay=-4;
        else if (rpm>4000) delay=-4;
        else if (rpm>3000) delay=-2;
        else if (rpm>2000) delay=-2;
        else if (rpm>1000) delay=-2;
        else delay=-2;

        return round_time*(offset-def_ignition+delay)/360;
    }
public:
    IgnMod(PinName pin,int il,float of_mm, float di_mm, float h) : _pin(pin) {
        float r=h/2;
        ignition_length=il;
        offset=acos((r-of_mm)/r)*180/PI;
        def_ignition=acos((r-di_mm)/r)*180/PI;
        t.start();
    }
    void ignite() {
        round_time=t.read_us();
        t.reset();
        ignition_delay=get_delay(round_time);
        ignition_timer.attach_us(this,&IgnMod::on,ignition_delay-t.read_us());
    }
};