

//#include "EthernetInterface.h"
#include <stdlib.h>
#include <string.h>
#include "mbed.h"
#include "rtos.h" // need for main thread sleep
#include "html.h" // need for html patch working with web server
#include "bloc_io.h"
#define RADIUS  0.2F // wheel size
#define NBPOLES 8 // magnetic pole number
#define DELTA_T 0.1F // speed measurement counting period


Bloc_IO MyPLD(p25,p26,p5,p6,p7,p8,p9,p10,p23,p24);// instantiate object needed to communicate with PLD
    // analog input connected to mbed 
    // valid pmw mbed pin
AnalogIn Poig(p17);
Serial pc(USBTX, USBRX); // tx, rx
    // Top_Hall Pin
    
    
 
    
/************ persistent file parameters section *****************/
LocalFileSystem local("local");               // Create the local filesystem under the name "local"
 

  
    
    
    
    
/********************* web server section **********************************/

//var_field_t tab_balise[10];  //une balise est présente dans le squelette
int giCounter=0;// acces counting


/*********************** can bus section  ************/
         // determine message ID used to send Gaz ref over can bus
#define _CAN_DEBUG // used to debug can bus activity
//#define USE_CAN_REF // uncomment to receive gaz ref over can_bus
CAN can_port (p30, p29); // initialisation du Bus CAN sur les broches 30 (rd) et 29(td) for lpc1768 + mbed shield
bool bCan_Active=false;



DigitalOut led1(LED1); //initialisation des Leds présentes sur le micro-controleur Mbed*/
DigitalOut led2(LED2);
DigitalOut led3(LED3); // blink when can message is sent
DigitalOut led4(LED4); // blink when can message is received 

DigitalOut VALID_PWM(p21);
InterruptIn TopHall(p22);
Ticker Timode;
Ticker T; 

 
//************ local function prototypes *******************
void lecture(void);
void Init(void);
void recupD(void);
void choix(void);
void compteur(void);
void mesures(void);

char cChoix=0;
int mode;
int giRefPwm =0;
int MODE,PWM;
float val_poig ,Val_PwmPoig;
float NgazMin=0.15F, NgazMax=0.65F;
float Delta_Gaz = NgazMax - NgazMin;
int Hall,Brake,Overcurrent,Fault,Direction;
int toto ;
int reF;
int val;
int giRefPwm_av;
float vitesse;
int tophall,cptTopHall;

 
FILE* File1 = NULL;
/**************** Read persistent data from text file located on local file system ****************/



/**************** write persitant  data to text file located on local file system ****************/






//************** calibation gaz function needed to record min_gaz and max_gaz value to persistent text file  ******************


// ************top hall counting interrupt needed for speed measurement


//********************** timer interrupt for speed measurement each 100ms  *************************

    
    
    


//********************* Timer Interrupt for gaz ref management each 10ms   ********************



/********* main cgi function used to patch data to the web server thread **********************************/
void CGI_Function(void) // cgi function that patch web data to empty web page
{  
    char ma_chaine4[20]={};// needed to form html response  
    /*sprintf (ma_chaine4,"%d",iCounter);// convert speed as ascii string  Html_Patch 
    (tab_balise,0,ma_chaine4);// patch first label with dyn.string 
    iCounter++;*/

}
    
    
  /*********************** CAN BUS SECTION  **********************/
    


void CAN_REC_THREAD(void const *args)
{ int iCount,iError;

 while (bCan_Active)
 {Thread::wait(100);// wait 100ms  
    // code todo
      
    }
    
}
       
void Init()
{
  VALID_PWM.write(0);
  //recupD();
  pc.printf("\n\r");
  pc.printf("NgazMin = %f\n\r",NgazMin);
  pc.printf("NgazMax = %f\n\r",NgazMax);
  MyPLD.write(0);
  VALID_PWM.write(1);
  mode = 0;//mode auto
  Timode.attach(&choix,0.05);
  TopHall.mode(PullUp);
  TopHall.rise(&compteur);
  T.attach(&mesures,0.01);
  
}
void recupD()
{
  File1 = fopen("/local/GR2a.txt","r");
  if(File1!=NULL)
    {
      fscanf(File1,"%f %f",&NgazMin,&NgazMax);
    }
    fclose(File1);
}
  
//*************************** main function *****************************************
int main() 
{

    
    Init();
    
    //***************************************** web section ********************************************/
    //Init_Web_Server(&CGI_Function); // create and initialize tcp server socket and pass function pointer to local CGI function
    //Thread WebThread(Web_Server_Thread);// create and launch web server thread
    /********* main cgi function used to patch data to the web server thread **********************************/
    //Gen_HtmlCode_From_File("/local/pagecgi2.htm",tab_balise,1);// read and localise ^VARDEF[X] tag in empty html file
    //var_field_t tab_balise[1];  //une seule balise est présente dans le squelette html
    //ma_chaine3 = Gen_HtmlCode_From_File("a:\\pagecgi.htm",tab_balise,1); 
    //******************************************* end web section  ************************************* / 
    
    
    pc.printf("\n\r");
    
    pc.printf(" programme scooter mbed \n\r");
    
    
    
    //********************* can bus section initialisation *******************************************
    //bCan_Active=true;// needed to lauchn CAN thread
    //Thread CanThread(CAN_REC_THREAD);// create and launch can receiver  thread
    //********************* end can bus section *****************************************************
    
    
    while(cChoix!='q' and cChoix!='Q')
    {
         pc.printf(" veuillez saisir un choix parmi la liste proposee: \n\r");
         pc.printf(" m : manuel\n\r");
         pc.printf(" l : Lecture registre \n\r");
         pc.printf(" c : calibrage\n\r");
         pc.printf(" a : automatique\n\r");
         pc.printf(" q : quitter \n\r");
         
         /************* multithreading : main thread need to sleep in order to allow web response */
         while (pc.readable()==0) // determine if char availabler
         {
             Thread::wait(10);
         } // wait 10 until char available on serial input
         /************* end of main thread sleep  ****************/ 
         
          pc.scanf(" %c",&cChoix);
          switch(cChoix)
          {
                case 'm':
                    mode = 1;
                    pc.printf("Saisir une vitesse\n\r");
                    pc.scanf("%d",&PWM);
                break; 
                
                case 'l':
                lecture();
             
                break;
            
                case 'c':
            
                pc.printf("Effectuez le calibrage\n\r");
                pc.printf("Valeur mini de la poignee\n\r");
                pc.scanf("%f",&toto);
                NgazMin=Poig.read();
                pc.printf("NgazMin = %f\n\r",NgazMin);
                pc.printf("Valeur max de la poignee\n\r");
                pc.scanf("%f",&toto);
                NgazMax=Poig.read();
                pc.printf("NgazMax = %f\n\r",NgazMax);
                
                File1 = fopen("/local/GR2a.txt","w");
                if(File1!=NULL)
                {
                  fprintf(File1,"%f %f",NgazMin,NgazMax);
                }
                fclose(File1);
                
                break;
                
                case'a':
                mode =0;
                break;
            
                case 'q':
            
                VALID_PWM.write(0);
                MyPLD.write(VALID_PWM);
                
                break;
          } 
              
    } // end while
         
     //************** thread deinit *********************
     //DeInit_Web_Server();
     //bCan_Active=false;
     //CanThread=false;// close can received thread
     pc.printf(" fin programme scooter mbed \n\r");
} // end main

void lecture()// lecture des valeures de retour du PLD
{
    
    int mypld=MyPLD.read();
    Hall = mypld &0x07;
    Brake = mypld &0x20;
    Overcurrent = mypld &0x40 ;
    Fault = mypld &0x10 ;
    Direction = mypld &0x08 ;
    
    tophall=TopHall.read();
    if(tophall == 1)
    {
        compteur();
    }
    
    
    
    pc.printf("\n\r");
    pc.printf("Valeure du secteur Hall=%d\n\r",Hall);
  
     if(Direction == 0)
        pc.printf("Marche arriere\n\r");
     else
        pc.printf("Marche avant\n\r");
     
     if (Brake == 0)
        pc.printf("Frein  actif\n\r");
     else
        pc.printf("Frein non actif\n\r");
     
     if (Overcurrent == 0)
        pc.printf(" surchage\n\r");
     else
        pc.printf("Pas de surchage\n\r");
     
     if(Fault == 0)
        pc.printf("pas d'erreur de convertisseur\n\r");
     else
        pc.printf("erreur de convertisseur\n\r");
        
    pc.printf("cptTopHall = %d\n\r",cptTopHall);    
    pc.printf("Vitesse = %f\n\r",vitesse);
    
    
    
}

void choix()//fonction ticker
{
    
    int mypld=MyPLD.read();
    Brake = mypld &0x20;
    if(mode == 0)
    {
        
        val_poig = Poig.read();
        
        val = ((val_poig-NgazMin)/(NgazMax-NgazMin)*255);
        if(Brake == 0)
        {
            val = 0;
        }
        if(val > giRefPwm_av)
        {
            giRefPwm_av = giRefPwm_av + 1;
        }
        if(val < giRefPwm_av)
        {
            giRefPwm_av = val;
        }
        if(giRefPwm_av > 255)
            giRefPwm_av = 255;
        if(giRefPwm_av < 0)
            giRefPwm_av = 0;
            
    }
        
    else
        {giRefPwm_av=PWM;}
        
    MyPLD.write(giRefPwm_av);
}
void mesures()
{   
    int cpthall;
    cpthall=0;
    vitesse = cpthall*10*((2*3.14*0.21)*3.6)/120;
}
void compteur()
{
    cptTopHall++; 
}