#include "MyLed.h"

MyLed::MyLed(PinName pin)
    : led(pin)
{
    led = 0;
}

MyLed::~MyLed()
{
}

void MyLed::Set(bool s)
{
    if(s)
        led = 1;
    else
        led = 0;
}

/* public method */
void MyLed::SetBlinkPeriod(float period)
{
    ticker.detach();
    if(period==0) {
        led = 0;
    } else {
        led = !led;
        ticker.attach(callback(this,&MyLed::TickerHandler),period);
    }
}

/* private method - interrupt handler */
void MyLed::TickerHandler()
{
    led = !led;
}