#include "mbed.h"
#include "MyLed.h"
#include <string>
#include <sstream>
#include <iostream>
#include <stdio.h>
#include <stdlib.h>


#define TICKER_TIME             1.0    // ticker period (1 second)

MyLed led(LED1);                    // TO DO: implement methotds and use this class

//DigitalOut led(LED1);                  // check pin on your board
InterruptIn sw(PA_0);                  // check pin on your board

Serial pc(USBTX, USBRX,9600);          // Tx pin, Rx pin, BaudRate
Ticker ticker;                         // ticker

/* Global variables */
volatile bool btnPressed = false;
volatile bool tick = false;
volatile uint8_t counter = 0;

/* Button interrupt handler */
void RiseHandler(void)
{
//    led = !led;
    btnPressed = true;
}

/* Ticker interrupt handler */
void OnTick(void)
{
    tick = true;
    counter++;
    if(counter>60) {
        counter = 0;
    }
}
PwmOut pwm(LED1);

using namespace std;

int main()
{
    pc.printf("\r\n----- Start of application ----- \r\n");
    
    //    led = 0;
        //ticker.attach(&OnTick,TICKER_TIME);
    
    sw.rise(&RiseHandler);

    char z;
    string a;
    char buffer[128];
    buffer[0]='\0';
    uint32_t cislo;
    uint8_t period;
    int len = 0;
    int k;
    int brightness = 0;
    char pwmTxt[] = "pwm\r";
    while (true) {
        if(btnPressed) {
            pc.printf("Button was pressed. \r\n");
            btnPressed = false;
        }
        
        /*if(tick) {
            pc. printf("Counter value : %d \r\n", counter);
            tick = false;
        }*/
        
        if(pc.readable()) {
            z = pc.getc();
            buffer[len++] = z;
            buffer[len] = '\0';
            
            if(z == '\r') {
            pc.printf("%s\r\n",buffer);
            len = 0;
            
            if(strcmp(buffer,pwmTxt)==0){
                   while(1){
                        for(int brightness=0; brightness<=100; brightness+=5){
                            pwm=(brightness/100.0);
                            ThisThread::sleep_for(50); 
                        }    
                        for(int brightness=100; brightness>=0; brightness-=5){
                            pwm=(brightness/100.0);
                            ThisThread::sleep_for(50);   
                        }    
                   }    
            }
            else{
            cislo = std::atoi(buffer);
                if((cislo>=0)&&(cislo<=100)){
                    pwm.write(cislo/100.0);
                } 
                else
                    pwm.write(1.0);   
            }
            
          }
        }
    }
   
}