#include "mbed.h"
#include "MyLed.h"

#define TICKER_TIME             60.0    // ticker period (1 second)

MyLed led(LED1);                    // TO DO: implement methotds and use this class

//DigitalOut led(LED1);                  // check pin on your board
InterruptIn sw(PA_0);                  // check pin on your board

Serial pc(USBTX, USBRX,9600);          // Tx pin, Rx pin, BaudRate
Ticker ticker;                         // ticker

/* Global variables */
volatile bool btnPressed = false;
volatile bool tick = false;
volatile uint8_t counter = 0;

/* Button interrupt handler */
void RiseHandler(void)
{
//    led = !led;
    btnPressed = true;
}

/* Ticker interrupt handler */
void OnTick(void)
{
    tick = true;
    counter++;
    if(counter>60) {
        counter = 0;
    }
}

int main()
{
    pc.printf("\r\n----- Start of application ----- \r\n");
    
    //    led = 0;
        ticker.attach(&OnTick,TICKER_TIME);
    
    sw.rise(&RiseHandler);

    char z;
    uint8_t period;
    while (true) {
        if(btnPressed) {
            pc.printf("Button was pressed. \r\n");
            btnPressed = false;
        }
        
        if(tick) {
            pc. printf("Counter value : %d \r\n", counter);
            tick = false;
        }
        /*
        if(pc.readable()) {
            z = pc.getc();
            pc.printf("Pressed key : %c \r\n", z);
            period = z - '0';
            if ((period >=0 )&&(period<=9)) {
                pc.printf("\r\nperiod: %d \r\n",period);
                led.SetBlinkPeriod(period);
            } else
                pc.printf("you entered the wrong value. \r\n");
        }*/
    }
}