
#include "mbed.h"

//
// ignore interrupt version till we discuss that topic
//

#ifdef INTERRUPT
InterruptIn fire(p14);
DigitalOut  led(LED1);
DigitalOut  flash(LED4);

void ISR1() {
    led = !led;
}

int main()
{
    fire.rise(&ISR1);
    fire.fall(&ISR1);
    
    while (1) {
        flash = !flash;
        wait(0.25);
    }   
}

#endif

#include "mbed.h"
#include "C12832_lcd.h" //LCD interface

BusIn joy(p15,p12,p13,p16);
DigitalIn fire(p14);


BusOut leds(LED1,LED2,LED3,LED4);
C12832_LCD lcd;

int btns[] = {0, 0, 0, 0};
char* btns_names[]= {"TOP", "BOT", "LFT", "RGT"};

int main()
{
    int t;
    lcd.locate(0,0);
    while(1) {
        if (fire) {
            leds=0xf;
        } else {
            leds=joy;
            t = joy;
            //add the switch settings
            /*
            btns[0] += (t&0x1 > 0) ? 1 : 0;
            btns[1] += (t&0x2 > 0) ? 1 : 0;
            btns[2] += (t&0x4 > 0) ? 1 : 0;
            btns[3] += (t&0x8 > 0) ? 1 : 0;
            */
            if(t&0x1 > 0) btns[0]+=1;            
            if(t&0x2 > 0) btns[1]+=1;
            if(t&0x4 > 0) btns[2]+=1;
            if(t&0x8 > 0) btns[3]+=1;
            lcd.locate(0,0); //{"TOP", "BOT", "LFT", "RGT"};
            lcd.printf("%s: %2d %2d ", btns_names[0],t&0x1, btns[0]);
            lcd.locate(70,0);
            lcd.printf("%s: %2d %2d ", btns_names[1],t&0x2, btns[1]);
            lcd.locate(0,10); 
            lcd.printf("%s: %2d %2d ", btns_names[2],t&0x4, btns[2]); 
            lcd.locate(70,10);
            lcd.printf("%s: %2d %2d ", btns_names[3],t&0x8, btns[3]);
            
        }
        wait(0.1);
    }
}

