#ifndef TCA9538_H
#define TCA9538_H

#include "mbed.h"

/**
 * @brief Class for TCA9538 IO-Expander
 * 
 * The TCA9538 is an 8-bit IO-Expander from Texas Instruments.
 * 
 * <h2>Example</h2>
 * @code
 * #include "mbed.h"
 * #include "TCA9538.h"
 * 
 * I2C         i2c(p9, p10);
 * DigitalOut  io_exp_reset(p11);
 * TCA9538     io_exp(i2c,0x70);
 * 
 * int main(void)
 * {
 *   io_exp_reset = 1;  //turn IO-Expander on
 *   io_exp.set(TCA9538::CONFIG, 0x0F); //Bits 0-3 Inputs ; Bits 4-7 Outputs
 * 
 *   io_exp.set(TCA9538::OUTPUT, 0xF0); //Turn all output pins on
 *   while(1)
 *   {
 *     uint8_t input_value = io_exp.get(TCA9538::OUTPUT);
 *   }
 * }
 * @endcode
 */
class TCA9538{
public:
  enum tca9538_registers_t
  {
    INPUT     = 0x00,
    OUTPUT    = 0x01,
    POLARITY  = 0x02,
    CONFIG    = 0x03
  };

  bool    set(tca9538_registers_t index, uint8_t value);
  uint8_t get(tca9538_registers_t index);

  TCA9538(I2C& i2c_device, uint8_t address);

private:
  uint8_t m_i2c_address;
  I2C&    m_i2c_device;
};

#endif /* */
