/**
 * @file i2c.h
 * @author Joel von Rotz (joel.vonrotz@maxonmotor.com)
 * @brief 
 * @version 0.1
 * @date 2019-05-14
 * 
 * @copyright Copyright (c) 2019, maxon motor ag, All Rights Reserved
 * 
 */
#ifndef _I2C_H
#define _I2C_H
#include "mbed.h"

class I2C_Master
{
public:
    I2C_Master(PinName sda, PinName scl, uint32_t frequency = 400000);
    void        i2c_write(uint8_t i2c_address, uint8_t slave_address, const uint8_t data);
    void        i2c_writeBits(uint8_t i2c_address, uint8_t slave_address, const uint8_t data, uint8_t mask);
    uint8_t     i2c_readBits(uint8_t i2c_address, uint8_t slave_address, uint8_t mask);
    void        i2c_readSeries(uint8_t i2c_address, uint8_t slave_address, uint8_t *data, uint8_t length);
    uint8_t     i2c_read(uint8_t i2c_address, uint8_t slave_address);

private:
    I2C         m_i2c_sensor;
    uint32_t    m_i2c_frequency;
};

#endif

