/**
 * @brief 
 * 
 * @file bno055_registermap.h
 * @author Joel von Rotz
 * @date 18.07.2018
 */
#ifndef BNO055_REGISTERMAP_H
#define BNO055_REGISTERMAP_H

#include "mbed.h"

enum bno055_reg_t
{
    //PAGE 0 - Selected on Startup ==========
    //ID Registerss --------------------------
    CHIP_ID         =   0x00,
    ACC_ID          =   0x01,
    MAG_ID          =   0x02,
    GYR_ID          =   0x03,
    SW_REV_ID_LSB   =   0x04,
    SW_REV_ID_MSB   =   0x05,
    BL_REV_ID       =   0x06,

    //PAGE Selector page --------------------
    PAGE_ID         =   0x07,

    //Sensor Data Registers -----------------
    //Accelerometer
    ACC_DATA_X_LSB      =   0x08,
    ACC_DATA_X_MSB      =   0x09,
    ACC_DATA_Y_LSB      =   0x0A,
    ACC_DATA_Y_MSB      =   0x0B,
    ACC_DATA_Z_LSB      =   0x0C,
    ACC_DATA_Z_MSB      =   0x0D,

    ACC_DATA_VECTOR     =   0x08,

    //Magnetometer
    MAG_DATA_X_LSB      =   0x0E,
    MAG_DATA_X_MSB      =   0x0F,
    MAG_DATA_Y_LSB      =   0x10,
    MAG_DATA_Y_MSB      =   0x11,
    MAG_DATA_Z_LSB      =   0x12,
    MAG_DATA_Z_MSB      =   0x13,

    MAG_DATA_VECTOR     =   0x0E,

    //Gyroscope
    GYR_DATA_X_LSB      =   0x14,
    GYR_DATA_X_MSB      =   0x15,
    GYR_DATA_Y_LSB      =   0x16,
    GYR_DATA_Y_MSB      =   0x17,
    GYR_DATA_Z_LSB      =   0x18,
    GYR_DATA_Z_MSB      =   0x19,

    GYR_DATA_VECTOR     =   0x14,

    //Euler Angles
    EUL_DATA_X_LSB      =   0x1A,
    EUL_DATA_X_MSB      =   0x1B,
    EUL_DATA_Y_LSB      =   0x1C,
    EUL_DATA_Y_MSB      =   0x1D,
    EUL_DATA_Z_LSB      =   0x1E,
    EUL_DATA_Z_MSB      =   0x1F,

    EUL_DATA_VECTOR     =   0x1A,

    //Quaternion
    QUA_DATA_W_LSB      =   0x20,
    QUA_DATA_W_MSB      =   0x21,
    QUA_DATA_X_LSB      =   0x22,
    QUA_DATA_X_MSB      =   0x23,
    QUA_DATA_Y_LSB      =   0x24,
    QUA_DATA_Y_MSB      =   0x25,
    QUA_DATA_Z_LSB      =   0x26,
    QUA_DATA_Z_MSB      =   0x27,

    QUA_DATA_VECTOR     =   0x20,

    //Linear Acceleration
    LIA_DATA_X_LSB      =   0x28,
    LIA_DATA_X_MSB      =   0x29,
    LIA_DATA_Y_LSB      =   0x2A,
    LIA_DATA_Y_MSB      =   0x2B,
    LIA_DATA_Z_LSB      =   0x2C,
    LIA_DATA_Z_MSB      =   0x2D,

    LIA_DATA_VECTOR     =   0x28,

    //Gravity Vector
    GRV_DATA_X_LSB      =   0x2E,
    GRV_DATA_X_MSB      =   0x2F,
    GRV_DATA_Y_LSB      =   0x30,
    GRV_DATA_Y_MSB      =   0x31,
    GRV_DATA_Z_LSB      =   0x32,
    GRV_DATA_Z_MSB      =   0x33,

    GRV_DATA_VECTOR     =   0x2E,

    //Temperature
    TEMP                =   0x34,

    //Calibration Status Register -----------
    CALIB_STAT          =   0x35,

    //Self Test Results ---------------------
    ST_RESULT           =   0x36,

    //Interrupt Indicator -------------------
    INT_STATUS          =   0x37,

    //System Register -----------------------
    SYS_CLK_STATUS      =   0x38,
    SYS_STATUS          =   0x39,
    SYS_ERR             =   0x3A,
    SYS_TRIGGER         =   0x3F,

    //Unit Selection ------------------------
    UNIT_SEL            =   0x3B,

    //Modes ---------------------------------
    OPR_MODE            =   0x3D,
    PWR_MODE            =   0x3E,

    //Temperature Source Selector -----------
    TEMP_SOURCE         =   0x40,

    //Axis Mapping & Sign -------------------
    AXIS_MAP_CONFIG     =   0x41,
    AXIS_MAP_SIGN       =   0x42,

    //Offset Register -----------------------
    ACC_OFFSET_X_LSB    =   0x55,
    ACC_OFFSET_X_MSB    =   0x56,
    ACC_OFFSET_Y_LSB    =   0x57,
    ACC_OFFSET_Y_MSB    =   0x58,
    ACC_OFFSET_Z_LSB    =   0x59,
    ACC_OFFSET_Z_MSB    =   0x5A,

    MAG_OFFSET_X_LSB    =   0x5B,
    MAG_OFFSET_X_MSB    =   0x5C,
    MAG_OFFSET_Y_LSB    =   0x5D,
    MAG_OFFSET_Y_MSB    =   0x5E,
    MAG_OFFSET_Z_LSB    =   0x5F,
    MAG_OFFSET_Z_MSB    =   0x60,

    GYR_OFFSET_X_LSB    =   0x61,
    GYR_OFFSET_X_MSB    =   0x62,
    GYR_OFFSET_Y_LSB    =   0x63,
    GYR_OFFSET_Y_MSB    =   0x64,
    GYR_OFFSET_Z_LSB    =   0x65,
    GYR_OFFSET_Z_MSB    =   0x66,

    //Radius Register -----------------------
    //Accelerometer
    ACC_RADIUS_LSB      =   0x67,
    ACC_RADIUS_MSB      =   0x68,

    //Magnetometer
    MAG_RADIUS_LSB      =   0x69,
    MAG_RADIUS_MSB      =   0x6A,

    //PAGE 1 ================================
    //Configuration -------------------------
    ACC_CONFIG          =   0x08,
    MAG_CONFIG          =   0x09,
    GYR_CONFIG_0        =   0x0A,
    GYR_CONFIG_1        =   0x0B,
    ACC_SLEEP_CONFIG    =   0x0C,
    GYR_SLEEP_CONFIG    =   0x0D,

    //Interupt Configuration ----------------
    INT_MSK             =   0x0F,
    INT_EN              =   0x10,
    //Accelerometer
    ACC_AM_THRES        =   0x11,
    ACC_INT_SETTING     =   0x12,
    ACC_HG_DURATION     =   0x13,
    ACC_HG_THRES        =   0x14,
    ACC_NM_THRES        =   0x15,
    ACC_NM_SET          =   0x16,
    //Gyroscope
    GYR_INT_SETTING     =   0x17,
    GYR_HR_X_SET        =   0x18,
    GYR_DUR_X           =   0x19,
    GYR_HR_Y_SET        =   0x1A,
    GYR_DUR_Y           =   0x1B,
    GYR_HR_Z_SET        =   0x1C,
    GYR_DUR_Z           =   0x1D,
    GYR_AM_THRES        =   0x1E,
    GYR_AM_SET          =   0x1F
};

#endif /* BNO055_REGISTERMAP_H */


