/**
 * @brief 
 * 
 * @file bno055_definitions.h
 * @author Joel von Rotz
 * @date 18.07.2018
 */
#ifndef BNO055_DEFINITIONS_H
#define BNO055_DEFINITIONS_H

#include "mbed.h"

#define FREQ_400kHz             400000

#define MASK_CALIBRATION_BITS   0x03

#define BNO055_ID               0xA0
#define FULLY_CALIBRATED        0xFF


#define ACCELERATION_FORMAT             (0.01f)
#define MILLI_G_FORCE_FORMAT            (1.0f)

#define MICRO_TESLA_FORMAT              (0.0625f)

#define GYRO_DEGREE_PER_SEC_FORMAT      (0.0625f)
#define GYRO_RADIAN_PER_SEC_FORMAT      (1.0f/900.0f)

#define QUATERNION_FORMAT               (0.00006103515625f)

#define TEMPERATURE_CELSIUS_FORMAT      (1.0f)
#define TEMPERATURE_FAHRENHEIT_FORMAT   (2.0f)

#define EULER_DEGREES_FORMAT            (0.0625f)
#define EULER_RADIANS_FORMAT            (1.0f/900.0f)


enum bitshift_t
{
    SHIFT_1BYTE         = 8,
    
    SHIFT_CALIB_SYSTEM  = 6,
    SHIFT_CALIB_GYRO    = 4,
    SHIFT_CALIB_ACCEL   = 2,
    
    //ACCELERATION INTERRUPT CONFIGURATION
    SHIFT_HIGH_AXIS     = 5,
    SHIFT_AM_NM_AXIS    = 2,

    //GYROSCOPE INTERRUPT CONFIGURATOIN
    SHIFT_HIGH_RATE_AXIS= 3,  
    SHIFT_AM_FILT       = 6,
    SHIFT_HIGH_RATE_FILT= 7,

    SHIFT_INT_GYRO_AM   = 2,
    SHIFT_INT_GYRO_HR   = 3,
    SHIFT_INT_ACCEL_HG  = 5,
    SHIFT_INT_ACCEL_AM  = 6,
    SHIFT_INT_ACCEL_NM  = 7,
};

enum bno055_axis_t
{
    X_AXIS = 0x00,
    Y_AXIS = 0x02,
    Z_AXIS = 0x04
};

enum bno055_config_int_axis_t
{
    NO_AXIS     = 0x00,      
    X_AXIS_ONLY = 0x01,     
    Y_AXIS_ONLY = 0x02,     
    Z_AXIS_ONLY = 0x04,     
    X_Y_AXIS    = 0x03,     
    X_Z_AXIS    = 0x05,     
    Y_Z_AXIS    = 0x06,     
    ALL_AXIS    = 0x07,     
};

enum bno055_any_motion_sample_t
{
    AM_1_SAMPLE = 0,
    AM_2_SAMPLE = 1,
    AM_3_SAMPLE = 2,
    AM_4_SAMPLE = 3,
};

enum bno055_euler_axis_t
{
    YAW     = 0x00,
    ROLL    = 0x02,
    PITCH   = 0x04,
};

enum bno055_quaternion_t
{
    QUATERNION_W = 0x00,
    QUATERNION_X = 0x02,
    QUATERNION_Y = 0x04,
    QUATERNION_Z = 0x06,
};

enum bno055_opr_mode_t
{
    OPERATION_MODE_CONFIGMODE   = 0x00,
    //NON-FUSION MODES
    OPERATION_MODE_ACCONLY      = 0x01, 
    OPERATION_MODE_MAGONLY      = 0x02,
    OPERATION_MODE_GYROONLY     = 0x03,
    OPERATION_MODE_ACCMAG       = 0x04,
    OPERATION_MODE_ACCGYRO      = 0x05,
    OPERATION_MODE_MAGGYRO      = 0x06,
    OPERATION_MODE_AMG          = 0x07,
    //FUSION MODES
    OPERATION_MODE_IMU          = 0x08,
    OPERATION_MODE_COMPASS      = 0x09,
    OPERATION_MODE_M4G          = 0x0A,
    OPERATION_MODE_NDOF_FMC_OFF = 0x0B,
    OPERATION_MODE_NDOF         = 0x0C
};

enum bno055_reg_mask_t
{
    MASK_REMAP_AXIS     = 0x3F,
    MASK_SIGN_AXIS      = 0x07,
    MASK_OPERAITON_MODE = 0x0F,
    MASK_UNIT_SEL       = 0x97,
    MASK_POWER_MODE     = 0x03,
    MASK_SYSTEM_RESET   = 0x20,
    MASK_EXT_CLOCK      = 0x80,

    MASK_GYRO_ANY_MOTION  = 0x04,
    MASK_GYRO_HIGH_RATE   = 0x08,
    MASK_ACCEL_HIGH_G     = 0x20,
    MASK_ACCEL_ANY_MOTION = 0x40,
    MASK_ACCEL_NO_MOTION  = 0x80,
};

enum bno055_axis_sign_t
{
    POSITIVE = 0,
    NEGATIVE
};

enum bno055_powermode_t
{
    POWER_NORMAL = 0,
    POWER_LOW_POWER_MODE,
    POWER_SUSPEND_MODE
};

enum bno055_remap_options_t
{                     //High-Byte = Remap, Low-Byte = Sign
    REMAP_OPTION_P0 =   0x2104,
    REMAP_OPTION_P1 =   0x2400,     //Default
    REMAP_OPTION_P2 =   0x2406,
    REMAP_OPTION_P3 =   0x2102,
    REMAP_OPTION_P4 =   0x2403,
    REMAP_OPTION_P5 =   0x2101,
    REMAP_OPTION_P6 =   0x2107,
    REMAP_OPTION_P7 =   0x2405
};

enum bno055_interrupt_status_bits_t
{
    GYRO_ANY_MOTION  = 0x04,
    GYRO_HIGH_RATE   = 0x08,
    ACCEL_HIGH_G     = 0x20,
    ACCEL_ANY_MOTION = 0x40,
    ACCEL_NO_MOTION  = 0x80,
};

enum bno055_page_t
{
    PAGE_0 = 0,
    PAGE_1
};

enum bno055_orientation_t
{
    WINDOWS = 0x00,
    ANDROID = 0x80
};

enum bno055_temperature_t
{
    CELSIUS     = 0x00,
    FAHRENHEIT  = 0x10
};

enum bno055_euler_t
{
    DEGREES = 0x00,
    RADIANS = 0x04
};

enum bno055_gyro_t
{
    DEGREE_PER_SEC = 0x00,
    RADIAN_PER_SEC = 0x02
};

enum bno055_acceleration_t
{
    ACCELERATION  = 0x00,
    MILLI_G_FORCE = 0x01
};

enum bno055_length_t
{
    LENGTH_1_BYTES  = 1,
    LENGTH_2_BYTES  = 2,
    LENGTH_6_BYTES  = 6,
    LENGTH_8_BYTES  = 8
};

enum bno055_enable_t
{
    DISABLE = 0,
    ENABLE = 1,
};

#endif /* BNO055_DEFINITIONS_H */


