#ifndef LED_H
#define LED_H

#include "mbed.h"

/** A LED class
 *  A class used for creating a led-object and changing it's state.
 *
 * Example:
 * @code
 * #include "led.h"
 * #include "mbed.h"
 *
 * led myled(LED1);
 * 
 * int main(){
 *     myled.blink(1);
 *     return 0;
 * }
 * @endcode
 */
class led{
    private:
    DigitalOut myled;
    public:
    /** The constructor creates an instance of the led class.
     */
    led(PinName name);
    
    /** Toggles the led.
     */
    void toggle_led();
    
    /** Turns the led on.
     */
    void on();
    
    /** Turns the led off.
     */
    void off();
    
    /** Blinks the led once.
     * @param sec The amount of seconds that should pass before chaging the state.
     */
    void blink(float time);
};

#endif