#include "mbed.h"
#include "C12832.h"

//
// The Shed's "FTDI"
// 50 GBP of hardware to emulate 10 GBP of hardware because Joe likes to live wire
//
// SW2, SW3, FIRE will reset the XBee
//

// Serial Devices
Serial pc(USBTX, USBRX); // tx, rx
Serial dev(D1, D0); // tx, rx

// Interrupts for XBee reset
InterruptIn sw2_int(PTC6);
InterruptIn sw3_int(PTA4);
InterruptIn fire_int(D5);

// XBee reset pin
DigitalOut rst(D3);

// Print instructions on LCD
C12832 lcd(D11, D13, D12, D7, D10);

void reset_xbee() {
    rst = 0;
    wait(0.5);
    rst = 1;
}
 
int main() {

    // Bring the reset pin to high    
    rst = 1;
    
    // Identify ourselves on the LCD
    lcd.printf(" -- The Shed's \"FTDI\" -- \n");
    lcd.printf("50GBP to emulate 5GBP\n");
    lcd.printf("SW2/SW3/FIRE to RST XBee\n");
    
    
    // Switch setup
    sw2_int.mode(PullUp);
    sw2_int.fall(&reset_xbee);
    
    sw3_int.mode(PullUp);
    sw3_int.fall(&reset_xbee);
    
    fire_int.mode(PullUp);
    fire_int.fall(&reset_xbee);
    
    // PC serial     
    pc.baud(9600);
    
    // Device serial 
    dev.baud(9600);   // XBee
 
    // Loop forever, allow for interrupts
    while(1) {
        if (pc.readable()) {
            dev.putc(pc.getc());
        }
        if (dev.readable()) {
            pc.putc(dev.getc());
        }
    }
 
}