#include "stimme.h"
#include "mbed.h"

Ticker tick ;           // Creates periodic interrupt
Ticker adcTick ;        // Creates periodic interrupt
AnalogOut ao(PA_4) ;    // Analog output

float berechnet = 0.0f;

volatile int index1 = 0 ; // verachtfachen der Anzahl
volatile int index2 = 0 ; // index into array of sin values

void writeAout()
{
    berechnet = (0.003921568627f * Text[0xb405 + index2]);        // berechnet = (Frequenz[index] * 1.0f/255.0f;
    ao.write(berechnet);
    index1++;
    if(index1 > 7)
    {
      index2++; // nach 8 Takten das nächste Byte holen
      if (index2 > 0x0ae6) index2 = 0;
      index1 = 0;
    }
}

int main()
{

    int old_update_us;
    int update_us;
    tick.attach_us(callback(&writeAout), update_us); // setup ticker to write to AnalogOut
    old_update_us = update_us;

    while (true)
     {
        if (update_us != old_update_us)
         {
            tick.attach_us(callback(&writeAout), update_us); // setup ticker to write to AnalogOut
            old_update_us = update_us;
          }
         Thread::wait(200); //in ms
     }
}