/* Example of Reading  TI HDC1080 sensor using STM F303K8 dev board

  By Joseph Ellsworth CTO of A2WH
  Take a look at A2WH.com Producing Water from Air using Solar Energy
  March-2016 License: https://developer.mbed.org/handbook/MIT-Licence
  Please contact us http://a2wh.com for help with custom design projects.
 */

#include "mbed.h"
#include <stdint.h>

//Pin Defines for I2C Bus
#define D_SDA                  PB_7 // specific for Nucleo-F303K8
#define D_SCL                  PB_6 // specific for Nucleo-F303K8
I2C hdc_i2c(D_SDA, D_SCL);
#include "hdc1080.h"

// Host PC Communication channels
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut myled(LED1);

int main()
{
    pc.baud(9600);
    printf("\r\\nHDC1080 Test\r\n");
    while(1) {        
        myled = !myled;
        hdc_begin();
        uint16_t manId = hdc_readManufactId();
        float tempC = hdc_readTemp();     
        float humid = hdc_readHumid();  
        unsigned long  serNum = hdc_readSerial();
        printf("manId=x%x, tempC=%0.3f humid=%0.3f serfNum=%lu\r\n",
          manId, tempC, humid, serNum);
        wait(3.0f);
    }
}

