/* Test ability to read SHT75 sensor from F303K8 board.

  Note:  Can not be on same pins as I2C due to different pull up 
  requirements.

  By Joseph Ellsworth CTO of A2WH
  Take a look at A2WH.com Producing Water from Air using Solar Energy
  March-2016 License: https://developer.mbed.org/handbook/MIT-Licence
  Please contact us http://a2wh.com for help with custom design projects.
  
  Sample code to test SHT75 humidity sensor using STM F303K8 board.    
  Uses a 3.3V from board to power sensor.  10K resistor Pull-up on data.   
  Must not be on same pins as I2C.    Uses D0 for Clk and D1 for Data.

  I had to modify sample code supplied by https://developer.mbed.org/users/nimbusgb/code/SHT75/  
  because the sensor failed to read without the softReset() and readStatus() at beginning 
  of measurement loop.  I think this is caused by the 72Mhtz speed of the F303K8  but did 
  not attempt to fully diagnose.

  The readStatus() method from library seems to malfunction and always return a -1 
  which never changes even when sensor is unplugged. 

  
 */

#include "mbed.h"
#include <stdint.h>

#define sht75_clk D0
#define sht75_data D1
#include "sht7X.h" 
SHT75 sht(sht75_clk, sht75_data); 
 

// Host PC Communication channels
Serial pc(USBTX, USBRX); // tx, rx
char buff[100];

DigitalOut myled(LED1);

int main()
{
    pc.baud(38400);
    wait(1);
    while(1) {
        myled = !myled;
        float temperature;                    // temperature -40 to 120 deg C
        float humidity;                       // relative humidity 1% to 100%
        float humi_f,rh_lin,rh_true;          // working registers for Illustration purposes
        int t;                                // temporary store for the temp ticks
        int h;
        sht.softReset();        
        int stat = sht.readStatus();
        wait(3.0);
        sht.readTempTicks(&t);
        temperature = ((float)(t) * 0.01) - 39.61;

        sht.readHumidityTicks(&h);
        humi_f = (float)(h);
        rh_lin = C3 * humi_f * humi_f + C2 * humi_f + C1;
        rh_true=(((temperature/100)-25)*(T1+T2*humi_f)+rh_lin);
        if(rh_true>100)rh_true=100;                             //cut if the value is outside
        if(rh_true<1)rh_true=1;                                 //the physical possible range
        humidity = rh_true;
        pc.printf("stat=%d Temp: %2.2f RH %2.2f\n\r",stat, temperature, humidity);
        
        wait(3.0);
    }
}