/* Adapted to auto set clock when the clock chip has not been 
previously initialized */

#define SCLK    PB_15
#define IO      PB_14
#define CE      PB_13
/* Initialize clock chip to compile time if we do 
 not detect that it has previsouly been set.  After
 that set the CPU time to reflect the clock chip time
 on startup.
 
  By Joseph Ellsworth CTO of A2WH
  Take a look at A2WH.com Producing Water from Air using Solar Energy
  March-2016 License: https://developer.mbed.org/handbook/MIT-Licence 
 
 NOTE:  To force reset of clock time change ClockSetSentinal to a different
 value.  Or you can change on the compare statement below if you want to keep
 the same sentinal. 
 
*/
#define ClockSetSentinal 19
#include "mbed.h"
#include "DS1302.h"
#include "compile_time_to_system_time.h"

DS1302 clk(SCLK, IO, CE);

int main() {
    
    printf("compile time=%s date=%s\r\n",__TIME__,__DATE__);
    time_t build_time = cvt_date(__DATE__,__TIME__);
    printf("compile time reformate=%s r\n", ctime(&build_time));
    
    time_t seconds = clk.time(NULL);
    
    if  (clk.recallByte(0) != ClockSetSentinal) {
      // our clock chip has not been initialized
      // to with this utility so we need to store
      // a starting time and our sentinal so we 
      // know it was already setup.
      printf("setting time in DS1302");
      clk.storeByte(0, ClockSetSentinal);    
      set_time(build_time);      
      clk.set_time(build_time);
    }
    else {            
      // On Startup we want to copy our clock value
      // to our CPU chip.  After that the internal clock
      // can keep it runing but we should re-sync every so often.
      printf("reading time from DS1302\r\n");
      char storedByte = clk.recallByte(0);      
      time_t seconds = clk.time(NULL);      
      set_time(seconds);        
    }
    
    while(1) {
        seconds = clk.time(NULL);        
        time_t intSeconds = time(NULL);
        printf("ds1302Time=%s intTime=%s\r\n", ctime(&seconds), ctime(&intSeconds));
        wait(1);
    }
}
