/*
  By Joseph Ellsworth CTO of A2WH
  Take a look at A2WH.com Producing Water from Air using Solar Energy
  March-2016 License: https://developer.mbed.org/handbook/MIT-Licence 
  Please contact us http://a2wh.com for help with custom design projects.


  Most STM and Freescale ARM chips include a unique Serail Number embedded
  in the CPU.  This is a perfect number to use in IoT as a SSID.  I use
  this to produce the WIFi SID so I can walk up with a phone and download
  telemetry.   I found a blog discussion for mbed that suggested using the
  MAC but this assumes mbed hardware whereas this version uses the serial
  number built in to the CPU so it should work on native boards.
*/

#ifndef uniqueCPUID_h
#define uniqueCPUID_h
#include "mbed.h"

#define uniqueSerialAdd_kl_freescale (unsigned long *)0x40048058
#define uniqueSerialAddr_stm32 (unsigned long *)0x1FFFF7E8

//TODO: Add logic to detect the different boards and select the correct
//  CPU ID based on the active board.
//#define uniqueSerialAddr uniqueSerialAdd_kl_freescale
#define uniqueSerialAddr uniqueSerialAddr_stm32

// Change to enable for address for your chip family
// Note some ealry stm L3 chips were produced with all
// chip ID set to FFF.  I have not seen any but did find
// it mentioned in a blog.


/* format the unique serial number as a string. we could use
as the router SID for Lot.  Supress leading zeros to save
space */
void getUniqueIDAsStr(char *destStr);

/* Send unique device ID to serail port */
void printUniqueId(Serial pc);

#endif
