/* Print unique CPU ID

  By Joseph Ellsworth CTO of A2WH
  Take a look at A2WH.com Producing Water from Air using Solar Energy
  March-2016 License: https://developer.mbed.org/handbook/MIT-Licence 
  Please contact us http://a2wh.com for help with custom design projects.

  Most STM and Freescale ARM chips include a unique Serail Number embedded
  in the CPU.  This is a perfect number to use in IoT as a SSID.  I use
  this to produce the WIFi SID so I can walk up with a phone and download
  telemetry.   I found a blog discussion for mbed that suggested using the
  MAC but this assumes mbed hardware whereas this version uses the serial
  number built in to the CPU so it should work on native boards.
*/

#include "mbed.h"

#include "uniqueCPUID.h"

Serial pc(USBTX, USBRX);



int main()
{
    pc.baud(9600);


    char uniqueAsStr[33];
    getUniqueIDAsStr(uniqueAsStr);
    pc.printf("Serial as SID %s\n", uniqueAsStr);   // send back to PC


    while (true) {
        wait(6.0);

        pc.printf("Serial as SID %s\n", uniqueAsStr);   // send back to PC
    }
}