/* Ohms law used to calculate things like resistance from voltage drop
and to compute read voltage adjusted for dividor.

   By Joseph Ellsworth CTO of A2WH
  Take a look at A2WH.com Producing Water from Air using Solar Energy
  March-2016 License: https://developer.mbed.org/handbook/MIT-Licence 
  Please contact us http://a2wh.com for help with custom design projects.


*/

#ifndef ohms_H
#define ohms_H
#include "mbed.h"

float volDivideCalcRatio(long r1, long r2);
float voltDivideAdjVolt(float vin, long r1, long r2);
long calcResistV(long refResistR1, float maxV, float measuredV);

/* Uses a voltage dividor to compute resistance of 
of R2 based on a known R1 and a source (refVolt) based
on drop of voltage measured where R1 and R2 connect. 
normaly used to measure resistance in variable resistance
circuits such as thermister. 

class VoltDivideAdjVolt {

  public:
    resistVoltDivide(PinName pin, long r1, float refVolt) {
        _r1 = r1;
        _refVolt = refVolt;
        _pinName = pinName;
    }
    ~resistVoltDivide();
    float read();
    
    
  private:
    PinName _pin;
    long _r1;
    long _r2;
    float _refVolt;    
};
*/

/* adjVoltDivide Compute the actual voltage output after effect 
of voltage dividor has been removed.  Normally used to compute
things like true battery voltage when voltage has been level
shifted into a range safe for use with micro-controller  Assumes
R1 is connected to source voltage = refVolt and R2 is connected
to ground measurement is where R2 and R1 meet. Result of read()
will be voltage as if it had been measured without influence of
divider. 
class adjVoltDivide {

  public:
    adjVoltDivide(long r1, long r2, float refVolt);
    ~adjVoltDivide();
    float adjust(float vin);
    float adjust(int adcin);
    float read(AnalogIn apin);
    uint16_t read_u16(AnalogIn apin);
    float ratio();
    
  private:
    long _r1;
    long _r2;
    float _refVolt;
    float _ratio;
};
*/
#endif