#include "mbed.h"

/*     By Joseph Ellsworth CTO of A2WH
  Take a look at A2WH.com Producing Water from Air using Solar Energy
  March-2016 License: https://developer.mbed.org/handbook/MIT-Licence 
  Please contact us http://a2wh.com for help with custom design projects.

 
*/

#include "ohms.h"

float volDivideCalcRatio(long r1, long r2) {
  return ((float) r2 / (float) (r1 + r2));
}
float voltDivideAdjVolt(float vin, long r1, long r2) {
  float ratio = ((float) r2 / (float) (r1 + r2));
  return vin / ratio;
}


long calcResistV(long refResistR1, float maxV, float measuredV) {
  float VDrop = maxV - measuredV;
  float dropRatio =  measuredV / VDrop;  
  return  (long) (refResistR1 * dropRatio);
}


/*

adjVoltDivide::adjVoltDivide(long r1, long r2, float refVolt) {
    _r1 = r1;
    _r2 = r2;
    _refVolt = refVolt;
    _ratio = volDivideRatio(r1, r2);
}
    
float adjVoltDivide::read(AnalogIn apin) {
    return apin.read() / _ratio;    
}

uint16_t adjVoltDivide::read_u16(AnalogIn apin) {
    return (int) ((float) apin.read_u16() / _ratio);
}

*/