/*
  by Joseph Ellsworth CTO A2WH.
  Freeuse for all.  No promises,  No warranty *
  Please contact us http://a2wh.com for help with custom design projects.

  Most STM and Freescale ARM chips include a unique Serail Number embedded
  in the CPU.  This is a perfect number to use in IoT as a SSID.  I use
  this to produce the WIFi SID so I can walk up with a phone and download
  telemetry.   I found a blog discussion for mbed that suggested using the
  MAC but this assumes mbed hardware whereas this version uses the serial
  number built in to the CPU so it should work on native boards.
*/

#include "mbed.h"
#include "SLCD.h"
//#include "lcd_scroll.h"


#define uniqueSerialAdd_kl_freescale (unsigned long *)0x40048058
#define uniqueSerialAddr_stm32 (unsigned long *)0x1FFFF7E8
#define uniqueSerialAddr uniqueSerialAdd_kl_freescale
#define lcdlen 4
// Change to enable for address for your chip family
// Note some ealry stm L3 chips were produced with all
// chip ID set to FFF.  I have not seen any but did find
// it mentioned in a blog.



DigitalOut gpo(D0);
DigitalOut led(LED_RED);
Serial pc(USBTX, USBRX);
SLCD slcd;


/* format the unique serial number as a string. we could use
as the router SID for Lot.  Supress leading zeros to save
space */
void getUniqueIDAsStr(char *destStr)
{
    unsigned long *Unique = uniqueSerialAddr;
    sprintf(destStr, "S%luX%luX%luX\000", Unique[0], Unique[1], Unique[2]);
}


void scroll(int lcdLen, char *message, float charDelay)
{
    short msgLen = strlen(message);
    short maxStartndx = msgLen - lcdLen;
    short currndx = 0;
    short currpos = 0;
    short winndx;
    slcd.clear();

    slcd.Home();
    for (currndx = 0; currndx <= maxStartndx; currndx++) {
        for (winndx = 0; winndx < lcdLen ; winndx++) {
            currpos = currndx + winndx;
            if (message[currpos] == 0) {
                break;
            }
            slcd.putc(message[currpos]);
        }
        wait(charDelay);
    }
    currndx++;

}


int main()
{
    pc.baud(9600);
    unsigned long *Unique = uniqueSerialAddr;
    printf("Simple Serial# %08luX %08luX %08luX\n", Unique[0], Unique[1], Unique[2]);

    char uniqueAsStr[33];
    getUniqueIDAsStr(uniqueAsStr);
    pc.printf("Serial as SID %s\n", uniqueAsStr);   // send back to PC


    while (true) {
        gpo = !gpo; // toggle pin
        led = !led; // toggle led

        slcd.clear();
        scroll(lcdlen, uniqueAsStr, 1.2);
        wait(2.0);
    }
}