/*  Function to convert compile time reported as 
  MBED compiler macro into a System time we can 
  use to set time and date in our chip.  This can
  be a helpful way to initialize clock chips for
  low volume tests 
  
  By Joseph Ellsworth CTO of A2WH
  Take a look at A2WH.com Producing Water from Air using Solar Energy
  March-2016 License: https://developer.mbed.org/handbook/MIT-Licence 
  Please contact us http://a2wh.com for help with custom design projects.


 call with the command
   printf("compile time=%s date=%s\r\n",__TIME__,__DATE__);
   time_t build_time = cvt_date(__DATE__,__TIME__);
   printf("compile time reformate=%s r\n", ctime(&build_time));
   
   
 TODO: Enhance to read time from clock chip and if unreasable 
   then re-initialize the time.  I have found a small number
   of instances when the clock lost the time due to battery
   run down but the init byte was still present.  This enhancement
   should accomodate that. 
    
*/
  
#ifndef compile_time_to_system_time_H
#define compile_time_to_system_time_H

 
// call with the command
//time_t build_time = cvt_date(__DATE__,__TIME__);

// Convert compile time to system time 
time_t cvt_date(char const *date, char const *time)
{
    char s_month[5];
    int year;
    struct tm t;
    static const char month_names[] = "JanFebMarAprMayJunJulAugSepOctNovDec";
    sscanf(date, "%s %d %d", s_month, &t.tm_mday, &year);
    sscanf(time, "%2d %*c %2d %*c %2d", &t.tm_hour, &t.tm_min, &t.tm_sec);
    // Find where is s_month in month_names. Deduce month value.
    t.tm_mon = (strstr(month_names, s_month) - month_names) / 3;    
    t.tm_year = year - 1900;    
    return mktime(&t);
}


#endif 