/* Example of Reading all the ADC pins PIN and display ot OLED display using
 Nucleo_F303K8. Displays voltage read from first 2 ADC lines on OLED display

  By Joseph Ellsworth CTO of A2WH
  Take a look at A2WH.com Producing Water from Air using Solar Energy
  March-2016 License: https://developer.mbed.org/handbook/MIT-Licence 
  Please contact us http://a2wh.com for help with custom design projects.

  
  Used to Drive:
   ebay part http://www.ebay.com/itm/152000005331?_trksid=p2057872.m2749.l2649&ssPageName=STRK%3AMEBIDX%3AIT
  0-96-I2C-IIC-SPI-Serial-White-OLED-LCD-LED-Display-Module-128X64
  The Datasheet.  https://www.adafruit.com/datasheets/SSD1306.pdf

  Unfortunately this part never turns on using the SSD1308 library.
  but did find that the https://developer.mbed.org/users/nkhorman/code/Adafruit_GFX/
  library works.  Unfortunately the Adafruit library doesn't include the scroll functionality.

  Using my I2C address scanner I found that it responds on Added 120 (x78) ,121 (x79)
  and when the part was unsoldered nothing responded on 120 or 121. According to
  to the page #19 (8.1.5) of the data sheet the I2C address should be 011110
  which seems to map correctly to dec=120 hex=79

 */

#include "mbed.h"
//#include "SSD1308.h"
#include "Adafruit_SSD1306.h"

//#include "mbed_logo.h"

//Pin Defines for I2C Bus
#define D_SDA                  PB_7 // specific for Nucleo-F303K8
#define D_SCL                  PB_6 // specific for Nucleo-F303K8
I2C i2c(D_SDA, D_SCL);

// Host PC Communication channels
Serial pc(USBTX, USBRX); // tx, rx

AnalogIn   pa0(PA_0);
AnalogIn   pa1(PA_1);
PwmOut  fan1(D11);
//PwmOut  fan2(D12);
//PwmOut  fan3(PA_2);
DigitalOut fan2x(D12);

DigitalOut myled(LED1);
const float voltMeterARef = 3.3;

// an I2C sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl) {
        frequency(400000);
        start();
    };
};


I2CPreInit gI2C(D_SDA,D_SCL);
Adafruit_SSD1306_I2c gOled2(gI2C,PB_5);


float readPrint(AnalogIn ain, char *label)
{
    float tval = ain.read();
    float volts = tval * voltMeterARef;
    float perc = tval * 100.0f;
    unsigned short  tvalu16 = ain.read_u16 ();
    pc.printf("adc %s R=%3.3f V=%3.3f U16=%u\r\n",label, tval, volts, tvalu16);
    gOled2.printf("%s=%3.3fV\r\n",label,volts);
    gOled2.display();
    return tval;
}


int main()
{
    pc.baud(9600);
    // Display with the Adafruit Library
    gOled2.printf("%ux%u OLED Display\r\n", gOled2.width(), gOled2.height());
    wait(5);
    gOled2.clearDisplay();
    while(1) {
        myled = !myled;
        gOled2.clearDisplay();
        gOled2.setTextCursor(1,1);
        readPrint(pa0, "PA_0");
        wait(0.1);
        gOled2.setTextCursor(1,10);
        readPrint(pa1, "PA_1");
        
         float pwmpw = 0.3; //0.0005; //0.09; // 0.1001;
         float pwmpp = 3.0; //0.00001; //0.0001; // 0.01001;
         //fan2.period_ms();
         //fan2.pulsewidth_ms(200);
         
         //float pwmpw = 0.1; //0.0005; //0.09; // 0.1001;
         //float pwmpp = 1.0; //0.00001; //0.0001; // 0.01001;
        //fan2.pulsewidth(0.1);
        //fan2.period(1.0  / 10.0);
        //fan2.pulsewidth(2.0);
        //fan2.period(20);
        float pwmduty = 0.1f;
        float unit_time = 10.0;                  
        float total_period = 0.1; //0.7; //3.5; //0.8;
        float num_cycle = (unit_time / total_period) + 1;

        while (pwmduty <= 1.1f) {
            float on_time = total_period * pwmduty;
            float off_time = total_period - on_time;
            //gOled2.clearDisplay();
            gOled2.setTextCursor(1,20);
            wait(0.1);
            gOled2.printf("pwm=%3.3f\r\n", pwmduty);            
            wait(0.1);
            gOled2.display();
            wait(0.1);
            gOled2.display();
            wait(0.1);
            pc.printf("pwm=%3.3f\r\n", pwmduty);            
            //wait(3.0);
            fan2x = 1;
            wait(0.15);
            for (int x=0; x<= num_cycle; x++) {
            
            fan2x = 1;
            wait(on_time);
            fan2x = 0;
            wait(off_time);
            // accelerate to get the motor turning
            // then slow down to the current speed;
            //fan1 = 0.0;
            //fan2 = 0.0;
            //fan3 = 0.0;
            //wait(0.02);
            //fan1 = pwmduty;
            //fan2 = pwmduty;
            //fan3 = pwmduty;
            //fan2 = pwmduty;
            //fan2.period(pwmduty/100);
            //fan2.period(pwmduty);
            
            }
            pwmduty+= 0.1f;
        }        
        //fan1 = 0.0;
        //fan2 = 0.0;
        //fan3 = 0.0;
        wait(3.0);
    }
}
