/* Example of Reading all the ADC pins available on the Nucleo_F303K8. 
 
  By Joseph Ellsworth CTO of A2WH
  Take a look at A2WH.com Producing Water from Air using Solar Energy
  March-2016 License: https://developer.mbed.org/handbook/MIT-Licence 
*/

#include "mbed.h" 

 // Host PC Communication channels
 Serial pc(USBTX, USBRX); // tx, rx
 

AnalogIn   pa7(PA_7);
AnalogIn   pa6(PA_6);
AnalogIn   pa5(PA_5);
AnalogIn   pa4(PA_4);
//AnalogIn   pa2(PA_2); // conflicts with USB TX
//AnalogIn  pa3(PA_3);  // conflicts with USB RX
AnalogIn   pa1(PA_1); 
AnalogIn   pa0(PA_0); 
AnalogIn   pb0(PB_0); 
AnalogIn   pb1(PB_1); 
 
DigitalOut myled(LED1);
const float voltMeterARef = 3.3;

float readPrint(AnalogIn ain, char *label) {
  float tval = ain.read();
  float volts = tval * voltMeterARef;
  float perc = tval * 100.0;  
  unsigned short  tvalu16 = ain.read_u16 ();

  printf("adc %s R=%3.3f V=%3.3f%% U16=%u\r\n",label, tval, volts, tvalu16);
  
  return tval;
}
    

int main() {
    while(1) {
        myled = !myled; // toggle led 
        readPrint(pa7, "PA_7");
        readPrint(pa6, "PA_6");
        readPrint(pa5, "PA_5");
        readPrint(pa4, "PA_4");
        //readPrint(pa3, "PA_3");
        //readPrint(pa2, "PA_2");
        readPrint(pa1, "PA_1");
        readPrint(pa0, "PA_0");
        
        readPrint(pb0, "PB_0");
        readPrint(pb1, "PB_1");
        printf("\r\n\r\n");
        wait(7.0);        
    }
}
