/* Scan I2C bus on specified pins and prints out
* the all address where an active device responds.
*
  By Joseph Ellsworth CTO of A2WH
  Take a look at A2WH.com Producing Water from Air using Solar Energy
  March-2016 License: https://developer.mbed.org/handbook/MIT-Licence 
  Please contact us http://a2wh.com for help with custom design projects.

  
* Don't forget 3K pull-up resistors on sda,scl 
* 
* I tested this by soldering in a I2C chip known to respond at
* address dec=120 hex=70 and the utility got the ack as expected.
* when the chip was de-soldered it was no longer detected.  
*/

#include "mbed.h"

Serial pc(USBTX, USBRX);
Serial pc2(USBTX, USBRX);

 #define D_SDA                  PB_7 
 #define D_SCL                  PB_6 
   // sda=PB7, scl=PB_6 Pins specific to Nucleo-F303K8
  // must change pins to match your board.

I2C i2c(D_SDA, D_SCL);  
  
DigitalOut myled(LED1);
 
int ack;   
int address;  
void scanI2C() {
  for(address=1;address<127;address++) {    
    ack = i2c.write(address, "11", 1);
    if (ack == 0) {
       pc.printf("\tFound at %3d -- %3x\r\n", address,address);
    }    
    wait(0.05);
  } 
}
 
int main() {
  pc.baud(9600);
  pc.printf("I2C scanner \r\n");
  scanI2C();
  pc.printf("Finished Scan\r\n");
  // just blink to let us know the CPU is alive 
  while(1) { 
      wait(5.0);          
      myled = !myled;
  }
}
 