#include <jsonlite.h>

#include "mbed.h"
#include "mtsas.h"
#include "M2XStreamClient.h"

const char m2xKey[] = "06ce9a9febbfc50ffceb0d8214427767";   // Replace with your M2X API key
const char feedId[] = "48c77c779f0eed1243e623190e588501";   // Replace with your blueprint Feed ID
const char streamName[] = "temperature"; // Replace with your stream name  

char name[] = "austin"; // Name of current location of datasource
double latitude = 30.3748076;
double longitude = -97.7386896; // You can also read those values from a GPS
double elevation = 400.00;

// Note: D8, D2, D3, D6, D4, D7 are being used by MTSAS Cellular Modem

PwmOut mypwm(D13);   // This is the Nucleo board LED2 
AnalogIn temp_sensor(A1);    // There's also a conflict with A0, so connect temp_sensor A1 

int main()
{ 
    int ping_status = 0;
    char amb_temp[6]; 
    int response;
    int adc_scale = 65536; //4096; 
    int B = 3975;
    float resistance; 
    float temperature;
    float temperature_f;   
               
    mypwm.period_ms(500);
    mypwm.pulsewidth_ms(250);                        
              
    //Modify to match your apn if you are using an HSPA radio with a SIM card
    const char APN[] = "epc.tmobile.com";
    printf("Starting....\n");
    //Sets the log level to INFO, higher log levels produce more log output.
    //Possible levels: NONE, FATAL, ERROR, WARNING, INFO, DEBUG, TRACE
    MTSLog::setLogLevel(MTSLog::TRACE_LEVEL);
    
    /** STMicro Nucelo F401RE
    * The supported jumper configurations of the MTSAS do not line up with
    * the pin mapping of the Nucleo F401RE. Therefore, the MTSAS serial TX
    * pin (JP8 Pin 2) must be manually jumped to Serial1 RX (Shield pin D2)
    * and the MTSAS serial RX pin (JP9 Pin 2) pin must be manually jumped to
    * Serial1 TX (Shield pin D8).
    * Uncomment the following line to use the STMicro Nuceleo F401RE
    */
    MTSSerialFlowControl* io = new MTSSerialFlowControl(D8, D2, D3, D6);
    printf("FlowControl...\n");
    /** Freescale KL46Z
    * To configure the serial pins for the Freescale KL46Z board, use MTSAS jumper 
    * configuration B. Uncomment the following line to use the Freescale KL46Z board
    */
    //MTSSerialFlowControl* io = new MTSSerialFlowControl(D2, D9, D3, D6);
    
    /** Freescale K64F
    * To configure the serial pins for the Freescale K64F board, use MTSAS jumper
    * configuration A. Uncomment the following line to use the Freescale K64F board
    */
    //MTSSerialFlowControl* io = new MTSSerialFlowControl(D1, D0, D3, D6);
    
    //Sets the baud rate for communicating with the radio
    io->baud(115200);
    printf("Baud...\n");
    //Create radio object
    Cellular* radio = CellularFactory::create(io);
    printf("CellularFactory...\n");
    if (! radio) {
        logFatal("Failed to initialize radio");
        return 1;
    }
    radio->configureSignals(D4,D7,RESET);
    Transport::setTransport(radio);
        printf("setTransport...\n");
    //Set radio APN
    for (int i = 0; i < 10; i++) {
        if (i >= 10) {
            logError("Failed to set APN to %s", APN);
        }
        if (radio->setApn(APN) == MTS_SUCCESS) {
            logInfo("Successfully set APN to %s", APN);
            break;
        } else {
            wait(1);
        }
    }
    
    //Establish PPP link
    for (int i = 0; i < 10; i++) {
        if (i >= 10) {
            logError("Failed to establish PPP link");
        }
        if (radio->connect() == true) {
            logInfo("Successfully established PPP link");
            break;
        } else {
            wait(1);
        }
    }
    
    //Ping google.com
    for (int i = 0; i < 10; i++) {
        if (i >= 10) {
            logError("Failed to ping api-m2x.att.com");
        }
        if (radio->ping("api-m2x.att.com") == true) {
            logInfo("Successfully pinged api-m2x.att.com");
            ping_status = 1;
            break;
        } else {
            wait(1);
        }
    }
        
    // Initialize the M2X client
    Client client;    
    M2XStreamClient m2xClient(&client, m2xKey);    
     
    if (ping_status)
    { 
        mypwm.pulsewidth_ms(500);
     
        /* Main loop */
        while (true) 
        {
     
            /* Wait 5 secs and then loop */
            delay(2500);
            mypwm.pulsewidth_ms(0);      
                  
            /* Read ADC value from analog sensor */
            uint16_t a = temp_sensor.read_u16();
                   
            /* Calculate the temperature in Fareheight and Celsius */
            resistance = (float)(adc_scale-a)*10000/a; //get the resistance of the sensor;              
            temperature = 1/(log(resistance/10000)/B+1/298.15)-273.15;  //convert to temperature via datasheet ;        
            temperature_f =(1.8 * temperature) +  32.0;
            sprintf(amb_temp, "%0.2f", temperature_f);  
            
            printf("Temp Sensor Analog Reading is 0x%X = %d  \r\n", a, a);         
            printf("Current Temperature: %f C  %f F \r\n", temperature, temperature_f); 
    
            delay(2500);
            mypwm.pulsewidth_ms(500);   
         
            /* Post temperature to M2X site */
            int response = m2xClient.put(feedId, streamName, amb_temp);
            printf("Post response code: %d\r\n", response);
            if (response == -1) 
            {
                mypwm.pulsewidth_ms(250);                
                printf("Temperature data transmit post error\n");
            }
            /* Update location data */
            response = m2xClient.updateLocation(feedId, name, latitude, longitude, elevation);
            printf("updateLocation response code: %d\r\n", response);
            if (response == -1) 
            {
                mypwm.pulsewidth_ms(250);        
                printf("Location data transmit post error\n");
            }    
            printf("\r\n");     
        }
    }

    //Disconnect ppp link
    radio->disconnect();
   
    logInfo("End of example code");
    return 0;
} 