#include "mbed.h"
#include "PPM.h"

//My channel mapping, yours will be different
//Channel 1 is roll. min 1000. max 1900
//Channel 2 is pitch. min 1000. max 1900
//Channel 3 is throttle < 900 when not connected. min 1000. max 1900
//Channel 4 is yaw. min 1000. max 1900
//Channel 5 is arm. armed > 1800 else unarmed
//Channel 6 is mode. rate > 1800. stab < 1100. else error 
//Channel 7 is spare
//Channel 8 is spare

//PPM object
PPM *_ppm;
//InterruptIn pin (p5)
InterruptIn *_interruptPin = new InterruptIn(p5);
//Connection to the PC
Serial pc(USBTX, USBRX);

int main() 
{
    //Create instance of PPM class
    //Pass in interrupt pin, minimum output value, maximum output value, minimum pulse time from transmitter, maximum pulse time from transmitter, number of channels, throttle channel (used for failsafe)
    _ppm = new PPM(_interruptPin, 0, 1, 1000, 1900, 8, 3);
    
    //Setup serial connection
    pc.baud(115200);
    
    //Loop, printing data
    while(true)
    {
        //Array to hold RC commands
        float rcCommands[8] = {0,0,0,0,0,0,0,0};
    
        //Get channel data (mapped to between 0 and 1 as I passed these in as my max and min in the PPM constructor)
        //The throttle channel will return -1 if the signal from the transmitter is lost (the throttle pulse time goes below the minimum pulse time passed into the PPM constructor)
        _ppm->GetChannelData(rcCommands);
        
        //Print
        printf("%f, %f, %f, %f, %f, %f, %f, %f\r\n", rcCommands[0], rcCommands[1], rcCommands[2], rcCommands[3], rcCommands[4], rcCommands[5], rcCommands[6], rcCommands[7]);
        
        //Wait 1 so the data can be read
        wait(1);
    }    
}
