#include "mbed.h"

#ifndef Ppm_H
#define Ppm_H

class Ppm
{
    public:
        //Constructor
        Ppm(PinName pin, int minimumOutput, int maximumOutput, int minimumPulseTime, int maximumPulseTime, int numberOfChannels, int throttleChannel);
        
    private:
        //Interrupt
        void SignalRise();
        
        //Interrupt pin
        InterruptIn *_ppmPin;
        
        //Timer, times length of pulses
        Timer _timer;
        //Number of channels in Ppm signal
        int _numberOfChannels;
        //Current channel
        char _currentChannel;  
        //Stores channel times
        int _times[100];
        //Stores most recent complete frame times
        int _completeTimes[100];
        //Keeps track of time between Ppm interrupts
        int _timeElapsed; 
        //Minimum time of frame
        int _minFrameTime;
        //If the pulse time for a channel is this short, something is wrong uS
        int _shortTime;
        //Minimum pulse time uS
        int _minimumPulseTime;
        //Maximum pulse time uS
        double _maximumPulseTime;
        //Minimum output
        double _minimumOutput;
        //Maximum output
        double _maximumOutput;
        //Throttle channel - used for fail safe
        int _throttleChannel;
        
    public:
        //Get channel data
        void GetChannelData(double* channelData);
        
    private:
        double Map(double input, double inputMin, double inputMax, double outputMin, double outputMax);
};

#endif


