#include "mbed.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx

PwmOut      _motor1(p22);
PwmOut      _motor2(p23);
PwmOut      _motor3(p24);
PwmOut      _motor4(p25);

int main()
{
    float period = 1.0 / 500;
    _motor1.period(period);
    _motor2.period(period);
    _motor3.period(period);
    _motor4.period(period);
    
    _motor1.pulsewidth_us(1860);
    _motor2.pulsewidth_us(1860);
    _motor3.pulsewidth_us(1860);
    _motor4.pulsewidth_us(1860);
    
    myled = 1;
    
    while(1)
    {
        if(pc.readable())
        {
            if(pc.getc() == 'a')
            {
                myled = 0;
                _motor1.pulsewidth_us(1060);
                _motor2.pulsewidth_us(1060);
                _motor3.pulsewidth_us(1060);
                _motor4.pulsewidth_us(1060);
            }
        }
    }
}
