#include "mbed.h"
#include "TextLCD.h"
#include "Counter.h"
#include "LIS302.h"
#include "Servo.h"

Servo myservo(p21);
LIS302 acc (p5,p6,p7,p8);
DigitalIn enable(p20);
DigitalOut LIS302(LIS302);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
#define TICK_PERIOD 1.0
LocalFileSystem local("local");
Counter counter(p18);


Ticker tick;

Timer t;
volatile int tick_active = 0;

void dotick (void) {
    tick_active = 1;
    led1  = !led1;
}
int rpm_counter=0;
int main() {

    float samples [5] = {0};
    int index = 0;
    int flipped_right = 1;
    int flipped_left = 1;

    TextLCD lcd(p24, p25, p26, p27, p28, p29, p30); // rs, rw, e, d0, d1, d2, d3
    FILE *fp = fopen("/local/car data.csv", "w");
    fprintf(fp, "RPM,X,Y,Z\n");
    tick.attach(dotick,1.0);
    while (1) {
        if (enable) {

            t.start ();


            while (enable) {
                led4 = 0;
                while (tick_active == 0) {}
                led2 = !led2;
                rpm_counter = counter.read();
                counter.reset();

                fprintf(fp,"%d,%.2f,%.2f,%.2f\n",60*rpm_counter,acc.x(),acc.y(),acc.z());

                tick_active = 0;
                led3 = !led3;

                samples[index] = acc.y();
                index++;
                if (index >= 5) {
                    index = 0;
                }
                int i;

                flipped_right = 1;
                flipped_left =1;

                for (i=0; i<5; i++) {
                    if (samples[i] > -0.8) {
                        flipped_left = 0;
                    }

                    if (samples[i] < 0.8) {
                        flipped_right = 0;
                    }
                }

                if (flipped_left||flipped_right||!enable) {


                    myservo = 1;

                    t.stop();

                    fprintf(fp,"this run lasted %f seconds \n", t.read());
                    fprintf(fp,"off,off,off,off");
                    fclose(fp);
                    led4 = !led4;
                    led2 = 0;
                    led3 = 0;
                }
            }
        }
    }
}
