#include "mbed.h"
#include "TextLCD.h"
#include "Counter.h"
#include "LIS302.h"
#include "MSCFileSystem.h"
#include "Servo.h"

Servo myservo(p21);
LIS302 acc (p5,p6,p7,p8);
DigitalIn enable(p20);
DigitalOut LIS302(LIS302);
DigitalOut led(LED1);
#define TICK_PERIOD 1.0
MSCFileSystem fs("fs");

Counter counter(p18);


Ticker tick;

Timer t;
int tick_active = 0;

void dotick (void) {
    tick_active = 1;
}
int rpm_counter=0;
int main() {

    TextLCD lcd(p24, p25, p26, p27, p28, p29, p30); // rs, rw, e, d0, d1, d2, d3
    FILE *fp = fopen("/fs/cardata.csv","w");
    fprintf(fp, "RPM,X,Y,Z\n");
    tick.attach(dotick,1.0);
    while (1) {
        if (enable) {
            t.start();
            while (enable) {

                while (tick_active == 0) {}
                rpm_counter = counter.read();
                counter.reset();
                led = !led;
                fprintf(fp,"%d,%.2f,%.2f,%.2f\n",60*rpm_counter,acc.x(),acc.y(),acc.z());
                wait (0.1);
                tick_active = 0;

            }
            if (!enable)
                t.stop();
            fprintf(fp,"this run lasted %f seconds \n", t.read());
            fprintf(fp,"off,off,off,off");
            fclose(fp);
        }
    }

}