#include "mbed.h"
#include "Counter.h"

Counter::Counter(PinName pin) 
    : _interrupt (pin) {    

    // attach rising edge to rising function
     _interrupt.rise(this, &Counter::rising); 

    // Initialise the counter to 0
    _count = 0;
}

// On a rising edge, increment the counter
void Counter::rising() {    
        _count++;
}

// return the current count
int Counter::read() {
        return _count;
}

// Reset the counter
void Counter::reset() {
        _count = 0;
}

