#include "mbed.h"
#include "TextLCD.h"
#include "Counter.h"
#include "LIS302.h"
#include "Servo.h"
#include "MSCFileSystem.h"

Servo myservo(p21);
LIS302 acc (p5,p6,p7,p8);
DigitalIn on(p20);
DigitalOut LIS302(LIS302);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
#define TICK_PERIOD 0.5
LocalFileSystem local("local");
Counter counter(p18);
char filename[64];
int n = 0;


Ticker tick;

Timer t;
volatile int tick_active = 0;

void dotick (void) {
    tick_active = 1;

}
float samples [2] = {0};
int index2 = 0;
int start = 1;

int rpm_counter=0;
int main() {

    float samples [1] = {0};
    int index = 0;
    int flipped_right = 1;
    int flipped_left = 1;

    TextLCD lcd(p24, p25, p26, p27, p28, p29, p30);
    sprintf(filename, "/local/file%03d.txt", n);
    FILE *fp = fopen(filename, "r"); //this opens a file on the mbed drive
    fprintf(fp, "RPM,X,Y,Z\n");                   //this part prints the columns headers
    if (fp == NULL) {
        break;
    }
    fclose(fp);
    n++;
}
tick.attach(dotick,0.5);

while (1) {
    while (tick_active == 0) {}
    rpm_counter = counter.read();
    counter.reset();

    tick_active = 0;
    samples[index2] = 120*rpm_counter;
    index2++;
    if (index2 >= 2) {
        index2 = 0;
    }
    int i;
    start = 1;
    for (i=0; i<2; i++) {
        if (samples[i] <60) {
            start = 0;
        }
    }
    if (on) {
        led2 = 1;
    }
    if (!on) {
        led2 = 0;
    }
    if (start) {
        led3 = 1;
    }
    if (!start) {
        led3 = 0;   // the leds are only to check the program is doing what i want it to!
    }
    if (start&&on)
        t.start ();
    while (start&&on) {       //if the light gate reads over 60RPM and the swich is on then it will enter this loop

        while (tick_active == 0) {}

        rpm_counter = counter.read();
        counter.reset();
        FILE *fp = fopen(filename, "w");
        fprintf(fp,"%d,%.2f,%.2f,%.2f\n",60*rpm_counter,acc.x(),acc.y(),acc.z());  //the data colected is saved in the file that was opend
        led1 = !led1;
        tick_active = 0;


        samples[index] = acc.y();
        index++;
        if (index >= 1) {
            index = 0;
        }
        int i;

        flipped_right = 1;
        flipped_left =1;

        for (i=0; i<1; i++) {
            if (samples[i] >= -0.8) {
                flipped_left = 0;
            }

            if (samples[i] <= 0.8) {
                flipped_right = 0;         //the bit abouve is an array that is looking to see if the accelerometer is reading between 0.8 and -0.8




            }

            if (flipped_left||flipped_right||!on) {
                // if the accelerometer is not reading between 0.8 and -0.8 on the y.acc or the swich is off the following will happen


                myservo = 1; // 1. the servo will turn to turn off the engine

                t.stop();  // 2. the timer will stop

                fprintf(fp,"this run lasted %f seconds \n", t.read()); // 3. the timer time will be printed to the file
                fprintf(fp,"off,off,off,off");
                fclose(fp); // and last the file will be closed
                led2 = 0
                       led1 = 0;
                led4 = 1;
            }
        }
    }
}
}