#include "HighPWM.h"

HighPWM::HighPWM(PinName pin) : PWMObject(pin){
    //Set clock source to CPU clock (without devider)
    LPC_SC->PCLKSEL0 |= 1<<12;
    
    _pulsewidth = 0;
    _period = 0;
    
    if (pin==p26||pin==LED1) {
        PWMUnit=1;
        MR=&LPC_PWM1->MR1;
        }
    else if (pin==p25||pin==LED2){
        PWMUnit=2;
        MR=&LPC_PWM1->MR2;
        }
    else if (pin==p24||pin==LED3){
        PWMUnit=3;
        MR=&LPC_PWM1->MR3;
        }
    else if (pin==p23||pin==LED4){
        PWMUnit=4;
        MR=&LPC_PWM1->MR4;
        }
    else if (pin==p22){
        PWMUnit=5;
        MR=&LPC_PWM1->MR5;
        }
    else if (pin==p21){
        PWMUnit=6;
        MR=&LPC_PWM1->MR6;
        }
    else
        error("Invalid hardware PWM pin\n\r");
    
    frequency(10000);   // 10kHz
}

void HighPWM::frequency(double frq) 
{
    if ( frq>0.0 )
        period(1.0/frq);
}

void HighPWM::period(double seconds) 
{
    period_ticks((unsigned int)(seconds*s_2_F_CLK+0.5));
}

void HighPWM::period_us(double us) 
{
    period_ticks((unsigned int)(us*us_2_F_CLK+0.5));
}

void HighPWM::period_ms(unsigned int ms) 
{
    period_ticks(ms*ms_2_F_CLK);
}

void HighPWM::period_us(unsigned int us) 
{
    period_ticks(us*us_2_F_CLK);
}

void HighPWM::period_ticks(unsigned int ticks) 
{
    double duty = (double)_pulsewidth/(double)_period;
    
    LPC_PWM1->MR0 = ticks;
    LPC_PWM1->LER |= 1;
    _period = ticks;
    pulsewidth_ticks((int)(duty*(double)_period+0.5));
}

void HighPWM::pulsewidth(double seconds) 
{
    pulsewidth_ticks((unsigned int)(seconds*s_2_F_CLK+0.5));
}

void HighPWM::pulsewidth_us(double us) 
{
    pulsewidth_ticks((unsigned int)(us*us_2_F_CLK+0.5));
}

void HighPWM::pulsewidth_ms(unsigned int ms) 
{
    pulsewidth_ticks(ms*ms_2_F_CLK);
}

void HighPWM::pulsewidth_us(unsigned int us) 
{
    pulsewidth_ticks(us*us_2_F_CLK);
}

void HighPWM::pulsewidth_ticks(unsigned int ticks) 
{
    *MR = ticks;
    LPC_PWM1->LER |= 1<<PWMUnit;
    _pulsewidth = ticks;
}

void HighPWM::write(double duty) 
{
    pulsewidth_ticks((int)(duty*(double)_period+0.5));
}

double HighPWM::read( void ) 
{
    return (double)_pulsewidth/(double)_period;
}
    
HighPWM & HighPWM::operator= (double value) 
{
    write(value);
    return(*this);
}
    
HighPWM::operator double() 
{
    return read();
}
    