#include "mbed.h"
#include "Pulses.h"

Serial pc(USBTX, USBRX); // tx, rx
AnalogOut multimeter(p18);

// Example for energy meter with SO interface.
// SO output of energy meter is connected (over opto-coppler) to pin 8

#define SO_PULSES 2000 // SO interface of energy meter with 2000 pulses per kWh
Pulses pulses(p8, Pulses::FALL);

int main() {
    pulses.setFactor ( 3600.0f/SO_PULSES );   // Scale to kW; kWh

    float averagePower = 0;    // Average energy since last call of get()
    float minPower = 0;        // Min. energy since last call of get()
    float maxPower = 0;        // Max. energy since last call of get()
    float sumEnergy = 0;       // Sum of energy over all since start of mbed
    
    while(1) {
        
        pulses.get ( &averagePower, &minPower, &maxPower, &sumEnergy );
        
        pc.printf ( "Power: %.3f (%.3f...%.3f) [kW]   Energy: %.3f [kWh]   SO-pulses=%d\r\n", 
            averagePower,
            minPower,
            maxPower,
            sumEnergy / 3600.0f,
            pulses.getCounter() );

        // wait(6);   // Example 6 seconds; typical 1 minute (60 sec) sample time
        
        // Additional feature: Output of actual power as analog voltage (1V==1kW; max3.3kW). Connect a multimeter to pin 18 and GND
        for ( int i=0; i<20; i++ ) {
            multimeter = pulses.getAct() / 3.3f;   // Scale to 1V==1kW
            wait(0.3);   // Example 6 seconds; typical 1 minute (60 sec) sample time
        }
    }
}
