#include "mbed.h"
#include "PinDetect.h"
#include "stdlib.h"
#include "TextLCD.h"

 
DigitalOut myled(LED1);
Timer t;
TextLCD lcd(p36, p34, p24, p23, p15, p16); // rs, e, d0-d3
PinDetect pb1(p18);
PinDetect pb2(p19);
DigitalIn dip0(p26);
DigitalIn dip1(p27);
DigitalIn dip2(p28);
DigitalIn dip3(p29);
Serial pc(USBTX, USBRX);
Serial hm(p9, p10); // definiere UART für HM-TPR433 Modul
DigitalOut config(p22);
DigitalOut enable(p21);
 
// Global count variable
int volatile count=0;
int volatile resetcnt=0;
int volatile zz1=0;
int volatile zz2=0;
int volatile sblock=0;
int volatile reset=0;
int volatile D=1;

int ms;
int sec;
int min;
int ms1;
char buffer[9]; 
char zwischenzeit[9];
char zwischenzeit1[9];
//char config_buffer[16];

/*Funktions Dekleration*/

void empfangen() {
    // Note: you need to actually read from the serial to clear the RX interrupt    
  
    t.stop();
    pc.printf("Gesamtzeit: %s\n", buffer);
    pc.printf("Zwischenzeit: %s\n", zwischenzeit);
    pc.printf("Zwischenzeit: %s\n", zwischenzeit1);
    sblock=1;
    hm.getc();
    enable = 1;
    wait(0.01);
    return;
}

void konfiguration(void)
{
 config = 0;
 enable = 0;
 //hm.printf("AA FA F0"); //Standardkonfiguration laden
 hm.printf("AA FA E1");
 //hm.getc();
 //pc.printf("%s\n", hm.getc()); // um RX Interrupt zu löschen, Zeichen auslesen 
 
 /*hm.printf("%x", 0xAA);
 hm.printf("%x", 0xFA);
 hm.printf("%x", 0xD2);
 hm.printf("%x", 0x19E2E460); //AA FA D2 19 E2 E4 60 */
 
 
 wait(0.1);
 config = 1;
 return;
}
/*
void frequenz_config(void)
{
 config = 0;
 enable = 0;
 if((dip0 == 0) && (dip1 == 0) && (dip2 == 0) && (dip3 == 0))   //Schalterstellung0
 {
 hm.printf("AA FA D2 19 CF D1 90"); //Frequenz1 = 433050000Hz
 }
 else if((dip0 == 1) && (dip1 == 0) && (dip2 == 0) && (dip3 == 0)) //Schalterstellung 1
 {
 hm.printf("AA FA D2 19 D3 A2 20"); //Frequenz2 = 433300000Hz
 }
  else if((dip0 == 0) && (dip1 == 1) && (dip2 == 0) && (dip3 == 0)) //Schalterstellung 2
 {
 hm.printf("AA FA D2 19 D7 72 B0"); //Frequenz3 = 433550000Hz
 }
  else if((dip0 == 1) && (dip1 == 1) && (dip2 == 0) && (dip3 == 0)) //Schalterstellung 3
 {
 hm.printf("AA FA D2 19 DB 43 40"); //Frequenz4 = 433800000Hz
 }
  else if((dip0 == 0) && (dip1 == 0) && (dip2 == 1) && (dip3 == 0)) //Schalterstellung 4
 {
 hm.printf("AA FA D2 19 DF 13 D0"); //Frequenz5 = 434050000Hz
 }
  else if((dip0 == 1) && (dip1 == 0) && (dip2 == 1) && (dip3 == 0)) //Schalterstellung 5
 {
 hm.printf("AA FA D2 19 E2 E4 60"); //Frequenz6 = 434550000Hz
 }
  else if((dip0 == 0) && (dip1 == 1) && (dip2 == 1) && (dip3 == 0)) //Schalterstellung 6
 {
 hm.printf("AA FA D2 19 E6 B4 F0"); //Frequenz7 = 434550000Hz
 }
  else if((dip0 == 1) && (dip1 == 1) && (dip2 == 1) && (dip3 == 0)) //Schalterstellung 7
 {
 hm.printf("AA FA D2 19 EA 85 80"); //Frequenz8 = 433300000Hz
 }
  else if((dip0 == 0) && (dip1 == 0) && (dip2 == 0) && (dip3 == 1)) //Schalterstellung 8
 {
 hm.printf("AA FA D2  19 EE 56 10"); //Frequenz9 = 435050000Hz
 }
  else if((dip0 == 1) && (dip1 == 0) && (dip2 == 0) && (dip3 == 1)) //Schalterstellung 9
 {
 hm.printf("AA FA D2 19 F2 26 A0"); //Frequenz10 = 435300000Hz
 }
  else if((dip0 == 0) && (dip1 == 1) && (dip2 == 0) && (dip3 == 1)) //Schalterstellung A
 {
 hm.printf("AA FA D2  19 F5 F7 30"); //Frequenz11 = 435550000Hz
 }
  else if((dip0 == 1) && (dip1 == 1) && (dip2 == 0) && (dip3 == 1)) //Schalterstellung B
 {
 hm.printf("AA FA D2 19 F9 C7 C0"); //Frequenz12 = 435800000Hz
 }
  else if((dip0 == 0) && (dip1 == 0) && (dip2 == 1) && (dip3 == 1)) //Schalterstellung C
 {
 hm.printf("AA FA D2 19 FD 98 50"); //Frequenz13 = 436050000Hz
 }
  else if((dip0 == 1) && (dip1 == 0) && (dip2 == 1) && (dip3 == 1)) //Schalterstellung D
 {
 hm.printf("AA FA D2 0x1A 01 68 E0"); //Frequenz14 = 436300000Hz
 }
  else if((dip0 == 0) && (dip1 == 1) && (dip2 == 1) && (dip3 == 1)) //Schalterstellung E
 {
 hm.printf("AA FA D2 1A 05 39 70"); //Frequenz15 = 436550000Hz
 }
  else if((dip0 == 1) && (dip1 == 1) && (dip2 == 1) && (dip3 == 1))  //Schalterstellung F
 {
 hm.printf("AA FA D2 1A 09 0A 00"); //Frequenz16 = 436800000Hz
 }
 else
 {
  lcd.cls();
  lcd.printf("Fehler");
 wait(0.8);
 }
 wait(0.1);
 config = 1;
 return;
}
*/

void stoppuhr(void)
{
    ms = t.read_ms();           //hole mir den TimerWert in ms
    sec = (ms/1000);            //erzeuge mir durch division eine sekunde - aktueller Timerwert/1000 - z.b: 2548/1000=2sec
    ms = ms - (sec*1000);       //stelle meine ms richtig
    min = (sec/60);             //erzeuge mir Minuten
    sec = sec - (min*60);       //stelle Sekunden richtig
    ms = (ms/10);
    ms1 = (ms/10);                //erzeuge mir zwei Stellen nach komma
    sprintf(buffer, "%02d:%02d:%02d", min, sec, ms);            //schreibe in den buffer
    return;
}  

void reset_halten( void ) 
{  
    if(sblock==1) // Reset für Durchgang erhöhen
    {   
        t.stop();
        t.reset();
        stoppuhr();
        sprintf(zwischenzeit,"%01d:%02d:%1d", min, sec, ms1);
        sprintf(zwischenzeit1,"%01d:%02d:%1d", min, sec, ms1);
        resetcnt=0;
        count=0;
        zz1=0;
        zz2=0; 
        sblock=0;
        D++;
        if(D>99){D=1;}     
    } 
    if(sblock==0)  // Reset für ungewolten Durchgang
    {   
        t.stop();
        t.reset();
        stoppuhr();
        sprintf(zwischenzeit,"%01d:%02d:%1d", min, sec, ms1);
        sprintf(zwischenzeit1,"%01d:%02d:%1d", min, sec, ms1);
        resetcnt=0;
        count=0;
        zz1=0;
        zz2=0; 
        sblock=0;
     }
}
 
// Callback routine is interrupt activated by a debounced pb1 hit
void pb1_hit_callback (void) {

    ++count;                    //erhöhe die Variable count nach jedem drücken des Startbuttoms um 1
    
    if ((resetcnt==0) && (count <= 1)&& (sblock==0)) 
    { 
    t.reset();                                  //restiere Timer
    t.start();                                  //starte Timer
    resetcnt=1;
    enable = 0;
    }        
    else if ((resetcnt==1) && (count <= 2) && (sblock==0)) 
    {
    zz1=1;
    sprintf(zwischenzeit,"%01d:%02d:%1d", min, sec, ms1);
    resetcnt=2;
    } 
    else if ((resetcnt==2) && (count <= 3) && (sblock==0)) 
    {
    zz2=1;
    sprintf(zwischenzeit1,"%01d:%02d:%1d", min, sec, ms1);
    }      
    else
    {
   resetcnt=resetcnt++;
   if(resetcnt==100){ resetcnt=3;}              
    }
    resetcnt=resetcnt++;  
}

void pb2_hit_callback (void) {      //Stoppen des Timers ohne Funk
    t.stop();
    pc.printf("Gesamtzeit: %s\n", buffer);
    pc.printf("Zwischenzeit: %s\n", zwischenzeit);
    pc.printf("Zwischenzeit: %s\n", zwischenzeit1);
    sblock=1;  
}

void stoppen( void )  //Kompletter Anzeigereset bei gedrückt halten
{  
        t.stop();
        t.reset();
        stoppuhr();
        sprintf(zwischenzeit,"%01d:%02d:%1d", min, sec, ms1);
        sprintf(zwischenzeit1,"%01d:%02d:%1d", min, sec, ms1);
        resetcnt=0;
        count=0;
        zz1=0;
        zz2=0; 
        sblock=0;
        D=0;
}

int main()  
{    
    // Use internal pullup for pushbutton
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    dip0.mode(PullUp);
    dip1.mode(PullUp);
    dip2.mode(PullUp);
    dip3.mode(PullUp);
      // Delay for initial pullup to take effect
    wait(0.01);     
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb1.attach_deasserted_held(&reset_halten); 
    pb2.attach_deasserted(&pb2_hit_callback);
    pb2.attach_deasserted_held(&stoppen); 
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    
    konfiguration();
    //frequenz_config();
    hm.attach(&empfangen); 
    
    
    while (1) {
        wait(.01);
        lcd.cls(); 
      //  myled = !myled;                 // LED1 blickt
        stoppuhr();                     //rufe Funktion stoppuhr auf      
        lcd.locate(0, 0);               //setze den curser auf Zeihen 0 Reihe 1
        lcd.printf("D%02d", D);         //Formatiere mein LCD-Ausgabe nach D00 (zwei stellen)
        lcd.locate(4, 0);  
        lcd.printf("ZE:%s", buffer);         
          if(zz1==1)   
            {
            lcd.locate(0, 1);
            lcd.printf("A%s", zwischenzeit);           
            }            
          if(zz2==1)   
            {
            lcd.locate(8, 1);
            lcd.printf("B%s", zwischenzeit1);         
            }                                     
    }
 
}
