#include "mbed.h"
#include "PinDetect.h"
#include "stdlib.h"
#include "TextLCD.h"
// must import Cookbook PinDetct library into project
// URL: http://mbed.org/users/AjK/libraries/PinDetect/lkyxpw
//TST was here
 
DigitalOut myled(LED1);
Timer t;
TextLCD lcd(p36, p34, p9, p10, p15, p16); // rs, e, d0-d3
PinDetect pb1(p18);
PinDetect pb2(p19);
Serial pc(USBTX, USBRX);

// SPST Pushbutton debounced count demo using interrupts and callback
// no external PullUp resistor needed
// Pushbutton from P8 to GND.
// Second Pushbutton from P7 to GND.
// A pb hit generates an interrupt and activates the callback function
// after the switch is debounced
 
// Global count variable
int volatile count=0;
int volatile resetcnt=0;
int volatile zz1=0;
int volatile zz2=0;
int volatile sblock=0;
int volatile reset=0;
int volatile D=0;
int ms;
int sec;
int min;
int ms1;
char buffer[9]; 
char zwischenzeit[9];
char zwischenzeit1[9];

/*Funktions Dekleration*/
void stoppuhr(void)
{
    ms = t.read_ms();           //hole mir den TimerWert in ms
    sec = (ms/1000);            //erzeuge mir durch division eine sekunde - aktueller Timerwert/1000 - z.b: 2548/1000=2sec
    ms = ms - (sec*1000);       //stelle meine ms richtig
    min = (sec/60);             //erzeuge mir Minuten
    sec = sec - (min*60);       //stelle Sekunden richtig
    ms = (ms/10);
    ms1 = (ms/10);                //erzeuge mir zwei Stellen nach komma
    sprintf(buffer, "%02d:%02d:%02d", min, sec, ms);            //schreibe in den buffer
    return;
}  

void reset_halten( void ) 
{
    
    if(sblock==1) 
    {   
        t.stop();
        t.reset();
        stoppuhr();
        sprintf(zwischenzeit,"%01d:%02d:%1d", min, sec, ms1);
        sprintf(zwischenzeit1,"%01d:%02d:%1d", min, sec, ms1);
        resetcnt=0;
        count=0;
        zz1=0;
        zz2=0; 
        sblock=0;
        D++;
        if(D>99){D=0;}     
    } 
}
 
// Callback routine is interrupt activated by a debounced pb1 hit
void pb1_hit_callback (void) {

    ++count;                    //erhöhe die Variable count nach jedem drücken des Startbuttoms um 1
    
    if ((resetcnt==0) && (count <= 1)&& (sblock==0)) 
    { 
    t.reset();                                  //restiere Timer
    t.start();                                  //starte Timer
    resetcnt=1;
    }        
    else if ((resetcnt==1) && (count <= 2) && (sblock==0)) 
    {
    zz1=1;
    sprintf(zwischenzeit,"%01d:%02d:%1d", min, sec, ms1);
    resetcnt=2;
    } 
    else if ((resetcnt==2) && (count <= 3) && (sblock==0)) 
    {
    zz2=1;
    sprintf(zwischenzeit1,"%01d:%02d:%1d", min, sec, ms1);
    }      
    else
    {
    lcd.cls();
   // wait(0.05);
    lcd.locate(1, 0);
    if(sblock==0)
     { 
     
    lcd.printf("STOPP DRUEKEN!");
    wait(1);
     }
    if(sblock==1)
     {
    lcd.printf("RESET: START    LANGE DRUEKEN!");
    wait(1);
     }
    }
    resetcnt=resetcnt++;  
}

// Callback routine is interrupt activated by a debounced pb2 hit
void pb2_hit_callback (void) {
    t.stop();
    if(sblock==1)
     {
    lcd.cls();
//    wait(0.05);
    lcd.printf("RESET: START    LANGE DRUEKEN!");
    wait(1);
     }
    pc.printf("Gesamtzeit: %s\n", buffer);
    pc.printf("Zwischenzeit: %s\n", zwischenzeit);
    pc.printf("Zwischenzeit: %s\n", zwischenzeit1);
    sblock=1;
}
int main() {
 
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb1.attach_deasserted_held(&reset_halten);
    pb2.attach_deasserted(&pb2_hit_callback);
    
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
       
    while (1) {
        wait(.1);
        lcd.cls(); 
        myled = !myled;                 // LED1 blickt
        stoppuhr();                     //rufe Funktion stoppuhr auf      
        lcd.locate(0, 0);               //setze den curser auf Zeihen 0 Reihe 1
        lcd.printf("D%02d", D);         //Formatiere mein LCD-Ausgabe nach D00 (zwei stellen)
        lcd.locate(4, 0);  
        lcd.printf("ZE:%s", buffer);         
          if(zz1==1)   
            {
            lcd.locate(0, 1);
            lcd.printf("A%s", zwischenzeit);           
            }            
          if(zz2==1)   
            {
            lcd.locate(8, 1);
            lcd.printf("B%s", zwischenzeit1);         
            }                          
      //  wait(.1);
       // lcd.cls();        
    }
 
}
