#include "mbed.h"
#include "Rtc_Ds1307.h"
#include "TM1636.h"


Rtc_Ds1307 rtc(D3, D6);//sda/sci
DigitalIn  button_K1(A5);
DigitalIn  button_K2(A4);
DigitalIn  button_K3(USER_BUTTON);
TM1636 tm1636(D7,D8); //clk/data 
Serial pc(USBTX, USBRX, "pc");


int main() {
int8_t temp[4];
int job[3];
int total[3];
int8_t run[4];
    button_K1.mode(PullUp);
    button_K2.mode(PullUp);
    tm1636.init();
    Rtc_Ds1307::Time_rtc tm = {};
    tm.date = 1 ;
    tm.mon = 1 ;
    tm.year = 12 ;
    tm.hour = 0;
    tm.min = 0;
    tm.sec = 0;
    rtc.setTime(tm, false, false);
    rtc.startClock();
    while(1) {
            if(button_K2){
            rtc.getTime(tm);
            pc.printf("%02d:%02d:%02d\n",tm.hour,tm.min,tm.sec);
            temp[0] = tm.min / 10;
            temp[1] = tm.min % 10;
            temp[2] = tm.sec / 10;
            temp[3] = tm.sec % 10;                 
            tm1636.display(temp);
            } 
            if (!button_K1){
            rtc.stopClock();
            pc.printf("%02d:%02d:%02d\n",tm.hour,tm.min,tm.sec);
            wait(0.05);
            rtc.getTime(tm);
            job[0] = tm.hour;
            job[1] = tm.min;
            job[2] = tm.sec; 
            rtc.startClock();
            }
            pc.printf("%02d:%02d:%02d++++++++++++++++++++++\n",job[0],job[1],job[2]);
            if (!button_K2){
                total[0]=tm.hour-job[0];
                total[1]=tm.min-job[1];
                total[2]=tm.sec-job[2];
                run[0]=total[1]/10;
                run[1]=total[1]%10;
                run[2]=total[2]/10;
                run[3]=total[2]%10 ;
                tm1636.display(run);
                wait(0.4);
                
                }
            
            if (button_K3==0){
                rtc.stopClock();
                
                }
            
            }
            }
       