#include "EthUtils.h"

const char* IP = IP_INI;               // IP
const char* MASK = MASK_INI;           // MASK
const char* GATEWAY = GATEWAY_INI;           // GATEWAY

static int flash_addr = flash_size() - SECTOR_SIZE;           //Write in last sector
static int flash_addr_ip = flash_addr + 16;
static int flash_addr_mask = flash_addr + 16 + 32;
static int flash_addr_gateway = flash_addr + 16 + 2*32;
    
int numberOfDigits(int x){
    
    int length = 1;
    while ( x /= 10 )
       length++;
       
    return length;
}

int isNumber(char *str){
    int number;
    
    number = atoi(str);
    
    if (!(strlen(str) == numberOfDigits(number)))
        return 0;
        
    if (number<0)
        return 0;
    
    if (number>255)
        return 0;
    
    return 1;
}

int splitstr(char *str, const char *delimiter, char parts[][MAX_IP_LEN]){

    int nparts=0;
    char *token;
    
    /* get the first token */
    token = strtok(str, delimiter);
    
    /* walk through other tokens */
    while( token != NULL ) 
    {
      strcpy(parts[nparts],token);
      nparts++;
      if (nparts>4) break;
      
      token = strtok(NULL, delimiter);
    }
    
    return nparts;    
}

int validateIp(char *_ip){
    
    char delimiter[] = ".";
    char ip_segment[5][MAX_IP_LEN];
    int nsegments;
    char str[80];
    
    strcpy(str, _ip);
    
    nsegments = splitstr(str, delimiter, ip_segment);
    
    if (nsegments != 4)
        return 0;
    
    for (int i=0; i<4; i++){
        if (!isNumber(ip_segment[i]))
            return 0;
    }
        
    return 1;
    
}

int splitIpConf(char* str, char *_ip, char *_mask, char *_gateway){
    
    char delimiter[] = "/";
    char parts[5][MAX_IP_LEN];
    int nparts;
    
    nparts = splitstr(str, delimiter, parts);
    
    if (nparts != 3)
        return 0;
    
    for (int i=0; i<MAX_IP_LEN; i++){
        _ip[i] = 0x00;
        _mask[i] = 0x00;
        _gateway[i] = 0x00;
    }
    strcpy(_ip, parts[0]);
    strcpy(_mask, parts[1]);
    strcpy(_gateway, parts[2]);
    
    if (!validateIp(_ip))
        return 0;
    
    if (!validateIp(_mask))
        return 0;
    
    if (!validateIp(_gateway))
        return 0;
        
    return 1;
}

int eraseIpConfig(){
    
    int flash_addr = flash_size() - SECTOR_SIZE;           //Write in last sector

    erase_sector(flash_addr);   
    
    return 1;
    
}

int saveIpConfig(char *ip, char *mask, char *gateway){

    erase_sector(flash_addr);
    
    int flag[1] = {FLASH_FULL};
    program_flash(flash_addr, (char*)&flag, 4);
    
    program_flash(flash_addr_ip, ip, MAX_IP_LEN);
    program_flash(flash_addr_mask, mask, MAX_IP_LEN);
    program_flash(flash_addr_gateway, gateway, MAX_IP_LEN);
    
    return 1;
}

int readIpConfig(char *_ip, char *_mask, char *_gateway){

    int *flag_flash = (int*)flash_addr;
    char *ip_flash = (char*)(flash_addr_ip);
    char *mask_flash = (char*)(flash_addr_mask);
    char *gateway_flash = (char*)(flash_addr_gateway);

    if (flag_flash[0] == FLASH_FULL){
        for (int i=0; i< MAX_IP_LEN; i++){
            _ip[i] = ip_flash[i];
            _mask[i] = mask_flash[i];
            _gateway[i] = gateway_flash[i];
        }
    }
    else{
        strcpy(_ip, IP);
        strcpy(_mask, MASK);
        strcpy(_gateway, GATEWAY);
    }
    return 1;
       
}