#ifndef        JRO_IPDATA
#define        JRO_IPDATA

#include "mbed.h"

#define HEADER      "$JRO$"
#define ID_CLASS    1
#define ID_DEV      1

#define OK_PAYLOAD  "OK"
#define OK_LEN      2

#define KO_PAYLOAD  "KO"
#define KO_LEN      2

#define NI_PAYLOAD  "NI"
#define NI_LEN      2

/*
IP DATA STRUCTURE

5B      4B      1B          1B          2B      NB          1B
CAB     LEN     ID_CLASS    ID_DEV      CMD     PAYLOAD     XOR

ID_CLASS: Identifica la clase de dispositivo a programar

    1   ->  CR
    2   ->  DDS
    3   ->  JARS
    4   ->  USRP
    5   ->  ECHOTEK
    6   ->  ABS
    7   ->  CLK_GEN

ID_DEV: Identifica el id del dispositivo a programar

    Desde el 1-255, el 0 es usado como broadcast.

CMD: Identifica el comando enviado que define la operacion a realizar

    1   ->  RESET
    2   ->  DEV. ENABLE
    3   ->  CONFIG
    4   ->  
    5   ->  

*/

class IpData{

    private:
        
        char* rx_buff;
        
        char id_class;
        char id_dev;
        unsigned short cmd;
        char* payload;
        unsigned long len_payload;
        char xor_rd;        
        
        char *tx_buff;
        unsigned long len_tx_data;
        unsigned long len_tx_buffer;
        
        bool isValidData;
        
        char* __findHeader(char* buffer);
        char __getXor(char* data, unsigned long len_data);
        int __verifyData(char* ip_data, unsigned long len_data);
        int __getParameters();
        
    public:
        
        IpData(char* tx_buffer);
        char id;
        char* encode( unsigned short cmd, const char* payload, unsigned long len_payload);
        int decode(char* buffer, unsigned long len_buffer);
        char getIdClass();
        char getIdDevice();
        unsigned short getCmd();
        unsigned long getPayloadLen();
        char* getPayload();
        char* getTxData();
        unsigned long getTxDataLen();
        char* getNIData(unsigned short cmd=0x0);
        unsigned long getNIDataLen();
        char* getOKData(unsigned short cmd=0x0);
        unsigned long getOKDataLen();
        char* getKOData(unsigned short cmd=0x0);
        unsigned long getKODataLen();
};

#endif