#ifndef        CR2_SER_DRIVER
#define        CR2_SER_DRIVER

#include "mbed.h"
#include "SerialDriver.h"

#define SPI_BITS 8
#define SPI_MODE 0
#define SPI_FREQ 4000000

#define CR2_RESET            0X00
#define CR2_ENABLE           0X01
#define CR2_IO               0X02
#define CR2_FREQ             0X03
#define CR2_MW_BUF_L         0X04
#define CR2_MW_BUF_H         0X05
#define CR2_MR_BUF_L         0X06
#define CR2_MR_BUF_H         0X07
#define CR2_MEM_A_0          0X08
#define CR2_MEM_A_1          0X09
#define CR2_MEM_A_2          0X0A
#define CR2_MEM_CONF         0X0B
#define CR2_SAMP_L           0X0C
#define CR2_SAMP_H           0X0D
#define CR2_SAMP_CONT        0X0E
#define CR2_MON_DAT_L        0X0F
#define CR2_MON_DAT_H        0X10
#define CR2_MON_CONT_L       0X11
#define CR2_MON_CONT_H       0X12
#define CR2_FRT_SEL_1        0X13
#define CR2_FRT_SEL_2        0X14
#define CR2_ACK_KEY          0X15

#define CR2_CMD_RESET       0X10
#define CR2_CMD_ENABLE_RF   0x11
#define CR2_CMD_MULTIPLIER  0X12
#define CR2_CMD_MODE        0x13
#define CR2_CMD_FREQUENCYA  0X14
#define CR2_CMD_FREQUENCYB  0x15
#define CR2_CMD_PHASEA      0X16
#define CR2_CMD_PHASEB      0x17
#define CR2_CMD_AMPLITUDE1  0X18
#define CR2_CMD_AMPLITUDE2  0x19
#define CR2_CMD_READ        0x8000

class CR2{
    private:
        float           clock;              // Work frequency in MHz
        char            cr2_multiplier;         // Multiplier 4- 20
        char            cr2_mode;                // Single, FSK, Ramped FSK, Chirp, BPSK
        bool            cr2_qdac_pwdn;           // Q DAC power down enable: 0 -> disable
        bool            cr2_ioupdclk;            // IO Update clock enable: 0 -> input
        bool            cr2_inv_sinc;            // Inverse sinc filter enable: 0 -> enable
        bool            cr2_osk_en;              // Enable AM: 0 -> disabled
        bool            cr2_osk_int;             // ext/int output shaped control: 0 -> external
        bool            cr2_msb_lsb;             // msb/lsb bit first: 0 -> MSB
        bool            cr2_sdo;                 // SDO pin active: 0 -> inactive

        char            frequency1[6];
        char            frequency2[6];
        char            phase1[2];
        char            phase2[2];       
        char            amplitudeI[2];
        char            amplitudeQ[2];
        bool            rf_enabled;
       
        double          factor_freq1;
        double          factor_freq2;
        
        SPI             *spi_device;
        //CR2 I/O
        DigitalOut      *cr2_mreset;
        DigitalOut      *cr2_outramp;
        DigitalOut      *cr2_sp_mode;
        DigitalOut      *cr2_cs;
        DigitalOut      *cr2_io_reset;
        DigitalInOut    *cr2_updclk;
        
        char*           cmd_answer;
        unsigned long   cmd_answer_len;
        
        int __writeData(char addr, char data);
        char __readData(char addr);
        int __writeDataAndVerify(char addr, char wr_spi_data, SerialDriver *screen=NULL);
        //char* __getControlRegister();
        //int __writeControlRegister();
        
    public:
        bool isConfig;

        
        CR2(SPI *spi_dev, DigitalOut *mreset, DigitalOut *outramp, DigitalOut *spmode, DigitalOut *cs, DigitalOut *ioreset, DigitalInOut *updclk);
        int init();
        int reset();
        int scanIOUpdate();
        int find();
        int writeBlock(char ndata, const char* data);
        /*
        char* rdMode();
        char* rdMultiplier();
        char* rdPhase1();
        char* rdPhase2();
        char* rdFrequency1();
        char* rdFrequency2();
        char* rdAmplitudeI();
        char* rdAmplitudeQ();
        int isRFEnabled();
        int wrMode(char mode);
        int wrMultiplier(char multiplier, float clock=200.0);
        int wrPhase1(char* phase, SerialDriver *screen=NULL);
        int wrPhase2(char* phase, SerialDriver *screen=NULL);
        int wrFrequency1(char* freq, SerialDriver *screen=NULL);
        int wrFrequency2(char* freq, SerialDriver *screen=NULL);
        int wrAmplitudeI(char* amplitude, SerialDriver *screen=NULL);
        int wrAmplitudeQ(char* amplitude, SerialDriver *screen=NULL);
        int enableRF();
        int disableRF();
        int defaultSettings(SerialDriver *screen=NULL);
        */
        char* setCommand(unsigned short cmd, char* payload, unsigned long payload_len);
        char* getCmdAnswer();
        unsigned long getCmdAnswerLen();
        //int setAllDevice(char* payload, SerialDriver *screen=NULL);
        bool wasInitialized();
        char getMultiplier();
        double getFreqFactor1();
        double getFreqFactor2();
        char getMode();
        char* getModeStr();
        
};

#endif